/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.event.EventManager;
import org.compiere.model.I_AD_Process;
import org.compiere.model.MLanguage;
import org.compiere.model.MPInstanceLog;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.model.X_AD_PInstance;
import org.compiere.print.MPrintFormat;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.distributed.IMessageService;
import org.idempiere.distributed.ITopic;
import org.osgi.service.event.Event;

public class MPInstance
extends X_AD_PInstance {
    private static final long serialVersionUID = -6414730734415159480L;
    public static final String ON_RUNNING_JOB_CHANGED_TOPIC = "onRunningJobChanged";
    private static CLogger s_log = CLogger.getCLogger(MPInstance.class);
    private MPInstancePara[] m_parameters = null;
    private ArrayList<MPInstanceLog> m_log = new ArrayList();
    public static final int RESULT_OK = 1;
    public static final int RESULT_ERROR = 0;

    public MPInstance(Properties ctx, String AD_PInstance_UU, String trxName) {
        super(ctx, AD_PInstance_UU, trxName);
        if (Util.isEmpty(AD_PInstance_UU)) {
            this.setInitialDefaults();
        }
    }

    public MPInstance(Properties ctx, int AD_PInstance_ID, String ignored) {
        super(ctx, AD_PInstance_ID, null);
        if (AD_PInstance_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsProcessing(false);
    }

    public MPInstance(Properties ctx, ResultSet rs, String ignored) {
        super(ctx, rs, null);
    }

    @Deprecated
    public MPInstance(MProcess process, int Record_ID) {
        this(process, -1, Record_ID, null);
    }

    public MPInstance(MProcess process, int Table_ID, int Record_ID, String Record_UU) {
        this(process.getCtx(), 0, null);
        this.setAD_Process_ID(process.getAD_Process_ID());
        this.setAD_Table_ID(Table_ID);
        this.setRecord_ID(Record_ID);
        this.setRecord_UU(Record_UU);
        this.setAD_User_ID(Env.getAD_User_ID(process.getCtx()));
        if (!this.save()) {
            throw new IllegalArgumentException("Cannot Save");
        }
        MProcessPara[] para = process.getParameters();
        int i2 = 0;
        while (i2 < para.length) {
            MPInstancePara pip = new MPInstancePara(this, para[i2].getSeqNo());
            pip.setParameterName(para[i2].getColumnName());
            pip.setInfo(para[i2].getName());
            pip.saveEx();
            ++i2;
        }
    }

    @Deprecated
    public MPInstance(Properties ctx, int AD_Process_ID, int Record_ID) {
        this(ctx, AD_Process_ID, -1, Record_ID, null);
    }

    public MPInstance(Properties ctx, int AD_Process_ID, int Table_ID, int Record_ID, String Record_UU) {
        this(ctx, 0, null);
        this.setAD_Process_ID(AD_Process_ID);
        this.setAD_Table_ID(Table_ID);
        this.setRecord_ID(Record_ID);
        this.setRecord_UU(Record_UU);
        this.setAD_User_ID(Env.getAD_User_ID(ctx));
        this.setIsProcessing(false);
    }

    public MPInstancePara[] getParameters() {
        if (this.m_parameters != null) {
            return this.m_parameters;
        }
        List<MPInstancePara> list = new Query(this.getCtx(), "AD_PInstance_Para", "AD_PInstance_ID=?", null).setParameters(this.getAD_PInstance_ID()).setOrderBy("SeqNo, ParameterName").list();
        this.m_parameters = new MPInstancePara[list.size()];
        list.toArray(this.m_parameters);
        return this.m_parameters;
    }

    public MProcessPara[] getProcessParameters() {
        List<MProcessPara> list = new Query(this.getCtx(), "AD_Process_Para", "AD_Process_ID=?", this.get_TrxName()).setParameters(this.getAD_Process_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        MProcessPara[] processParameters = new MProcessPara[list.size()];
        list.toArray(processParameters);
        return processParameters;
    }

    public boolean equalParameters(MPInstancePara[] params) {
        if (!(this.getParameters() != null && this.getParameters().length != 0 || params != null && params.length != 0)) {
            return true;
        }
        if (this.getParameters().length != params.length) {
            return false;
        }
        int comparedParams = 0;
        MPInstancePara[] mPInstanceParaArray = this.getParameters();
        int n = mPInstanceParaArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPInstancePara instanceParameter = mPInstanceParaArray[n2];
            MPInstancePara[] mPInstanceParaArray2 = params;
            int n3 = params.length;
            int n4 = 0;
            while (n4 < n3) {
                MPInstancePara para = mPInstanceParaArray2[n4];
                if (instanceParameter.getParameterName().equals(para.getParameterName())) {
                    ++comparedParams;
                    if (instanceParameter.equalParameter(para)) break;
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return comparedParams == this.getParameters().length;
    }

    public MPInstanceLog[] getLog() {
        block6: {
            this.m_log.clear();
            String sql = "SELECT * FROM AD_PInstance_Log WHERE AD_PInstance_ID=? ORDER BY Log_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getAD_PInstance_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.m_log.add(new MPInstanceLog(rs));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MPInstanceLog[] retValue = new MPInstanceLog[this.m_log.size()];
        this.m_log.toArray(retValue);
        return retValue;
    }

    public MPInstanceLog addLog(Timestamp P_Date, int P_ID, BigDecimal P_Number, String P_Msg) {
        return this.addLog(P_Date, P_ID, P_Number, P_Msg, 0, 0);
    }

    public MPInstanceLog addLog(Timestamp P_Date, int P_ID, BigDecimal P_Number, String P_Msg, int AD_Table_ID, int Record_ID) {
        MPInstanceLog logEntry = new MPInstanceLog(this.getAD_PInstance_ID(), this.m_log.size() + 1, P_Date, P_ID, P_Number, P_Msg, AD_Table_ID, Record_ID);
        this.m_log.add(logEntry);
        return logEntry;
    }

    @Override
    public void setAD_Process_ID(int AD_Process_ID) {
        MRole role;
        Boolean access;
        int AD_Role_ID = Env.getAD_Role_ID(this.getCtx());
        if (!(AD_Role_ID == 0 || (access = (role = MRole.get(this.getCtx(), AD_Role_ID)).getProcessAccess(AD_Process_ID)) != null && access.booleanValue())) {
            MProcess proc = MProcess.get(this.getCtx(), AD_Process_ID);
            StringBuilder procMsg = new StringBuilder("[");
            if (!Language.isBaseLanguage(Env.getAD_Language(this.getCtx()))) {
                procMsg.append(proc.get_Translation("Name")).append(" / ");
            }
            procMsg.append(proc.getName()).append("]");
            throw new IllegalStateException(Msg.getMsg(this.getCtx(), "CannotAccessProcess", new Object[]{procMsg.toString(), role.getName()}));
        }
        super.setAD_Process_ID(AD_Process_ID);
    }

    @Override
    public void setRecord_ID(int Record_ID) {
        if (Record_ID < 0) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Set to 0 from " + Record_ID);
            }
            Record_ID = 0;
        }
        this.set_ValueNoCheck("Record_ID", Record_ID);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MPInstance[").append(this.get_ID()).append(",OK=").append(this.isOK());
        String msg = this.getErrorMsg();
        if (msg != null && msg.length() > 0) {
            sb.append(msg);
        }
        sb.append("]");
        return sb.toString();
    }

    public void log() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
            MPInstanceLog[] pil = this.getLog();
            int i2 = 0;
            while (i2 < pil.length) {
                this.log.info(i2 + "=" + String.valueOf(pil[i2]));
                ++i2;
            }
        }
    }

    public boolean isOK() {
        return this.getResult() == 1;
    }

    public void setResult(boolean ok) {
        super.setResult(ok ? 1 : 0);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord && !this.isProcessing() && this.is_ValueChanged("IsProcessing")) {
            String updsql;
            int no;
            long ms = System.currentTimeMillis() - this.getCreated().getTime();
            int seconds = (int)(ms / 1000L);
            if (seconds < 1) {
                seconds = 1;
            }
            if ((no = DB.executeUpdate(updsql = "UPDATE AD_Process SET Statistic_Count=Statistic_Count+1, Statistic_Seconds=Statistic_Seconds+? WHERE AD_Process_ID=?", new Object[]{seconds, this.getAD_Process_ID()}, true, null)) == 1) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("afterSave - Process Statistics updated Sec=" + seconds);
                }
            } else {
                this.log.warning("afterSave - Process Statistics not updated");
            }
        }
        return success;
    }

    public MPInstancePara createParameter(int seqNo, String parameterName, Object value) {
        MPInstancePara ip = new MPInstancePara(this, seqNo);
        if (value == null) {
            ip.setParameter(parameterName, (String)null);
        } else if (value instanceof BigDecimal) {
            ip.setParameter(parameterName, (BigDecimal)value);
        } else if (value instanceof Integer) {
            ip.setParameter(parameterName, (Integer)value);
        } else if (value instanceof Timestamp) {
            ip.setParameter(parameterName, (Timestamp)value);
        } else if (value instanceof Boolean) {
            ip.setParameter(parameterName, (Boolean)value);
        } else {
            ip.setParameter(parameterName, value.toString());
        }
        ip.saveEx();
        return ip;
    }

    @Override
    public I_AD_Process getAD_Process() throws RuntimeException {
        return MProcess.get(this.getAD_Process_ID());
    }

    public static void publishChangedEvent(int AD_User_ID) {
        IMessageService service = Core.getMessageService();
        if (service != null) {
            ITopic<Integer> topic = service.getTopic(ON_RUNNING_JOB_CHANGED_TOPIC);
            topic.publish(AD_User_ID);
        } else {
            MPInstance.postOnChangedEvent(AD_User_ID);
        }
    }

    public static void postOnChangedEvent(int AD_User_ID) {
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("AD_User_ID", AD_User_ID);
        Event event = EventManager.newEvent(ON_RUNNING_JOB_CHANGED_TOPIC, properties, true);
        EventManager.getInstance().postEvent(event);
    }

    public static List<MPInstance> get(Properties ctx, int AD_Process_ID, int AD_User_ID) {
        ArrayList<MPInstance> list;
        block11: {
            list = new ArrayList<MPInstance>();
            ArrayList<String> paramsStrAdded = new ArrayList<String>();
            List namedInstances = new Query(ctx, "AD_PInstance", "AD_Process_ID=? AND AD_User_ID=? AND Name IS NOT NULL", null).setClient_ID().setOnlyActiveRecords(true).setParameters(AD_Process_ID, AD_User_ID).setOrderBy("Name").list();
            for (MPInstance namedInstance : namedInstances) {
                list.add(namedInstance);
                paramsStrAdded.add(namedInstance.getParamsStr());
            }
            int lastRunCount = MSysConfig.getIntValue("LASTRUN_RECORD_COUNT", 5, Env.getAD_Client_ID(ctx));
            if (lastRunCount > 0) {
                int maxLoopCount = 10 * lastRunCount;
                String sql = "SELECT * FROM AD_PInstance  WHERE AD_Process_ID=? AND AD_User_ID=? AND IsActive='Y' AND AD_Client_ID=? AND Name IS NULL ORDER BY Created DESC";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                int runCount = 0;
                int loopCount = 0;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setFetchSize(lastRunCount);
                        pstmt.setInt(1, AD_Process_ID);
                        pstmt.setInt(2, AD_User_ID);
                        pstmt.setInt(3, Env.getAD_Client_ID(ctx));
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            ++loopCount;
                            MPInstance unnamedInstance = new MPInstance(ctx, rs, null);
                            String paramsStr = unnamedInstance.getParamsStr();
                            if (!paramsStrAdded.contains(paramsStr)) {
                                unnamedInstance.setName(Msg.getMsg(ctx, "LastRun") + " " + String.valueOf(unnamedInstance.getCreated()));
                                list.add(unnamedInstance);
                                paramsStrAdded.add(paramsStr);
                                if (++runCount == lastRunCount) break;
                            }
                            if (loopCount != maxLoopCount) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        s_log.log(Level.SEVERE, "Error while Fetching last run records", e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        return list;
    }

    private String getParamsStr() {
        StringBuilder cksum = new StringBuilder();
        MPInstancePara[] mPInstanceParaArray = this.getParameters();
        int n = mPInstanceParaArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPInstancePara ip = mPInstanceParaArray[n2];
            cksum.append("(").append(ip.getParameterName()).append("|").append(ip.getP_String()).append("|").append(ip.getP_String_To()).append("|").append(ip.getP_Number()).append("|").append(ip.getP_Number_To()).append("|").append(ip.getP_Date()).append("|").append(ip.getP_Date_To()).append("|").append(ip.getInfo()).append("|").append(ip.getInfo_To()).append("|").append(")");
            ++n2;
        }
        if (this.getAD_Process().isReport()) {
            cksum.append(this.getAD_Language_ID()).append("|").append(this.getAD_PrintFormat_ID()).append(this.getAD_Language_ID()).append(this.getReportType()).append(this.isSummary());
        }
        return cksum.toString();
    }

    public static PInstanceInfo getPInstanceInfo(int AD_PInstance_ID) throws SQLException {
        PInstanceInfo info = null;
        Object sql = "SELECT p.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport,p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END, p.JasperReport, p.AD_Process_UU FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID) WHERE p.IsActive='Y' AND i.AD_PInstance_ID=?";
        if (!Env.isBaseLanguage(Env.getCtx(), "AD_Process")) {
            sql = "SELECT t.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport, p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END, p.JasperReport, p.AD_Process_UU FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID)  INNER JOIN AD_Process_Trl t ON (p.AD_Process_ID=t.AD_Process_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "') WHERE p.IsActive='Y' AND i.AD_PInstance_ID=?";
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, 1003, 1007, null);
            pstmt.setInt(1, AD_PInstance_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                info = new PInstanceInfo();
                info.name = rs.getString(1);
                info.procedureName = rs.getString(2);
                info.className = rs.getString(3);
                info.AD_Process_ID = rs.getInt(4);
                info.AD_Process_UU = rs.getString(11);
                if ("Y".equals(rs.getString(5))) {
                    info.isReport = true;
                }
                if ("Y".equals(rs.getString(6))) {
                    info.isDirectPrint = true;
                }
                info.AD_ReportView_ID = rs.getInt(7);
                info.AD_Workflow_ID = rs.getInt(8);
                info.estimate = rs.getInt(9);
                info.jasperReport = rs.getString(10);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return info;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int sessionId;
        if (newRecord && (sessionId = Env.getContextAsInt(Env.getCtx(), "#AD_Session_ID")) > 0) {
            this.setAD_Session_ID(sessionId);
        }
        return true;
    }

    public void updatePrintFormatAndLanguageIfEmpty(MPrintFormat format) {
        if (this.getAD_PrintFormat_ID() <= 0 && format.getAD_PrintFormat_ID() > 0) {
            this.setAD_PrintFormat_ID(format.getAD_PrintFormat_ID());
            this.saveEx();
        }
        if (this.getAD_Language_ID() <= 0 && format.getLanguage() != null) {
            this.setAD_Language_ID(MLanguage.get(Env.getCtx(), format.getLanguage()).getAD_Language_ID());
            this.saveEx();
        }
    }

    public static class PInstanceInfo {
        public int AD_Process_ID;
        public String AD_Process_UU;
        public int AD_ReportView_ID = 0;
        public int AD_Workflow_ID = 0;
        public String name;
        public String className;
        public String procedureName = "";
        public String jasperReport = "";
        public boolean isReport = false;
        public boolean isDirectPrint = false;
        public int estimate;
    }
}

