/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.adempiere.base.Core;
import org.adempiere.base.IProductPricing;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.ProductNotOnPriceListException;
import org.adempiere.model.ITaxProvider;
import org.compiere.model.MCharge;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderTax;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MRole;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.model.MUOM;
import org.compiere.model.X_C_OrderLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MOrderLine
extends X_C_OrderLine {
    private static final long serialVersionUID = 7994694334621222461L;
    protected static CLogger s_log = CLogger.getCLogger(MOrderLine.class);
    protected int m_M_PriceList_ID = 0;
    protected boolean m_IsSOTrx = true;
    protected IProductPricing m_productPrice = null;
    protected MTax m_tax = null;
    protected Integer m_precision = null;
    protected MProduct m_product = null;
    protected MCharge m_charge = null;
    protected MOrder m_parent = null;

    public static BigDecimal getNotReserved(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int excludeC_OrderLine_ID) {
        BigDecimal retValue;
        block11: {
            retValue = Env.ZERO;
            Object sql = "SELECT SUM(QtyOrdered-QtyDelivered-QtyReserved) FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE ol.M_Warehouse_ID=? AND M_Product_ID=? AND o.IsSOTrx='Y' AND o.DocStatus='DR' AND QtyOrdered-QtyDelivered-QtyReserved<>0 AND ol.C_OrderLine_ID<>?";
            if (M_AttributeSetInstance_ID != 0) {
                sql = (String)sql + " AND M_AttributeSetInstance_ID=?";
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    pstmt.setInt(3, excludeC_OrderLine_ID);
                    if (M_AttributeSetInstance_ID != 0) {
                        pstmt.setInt(4, M_AttributeSetInstance_ID);
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        retValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, (String)sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            s_log.fine("-");
        } else if (s_log.isLoggable(Level.FINE)) {
            s_log.fine(retValue.toString());
        }
        return retValue;
    }

    public MOrderLine(Properties ctx, String C_OrderLine_UU, String trxName) {
        super(ctx, C_OrderLine_UU, trxName);
        if (Util.isEmpty(C_OrderLine_UU)) {
            this.setInitialDefaults();
        }
    }

    public MOrderLine(Properties ctx, int C_OrderLine_ID, String trxName) {
        this(ctx, C_OrderLine_ID, trxName, null);
    }

    public MOrderLine(Properties ctx, int C_OrderLine_ID, String trxName, String ... virtualColumns) {
        super(ctx, C_OrderLine_ID, trxName, virtualColumns);
        if (C_OrderLine_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setFreightAmt(Env.ZERO);
        this.setLineNetAmt(Env.ZERO);
        this.setPriceEntered(Env.ZERO);
        this.setPriceActual(Env.ZERO);
        this.setPriceLimit(Env.ZERO);
        this.setPriceList(Env.ZERO);
        this.setM_AttributeSetInstance_ID(0);
        this.setQtyEntered(Env.ZERO);
        this.setQtyOrdered(Env.ZERO);
        this.setQtyDelivered(Env.ZERO);
        this.setQtyInvoiced(Env.ZERO);
        this.setQtyReserved(Env.ZERO);
        this.setIsDescription(false);
        this.setProcessed(false);
        this.setLine(0);
    }

    public MOrderLine(MOrder order) {
        this(order.getCtx(), 0, order.get_TrxName());
        if (order.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setC_Order_ID(order.getC_Order_ID());
        this.setOrder(order);
    }

    public MOrderLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setOrder(MOrder order) {
        this.setClientOrg(order);
        this.setC_BPartner_ID(order.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
        this.setM_Warehouse_ID(order.getM_Warehouse_ID());
        this.setDateOrdered(order.getDateOrdered());
        this.setDatePromised(order.getDatePromised());
        this.setC_Currency_ID(order.getC_Currency_ID());
        this.setHeaderInfo(order);
    }

    public void setHeaderInfo(MOrder order) {
        this.m_parent = order;
        this.m_precision = order.getPrecision();
        this.m_M_PriceList_ID = order.getM_PriceList_ID();
        this.m_IsSOTrx = order.isSOTrx();
    }

    public MOrder getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setPrice(BigDecimal PriceActual) {
        this.setPriceEntered(PriceActual);
        this.setPriceActual(PriceActual);
    }

    @Override
    public void setPriceActual(BigDecimal PriceActual) {
        if (PriceActual == null) {
            throw new IllegalArgumentException("PriceActual is mandatory");
        }
        this.set_ValueNoCheck("PriceActual", PriceActual);
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.m_M_PriceList_ID == 0) {
            throw new IllegalStateException("PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID);
    }

    public void setPrice(int M_PriceList_ID) {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString() + " - M_PriceList_ID=" + M_PriceList_ID);
        }
        this.getProductPricing(M_PriceList_ID);
        this.setPriceActual(this.m_productPrice.getPriceStd());
        this.setPriceList(this.m_productPrice.getPriceList());
        this.setPriceLimit(this.m_productPrice.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyOrdered()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyOrdered().divide(this.getQtyEntered(), 12, RoundingMode.HALF_UP)));
        }
        this.setDiscount(this.m_productPrice.getDiscount());
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(this.m_productPrice.getC_UOM_ID());
        }
    }

    protected IProductPricing getProductPricing(int M_PriceList_ID) {
        this.m_productPrice = Core.getProductPricing();
        this.m_productPrice.setOrderLine(this, this.get_TrxName());
        this.m_productPrice.setM_PriceList_ID(M_PriceList_ID);
        this.m_productPrice.calculatePrice();
        return this.m_productPrice;
    }

    public boolean setTax() {
        int ii = Core.getTaxLookup().get(this.getCtx(), this.getM_Product_ID(), this.getC_Charge_ID(), this.getDateOrdered(), this.getDateOrdered(), this.getAD_Org_ID(), this.getM_Warehouse_ID(), this.getC_BPartner_Location_ID(), this.getC_BPartner_Location_ID(), this.m_IsSOTrx, this.getParent().getDeliveryViaRule(), this.get_TrxName());
        if (ii == 0) {
            this.log.log(Level.SEVERE, "No Tax found");
            return false;
        }
        this.setC_Tax_ID(ii);
        return true;
    }

    public void setLineNetAmt() {
        BigDecimal bd = this.getPriceEntered().multiply(this.getQtyEntered());
        int precision = this.getPrecision();
        if (bd.scale() > precision) {
            bd = bd.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setLineNetAmt(bd);
    }

    public MCharge getCharge() {
        if (this.m_charge == null && this.getC_Charge_ID() != 0) {
            this.m_charge = MCharge.getCopy(this.getCtx(), this.getC_Charge_ID(), this.get_TrxName());
        }
        return this.m_charge;
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public int getPrecision() {
        MCurrency cur;
        if (this.m_precision != null) {
            return this.m_precision;
        }
        if (this.getC_Currency_ID() == 0) {
            this.setOrder(this.getParent());
            if (this.m_precision != null) {
                return this.m_precision;
            }
        }
        if (this.getC_Currency_ID() != 0 && (cur = MCurrency.get(this.getCtx(), this.getC_Currency_ID())).get_ID() != 0) {
            this.m_precision = cur.getStdPrecision();
            return this.m_precision;
        }
        String sql = "SELECT c.StdPrecision FROM C_Currency c INNER JOIN C_Order x ON (x.C_Currency_ID=c.C_Currency_ID) WHERE x.C_Order_ID=?";
        int i = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Order_ID());
        this.m_precision = i;
        return this.m_precision;
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.set_ValueNoCheck("C_UOM_ID", null);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        super.setM_Product_ID(M_Product_ID);
        if (C_UOM_ID != 0) {
            super.setC_UOM_ID(C_UOM_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.getCopy(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        }
        return this.m_product;
    }

    @Override
    public void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        if (M_AttributeSetInstance_ID == 0) {
            this.set_Value("M_AttributeSetInstance_ID", (Object)0);
        } else {
            super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        }
    }

    @Override
    public void setM_Warehouse_ID(int M_Warehouse_ID) {
        if (this.getM_Warehouse_ID() > 0 && this.getM_Warehouse_ID() != M_Warehouse_ID && !this.canChangeWarehouse()) {
            this.log.severe("Ignored - Already Delivered/Invoiced/Reserved");
        } else {
            super.setM_Warehouse_ID(M_Warehouse_ID);
        }
    }

    public boolean canChangeWarehouse() {
        if (this.getQtyDelivered().signum() != 0) {
            this.log.saveError("Error", Msg.translate(this.getCtx(), "QtyDelivered") + "=" + String.valueOf(this.getQtyDelivered()));
            return false;
        }
        if (this.getQtyInvoiced().signum() != 0) {
            this.log.saveError("Error", Msg.translate(this.getCtx(), "QtyInvoiced") + "=" + String.valueOf(this.getQtyInvoiced()));
            return false;
        }
        if (this.getQtyReserved().signum() != 0) {
            this.log.saveError("Error", Msg.translate(this.getCtx(), "QtyReserved") + "=" + String.valueOf(this.getQtyReserved()));
            return false;
        }
        return true;
    }

    @Override
    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    @Override
    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    @Override
    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    @Override
    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    @Override
    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    @Override
    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MOrderLine[").append(this.get_ID()).append(", Line=").append(this.getLine()).append(", Ordered=").append(this.getQtyOrdered()).append(", Delivered=").append(this.getQtyDelivered()).append(", Invoiced=").append(this.getQtyInvoiced()).append(", Reserved=").append(this.getQtyReserved()).append(", LineNet=").append(this.getLineNetAmt()).append("]");
        return sb.toString();
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    public String getName() {
        this.getProduct();
        if (this.m_product != null) {
            return this.m_product.getName();
        }
        if (this.getC_Charge_ID() != 0) {
            MCharge charge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
            return charge.getName();
        }
        return "";
    }

    @Override
    public void setC_Charge_ID(int C_Charge_ID) {
        super.setC_Charge_ID(C_Charge_ID);
        if (C_Charge_ID > 0) {
            this.set_ValueNoCheck("C_UOM_ID", null);
        }
    }

    public void setDiscount() {
        BigDecimal list = this.getPriceList();
        if (Env.ZERO.compareTo(list) == 0) {
            return;
        }
        BigDecimal discount = list.subtract(this.getPriceActual()).multiply(Env.ONEHUNDRED).divide(list, this.getPrecision(), RoundingMode.HALF_UP);
        this.setDiscount(discount);
    }

    public boolean isTaxIncluded() {
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = DB.getSQLValue(this.get_TrxName(), "SELECT M_PriceList_ID FROM C_Order WHERE C_Order_ID=?", this.getC_Order_ID());
        }
        MPriceList pl = MPriceList.get(this.getCtx(), this.m_M_PriceList_ID, this.get_TrxName());
        return pl.isTaxIncluded();
    }

    public void setQty(BigDecimal Qty) {
        super.setQtyEntered(Qty);
        super.setQtyOrdered(this.getQtyEntered());
    }

    @Override
    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyEntered(QtyEntered);
    }

    @Override
    public void setQtyOrdered(BigDecimal QtyOrdered) {
        MProduct product = this.getProduct();
        if (QtyOrdered != null && product != null) {
            int precision = product.getUOMPrecision();
            QtyOrdered = QtyOrdered.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyOrdered(QtyOrdered);
    }

    public BigDecimal getBase(String CostDistribution) {
        if ("C".equals(CostDistribution)) {
            return this.getQtyOrdered().multiply(this.getPriceActual());
        }
        if ("L".equals(CostDistribution)) {
            return Env.ONE;
        }
        if ("Q".equals(CostDistribution)) {
            return this.getQtyOrdered();
        }
        if ("V".equals(CostDistribution)) {
            MProduct product = this.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return this.getQtyOrdered().multiply(product.getVolume());
        }
        if ("W".equals(CostDistribution)) {
            MProduct product = this.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return this.getQtyOrdered().multiply(product.getWeight());
        }
        this.log.severe("Invalid Criteria: " + CostDistribution);
        return Env.ZERO;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getParent().isProcessed()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "C_Order_ID"));
            return false;
        }
        if (this.getC_BPartner_ID() == 0 || this.getC_BPartner_Location_ID() == 0 || this.getM_Warehouse_ID() == 0 || this.getC_Currency_ID() == 0) {
            this.setOrder(this.getParent());
        }
        if (this.m_M_PriceList_ID == 0) {
            this.setHeaderInfo(this.getParent());
        }
        if (!newRecord && (this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("M_Warehouse_ID") || !this.getParent().isProcessed() && this.is_ValueChanged("M_AttributeSetInstance_ID")) && !this.canChangeWarehouse()) {
            return false;
        }
        if (this.getC_Charge_ID() != 0 && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        if (this.getM_Product_ID() == 0) {
            this.setM_AttributeSetInstance_ID(0);
        } else if (!this.isProcessed()) {
            boolean enforce;
            if (this.m_productPrice == null && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
                this.setPrice();
            }
            if (this.m_productPrice == null) {
                this.getProductPricing(this.m_M_PriceList_ID);
            }
            boolean bl = enforce = this.m_IsSOTrx && this.getParent().getM_PriceList().isEnforcePriceLimit();
            if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
                enforce = false;
            }
            if (enforce && this.getPriceLimit() != Env.ZERO && this.getPriceActual().compareTo(this.getPriceLimit()) < 0) {
                this.log.saveError("UnderLimitPrice", "PriceEntered=" + String.valueOf(this.getPriceEntered()) + ", PriceLimit=" + String.valueOf(this.getPriceLimit()));
                return false;
            }
            int C_DocType_ID = this.getParent().getDocTypeID();
            MDocType docType = MDocType.get(this.getCtx(), C_DocType_ID);
            if (!docType.isNoPriceListCheck() && !this.m_productPrice.isCalculated()) {
                throw new ProductNotOnPriceListException(this.m_productPrice, this.getLine());
            }
        }
        if (this.getC_UOM_ID() == 0) {
            this.setDefaultC_UOM_ID();
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("QtyOrdered")) {
            this.setQtyOrdered(this.getQtyOrdered());
        }
        if (Env.ZERO.compareTo(this.getFreightAmt()) != 0) {
            this.setFreightAmt(Env.ZERO);
        }
        if (this.getC_Tax_ID() == 0) {
            this.setTax();
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_OrderLine WHERE C_Order_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Order_ID());
            this.setLine(ii);
        }
        this.setLineNetAmt();
        this.setDiscount();
        if (this.getParent().getC_DocTypeTarget().isChargeOrProductMandatory() && this.getC_Charge_ID() == 0 && this.getM_Product_ID() == 0 && (this.getPriceEntered().signum() != 0 || this.getQtyEntered().signum() != 0)) {
            this.log.saveError("FillMandatory", Msg.translate(this.getCtx(), "ChargeOrProductMandatory"));
            return false;
        }
        if (!newRecord && "CL".equals(this.getParent().getDocStatus()) && this.is_ValueChanged("QtyDelivered") && !this.getParent().is_ValueChanged("DocStatus")) {
            if (this.getQtyOrdered().compareTo(this.getQtyDelivered()) > 0) {
                this.setQtyLostSales(this.getQtyLostSales().add(this.getQtyOrdered().subtract(this.getQtyDelivered())));
                this.setQtyOrdered(this.getQtyDelivered());
            } else {
                this.setQtyLostSales(Env.ZERO);
            }
        }
        MClientInfo ci = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        if ("S".equals(this.getParent().getDeliveryViaRule()) && "I".equals(this.getParent().getFreightCostRule()) && (this.getM_Product_ID() > 0 && this.getM_Product_ID() == ci.getM_ProductFreight_ID() || this.getC_Charge_ID() > 0 && this.getC_Charge_ID() == ci.getC_ChargeFreight_ID())) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "FreightOrderLineNotAllowed"));
            return false;
        }
        return true;
    }

    private void setDefaultC_UOM_ID() {
        int C_UOM_ID = 0;
        C_UOM_ID = MProduct.get(this.getCtx(), this.getM_Product_ID()) != null ? MProduct.get(this.getCtx(), this.getM_Product_ID()).getC_UOM_ID() : MUOM.getDefault_UOM_ID(this.getCtx());
        if (C_UOM_ID > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
    }

    @Override
    protected boolean beforeDelete() {
        if (Env.ZERO.compareTo(this.getQtyDelivered()) != 0) {
            this.log.saveError("DeleteError", Msg.translate(this.getCtx(), "QtyDelivered") + "=" + String.valueOf(this.getQtyDelivered()));
            return false;
        }
        if (Env.ZERO.compareTo(this.getQtyInvoiced()) != 0) {
            this.log.saveError("DeleteError", Msg.translate(this.getCtx(), "QtyInvoiced") + "=" + String.valueOf(this.getQtyInvoiced()));
            return false;
        }
        if (Env.ZERO.compareTo(this.getQtyReserved()) != 0) {
            this.log.saveError("DeleteError", Msg.translate(this.getCtx(), "QtyReserved") + "=" + String.valueOf(this.getQtyReserved()));
            return false;
        }
        MRequisitionLine.unlinkC_OrderLine_ID(this.getCtx(), this.get_ID(), this.get_TrxName());
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (this.getParent().isProcessed()) {
            return success;
        }
        if (newRecord || this.is_ValueChanged("C_Tax_ID") || this.is_ValueChanged("LineNetAmt")) {
            MTax tax = new MTax(this.getCtx(), this.getC_Tax_ID(), this.get_TrxName());
            MTaxProvider provider = new MTaxProvider(tax.getCtx(), tax.getC_TaxProvider_ID(), tax.get_TrxName());
            ITaxProvider calculator = Core.getTaxProvider(provider);
            if (calculator == null) {
                throw new AdempiereException(Msg.getMsg(this.getCtx(), "TaxNoProvider"));
            }
            return calculator.recalculateTax(provider, this, newRecord);
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        if (this.getS_ResourceAssignment_ID() != 0) {
            MResourceAssignment ra = new MResourceAssignment(this.getCtx(), this.getS_ResourceAssignment_ID(), this.get_TrxName());
            ra.delete(true);
        }
        return this.updateHeaderTax();
    }

    public boolean updateOrderTax(boolean oldTax) {
        boolean isOldTax;
        int C_Tax_ID = this.getC_Tax_ID();
        boolean bl = isOldTax = oldTax && this.is_ValueChanged("C_Tax_ID");
        if (isOldTax) {
            Object old = this.get_ValueOld("C_Tax_ID");
            if (old == null) {
                return true;
            }
            C_Tax_ID = (Integer)old;
        }
        if (C_Tax_ID == 0) {
            return true;
        }
        MTax t = MTax.get(C_Tax_ID);
        if (t.isSummary()) {
            MOrderTax[] taxes = MOrderTax.getChildTaxes(this, this.getPrecision(), isOldTax, this.get_TrxName());
            if (taxes != null && taxes.length > 0) {
                MOrderTax[] mOrderTaxArray = taxes;
                int n = taxes.length;
                int n2 = 0;
                while (n2 < n) {
                    MOrderTax tax = mOrderTaxArray[n2];
                    if (!tax.calculateTaxFromLines()) {
                        return false;
                    }
                    if (tax.getTaxAmt().signum() != 0 ? !tax.save(this.get_TrxName()) : !tax.is_new() && !tax.delete(false, this.get_TrxName())) {
                        return false;
                    }
                    ++n2;
                }
            }
        } else {
            MOrderTax tax = MOrderTax.get(this, this.getPrecision(), oldTax, this.get_TrxName());
            if (tax != null) {
                if (!tax.calculateTaxFromLines()) {
                    return false;
                }
                if (tax.getTaxAmt().signum() != 0 ? !tax.save(this.get_TrxName()) : !tax.is_new() && !tax.delete(false, this.get_TrxName())) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean updateHeaderTax() {
        if (this.isProcessed() && !this.is_ValueChanged("Processed")) {
            return true;
        }
        MTax tax = new MTax(this.getCtx(), this.getC_Tax_ID(), this.get_TrxName());
        MTaxProvider provider = new MTaxProvider(tax.getCtx(), tax.getC_TaxProvider_ID(), tax.get_TrxName());
        ITaxProvider calculator = Core.getTaxProvider(provider);
        if (calculator == null) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "TaxNoProvider"));
        }
        if (!calculator.updateOrderTax(provider, this)) {
            return false;
        }
        return calculator.updateHeaderTax(provider, this);
    }

    public void clearParent() {
        this.m_parent = null;
    }

    public String getDescriptionStrippingCloseTag() {
        String description = this.getDescription();
        if (description == null) {
            return description;
        }
        Pattern pattern = Pattern.compile("( \\| )?Close \\(.*\\)");
        String[] parts = pattern.split(description);
        StringBuilder description_sb = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            description_sb.append(s);
            ++n2;
        }
        return description_sb.toString();
    }
}

