/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAuthorizationAccount;
import org.compiere.util.CLogger;

public class EMailAuthenticator
extends Authenticator {
    private PasswordAuthentication m_pass = null;
    private boolean m_isOAuth2 = false;
    private MAuthorizationAccount m_authAccount = null;
    private static CLogger log = CLogger.getCLogger(EMailAuthenticator.class);

    public EMailAuthenticator(String username, String password) {
        this.m_authAccount = MAuthorizationAccount.getEMailAccount(username);
        if (this.m_authAccount != null) {
            this.m_isOAuth2 = true;
            try {
                password = this.m_authAccount.refreshAndGetAccessToken();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new AdempiereException(e);
            }
            if (this.m_authAccount.getPreferred_UserName() != null) {
                username = this.m_authAccount.getPreferred_UserName();
            }
        }
        this.m_pass = new PasswordAuthentication(username, password);
        if (username == null || username.length() == 0) {
            log.log(Level.SEVERE, "Username is NULL");
            Thread.dumpStack();
        }
        if (password == null || password.length() == 0) {
            log.log(Level.SEVERE, "Password is NULL");
            Thread.dumpStack();
        }
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return this.m_pass;
    }

    protected MAuthorizationAccount getAuthorizationAccount() {
        return this.m_authAccount;
    }

    protected boolean isOAuth2() {
        return this.m_isOAuth2;
    }

    public String toString() {
        if (this.m_pass == null) {
            return "EMailAuthenticator[]";
        }
        return "EMailAuthenticator[" + this.m_pass.getUserName() + "/************]";
    }
}

