/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.db.Database;
import org.compiere.model.MIndexColumn;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_TableIndex;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MTableIndex
extends X_AD_TableIndex {
    private static final long serialVersionUID = 1433937879086456196L;
    private MIndexColumn[] m_columns = null;
    private String m_ddl = null;
    private String m_whereClause = "";

    public static MTableIndex[] get(MTable table2) {
        Query query = new Query(table2.getCtx(), "AD_TableIndex", "AD_Table_ID=?", table2.get_TrxName());
        query.setParameters(table2.getAD_Table_ID());
        query.setOnlyActiveRecords(true);
        List<MTableIndex> list = query.list();
        MTableIndex[] retValue = new MTableIndex[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static List<MTableIndex> getTableIndexesByQuery(Properties ctx, String whereClause) {
        Query query = new Query(ctx, "AD_TableIndex", whereClause, null);
        List<MTableIndex> list = query.list();
        return list;
    }

    public MTableIndex(Properties ctx, String AD_TableIndex_UU, String trxName) {
        super(ctx, AD_TableIndex_UU, trxName);
        if (Util.isEmpty(AD_TableIndex_UU)) {
            this.setInitialDefaults();
        }
    }

    public MTableIndex(Properties ctx, int AD_TableIndex_ID, String trxName) {
        super(ctx, AD_TableIndex_ID, trxName);
        if (AD_TableIndex_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setEntityType("U");
        this.setIsUnique(false);
        this.setIsCreateConstraint(false);
    }

    public MTableIndex(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.m_ddl = this.createDDL();
    }

    public MTableIndex(MTable parent, String name) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
        this.setName(name);
    }

    public MIndexColumn[] getColumns(boolean reload) {
        return this.getColumns(reload, false);
    }

    public MIndexColumn[] getColumns(boolean reload, boolean activeOnly) {
        StringBuilder where = new StringBuilder("AD_TableIndex_ID").append("=?");
        if (activeOnly) {
            where.append(" AND IsActive='Y'");
        }
        String whereClause = where.toString();
        if (this.m_columns != null && !reload && this.m_whereClause.equalsIgnoreCase(whereClause)) {
            return this.m_columns;
        }
        this.m_whereClause = whereClause;
        Query query = new Query(this.getCtx(), "AD_IndexColumn", whereClause, this.get_TrxName());
        query.setParameters(this.getAD_TableIndex_ID());
        query.setOrderBy("SeqNo");
        List<MIndexColumn> list = query.list();
        this.m_columns = new MIndexColumn[list.size()];
        list.toArray(this.m_columns);
        return this.m_columns;
    }

    public String getTableName() {
        int AD_Table_ID = this.getAD_Table_ID();
        return MTable.getTableName(this.getCtx(), AD_Table_ID);
    }

    private String createDDL() {
        StringBuilder sql = null;
        if (!this.isCreateConstraint()) {
            sql = new StringBuilder("CREATE ");
            if (this.isUnique()) {
                sql.append("UNIQUE ");
            }
            sql.append("INDEX ").append(this.getName()).append(" ON ").append(this.getTableName()).append(this.createColumnList());
        } else if (this.isUnique()) {
            sql = new StringBuilder("ALTER TABLE ").append(this.getTableName()).append(" ADD CONSTRAINT ").append(this.getName());
            if (this.isKey()) {
                sql.append(" PRIMARY KEY");
            } else {
                sql.append(" UNIQUE");
            }
            sql.append(this.createColumnList());
        } else {
            String errMsg = Msg.getMsg(this.getCtx(), "NeitherTableIndexNorUniqueConstraint", new Object[]{this.getTableName()});
            this.log.severe(errMsg);
            throw new AdempiereException(errMsg);
        }
        return sql.toString();
    }

    private String createColumnList() {
        this.getColumns(false, true);
        if (this.m_columns.length <= 0) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "NoIndexColumnsSpecified"));
        }
        StringBuilder columnList = new StringBuilder(" (");
        int i = 0;
        while (i < this.m_columns.length) {
            MIndexColumn ic = this.m_columns[i];
            if (i > 0) {
                columnList.append(",");
            }
            columnList.append(ic.getColumnName());
            ++i;
        }
        columnList.append(")");
        return columnList.toString();
    }

    public String getDDL() {
        if (this.m_ddl == null) {
            this.m_ddl = this.createDDL();
        }
        return this.m_ddl;
    }

    public String getDropDDL() {
        String sql = null;
        sql = this.isCreateConstraint() ? "ALTER TABLE " + this.getAD_Table().getTableName() + " DROP CONSTRAINT " + this.getName() + " CASCADE" : "DROP INDEX " + this.getName();
        return sql;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String error = Database.isValidIdentifier(this.getName());
        if (!Util.isEmpty(error)) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), error) + " [Name]");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MTableIndex[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",AD_Table_ID=").append(this.getAD_Table_ID()).append("]");
        return sb.toString();
    }
}

