/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_C_UOM;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MUOM
extends X_C_UOM
implements ImmutablePOSupport {
    private static final long serialVersionUID = 6277867983718121588L;
    public static final String X12_SECOND = "03";
    public static final String X12_MINUTE = "MJ";
    public static final String X12_HOUR = "HR";
    public static final String X12_DAY = "DA";
    public static final String X12_DAY_WORK = "WD";
    public static final String X12_WEEK = "WK";
    public static final String X12_MONTH = "MO";
    public static final String X12_MONTH_WORK = "WM";
    public static final String X12_YEAR = "YR";
    protected static ImmutableIntPOCache<Integer, MUOM> s_cache = new ImmutableIntPOCache("C_UOM", 30);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMinute_UOM_ID(Properties ctx) {
        Class<MUOM> clazz = MUOM.class;
        synchronized (MUOM.class) {
            for (MUOM uom : s_cache.values()) {
                if (!uom.isMinute()) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return uom.getC_UOM_ID();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            String sql = "SELECT C_UOM_ID FROM C_UOM WHERE IsActive='Y' AND X12DE355=?";
            return DB.getSQLValue(null, sql, X12_MINUTE);
        }
    }

    public static int getDefault_UOM_ID(Properties ctx) {
        String sql = "SELECT C_UOM_ID FROM C_UOM WHERE AD_Client_ID IN (0,?) ORDER BY IsDefault DESC, AD_Client_ID DESC, C_UOM_ID";
        return DB.getSQLValue(null, sql, Env.getAD_Client_ID(ctx));
    }

    public static synchronized MUOM get(int C_UOM_ID) {
        return MUOM.get(Env.getCtx(), C_UOM_ID);
    }

    public static synchronized MUOM get(Properties ctx, int C_UOM_ID) {
        MUOM uom;
        if (s_cache.size() == 0) {
            MUOM.loadUOMs(ctx);
        }
        if ((uom = s_cache.get(ctx, C_UOM_ID, e -> new MUOM(ctx, (MUOM)e))) != null) {
            return uom;
        }
        uom = new MUOM(ctx, C_UOM_ID, null);
        if (uom.get_ID() == C_UOM_ID) {
            s_cache.put(C_UOM_ID, uom, e -> new MUOM(Env.getCtx(), (MUOM)e));
            return uom;
        }
        return null;
    }

    public static MUOM get(Properties ctx, String name, String trxName) {
        MTable table2 = MTable.get(Env.getCtx(), 146);
        MUOM uom = (MUOM)table2.getPO("Name = ?", new Object[]{name}, trxName);
        return uom;
    }

    public static int getPrecision(Properties ctx, int C_UOM_ID) {
        MUOM uom = MUOM.get(ctx, C_UOM_ID);
        return uom.getStdPrecision();
    }

    protected static synchronized void loadUOMs(Properties ctx) {
        List list = new Query(ctx, "C_UOM", "IsActive='Y'", null).setApplyAccessFilter(false, false).list();
        for (MUOM uom : list) {
            s_cache.put(uom.get_ID(), uom, e -> new MUOM(Env.getCtx(), (MUOM)e));
        }
    }

    public MUOM(Properties ctx, String C_UOM_UU, String trxName) {
        super(ctx, C_UOM_UU, trxName);
        if (Util.isEmpty(C_UOM_UU)) {
            this.setInitialDefaults();
        }
    }

    public MUOM(Properties ctx, int C_UOM_ID, String trxName) {
        super(ctx, C_UOM_ID, trxName);
        if (C_UOM_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsDefault(false);
        this.setStdPrecision(2);
        this.setCostingPrecision(6);
    }

    public MUOM(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MUOM(MUOM copy) {
        this(Env.getCtx(), copy);
    }

    public MUOM(Properties ctx, MUOM copy) {
        this(ctx, copy, null);
    }

    public MUOM(Properties ctx, MUOM copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("UOM[");
        sb.append("ID=").append(this.get_ID()).append(", Name=").append(this.getName());
        return sb.toString();
    }

    public BigDecimal round(BigDecimal qty, boolean stdPrecision) {
        int precision = this.getStdPrecision();
        if (!stdPrecision) {
            precision = this.getCostingPrecision();
        }
        if (qty.scale() > precision) {
            return qty.setScale(this.getStdPrecision(), RoundingMode.HALF_UP);
        }
        return qty;
    }

    public boolean isSecond() {
        return X12_SECOND.equals(this.getX12DE355());
    }

    public boolean isMinute() {
        return X12_MINUTE.equals(this.getX12DE355());
    }

    public boolean isHour() {
        return X12_HOUR.equals(this.getX12DE355());
    }

    public boolean isDay() {
        return X12_DAY.equals(this.getX12DE355());
    }

    public boolean isWorkDay() {
        return X12_DAY_WORK.equals(this.getX12DE355());
    }

    public boolean isWeek() {
        return X12_WEEK.equals(this.getX12DE355());
    }

    public boolean isMonth() {
        return X12_MONTH.equals(this.getX12DE355());
    }

    public boolean isWorkMonth() {
        return X12_MONTH_WORK.equals(this.getX12DE355());
    }

    public boolean isYear() {
        return X12_YEAR.equals(this.getX12DE355());
    }

    @Override
    public MUOM markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

