/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.LookupDisplayColumn;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MQuery;
import org.compiere.model.MReference;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MValRule;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class MLookupFactory {
    private static CLogger s_log = CLogger.getCLogger(MLookupFactory.class);
    private static CCache<String, MLookupInfo> s_cacheRefTable = new CCache("AD_Ref_Table", 30, CCache.DEFAULT_EXPIRE_MINUTE);
    private static CCache<String, MLookupInfo> s_cacheRefList = new CCache("AD_Ref_List", 30, CCache.DEFAULT_EXPIRE_MINUTE);

    public static MLookup get(Properties ctx, int WindowNo, int Column_ID, int AD_Reference_ID, Language language, String ColumnName, int AD_Reference_Value_ID, boolean IsParent, String ValidationCode) throws Exception {
        MLookupInfo info = MLookupFactory.getLookupInfo(ctx, WindowNo, Column_ID, AD_Reference_ID, language, ColumnName, AD_Reference_Value_ID, IsParent, ValidationCode);
        if (info == null) {
            throw new Exception("MLookup.create - no LookupInfo");
        }
        return new MLookup(info, 0);
    }

    public static MLookupInfo getLookupInfo(Properties ctx, int WindowNo, int Column_ID, int AD_Reference_ID) {
        return MLookupFactory.getLookupInfo(ctx, WindowNo, 0, Column_ID, AD_Reference_ID);
    }

    public static MLookupInfo getLookupInfo(Properties ctx, int WindowNo, int TabNo, int Column_ID, int AD_Reference_ID) {
        MColumn column = MColumn.get(ctx, Column_ID);
        if (column.get_ID() == 0) {
            s_log.log(Level.SEVERE, "Column Not Found - AD_Column_ID=" + Column_ID);
        }
        String ColumnName = column.getColumnName();
        int AD_Reference_Value_ID = column.getAD_Reference_Value_ID();
        boolean IsParent = column.isParent();
        String ValidationCode = "";
        if (column.getAD_Val_Rule_ID() > 0) {
            MValRule valRule = MValRule.get(ctx, column.getAD_Val_Rule_ID());
            ValidationCode = valRule.getCode();
        }
        MLookupInfo info = MLookupFactory.getLookupInfo(ctx, WindowNo, TabNo, Column_ID, AD_Reference_ID, Env.getLanguage(ctx), ColumnName, AD_Reference_Value_ID, IsParent, ValidationCode);
        return info;
    }

    public static MLookup get(Properties ctx, int WindowNo, int TabNo, int Column_ID, int AD_Reference_ID) {
        MLookupInfo info = MLookupFactory.getLookupInfo(ctx, WindowNo, TabNo, Column_ID, AD_Reference_ID);
        return new MLookup(info, TabNo);
    }

    public static MLookupInfo getLookupInfo(Properties ctx, int WindowNo, int Column_ID, int AD_Reference_ID, Language language, String ColumnName, int AD_Reference_Value_ID, boolean IsParent, String ValidationCode) {
        return MLookupFactory.getLookupInfo(ctx, WindowNo, 0, Column_ID, AD_Reference_ID, language, ColumnName, AD_Reference_Value_ID, IsParent, ValidationCode);
    }

    public static MLookupInfo getLookupInfo(Properties ctx, int WindowNo, int tabNo, int Column_ID, int AD_Reference_ID, Language language, String ColumnName, int AD_Reference_Value_ID, boolean IsParent, String ValidationCode) {
        String newSQL;
        MLookupInfo info = null;
        boolean needToAddSecurity = true;
        if (DisplayType.isList(AD_Reference_ID)) {
            info = MLookupFactory.getLookup_List(language, AD_Reference_Value_ID);
            needToAddSecurity = false;
        } else {
            info = (AD_Reference_ID == 18 || AD_Reference_ID == 200233 || AD_Reference_ID == 30 || AD_Reference_ID == 200235 || AD_Reference_ID == 200162 || AD_Reference_ID == 200163) && AD_Reference_Value_ID != 0 ? MLookupFactory.getLookup_Table(ctx, language, WindowNo, AD_Reference_Value_ID) : MLookupFactory.getLookup_TableDir(ctx, language, WindowNo, ColumnName);
        }
        if (info == null) {
            s_log.severe("No SQL - " + ColumnName);
            return null;
        }
        info.ctx = ctx;
        info.WindowNo = WindowNo;
        info.tabNo = tabNo;
        info.Column_ID = Column_ID;
        info.DisplayType = AD_Reference_ID;
        info.AD_Reference_Value_ID = AD_Reference_Value_ID;
        info.IsParent = IsParent;
        info.ValidationCode = ValidationCode;
        if (info.ValidationCode == null) {
            info.ValidationCode = "";
        }
        if (info.Query.indexOf(64) != -1) {
            newSQL = Env.parseContext(ctx, 0, info.Query, false);
            if (newSQL.length() == 0) {
                s_log.severe("SQL parse error: " + info.Query);
                return null;
            }
            info.Query = newSQL;
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("getLookupInfo, newSQL =" + newSQL);
            }
        }
        if (info.QueryDirect.indexOf(64) != -1) {
            newSQL = Env.parseContext(ctx, 0, info.QueryDirect, false);
            if (newSQL.length() == 0) {
                s_log.severe("SQL parse error: " + info.QueryDirect);
                return null;
            }
            info.QueryDirect = newSQL;
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("getLookupInfo, newSQL =" + newSQL);
            }
        }
        info.IsValidated = info.ValidationCode.length() == 0;
        if (needToAddSecurity) {
            info.Query = MRole.getDefault(ctx, false).addAccessSQL(info.Query, info.TableName, true, false);
        }
        return info;
    }

    public static MLookupInfo getLookup_List(Language language, int AD_Reference_Value_ID) {
        String lang = language == null ? Env.getAD_Language(Env.getCtx()) : language.getAD_Language();
        StringBuilder key = new StringBuilder().append(Env.getAD_Client_ID(Env.getCtx())).append("|").append(lang).append("|").append(String.valueOf(AD_Reference_Value_ID));
        MLookupInfo retValue = s_cacheRefList.get(key.toString());
        if (retValue != null) {
            if (s_log.isLoggable(Level.FINEST)) {
                s_log.finest("Cache: " + String.valueOf(retValue));
            }
            return retValue.cloneIt();
        }
        boolean orderByValue = MReference.get(AD_Reference_Value_ID).isOrderByValue();
        StringBuilder realSQL = new StringBuilder("SELECT NULL, AD_Ref_List.Value,");
        MClient client = MClient.get(Env.getCtx());
        StringBuilder AspFilter = new StringBuilder();
        if (client.isUseASP()) {
            AspFilter.append(" AND AD_Ref_List.AD_Ref_List_ID NOT IN ( ").append(" SELECT li.AD_Ref_List_ID").append(" FROM ASP_Ref_List li").append(" INNER JOIN ASP_Level l ON ( li.ASP_Level_ID = l.ASP_Level_ID)").append(" INNER JOIN ASP_ClientLevel cl on (l.ASP_Level_ID = cl.ASP_Level_ID)").append(" INNER JOIN AD_Client c on (cl.AD_Client_ID = c.AD_Client_ID)").append(" WHERE li.AD_Reference_ID=").append(AD_Reference_Value_ID).append(" AND li.IsActive='Y'").append(" AND c.AD_Client_ID=").append(client.getAD_Client_ID()).append(" AND li.ASP_Status='H')");
        }
        if (Env.isBaseLanguage(language, "AD_Ref_List")) {
            realSQL.append("AD_Ref_List.Name,AD_Ref_List.IsActive FROM AD_Ref_List ");
        } else {
            realSQL.append("trl.Name, AD_Ref_List.IsActive ").append("FROM AD_Ref_List  INNER JOIN AD_Ref_List_Trl trl ").append(" ON (AD_Ref_List.AD_Ref_List_ID=trl.AD_Ref_List_ID AND trl.AD_Language='").append(language.getAD_Language()).append("')");
        }
        realSQL.append(" WHERE AD_Ref_List.AD_Reference_ID=").append(AD_Reference_Value_ID);
        String directSql = realSQL.toString() + " AND AD_Ref_List.Value=?";
        realSQL.append(AspFilter.toString());
        if (orderByValue) {
            realSQL.append(" ORDER BY 2");
        } else {
            realSQL.append(" ORDER BY 3");
        }
        MLookupInfo info = new MLookupInfo(realSQL.toString(), "AD_Ref_List", "AD_Ref_List.Value", 101, 101, MQuery.getEqualQuery("AD_Reference_ID", AD_Reference_Value_ID));
        info.QueryDirect = directSql;
        s_cacheRefList.put(key.toString(), info.cloneIt());
        return info;
    }

    public static String getLookup_ListEmbed(Language language, int AD_Reference_Value_ID, String linkColumnName) {
        StringBuilder realSQL = new StringBuilder("SELECT ");
        if (Env.isBaseLanguage(language, "AD_Ref_List")) {
            realSQL.append("AD_Ref_List.Name FROM AD_Ref_List ");
        } else {
            realSQL.append("trl.Name ").append("FROM AD_Ref_List  INNER JOIN AD_Ref_List_Trl trl ").append(" ON (AD_Ref_List.AD_Ref_List_ID=trl.AD_Ref_List_ID AND trl.AD_Language='").append(language.getAD_Language()).append("')");
        }
        realSQL.append(" WHERE AD_Ref_List.AD_Reference_ID=").append(AD_Reference_Value_ID).append(" AND AD_Ref_List.Value=").append(linkColumnName);
        return realSQL.toString();
    }

    private static MLookupInfo getLookup_Table(Properties ctx, Language language, int WindowNo, int AD_Reference_Value_ID) {
        int zoomWinID;
        String lang = language == null ? Env.getAD_Language(Env.getCtx()) : language.getAD_Language();
        StringBuilder key = new StringBuilder().append(Env.getAD_Client_ID(ctx)).append("|").append(Env.getAD_Role_ID(ctx)).append("|").append(Env.getAD_User_ID(ctx)).append("|").append(lang).append("|").append(String.valueOf(AD_Reference_Value_ID));
        MLookupInfo retValue = s_cacheRefTable.get(key.toString());
        if (retValue != null) {
            if (s_log.isLoggable(Level.FINEST)) {
                s_log.finest("Cache: " + String.valueOf(retValue));
            }
            return retValue.cloneIt();
        }
        String sql0 = "SELECT t.TableName,ck.ColumnName AS KeyColumn,cd.ColumnName AS DisplayColumn,rt.IsValueDisplayed,cd.IsTranslated,rt.WhereClause,rt.OrderByClause,t.AD_Window_ID,t.PO_Window_ID, t.AD_Table_ID, cd.ColumnSQL as DisplayColumnSQL, rt.AD_Window_ID as RT_AD_Window_ID, rt.AD_InfoWindow_ID as AD_InfoWindow_ID FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Column ck ON (rt.AD_Key=ck.AD_Column_ID) INNER JOIN AD_Column cd ON (rt.AD_Display=cd.AD_Column_ID) WHERE rt.AD_Reference_ID=? AND rt.IsActive='Y' AND t.IsActive='Y'";
        String KeyColumn = null;
        String DisplayColumn = null;
        String TableName = null;
        String WhereClause = null;
        String OrderByClause = null;
        String displayColumnSQL = null;
        boolean IsTranslated = false;
        boolean isValueDisplayed = false;
        int ZoomWindow = 0;
        int ZoomWindowPO = 0;
        int overrideZoomWindow = 0;
        int infoWindowId = 0;
        boolean loaded = false;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql0, null);
                pstmt.setInt(1, AD_Reference_Value_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    TableName = rs.getString(1);
                    KeyColumn = rs.getString(2);
                    DisplayColumn = rs.getString(3);
                    isValueDisplayed = "Y".equals(rs.getString(4));
                    IsTranslated = "Y".equals(rs.getString(5));
                    WhereClause = rs.getString(6);
                    OrderByClause = rs.getString(7);
                    ZoomWindow = rs.getInt(8);
                    ZoomWindowPO = rs.getInt(9);
                    displayColumnSQL = rs.getString(11);
                    if (displayColumnSQL != null && displayColumnSQL.length() > 0 && (displayColumnSQL.startsWith("@SQL=") || displayColumnSQL.startsWith("@SQLFIND="))) {
                        displayColumnSQL = "NULL";
                    }
                    if (displayColumnSQL != null && displayColumnSQL.contains("@")) {
                        displayColumnSQL = Env.parseContext(Env.getCtx(), -1, displayColumnSQL, false, true);
                    }
                    overrideZoomWindow = rs.getInt(12);
                    infoWindowId = rs.getInt(13);
                    loaded = true;
                }
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, sql0, e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (!loaded) {
            s_log.log(Level.SEVERE, "No Table Reference Table ID=" + AD_Reference_Value_ID);
            return null;
        }
        StringBuilder realSQL = new StringBuilder("SELECT ");
        if (!KeyColumn.endsWith("_ID") && !KeyColumn.endsWith("_UU")) {
            realSQL.append("NULL,");
        }
        boolean showID = DisplayColumn.equals(TableName + "_ID") || DisplayColumn.equals(PO.getUUIDColumnName(TableName));
        ArrayList<LookupDisplayColumn> list = null;
        if (showID) {
            list = MLookupFactory.getListIdentifiers(TableName);
            if (list == null || list.size() == 0) {
                if (s_log.isLoggable(Level.INFO)) {
                    s_log.log(Level.INFO, "No Identifier records found: " + KeyColumn);
                }
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(new LookupDisplayColumn(KeyColumn, null, false, 13, 0));
            }
            IsTranslated = false;
            for (LookupDisplayColumn ldc : list) {
                if (IsTranslated || !ldc.IsTranslated) continue;
                IsTranslated = true;
                break;
            }
        }
        String separator = MSysConfig.getValue("IDENTIFIER_SEPARATOR", "_", Env.getAD_Client_ID(Env.getCtx()));
        String lookupDisplayColumn = null;
        if (IsTranslated && !Env.isBaseLanguage(language, TableName)) {
            realSQL.append(TableName).append(".").append(KeyColumn).append(",");
            if (KeyColumn.endsWith("_ID") || KeyColumn.endsWith("_UU")) {
                realSQL.append("NULL,");
            }
            if (isValueDisplayed) {
                realSQL.append("NVL(").append(TableName).append(".Value,'-1') || '").append(separator).append("' || ");
            }
            if (displayColumnSQL != null && displayColumnSQL.trim().length() > 0) {
                realSQL.append("NVL(").append(displayColumnSQL).append(",'-1')");
            } else if (showID) {
                displayColumn = MLookupFactory.getDisplayColumn(language, TableName, list);
                lookupDisplayColumn = displayColumn.toString();
                realSQL.append((CharSequence)displayColumn);
            } else {
                lookupDisplayColumn = DisplayColumn;
                realSQL.append("NVL(").append(TableName).append("_Trl.").append(DisplayColumn).append(",'-1')");
            }
            realSQL.append(",").append(TableName).append(".IsActive");
            realSQL.append(" FROM ").append(TableName).append(" INNER JOIN ").append(TableName).append("_TRL ON (").append(TableName).append(".").append(KeyColumn).append("=").append(TableName).append("_Trl.").append(KeyColumn).append(" AND ").append(TableName).append("_Trl.AD_Language='").append(language.getAD_Language()).append("')");
        } else {
            realSQL.append(TableName).append(".").append(KeyColumn).append(",");
            if (KeyColumn.endsWith("_ID") || KeyColumn.endsWith("_UU")) {
                realSQL.append("NULL,");
            }
            if (isValueDisplayed) {
                realSQL.append("NVL(").append(TableName).append(".Value,'-1') || '").append(separator).append("' || ");
            }
            if (displayColumnSQL != null && displayColumnSQL.trim().length() > 0) {
                realSQL.append("NVL(").append(displayColumnSQL).append(",'-1')");
            } else if (showID) {
                displayColumn = MLookupFactory.getDisplayColumn(language, TableName, list);
                lookupDisplayColumn = displayColumn.toString();
                realSQL.append((CharSequence)displayColumn);
            } else {
                lookupDisplayColumn = DisplayColumn;
                realSQL.append("NVL(").append(TableName).append(".").append(DisplayColumn).append(",'-1')");
            }
            realSQL.append(",").append(TableName).append(".IsActive");
            realSQL.append(" FROM ").append(TableName);
        }
        String directQuery = realSQL.toString() + " WHERE " + TableName + "." + KeyColumn + "=?";
        MQuery zoomQuery = null;
        if (WhereClause != null && WhereClause.length() > 0) {
            String where = WhereClause;
            if (where.indexOf(64) != -1) {
                where = Env.parseContext(ctx, WindowNo, where, false);
            }
            if (where.length() == 0 && WhereClause.length() != 0) {
                s_log.severe("Could not resolve: " + WhereClause);
            }
            if (where.length() != 0) {
                realSQL.append(" WHERE ").append(where);
                if (where.indexOf(46) == -1) {
                    s_log.log(Level.SEVERE, "getLookup_Table - " + TableName + ": WHERE should be fully qualified: " + WhereClause);
                }
                zoomQuery = new MQuery(TableName);
                zoomQuery.addRestriction(where);
            }
        }
        if (OrderByClause != null && OrderByClause.length() > 0) {
            realSQL.append(" ORDER BY ").append(OrderByClause);
            if (OrderByClause.indexOf(46) == -1) {
                s_log.log(Level.SEVERE, "getLookup_Table - " + TableName + ": ORDER BY must fully qualified: " + OrderByClause);
            }
        } else {
            realSQL.append(" ORDER BY 3");
        }
        if (s_log.isLoggable(Level.FINEST)) {
            s_log.finest("AD_Reference_Value_ID=" + AD_Reference_Value_ID + " - " + String.valueOf(realSQL));
        }
        if ((zoomWinID = Env.getZoomWindowID(MTable.get(ctx, TableName).getAD_Table_ID(), 0, WindowNo)) > 0) {
            ZoomWindow = zoomWinID;
        }
        if (overrideZoomWindow > 0) {
            ZoomWindow = overrideZoomWindow;
            ZoomWindowPO = 0;
        }
        StringBuilder msginf = new StringBuilder().append(TableName).append(".").append(KeyColumn);
        retValue = new MLookupInfo(realSQL.toString(), TableName, msginf.toString(), ZoomWindow, ZoomWindowPO, zoomQuery);
        retValue.DisplayColumn = lookupDisplayColumn;
        retValue.InfoWindowId = infoWindowId;
        retValue.QueryDirect = MRole.getDefault().addAccessSQL(directQuery, TableName, true, false);
        ArrayList<String> lookupDisplayColumns = new ArrayList<String>();
        if (isValueDisplayed) {
            lookupDisplayColumns.add("Value");
        }
        lookupDisplayColumns.add(lookupDisplayColumn != null ? lookupDisplayColumn : DisplayColumn);
        retValue.lookupDisplayColumns = lookupDisplayColumns;
        if (list != null) {
            retValue.lookupDisplayColumnNames = new ArrayList<String>();
            if (isValueDisplayed) {
                retValue.lookupDisplayColumnNames.add("Value");
            }
            for (LookupDisplayColumn ldc : list) {
                retValue.lookupDisplayColumnNames.add(ldc.ColumnName);
            }
        } else {
            retValue.lookupDisplayColumnNames = new ArrayList<String>(retValue.lookupDisplayColumns);
        }
        s_cacheRefTable.put(key.toString(), retValue.cloneIt());
        return retValue;
    }

    public static String getLookup_TableEmbed(Language language, String BaseColumn, String BaseTable, int AD_Reference_Value_ID) {
        MColumn columnDisplay;
        boolean showID;
        boolean IsTranslated;
        boolean isValueDisplayed;
        String DisplayColumn;
        String KeyColumn;
        String TableName;
        ResultSet rs;
        CPreparedStatement pstmt;
        Integer columnDisplay_ID;
        String sql;
        block18: {
            sql = "SELECT t.TableName,ck.ColumnName AS KeyColumn,cd.ColumnName AS DisplayColumn,rt.isValueDisplayed,cd.IsTranslated, cd.AD_Column_ID AS columnDisplay_ID FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Column ck ON (rt.AD_Key=ck.AD_Column_ID) INNER JOIN AD_Column cd ON (rt.AD_Display=cd.AD_Column_ID) WHERE rt.AD_Reference_ID=? AND rt.IsActive='Y' AND t.IsActive='Y'";
            columnDisplay_ID = 0;
            pstmt = null;
            rs = null;
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Reference_Value_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) break block18;
            s_log.log(Level.SEVERE, "Cannot find Reference Table, ID=" + AD_Reference_Value_ID + ", Base=" + BaseTable + "." + BaseColumn);
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return null;
        }
        try {
            try {
                TableName = rs.getString(1);
                KeyColumn = rs.getString(2);
                DisplayColumn = rs.getString(3);
                isValueDisplayed = rs.getString(4).equals("Y");
                IsTranslated = rs.getString(5).equals("Y");
                columnDisplay_ID = rs.getInt(6);
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, sql, e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        int Column_ID = MColumn.getColumn_ID(BaseTable, BaseColumn);
        MColumn column = MColumn.get(Env.getCtx(), Column_ID);
        boolean bl = showID = DisplayColumn.equals(TableName + "_ID") || DisplayColumn.equals(PO.getUUIDColumnName(TableName));
        if (showID) {
            if (column.isVirtualColumn()) {
                return MLookupFactory.getLookup_TableDirEmbed(language, DisplayColumn, BaseTable, column.getColumnSQL());
            }
            return MLookupFactory.getLookup_TableDirEmbed(language, DisplayColumn, BaseTable, BaseColumn);
        }
        Object TableNameAlias = TableName.equals(BaseTable) ? TableName + "1" : TableName;
        StringBuilder embedSQL = new StringBuilder("SELECT ");
        if (isValueDisplayed) {
            String separator = MSysConfig.getValue("IDENTIFIER_SEPARATOR", "_", Env.getAD_Client_ID(Env.getCtx()));
            embedSQL.append((String)TableNameAlias).append(".Value||'").append(separator).append("'||");
        }
        if ((columnDisplay = MColumn.get(Env.getCtx(), columnDisplay_ID)).isVirtualUIColumn() || columnDisplay.isVirtualSearchColumn()) {
            s_log.warning("Virtual UI Column must not be used as display");
            return null;
        }
        boolean translated = false;
        if (IsTranslated && !Env.isBaseLanguage(language, TableName)) {
            translated = true;
            if (columnDisplay.isVirtualColumn()) {
                s_log.warning("Column SQL should not be Translated");
                return null;
            }
            embedSQL.append(TableName).append("_Trl.").append(DisplayColumn);
            embedSQL.append(" FROM ").append(TableName).append(" ").append((String)TableNameAlias).append(" INNER JOIN ").append(TableName).append("_TRL ON (").append((String)TableNameAlias).append(".").append(KeyColumn).append("=").append(TableName).append("_Trl.").append(KeyColumn).append(" AND ").append(TableName).append("_Trl.AD_Language='").append(language.getAD_Language()).append("')");
        } else {
            if (columnDisplay.isVirtualColumn()) {
                embedSQL.append(columnDisplay.getColumnSQL(true)).append(" AS ").append(KeyColumn);
            } else {
                embedSQL.append((String)TableNameAlias).append(".").append(DisplayColumn);
            }
            embedSQL.append(" FROM ").append(TableName).append(" ").append((String)TableNameAlias);
        }
        embedSQL.append(" WHERE ");
        if (!column.isVirtualColumn()) {
            embedSQL.append(BaseTable).append(".").append(BaseColumn);
            embedSQL.append("=").append((String)TableNameAlias).append(".").append(KeyColumn);
        } else if (translated) {
            embedSQL.append((String)TableNameAlias).append(".").append(KeyColumn).append("=").append(column.getColumnSQL(true));
        } else {
            embedSQL.append((String)TableNameAlias).append(".").append(KeyColumn).append("=").append(column.getColumnSQL(true));
        }
        return embedSQL.toString();
    }

    private static MLookupInfo getLookup_TableDir(Properties ctx, Language language, int WindowNo, String ColumnName) {
        if (!ColumnName.endsWith("_ID") && !ColumnName.endsWith("_UU")) {
            String error = "Key does not end with '_ID' or '_UU': " + ColumnName;
            s_log.log(Level.SEVERE, error, new Exception(error));
            return null;
        }
        String KeyColumn = MQuery.getZoomColumnName(ColumnName);
        String TableName = MQuery.getZoomTableName(ColumnName);
        int ZoomWindow = 0;
        int ZoomWindowPO = 0;
        StringBuilder cacheKey = new StringBuilder().append(Env.getAD_Client_ID(ctx)).append("|").append(Env.getAD_Role_ID(ctx)).append("|").append(Env.getAD_User_ID(ctx)).append("|").append(language.getAD_Language()).append("|").append(TableName).append(".").append(KeyColumn);
        if (s_cacheRefTable.containsKey(cacheKey.toString())) {
            return s_cacheRefTable.get(cacheKey.toString()).cloneIt();
        }
        ArrayList<LookupDisplayColumn> list = MLookupFactory.getListIdentifiers(TableName);
        if (list == null || list.size() == 0) {
            if (s_log.isLoggable(Level.INFO)) {
                s_log.log(Level.INFO, "No Identifier records found: " + ColumnName);
            }
            if (list == null) {
                list = new ArrayList();
            }
            list.add(new LookupDisplayColumn(KeyColumn, null, false, 13, 0));
        }
        boolean isTranslated = false;
        for (LookupDisplayColumn ldc : list) {
            if (isTranslated || !ldc.IsTranslated) continue;
            isTranslated = true;
            break;
        }
        MTable table2 = MTable.get(ctx, TableName);
        ZoomWindow = table2.getAD_Window_ID();
        ZoomWindowPO = table2.getPO_Window_ID();
        int zoomWinID = Env.getZoomWindowID(table2.getAD_Table_ID(), 0, WindowNo);
        if (zoomWinID > 0) {
            ZoomWindow = zoomWinID;
        }
        StringBuilder realSQL = new StringBuilder("SELECT ");
        realSQL.append(TableName).append(".").append(KeyColumn).append(",NULL,");
        StringBuilder displayColumn = MLookupFactory.getDisplayColumn(language, TableName, list);
        realSQL.append(displayColumn.toString());
        realSQL.append(",").append(TableName).append(".IsActive");
        if (isTranslated && !Env.isBaseLanguage(language, TableName)) {
            realSQL.append(" FROM ").append(TableName).append(" INNER JOIN ").append(TableName).append("_TRL ON (").append(TableName).append(".").append(KeyColumn).append("=").append(TableName).append("_Trl.").append(KeyColumn).append(" AND ").append(TableName).append("_Trl.AD_Language='").append(language.getAD_Language()).append("')");
        } else {
            realSQL.append(" FROM ").append(TableName);
        }
        String directQuery = realSQL.toString() + " WHERE " + TableName + "." + KeyColumn + "=?";
        realSQL.append(" ORDER BY 3");
        MQuery zoomQuery = null;
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("ColumnName=" + ColumnName + " - " + String.valueOf(realSQL));
        }
        StringBuilder msginf = new StringBuilder().append(TableName).append(".").append(KeyColumn);
        MLookupInfo lInfo = new MLookupInfo(realSQL.toString(), TableName, msginf.toString(), ZoomWindow, ZoomWindowPO, zoomQuery);
        lInfo.DisplayColumn = displayColumn.toString();
        lInfo.QueryDirect = MRole.getDefault().addAccessSQL(directQuery, TableName, true, false);
        ArrayList<String> lookupDisplayColumns = new ArrayList<String>();
        for (LookupDisplayColumn ldc : list) {
            lookupDisplayColumns.add(ldc.ColumnName);
        }
        lInfo.lookupDisplayColumns = lookupDisplayColumns;
        if (list != null) {
            lInfo.lookupDisplayColumnNames = new ArrayList<String>();
            for (LookupDisplayColumn ldc : list) {
                lInfo.lookupDisplayColumnNames.add(ldc.ColumnName);
            }
        }
        s_cacheRefTable.put(cacheKey.toString(), lInfo.cloneIt());
        return lInfo;
    }

    private static StringBuilder getDisplayColumn(Language language, String tableName, ArrayList<LookupDisplayColumn> list) {
        return MLookupFactory.getDisplayColumn(language, tableName, list, tableName);
    }

    private static StringBuilder getDisplayColumn(Language language, String TableName, ArrayList<LookupDisplayColumn> list, String baseTable) {
        StringBuilder displayColumn = new StringBuilder();
        int size = list.size();
        int i2 = 0;
        while (i2 < size) {
            if (i2 > 0) {
                displayColumn.append(" ||'").append(MSysConfig.getValue("IDENTIFIER_SEPARATOR", "_", Env.getAD_Client_ID(Env.getCtx()))).append("'|| ");
            }
            LookupDisplayColumn ldc = list.get(i2);
            StringBuilder msg = new StringBuilder().append(TableName).append(".").append(ldc.ColumnName);
            String columnSQL = ldc.IsVirtual ? ldc.ColumnSQL : msg.toString();
            displayColumn.append("NVL(");
            if (ldc.IsTranslated && !Env.isBaseLanguage(language, TableName) && !ldc.IsVirtual && baseTable != null && !(TableName + "_Trl").equalsIgnoreCase(baseTable)) {
                displayColumn.append(TableName).append("_Trl.").append(ldc.ColumnName);
            } else if (DisplayType.isDate(ldc.DisplayType) || DisplayType.isNumeric(ldc.DisplayType)) {
                displayColumn.append(DB.TO_CHAR(columnSQL, ldc.DisplayType, language.getAD_Language()));
            } else if ((ldc.DisplayType == 18 || ldc.DisplayType == 200233 || ldc.DisplayType == 30 || ldc.DisplayType == 200235) && ldc.AD_Reference_ID != 0) {
                embeddedSQL = ldc.IsVirtual ? MLookupFactory.getLookup_TableEmbed(language, ldc.ColumnSQL, TableName, ldc.AD_Reference_ID) : MLookupFactory.getLookup_TableEmbed(language, ldc.ColumnName, TableName, ldc.AD_Reference_ID);
                if (embeddedSQL != null) {
                    displayColumn.append("(").append(embeddedSQL).append(")");
                }
            } else if ((ldc.DisplayType == 19 || ldc.DisplayType == 30) && ldc.ColumnName.endsWith("_ID") || (ldc.DisplayType == 200234 || ldc.DisplayType == 200235) && ldc.ColumnName.endsWith("_UU")) {
                embeddedSQL = ldc.IsVirtual ? MLookupFactory.getLookup_TableDirEmbed(language, ldc.ColumnName, TableName, ldc.ColumnSQL) : MLookupFactory.getLookup_TableDirEmbed(language, ldc.ColumnName, TableName);
                if (embeddedSQL != null) {
                    displayColumn.append("(").append(embeddedSQL).append(")");
                }
            } else if (DisplayType.isList(ldc.DisplayType)) {
                if (ldc.DisplayType == 200161) {
                    displayColumn.append(columnSQL);
                } else {
                    embeddedSQL = MLookupFactory.getLookup_ListEmbed(language, ldc.AD_Reference_ID, ldc.ColumnName);
                    if (embeddedSQL != null) {
                        displayColumn.append("(").append(embeddedSQL).append(")");
                    }
                }
            } else if (DisplayType.isID(ldc.DisplayType)) {
                displayColumn.append(DB.TO_CHAR(columnSQL, ldc.DisplayType, language.getAD_Language()));
            } else {
                displayColumn.append(columnSQL);
            }
            displayColumn.append(",'-1')");
            ++i2;
        }
        return displayColumn;
    }

    public static String getLookup_TableDirEmbed(Language language, String ColumnName, String BaseTable) {
        return MLookupFactory.getLookup_TableDirEmbed(language, ColumnName, BaseTable, ColumnName);
    }

    public static String getLookup_TableDirEmbed(Language language, String ColumnName, String BaseTable, String BaseColumn) {
        String KeyColumn = MQuery.getZoomColumnName(ColumnName);
        String TableName = MQuery.getZoomTableName(ColumnName);
        ArrayList<LookupDisplayColumn> list = MLookupFactory.getListIdentifiers(TableName);
        if (list == null || list.size() == 0) {
            s_log.log(Level.SEVERE, "No Identifier records found: " + ColumnName);
            return "";
        }
        boolean isTranslated = false;
        for (LookupDisplayColumn ldc : list) {
            if (isTranslated || !ldc.IsTranslated) continue;
            isTranslated = true;
            break;
        }
        StringBuilder embedSQL = new StringBuilder("SELECT ");
        StringBuilder displayColumn = MLookupFactory.getDisplayColumn(language, TableName, list, BaseTable);
        embedSQL.append(displayColumn.toString());
        embedSQL.append(" FROM ").append(TableName);
        if (isTranslated && !Env.isBaseLanguage(language, TableName) && !(TableName + "_Trl").equalsIgnoreCase(BaseTable)) {
            embedSQL.append(" INNER JOIN ").append(TableName).append("_TRL ON (").append(TableName).append(".").append(KeyColumn).append("=").append(TableName).append("_Trl.").append(KeyColumn).append(" AND ").append(TableName).append("_Trl.AD_Language=").append(DB.TO_STRING(language.getAD_Language())).append(")");
        }
        embedSQL.append(" WHERE ");
        if (!BaseColumn.trim().startsWith("(")) {
            embedSQL.append(BaseTable).append(".").append(BaseColumn);
        } else {
            embedSQL.append(BaseColumn);
        }
        embedSQL.append("=").append(TableName).append(".").append(ColumnName);
        return embedSQL.toString();
    }

    private static ArrayList<LookupDisplayColumn> getListIdentifiers(String TableName) {
        ArrayList<LookupDisplayColumn> list = new ArrayList<LookupDisplayColumn>();
        MTable table2 = MTable.get(Env.getCtx(), TableName);
        if (table2 == null) {
            return null;
        }
        String[] stringArray = table2.getIdentifierColumns();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String idColumnName = stringArray[n2];
            MColumn column = table2.getColumn(idColumnName);
            LookupDisplayColumn ldc = new LookupDisplayColumn(column.getColumnName(), column.getColumnSQL(true), column.isTranslated(), column.getAD_Reference_ID(), column.getAD_Reference_Value_ID());
            list.add(ldc);
            ++n2;
        }
        return list;
    }
}

