/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MClientInfo;
import org.compiere.model.MColumn;
import org.compiere.model.MForm;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTab;
import org.compiere.model.MTask;
import org.compiere.model.MToolBarButton;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.MWindow;
import org.compiere.model.X_ASP_Field;
import org.compiere.model.X_ASP_Form;
import org.compiere.model.X_ASP_Process;
import org.compiere.model.X_ASP_Process_Para;
import org.compiere.model.X_ASP_Tab;
import org.compiere.model.X_ASP_Task;
import org.compiere.model.X_ASP_Window;
import org.compiere.model.X_ASP_Workflow;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;

@Process
public class ASPGenerateLevel
extends SvrProcess {
    private String p_ASP_Status;
    private int p_AD_Menu_ID;
    private boolean p_IsGenerateFields;
    private int p_ASP_Level_ID;
    private int noWindows = 0;
    private int noTabs = 0;
    private int noFields = 0;
    private int noProcesses = 0;
    private int noParameters = 0;
    private int noForms = 0;
    private int noTasks = 0;
    private int noWorkflows = 0;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals("ASP_Status")) {
                    this.p_ASP_Status = (String)para.getParameter();
                } else if (name.equals("AD_Menu_ID")) {
                    this.p_AD_Menu_ID = para.getParameterAsInt();
                } else if (name.equals("IsGenerateFields")) {
                    this.p_IsGenerateFields = para.getParameter().equals("Y");
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
                }
            }
            ++n2;
        }
        this.p_ASP_Level_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        StringBuilder msglog = new StringBuilder("ASP_Status=").append(this.p_ASP_Status).append(", AD_Menu_ID=").append(this.p_AD_Menu_ID).append(", IsGenerateFields=").append(this.p_IsGenerateFields);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(msglog.toString());
        }
        MClientInfo clientInfo = MClientInfo.get((Properties)this.getCtx(), (int)this.getAD_Client_ID(), (String)this.get_TrxName());
        int AD_Tree_ID = clientInfo.getAD_Tree_Menu_ID();
        MTree thisTree = new MTree(this.getCtx(), AD_Tree_ID, true, true, true, this.get_TrxName());
        MTreeNode node = this.p_AD_Menu_ID > 0 ? thisTree.getRoot().findNode(this.p_AD_Menu_ID) : thisTree.getRoot();
        if (node != null) {
            Enumeration en = node.preorderEnumeration();
            while (en.hasMoreElements()) {
                MTreeNode nn = (MTreeNode)en.nextElement();
                if (nn.isSummary()) continue;
                this.addNodeToLevel(nn);
            }
        }
        if (this.noWindows > 0) {
            this.addLog("Window " + this.noWindows);
        }
        if (this.noTabs > 0) {
            this.addLog("Tab " + this.noTabs);
        }
        if (this.noFields > 0) {
            this.addLog("Field " + this.noFields);
        }
        if (this.noProcesses > 0) {
            this.addLog("Process " + this.noProcesses);
        }
        if (this.noParameters > 0) {
            this.addLog("Process Parameter " + this.noParameters);
        }
        if (this.noForms > 0) {
            this.addLog("Form " + this.noForms);
        }
        if (this.noTasks > 0) {
            this.addLog("Task " + this.noTasks);
        }
        if (this.noWorkflows > 0) {
            this.addLog("Workflow " + this.noWorkflows);
        }
        return "@OK@";
    }

    private void addNodeToLevel(MTreeNode nn) {
        MMenu menu = new MMenu(this.getCtx(), nn.getNode_ID(), this.get_TrxName());
        if (menu.getAction().equals("W")) {
            this.generateWindow(menu.getAD_Window_ID());
        } else if (menu.getAction().equals("P") || menu.getAction().equals("R")) {
            this.generateProcess(menu.getAD_Process_ID());
        } else if (menu.getAction().equals("X")) {
            this.generateForm(menu.getAD_Form_ID());
        } else if (menu.getAction().equals("T")) {
            this.generateTask(menu.getAD_Task_ID());
        } else if (menu.getAction().equals("F")) {
            this.generateWorkflow(menu.getAD_Workflow_ID());
        }
    }

    private void generateProcess(int p_AD_Process_ID) {
        MProcess process = new MProcess(this.getCtx(), p_AD_Process_ID, this.get_TrxName());
        int asp_process_id = DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT ASP_Process_ID FROM ASP_Process WHERE ASP_Level_ID = ? AND AD_Process_ID = ?", (Object[])new Object[]{this.p_ASP_Level_ID, process.getAD_Process_ID()});
        X_ASP_Process aspProcess = null;
        if (asp_process_id < 1) {
            aspProcess = new X_ASP_Process(this.getCtx(), 0, this.get_TrxName());
            aspProcess.setASP_Level_ID(this.p_ASP_Level_ID);
            aspProcess.setAD_Process_ID(process.getAD_Process_ID());
            aspProcess.setASP_Status(this.p_ASP_Status);
            if (aspProcess.save()) {
                ++this.noProcesses;
                asp_process_id = aspProcess.getASP_Process_ID();
            }
        } else {
            aspProcess = new X_ASP_Process(this.getCtx(), asp_process_id, this.get_TrxName());
        }
        MProcessPara[] mProcessParaArray = process.getParameters();
        int n = mProcessParaArray.length;
        int n2 = 0;
        while (n2 < n) {
            MProcessPara processpara = mProcessParaArray[n2];
            if (DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT COUNT(*) FROM ASP_Process_Para WHERE ASP_Process_ID = ? AND AD_Process_Para_ID = ?", (Object[])new Object[]{asp_process_id, processpara.getAD_Process_Para_ID()}) < 1) {
                X_ASP_Process_Para aspProcess_Para = new X_ASP_Process_Para(this.getCtx(), 0, this.get_TrxName());
                aspProcess_Para.setASP_Process_ID(asp_process_id);
                aspProcess_Para.setAD_Process_Para_ID(processpara.getAD_Process_Para_ID());
                aspProcess_Para.setASP_Status(this.p_ASP_Status);
                if (aspProcess_Para.save()) {
                    ++this.noParameters;
                }
            }
            ++n2;
        }
        if (process.getAD_Workflow_ID() > 0) {
            this.generateWorkflow(process.getAD_Workflow_ID());
        }
        if (process.getAD_Form_ID() > 0) {
            this.generateForm(process.getAD_Form_ID());
        }
    }

    private void generateWorkflow(int p_AD_Workflow_ID) {
        MWorkflow workflow = new MWorkflow(this.getCtx(), p_AD_Workflow_ID, this.get_TrxName());
        if (DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT COUNT(*) FROM ASP_Workflow WHERE ASP_Level_ID = ? AND AD_Workflow_ID = ?", (Object[])new Object[]{this.p_ASP_Level_ID, workflow.getAD_Workflow_ID()}) < 1) {
            X_ASP_Workflow aspWorkflow = new X_ASP_Workflow(this.getCtx(), 0, this.get_TrxName());
            aspWorkflow.setASP_Level_ID(this.p_ASP_Level_ID);
            aspWorkflow.setAD_Workflow_ID(workflow.getAD_Workflow_ID());
            aspWorkflow.setASP_Status(this.p_ASP_Status);
            if (aspWorkflow.save()) {
                ++this.noWorkflows;
            }
        }
        MWFNode[] mWFNodeArray = workflow.getNodes(false, this.getAD_Client_ID());
        int n = mWFNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MWFNode node = mWFNodeArray[n2];
            if (("P".equals(node.getAction()) || "R".equals(node.getAction())) && node.getAD_Process_ID() > 0) {
                this.generateProcess(node.getAD_Process_ID());
            } else if ("T".equals(node.getAction()) && node.getAD_Task_ID() > 0) {
                this.generateTask(node.getAD_Task_ID());
            } else if ("X".equals(node.getAction()) && node.getAD_Form_ID() > 0) {
                this.generateForm(node.getAD_Form_ID());
            } else if ("W".equals(node.getAction()) && node.getAD_Window_ID() > 0) {
                this.generateWindow(node.getAD_Window_ID());
            }
            ++n2;
        }
    }

    private void generateForm(int p_AD_Form_ID) {
        MForm form = new MForm(this.getCtx(), p_AD_Form_ID, this.get_TrxName());
        if (DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT COUNT(*) FROM ASP_Form WHERE ASP_Level_ID = ? AND AD_Form_ID = ?", (Object[])new Object[]{this.p_ASP_Level_ID, form.getAD_Form_ID()}) < 1) {
            X_ASP_Form aspForm = new X_ASP_Form(this.getCtx(), 0, this.get_TrxName());
            aspForm.setASP_Level_ID(this.p_ASP_Level_ID);
            aspForm.setAD_Form_ID(form.getAD_Form_ID());
            aspForm.setASP_Status(this.p_ASP_Status);
            if (aspForm.save()) {
                ++this.noForms;
            }
        }
    }

    private void generateTask(int p_AD_Task_ID) {
        MTask task = new MTask(this.getCtx(), p_AD_Task_ID, this.get_TrxName());
        if (DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT COUNT(*) FROM ASP_Task WHERE ASP_Level_ID = ? AND AD_Task_ID = ?", (Object[])new Object[]{this.p_ASP_Level_ID, task.getAD_Task_ID()}) < 1) {
            X_ASP_Task aspTask = new X_ASP_Task(this.getCtx(), 0, this.get_TrxName());
            aspTask.setASP_Level_ID(this.p_ASP_Level_ID);
            aspTask.setAD_Task_ID(task.getAD_Task_ID());
            aspTask.setASP_Status(this.p_ASP_Status);
            if (aspTask.save()) {
                ++this.noTasks;
            }
        }
    }

    private void generateWindow(int p_AD_Window_ID) {
        MWindow window = new MWindow(this.getCtx(), p_AD_Window_ID, this.get_TrxName());
        int asp_window_id = DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT ASP_Window_ID FROM ASP_Window WHERE ASP_Level_ID = ? AND AD_Window_ID = ?", (Object[])new Object[]{this.p_ASP_Level_ID, window.getAD_Window_ID()});
        X_ASP_Window aspWindow = null;
        if (asp_window_id < 1) {
            aspWindow = new X_ASP_Window(this.getCtx(), 0, this.get_TrxName());
            aspWindow.setASP_Level_ID(this.p_ASP_Level_ID);
            aspWindow.setAD_Window_ID(window.getAD_Window_ID());
            aspWindow.setASP_Status(this.p_ASP_Status);
            if (aspWindow.save()) {
                ++this.noWindows;
                asp_window_id = aspWindow.getASP_Window_ID();
            }
        } else {
            aspWindow = new X_ASP_Window(this.getCtx(), asp_window_id, this.get_TrxName());
        }
        MTab[] mTabArray = window.getTabs(true, this.get_TrxName());
        int n = mTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            MTab tab = mTabArray[n2];
            int asp_tab_id = DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT ASP_Tab_ID FROM ASP_Tab WHERE ASP_Window_ID = ? AND AD_Tab_ID = ?", (Object[])new Object[]{asp_window_id, tab.getAD_Tab_ID()});
            X_ASP_Tab aspTab = null;
            if (asp_tab_id < 1) {
                aspTab = new X_ASP_Tab(this.getCtx(), 0, this.get_TrxName());
                aspTab.setASP_Window_ID(asp_window_id);
                aspTab.setAD_Tab_ID(tab.getAD_Tab_ID());
                aspTab.setASP_Status(this.p_ASP_Status);
                aspTab.setAllFields(!this.p_IsGenerateFields);
                if (aspTab.save()) {
                    ++this.noTabs;
                    asp_tab_id = aspTab.getASP_Tab_ID();
                }
            } else {
                aspTab = new X_ASP_Tab(this.getCtx(), asp_tab_id, this.get_TrxName());
            }
            if (tab.getAD_Process_ID() > 0) {
                this.generateProcess(tab.getAD_Process_ID());
            }
            MToolBarButton[] mToolBarButtonArray = MToolBarButton.getProcessButtonOfTab((int)tab.getAD_Tab_ID(), (String)this.get_TrxName());
            int n3 = mToolBarButtonArray.length;
            int n4 = 0;
            while (n4 < n3) {
                MToolBarButton tb = mToolBarButtonArray[n4];
                if (tb.getAD_Process_ID() > 0) {
                    this.generateProcess(tb.getAD_Process_ID());
                }
                ++n4;
            }
            mToolBarButtonArray = tab.getFields(true, this.get_TrxName());
            n3 = mToolBarButtonArray.length;
            n4 = 0;
            while (n4 < n3) {
                MColumn column;
                MToolBarButton field = mToolBarButtonArray[n4];
                if (this.p_IsGenerateFields && DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT COUNT(*) FROM ASP_Field WHERE ASP_Tab_ID = ? AND AD_Field_ID = ?", (Object[])new Object[]{aspTab.getASP_Tab_ID(), field.getAD_Field_ID()}) < 1) {
                    X_ASP_Field aspField = new X_ASP_Field(this.getCtx(), 0, this.get_TrxName());
                    aspField.setASP_Tab_ID(aspTab.getASP_Tab_ID());
                    aspField.setAD_Field_ID(field.getAD_Field_ID());
                    aspField.setASP_Status(this.p_ASP_Status);
                    if (aspField.save()) {
                        ++this.noFields;
                    }
                }
                if ((column = MColumn.get((Properties)this.getCtx(), (int)field.getAD_Column_ID())).getAD_Reference_ID() == 28 && column.getAD_Process_ID() > 0) {
                    this.generateProcess(column.getAD_Process_ID());
                }
                ++n4;
            }
            ++n2;
        }
    }
}

