/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.Serializable;
import java.util.Objects;
import java.util.Properties;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WRecordEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.factory.ButtonFactory;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Vlayout;

public class WRecordIDDialog
extends Window
implements EventListener<Event>,
ValueChangeListener {
    private static final long serialVersionUID = 1791159320699080384L;
    private WRecordEditor<?> editor;
    private GridField tableIDGridField;
    private Object recordIDValue;
    private Integer tableIDValue;
    GridTab gridTab;
    GridField gridField;
    int windowNo;
    int tabNo;
    private Div contentDiv;
    private Div labelsDiv;
    private Div fieldsDiv;
    private Div confirmPanelDiv;
    private WEditor tableIDEditor;
    private Button okBtn;
    private Button cancelBtn;
    private Textbox parentTextBox;
    private WSearchEditor recordsEditor;
    private Text recordsEditorLabel;

    public WRecordIDDialog(Page page, WRecordEditor<?> editor, GridField tableIDGridField) {
        this.editor = editor;
        this.gridTab = editor.getGridField().getGridTab();
        this.gridField = editor.getGridField();
        this.tabNo = this.gridTab != null ? this.gridTab.getTabNo() : 99;
        int n = this.windowNo = this.gridTab != null ? this.gridTab.getWindowNo() : this.gridField.getWindowNo();
        this.tableIDValue = editor.getAD_Table_ID() instanceof Integer ? (Integer)editor.getAD_Table_ID() : (editor.getAD_Table_ID() == null ? null : Integer.valueOf(editor.getAD_Table_ID().toString()));
        this.tableIDGridField = tableIDGridField;
        this.recordIDValue = editor.toKeyValue(editor.getValue());
        this.init(page);
    }

    private void init(Page page) {
        Text text;
        Vlayout vLayout = new Vlayout();
        this.labelsDiv = new Div();
        this.fieldsDiv = new Div();
        this.contentDiv = new Div();
        this.confirmPanelDiv = new Div();
        this.okBtn = ButtonFactory.createNamedButton("Ok", true, true);
        this.cancelBtn = ButtonFactory.createNamedButton("Cancel", true, true);
        this.tableIDEditor = 30 == this.tableIDGridField.getDisplayType() ? new WSearchEditor("AD_Table_ID", false, false, true, this.tableIDGridField.getLookup()) : new WTableDirEditor("AD_Table_ID", false, false, true, this.tableIDGridField.getLookup(), true);
        this.tableIDEditor.addValueChangeListener(this);
        this.tableIDEditor.setValue(this.tableIDValue);
        int tableID = this.tableIDValue != null ? this.tableIDValue : 0;
        MLookup recordsLookup = MLookup.getRecordsLookup((int)tableID, (int)this.tabNo, (int)this.windowNo, (boolean)this.editor.isUseUUIDKey());
        if (recordsLookup != null) {
            this.recordsEditor = new WSearchEditor(this.editor.getColumnName(), false, false, true, (Lookup)recordsLookup);
        }
        this.setPage(page);
        this.setClosable(true);
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"ChooseRelatedRecord"));
        this.setPosition("center");
        this.setSclass("recordid-dialog");
        this.contentDiv.setSclass("recordid-dialog-content");
        this.confirmPanelDiv.setSclass("recordid-dialog-confirm");
        if (this.editor.getGridField().getGridTab() != null) {
            this.parentTextBox = new Textbox();
            this.parentTextBox.setReadonly(true);
            MTable parentTable = MTable.get((int)this.editor.getGridField().getGridTab().getAD_Table_ID());
            Serializable parentRecordId = !parentTable.isIDKeyTable() ? (Serializable)this.editor.getGridField().getGridTab().getValue(PO.getUUIDColumnName((String)parentTable.getTableName())) : Integer.valueOf(this.editor.getGridField().getGridTab().getRecord_ID());
            this.parentTextBox.setValue(MLookup.getIdentifier((int)parentTable.getAD_Table_ID(), (Serializable)parentRecordId, (int)this.tabNo, (int)this.windowNo));
        }
        if (this.recordsEditor != null) {
            this.recordsEditor.setValue(this.recordIDValue);
        }
        this.okBtn.addEventListener("onClick", this);
        this.okBtn.setSclass("recordid-dialog-confirm");
        this.cancelBtn.addEventListener("onClick", this);
        this.cancelBtn.setSclass("recordid-dialog-confirm");
        if (this.parentTextBox != null) {
            text = new Text(Msg.getMsg((Properties)Env.getCtx(), (String)"Parent"));
            this.labelsDiv.appendChild((Component)text);
        }
        text = new Text(Msg.getMsg((Properties)Env.getCtx(), (String)"Table"));
        this.labelsDiv.appendChild((Component)text);
        this.recordsEditorLabel = new Text(Msg.getMsg((Properties)Env.getCtx(), (String)"Record"));
        if (this.recordsEditor != null) {
            this.labelsDiv.appendChild((Component)this.recordsEditorLabel);
        }
        this.labelsDiv.setSclass("recordid-dialog-labels");
        this.fieldsDiv.setSclass("recordid-dialog-fields");
        if (this.parentTextBox != null) {
            this.fieldsDiv.appendChild((Component)this.parentTextBox);
        }
        this.fieldsDiv.appendChild(this.tableIDEditor.getComponent());
        if (this.recordsEditor != null) {
            this.fieldsDiv.appendChild((Component)this.recordsEditor.getComponent());
        }
        this.contentDiv.appendChild((Component)this.labelsDiv);
        this.contentDiv.appendChild((Component)this.fieldsDiv);
        this.confirmPanelDiv.appendChild((Component)this.okBtn);
        this.confirmPanelDiv.appendChild((Component)this.cancelBtn);
        vLayout.appendChild((Component)this.contentDiv);
        vLayout.appendChild((Component)this.confirmPanelDiv);
        this.appendChild((Component)vLayout);
        this.doHighlighted();
        if (this.tableIDEditor.getComponent() instanceof HtmlBasedComponent) {
            ((HtmlBasedComponent)this.tableIDEditor.getComponent()).focus();
        }
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equalsIgnoreCase("onClick")) {
            if (event.getTarget().equals((Object)this.okBtn)) {
                this.editor.setAD_Table_ID(this.tableIDEditor.getValue());
                if (this.recordsEditor != null) {
                    this.editor.setValue(this.recordsEditor.getValue());
                }
                this.onClose();
            } else if (event.getTarget().equals((Object)this.cancelBtn)) {
                this.onClose();
            }
        }
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        if (evt.getSource().equals(this.tableIDEditor)) {
            MLookup recordsLookup;
            String error;
            int tableID = Integer.parseInt(Objects.toString(evt.getNewValue(), "-1"));
            if (tableID > 0 && !Util.isEmpty((String)(error = this.editor.validateTableIdValue(tableID)))) {
                throw new WrongValueException(this.tableIDEditor.getComponent(), Msg.getMsg((Properties)Env.getCtx(), (String)error));
            }
            if (this.recordsEditor != null) {
                this.recordsEditor.setValue(null);
                this.recordsEditorLabel.detach();
                this.recordsEditor.getComponent().detach();
            }
            if ((recordsLookup = MLookup.getRecordsLookup((int)tableID, (int)this.tabNo, (int)this.windowNo, (boolean)this.editor.isUseUUIDKey())) != null) {
                this.recordsEditor = new WSearchEditor(this.editor.getColumnName(), false, false, true, (Lookup)recordsLookup);
                this.labelsDiv.appendChild((Component)this.recordsEditorLabel);
                this.fieldsDiv.appendChild((Component)this.recordsEditor.getComponent());
                this.recordsEditor.getComponent().focus();
            } else {
                if (tableID > 0) {
                    throw new WrongValueException(this.tableIDEditor.getComponent(), Msg.getMsg((Properties)Env.getCtx(), (String)"TableHasNoKeyColumn"));
                }
                if (this.tableIDEditor.getComponent() instanceof HtmlBasedComponent) {
                    ((HtmlBasedComponent)this.tableIDEditor.getComponent()).focus();
                }
            }
        }
    }
}

