/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.costing;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProcess;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class NonStockedExpTypeAvgPOCostingTest
extends AbstractTestCase {
    private static final BigDecimal BD_2 = new BigDecimal("2.00");
    private static final BigDecimal BD_5 = new BigDecimal("5.00");
    private static final BigDecimal BD_20 = new BigDecimal("20.00");

    @Test
    public void testMaterialReceipt() {
        MProductCategory category = this.createProductCategory();
        MProduct product = this.createProduct(category.get_ID());
        try {
            int[] ids;
            MAcctSchema as = this.getAccountingSchema();
            MCost cost = this.getCost(as, product);
            MInOutLine rLine = this.createPOAndMRForProduct(product);
            MMatchPO[] matchPOs = MMatchPO.get((Properties)Env.getCtx(), (int)rLine.getM_InOutLine_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)matchPOs.length);
            Assertions.assertEquals((int)rLine.getC_OrderLine_ID(), (int)matchPOs[0].getC_OrderLine_ID());
            Assertions.assertEquals((int)rLine.getM_InOutLine_ID(), (int)matchPOs[0].getM_InOutLine_ID());
            Assertions.assertTrue((matchPOs[0].getQty().compareTo(BigDecimal.TEN) == 0 ? 1 : 0) != 0);
            cost.load(this.getTrxName(), new String[0]);
            this.assertNoAveragePOCost(product.get_ID());
            Assertions.assertEquals((Object)BD_2, (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            Assertions.assertEquals((Object)BigDecimal.TEN.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentQty().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current Qty");
            MStorageOnHand[] storages = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)DictionaryIDs.M_Locator.HQ.id, (String)this.getTrxName(), (boolean)false, (int)0);
            Assertions.assertEquals((int)0, (int)storages.length, (String)"No storage records should be created for expense type product");
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)rLine.getM_InOut_ID(), (String)this.getTrxName());
            doc.setC_BPartner_ID(rLine.getM_InOut().getC_BPartner_ID());
            MAccount acctNIR = doc.getAccount(51, as);
            ProductCost pc = new ProductCost(Env.getCtx(), rLine.getM_Product_ID(), 0, this.getTrxName());
            MAccount productExpense = pc.getAccount(2, as);
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("AD_Table_ID").append("=").append(319).append(" AND ").append("Record_ID").append("=").append(rLine.getM_InOut_ID()).append(" AND ").append("C_AcctSchema_ID").append("=").append(as.getC_AcctSchema_ID());
            int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)whereClause.toString(), (String)this.getTrxName());
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                if (fa.getAccount_ID() == acctNIR.getAccount_ID()) {
                    Assertions.assertEquals((Object)BD_20, (Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (String)"");
                    Assertions.assertEquals((Object)new BigDecimal("-10.00"), (Object)fa.getQty().setScale(2, RoundingMode.HALF_UP), (String)"");
                } else if (fa.getAccount_ID() == productExpense.getAccount_ID()) {
                    Assertions.assertEquals((Object)BD_20, (Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (String)"");
                    Assertions.assertEquals((Object)BigDecimal.TEN.setScale(2, RoundingMode.HALF_UP), (Object)fa.getQty().setScale(2, RoundingMode.HALF_UP), (String)"");
                }
                ++n2;
            }
        }
        finally {
            this.rollback();
            if (product != null) {
                product.deleteEx(true);
            }
            if (category != null) {
                category.deleteEx(true);
            }
        }
    }

    @Test
    public void testSOAndShipment() {
        MProductCategory category = this.createProductCategory();
        MProduct product = this.createProduct(category.get_ID());
        try {
            MAcctSchema as = this.getAccountingSchema();
            MCost cost = this.getCost(as, product);
            this.createPOAndMRForProduct(product);
            cost.load(this.getTrxName(), new String[0]);
            this.assertNoAveragePOCost(product.get_ID());
            this.createSOAndShipmentForProduct(product);
            cost.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)BD_2, (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            Assertions.assertEquals((Object)BigDecimal.TEN.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentQty().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current Qty");
            MStorageOnHand[] storages = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)DictionaryIDs.M_Locator.HQ.id, (String)this.getTrxName(), (boolean)false, (int)0);
            Assertions.assertEquals((int)0, (int)storages.length, (String)"No storage records should be created for expense type product");
        }
        finally {
            this.rollback();
            if (product != null) {
                product.deleteEx(true);
            }
            if (category != null) {
                category.deleteEx(true);
            }
        }
    }

    @Test
    public void testCustomerRMA() {
        MProductCategory category = this.createProductCategory();
        MProduct product = this.createProduct(category.get_ID());
        try {
            MAcctSchema as = this.getAccountingSchema();
            MCost cost = this.getCost(as, product);
            this.createPOAndMRForProduct(product);
            cost.load(this.getTrxName(), new String[0]);
            this.assertNoAveragePOCost(product.get_ID());
            MInOutLine sLine = this.createSOAndShipmentForProduct(product);
            cost.load(this.getTrxName(), new String[0]);
            MRMA rma = new MRMA(Env.getCtx(), 0, this.getTrxName());
            rma.setName("testCustomerReturnMaterial");
            rma.setC_DocType_ID(DictionaryIDs.C_DocType.CUSTOMER_RETURN_MATERIAL.id);
            rma.setM_RMAType_ID(DictionaryIDs.M_RMAType.DAMAGE_ON_ARRIVAL.id);
            rma.setM_InOut_ID(sLine.getM_InOut_ID());
            rma.setIsSOTrx(true);
            rma.setSalesRep_ID(100);
            rma.saveEx();
            MRMALine rmaLine = new MRMALine(Env.getCtx(), 0, this.getTrxName());
            rmaLine.setLine(10);
            rmaLine.setM_RMA_ID(rma.get_ID());
            rmaLine.setQty(new BigDecimal("3"));
            rmaLine.setM_InOutLine_ID(sLine.get_ID());
            rmaLine.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)rma, (String)"CO");
            rma.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)rma.getDocStatus());
            MInOut delivery = new MInOut(Env.getCtx(), 0, this.getTrxName());
            delivery.setM_RMA_ID(rma.get_ID());
            delivery.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            delivery.setC_DocType_ID(DictionaryIDs.C_DocType.MM_CUSTOMER_RETURN.id);
            delivery.setMovementType("C+");
            delivery.setIsSOTrx(true);
            delivery.setDocStatus("DR");
            delivery.setDocAction("CO");
            delivery.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQ.id);
            delivery.saveEx();
            MInOutLine dLine = new MInOutLine(delivery);
            dLine.setM_RMALine_ID(rmaLine.get_ID());
            dLine.setLine(10);
            dLine.setProduct(new MProduct(Env.getCtx(), product.getM_Product_ID(), this.getTrxName()));
            dLine.setM_Locator_ID(sLine.getM_Locator_ID());
            dLine.setQty(new BigDecimal("3"));
            dLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)delivery, (String)"CO");
            delivery.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            MInOutConfirm[] confirmations = delivery.getConfirmations(true);
            Assertions.assertEquals((int)1, (int)confirmations.length, (String)"Expected 1 Shipment Confirmation Document");
            Assertions.assertTrue((confirmations[0].getM_InOutConfirm_ID() != delivery.getM_InOut_ID() ? 1 : 0) != 0, (String)"Test should run with M_InOut_ID != M_InOutConfirm_ID");
            info = MWorkflow.runDocumentActionWorkflow((PO)confirmations[0], (String)"CO");
            if (info.isError()) {
                Assertions.fail((String)("Failed to complete shipment confirmation" + (String)(Util.isEmpty((String)info.getSummary()) ? "" : " : " + info.getSummary())));
                return;
            }
            confirmations[0].load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)confirmations[0].getDocStatus(), (String)"Expected Completed Status for Shipment Confirmation");
            info = MWorkflow.runDocumentActionWorkflow((PO)delivery, (String)"CO");
            delivery.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)delivery.getDocStatus(), (String)"Expected Completed Status for Shipment");
            if (!delivery.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)delivery.getAD_Client_ID(), (int)319, (int)delivery.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            cost.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)BD_2, (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            Assertions.assertEquals((Object)BigDecimal.TEN.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentQty().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost Qty");
            MStorageOnHand[] storages = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)DictionaryIDs.M_Locator.HQ.id, (String)this.getTrxName(), (boolean)false, (int)0);
            Assertions.assertEquals((int)0, (int)storages.length, (String)"No storage records should be created for expense type product");
        }
        finally {
            this.rollback();
            if (product != null) {
                product.deleteEx(true);
            }
            if (category != null) {
                category.deleteEx(true);
            }
        }
    }

    @Test
    public void testInvoice() {
        MProductCategory category = this.createProductCategory();
        MProduct product = this.createProduct(category.get_ID());
        try {
            int[] idsMatchInv;
            int[] ids;
            MAcctSchema as = this.getAccountingSchema();
            MCost cost = this.getCost(as, product);
            MInOutLine rLine = this.createPOAndMRForProduct(product);
            cost.load(this.getTrxName(), new String[0]);
            this.assertNoAveragePOCost(product.get_ID());
            MInOut mInOut = (MInOut)rLine.getM_InOut();
            MInvoice invoice = new MInvoice(mInOut, rLine.getM_InOut().getMovementDate());
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MOrderLine oLine = (MOrderLine)rLine.getC_OrderLine();
            MInvoiceLine iLine = new MInvoiceLine(invoice);
            iLine.setOrderLine(oLine);
            iLine.setLine(10);
            iLine.setProduct(new MProduct(Env.getCtx(), product.getM_Product_ID(), this.getTrxName()));
            iLine.setQty(BigDecimal.TEN);
            iLine.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            invoice.getDocsPostProcess().clear();
            if (!invoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)invoice.get_Table_ID(), (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            ProductCost pc = new ProductCost(Env.getCtx(), iLine.getM_Product_ID(), 0, this.getTrxName());
            MAccount productExpense = pc.getAccount(2, as);
            MAccount acctPT = new MAccount(Env.getCtx(), as.getAcctSchemaDefault().getV_Liability_Acct(), this.getTrxName());
            Object whereClause = "AD_Table_ID = 318";
            whereClause = (String)whereClause + " AND Record_ID = " + iLine.getC_Invoice_ID();
            whereClause = (String)whereClause + " AND C_AcctSchema_ID = " + as.getC_AcctSchema_ID();
            int[] nArray = ids = MFactAcct.getAllIDs((String)"Fact_Acct", (String)((String)whereClause).toString(), (String)this.getTrxName());
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                if (fa.getAccount_ID() == acctPT.getAccount_ID()) {
                    Assertions.assertEquals((Object)BD_20, (Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (String)"");
                    Assertions.assertEquals((Object)BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP), (Object)fa.getQty().setScale(2, RoundingMode.HALF_UP), (String)"");
                } else if (fa.getAccount_ID() == productExpense.getAccount_ID()) {
                    Assertions.assertEquals((Object)BD_20, (Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (String)"");
                    Assertions.assertEquals((Object)BigDecimal.TEN.setScale(2, RoundingMode.HALF_UP), (Object)fa.getQty().setScale(2, RoundingMode.HALF_UP), (String)"");
                }
                ++n2;
            }
            MMatchInv[] matchInvoices = MMatchInv.getInOut((Properties)Env.getCtx(), (int)rLine.getM_InOut_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)matchInvoices.length);
            Assertions.assertEquals((int)rLine.getM_InOutLine_ID(), (int)matchInvoices[0].getM_InOutLine_ID());
            Assertions.assertTrue((matchInvoices[0].getQty().compareTo(BigDecimal.TEN) == 0 ? 1 : 0) != 0, (String)("Expected 5, get " + String.valueOf(matchInvoices[0].getQty())));
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)472, (int)matchInvoices[0].get_ID(), (String)this.getTrxName());
            doc.setC_BPartner_ID(matchInvoices[0].getC_InvoiceLine().getC_Invoice().getC_BPartner_ID());
            MAccount acctNIR = doc.getAccount(51, as);
            pc = new ProductCost(Env.getCtx(), matchInvoices[0].getM_Product_ID(), 0, this.getTrxName());
            productExpense = pc.getAccount(2, as);
            whereClause = null;
            whereClause = "AD_Table_ID = 472";
            whereClause = (String)whereClause + " AND Record_ID = " + matchInvoices[0].get_ID();
            whereClause = (String)whereClause + " AND C_AcctSchema_ID = " + as.getC_AcctSchema_ID();
            int[] nArray2 = idsMatchInv = MFactAcct.getAllIDs((String)"Fact_Acct", (String)((String)whereClause).toString(), (String)this.getTrxName());
            int n3 = idsMatchInv.length;
            int n4 = 0;
            while (n4 < n3) {
                int id = nArray2[n4];
                MFactAcct fa = new MFactAcct(Env.getCtx(), id, this.getTrxName());
                if (fa.getAccount_ID() == acctNIR.getAccount_ID()) {
                    Assertions.assertEquals((Object)BD_20, (Object)fa.getAmtAcctDr().setScale(2, RoundingMode.HALF_UP), (String)"");
                    Assertions.assertEquals((Object)BigDecimal.TEN.setScale(2, RoundingMode.HALF_UP), (Object)fa.getQty().setScale(2, RoundingMode.HALF_UP), (String)"");
                } else if (fa.getAccount_ID() == productExpense.getAccount_ID()) {
                    Assertions.assertEquals((Object)BD_20, (Object)fa.getAmtAcctCr().setScale(2, RoundingMode.HALF_UP), (String)"");
                    Assertions.assertEquals((Object)new BigDecimal("-10.00"), (Object)fa.getQty().setScale(2, RoundingMode.HALF_UP), (String)"");
                }
                ++n4;
            }
        }
        finally {
            this.rollback();
            if (product != null) {
                product.deleteEx(true);
            }
            if (category != null) {
                category.deleteEx(true);
            }
        }
    }

    @Test
    public void testExpenseProduction() {
        MProductCategory category = this.createProductCategory();
        MProduct product = this.createProduct(category.get_ID());
        MProduct fgProdcut = null;
        try {
            MAcctSchema as = this.getAccountingSchema();
            MCost cost = this.getCost(as, product);
            this.createPOAndMRForProduct(product);
            cost.load(this.getTrxName(), new String[0]);
            this.assertNoAveragePOCost(product.get_ID());
            fgProdcut = new MProduct(Env.getCtx(), 0, null);
            fgProdcut.setName("Test_BOM");
            fgProdcut.setIsBOM(true);
            fgProdcut.setIsStocked(true);
            fgProdcut.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            fgProdcut.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            fgProdcut.setProductType("I");
            fgProdcut.setM_Product_Category_ID(category.get_ID());
            fgProdcut.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            fgProdcut.saveEx();
            MCost fgCost = MCost.get((MProduct)fgProdcut, (int)0, (MAcctSchema)as, (int)0, (int)DictionaryIDs.M_CostElement.MATERIAL.id, (String)this.getTrxName());
            MPPProductBOM bom = new MPPProductBOM(Env.getCtx(), 0, this.getTrxName());
            bom.setM_Product_ID(fgProdcut.get_ID());
            bom.setBOMType("A");
            bom.setBOMUse("A");
            bom.setName(fgProdcut.getName());
            bom.saveEx();
            MPPProductBOMLine bomLine = new MPPProductBOMLine(bom);
            bomLine.setM_Product_ID(product.getM_Product_ID());
            bomLine.setQtyBOM(BD_2);
            bomLine.saveEx();
            MProduction production = new MProduction(Env.getCtx(), 0, this.getTrxName());
            production.setM_Product_ID(fgProdcut.get_ID());
            production.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
            production.setIsUseProductionPlan(false);
            production.setMovementDate(this.getLoginDate());
            production.setDocAction("CO");
            production.setDocStatus("DR");
            production.setIsComplete(false);
            production.setProductionQty(BD_2);
            production.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
            production.saveEx();
            MProcess process = MProcess.get((Properties)Env.getCtx(), (int)53226);
            ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setRecord_ID(production.get_ID());
            pi.setTransactionName(this.getTrxName());
            ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx(), (boolean)false);
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            production.load(this.getTrxName(), new String[0]);
            MProductionLine[] plines = production.getLines();
            Assertions.assertEquals((Object)"Y", (Object)production.getIsCreated(), (String)"MProduction.IsCreated != Y");
            Assertions.assertTrue((plines.length > 0 ? 1 : 0) != 0, (String)"No Production Lines");
            Assertions.assertEquals((int)2, (int)plines.length, (String)"Unexpected number of production lines");
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)production, (String)"CO");
            production.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)production.getDocStatus(), (String)("Production Status=" + production.getDocStatus()));
            fgCost.load(this.getTrxName(), new String[0]);
            cost.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)new BigDecimal("6.00"), (Object)cost.getCurrentQty().setScale(2, RoundingMode.HALF_UP), (String)"");
            Assertions.assertEquals((Object)BD_2, (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"");
            MStorageOnHand[] storages = MStorageOnHand.getAll((Properties)Env.getCtx(), (int)product.get_ID(), (int)DictionaryIDs.M_Locator.HQ.id, (String)this.getTrxName(), (boolean)false, (int)0);
            Assertions.assertEquals((int)0, (int)storages.length, (String)"No stocked should be used for expense type product Usage in Poroduction");
            Assertions.assertEquals((Object)BD_2, (Object)fgCost.getCurrentQty().setScale(2, RoundingMode.HALF_UP), (String)"");
            Assertions.assertEquals((Object)BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP), (Object)fgCost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"");
            BigDecimal onHand = MStorageOnHand.getQtyOnHand((int)fgProdcut.get_ID(), (int)DictionaryIDs.M_Warehouse.HQ.id, (int)0, (String)this.getTrxName());
            Assertions.assertEquals((Object)BD_2, (Object)onHand.setScale(2, RoundingMode.HALF_UP), (String)"Storage for the Expense Type Product Should not be Created");
        }
        finally {
            this.rollback();
            if (product != null) {
                product.deleteEx(true);
            }
            if (fgProdcut != null) {
                fgProdcut.deleteEx(true);
            }
            if (category != null) {
                category.deleteEx(true);
            }
        }
    }

    private MProduct createProduct(int category_ID) {
        MProduct product = new MProduct(Env.getCtx(), 0, null);
        product.setName("testStandardCosting");
        product.setValue("testStandardCosting");
        product.setProductType("E");
        product.setIsStocked(false);
        product.setIsSold(true);
        product.setIsPurchased(true);
        product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
        product.setM_Product_Category_ID(category_ID);
        product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
        product.saveEx();
        MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
        MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
        pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
        pp.setM_Product_ID(product.get_ID());
        pp.saveEx();
        MPriceListVersion plvs = MPriceList.get((int)DictionaryIDs.M_PriceList.STANDARD.id).getPriceListVersion(null);
        MProductPrice pps = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
        pps.setM_PriceList_Version_ID(plvs.getM_PriceList_Version_ID());
        pps.setM_Product_ID(product.get_ID());
        pps.saveEx();
        return product;
    }

    private MInOutLine createPOAndMRForProduct(MProduct product) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine oLine = new MOrderLine(order);
        oLine.setLine(10);
        oLine.setProduct(product);
        oLine.setQty(BigDecimal.TEN);
        oLine.setDatePromised(today);
        oLine.setPrice(BD_2);
        oLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine rLine = new MInOutLine(receipt);
        rLine.setOrderLine(oLine, 0, BigDecimal.TEN);
        rLine.setQty(BigDecimal.TEN);
        rLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)receipt.get_Table_ID(), (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)error, (String)error);
        }
        return rLine;
    }

    private MInOutLine createSOAndShipmentForProduct(MProduct product) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.STANDARD_ORDER.id);
        order.setIsSOTrx(true);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine oLine = new MOrderLine(order);
        oLine.setLine(10);
        oLine.setProduct(product);
        oLine.setQty(BD_5);
        oLine.setDatePromised(today);
        oLine.setPrice(BD_2);
        oLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.setIsSOTrx(true);
        receipt.saveEx();
        MInOutLine rLine = new MInOutLine(receipt);
        rLine.setOrderLine(oLine, 0, BD_5);
        rLine.setQty(BD_5);
        rLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)receipt.get_Table_ID(), (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)error, (String)error);
        }
        return rLine;
    }

    private MAcctSchema getAccountingSchema() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        return as;
    }

    private MCost getCost(MAcctSchema as, MProduct product) {
        return MCost.get((MProduct)product, (int)0, (MAcctSchema)as, (int)0, (int)DictionaryIDs.M_CostElement.MATERIAL.id, (String)this.getTrxName());
    }

    private MProductCategory createProductCategory() {
        MProductCategory category = new MProductCategory(Env.getCtx(), 0, null);
        category.setName("Average PO");
        category.saveEx();
        String whereClause = "M_Product_Category_ID=?";
        List categoryAccts = new Query(Env.getCtx(), "M_Product_Category_Acct", whereClause, null).setParameters(new Object[]{category.get_ID()}).list();
        for (MProductCategoryAcct categoryAcct : categoryAccts) {
            categoryAcct.setCostingMethod("A");
            categoryAcct.saveEx();
        }
        return category;
    }

    private void assertNoAveragePOCost(int productID) {
        List costs = new Query(Env.getCtx(), "M_Cost", " M_Product_ID = ? ", null).setParameters(new Object[]{productID}).list();
        for (MCost cost : costs) {
            Assertions.assertFalse((DictionaryIDs.M_CostElement.AVERAGE_PO.id == cost.getM_CostElement_ID() ? 1 : 0) != 0, (String)"Average PO cost should not be created for Expense type product");
        }
    }
}

