/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MCtxHelp;
import org.compiere.model.MCtxHelpMsg;
import org.compiere.model.MCtxHelpSuggestion;
import org.compiere.model.MForm;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MProcess;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.MTask;
import org.compiere.model.MUserDefInfo;
import org.compiere.model.PO;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;
import org.zkforge.ckez.CKeditor;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Label;
import org.zkoss.zul.South;
import org.zkoss.zul.Vbox;

public class WCtxHelpSuggestion
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 2068729997836800852L;
    private ConfirmPanel confirmPanel;
    private MCtxHelpMsg ctxHelpMsg;
    private CKeditor helpTextbox;
    private PO po;
    private String baseContent;
    private String translatedContent;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));

    public WCtxHelpSuggestion(MCtxHelpMsg ctxHelpMsg) {
        this.ctxHelpMsg = new MCtxHelpMsg(ctxHelpMsg.getCtx(), ctxHelpMsg.getAD_CtxHelpMsg_ID(), ctxHelpMsg.get_TrxName());
        this.layout();
    }

    public WCtxHelpSuggestion(PO po, String baseContent, String translatedContent) {
        this.po = po;
        this.baseContent = baseContent;
        this.translatedContent = translatedContent;
        this.layout();
    }

    private void layout() {
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        borderlayout.setHflex("1");
        borderlayout.setVflex("1");
        Center center = new Center();
        center.setVflex("1");
        center.setHflex("1");
        borderlayout.appendChild((Component)center);
        Vbox vlayout = new Vbox();
        vlayout.setStyle("padding: 8px 16px");
        vlayout.setWidth("100%");
        vlayout.setHeight("100%");
        vlayout.setPack("stretch");
        center.appendChild((Component)vlayout);
        Hbox hlayout = new Hbox();
        hlayout.setVflex("min");
        hlayout.setWidth("100%");
        hlayout.setAlign("center");
        Cell cell = new Cell();
        cell.setWidth("15%");
        cell.setStyle("padding-right: 8px;");
        cell.setAlign("right");
        cell.appendChild((Component)new Label(Msg.getElement((Properties)Env.getCtx(), (String)"AD_CtxHelp_ID") + " : "));
        hlayout.appendChild((Component)cell);
        cell = new Cell();
        cell.setWidth("85%");
        cell.setAlign("left");
        cell.appendChild((Component)new Label(this.ctxHelpMsg != null ? this.ctxHelpMsg.getAD_CtxHelp().getName() : this.getContextHelpName(this.po)));
        hlayout.appendChild((Component)cell);
        vlayout.appendChild((Component)hlayout);
        hlayout = new Hbox();
        hlayout.setVflex("1");
        hlayout.setHflex("1");
        hlayout.setAlign("stretch");
        cell = new Cell();
        cell.setWidth("15%");
        cell.setStyle("padding-right: 8px;");
        cell.setAlign("right");
        cell.appendChild((Component)new Label(Msg.getElement((Properties)Env.getCtx(), (String)"MsgText") + " : "));
        hlayout.appendChild((Component)cell);
        this.helpTextbox = new CKeditor();
        this.helpTextbox.setCustomConfigurationsPath("/js/ckeditor/config-min.js");
        this.helpTextbox.setToolbar("MyToolbar");
        String msgText = this.ctxHelpMsg != null ? this.ctxHelpMsg.get_Translation("MsgText") : (Util.isEmpty((String)this.translatedContent) ? this.baseContent : this.translatedContent);
        msgText = this.removeHeaderTag(msgText);
        this.helpTextbox.setValue(msgText);
        this.helpTextbox.setWidth("99%");
        this.helpTextbox.setVflex("1");
        cell = new Cell();
        cell.setWidth("85%");
        cell.setHeight("100%");
        cell.setAlign("left");
        cell.appendChild((Component)this.helpTextbox);
        hlayout.appendChild((Component)cell);
        vlayout.appendChild((Component)hlayout);
        this.confirmPanel = new ConfirmPanel(true);
        this.confirmPanel.addActionListener(this);
        South southPane = new South();
        southPane.setSclass("dialog-footer");
        borderlayout.appendChild((Component)southPane);
        southPane.appendChild((Component)this.confirmPanel);
        this.setSclass("popup-dialog");
        this.setClosable(true);
        this.setBorder("normal");
        this.setWidth("60%");
        this.setHeight("650px");
        this.setShadow(true);
        this.setAttribute("mode", "highlighted");
        this.setSizable(true);
        if (this.ctxHelpMsg != null && this.ctxHelpMsg.getAD_Client_ID() == Env.getAD_Client_ID((Properties)Env.getCtx())) {
            this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"edit") + " " + Msg.getElement((Properties)Env.getCtx(), (String)"AD_CtxHelpMsg_ID"));
        } else {
            this.setTitle(Msg.getElement((Properties)Env.getCtx(), (String)"AD_CtxHelpSuggestion_ID"));
        }
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.confirmPanel.getButton("Ok")) {
            this.onSave();
        } else if (event.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.onCancel();
        }
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.detach();
    }

    private void onSave() {
        String trxName = Trx.createTrxName();
        try (Trx trx = Trx.get((String)trxName, (boolean)true);){
            try {
                trx.start();
                this.onSave0(trx);
                trx.commit(true);
                if (this.ctxHelpMsg != null && this.ctxHelpMsg.getAD_Client_ID() == Env.getAD_Client_ID((Properties)Env.getCtx())) {
                    Dialog.info(0, Msg.getMsg((Properties)Env.getCtx(), (String)"Your changes have been saved."));
                } else {
                    Dialog.info(0, Msg.getMsg((Properties)Env.getCtx(), (String)"Your suggestions have been submitted for review"));
                }
            }
            catch (Exception e) {
                trx.rollback();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private void onSave0(Trx trx) {
        if (this.ctxHelpMsg != null && this.ctxHelpMsg.getAD_Client_ID() == Env.getAD_Client_ID((Properties)Env.getCtx())) {
            if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_CtxHelpMsg")) {
                this.ctxHelpMsg.setMsgText(this.helpTextbox.getValue());
                this.ctxHelpMsg.saveEx(trx.getTrxName());
            }
            StringBuilder update = new StringBuilder("UPDATE AD_CtxHelpMsg_Trl SET MsgText=? ");
            update.append("WHERE AD_CtxHelpMsg_ID=? AND AD_Client_ID=? AND AD_Language=? AND IsActive='Y' ");
            Object[] params = new Object[]{this.helpTextbox.getValue(), this.ctxHelpMsg.get_ID(), this.ctxHelpMsg.getAD_Client_ID(), Env.getAD_Language((Properties)Env.getCtx())};
            DB.executeUpdateEx((String)update.toString(), (Object[])params, (String)trx.getTrxName());
        } else {
            MCtxHelpSuggestion suggestion = new MCtxHelpSuggestion(Env.getCtx(), 0, trx.getTrxName());
            suggestion.setClientOrg(0, 0);
            if (this.ctxHelpMsg != null) {
                suggestion.setAD_CtxHelp_ID(this.ctxHelpMsg.getAD_CtxHelp_ID());
                suggestion.setAD_CtxHelpMsg_ID(this.ctxHelpMsg.get_ID());
            } else {
                MCtxHelp ctxHelp = new MCtxHelp(Env.getCtx(), 0, trx.getTrxName());
                this.setContextHelpInfo(this.po, ctxHelp);
                ctxHelp.setClientOrg(0, 0);
                ctxHelp.saveCrossTenantSafeEx();
                if (this.po != null) {
                    if (this.po.is_Immutable()) {
                        MTable table2 = MTable.get((int)this.po.get_Table_ID());
                        PO mutablePO = table2.getPO(this.po.get_ID(), trx.getTrxName());
                        mutablePO.set_ValueOfColumn("AD_CtxHelp_ID", (Object)ctxHelp.getAD_CtxHelp_ID());
                        mutablePO.saveCrossTenantSafeEx(trx.getTrxName());
                        this.po.load(trx.getTrxName(), new String[0]);
                    } else {
                        this.po.set_ValueOfColumn("AD_CtxHelp_ID", (Object)ctxHelp.getAD_CtxHelp_ID());
                        this.po.saveCrossTenantSafeEx(trx.getTrxName());
                    }
                }
                suggestion.setAD_CtxHelp_ID(ctxHelp.getAD_CtxHelp_ID());
                MCtxHelpMsg msg = new MCtxHelpMsg(Env.getCtx(), 0, trx.getTrxName());
                msg.setAD_CtxHelp_ID(ctxHelp.getAD_CtxHelp_ID());
                msg.setClientOrg(0, 0);
                msg.setMsgText(this.baseContent);
                msg.saveCrossTenantSafeEx();
                suggestion.setAD_CtxHelpMsg_ID(msg.getAD_CtxHelpMsg_ID());
                if (!Util.isEmpty((String)this.translatedContent) && !Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_CtxHelpMsg")) {
                    int id = DB.getSQLValueEx((String)trx.getTrxName(), (String)"SELECT AD_CtxHelpMsg_ID FROM AD_CtxHelpMsg_Trl WHERE AD_CtxHelpMsg_ID=? AND AD_Client_ID=? AND IsActive='Y' AND AD_Language=?", (Object[])new Object[]{msg.getAD_CtxHelpMsg_ID(), 0, Env.getAD_Language((Properties)Env.getCtx())});
                    if (id == msg.getAD_CtxHelpMsg_ID()) {
                        ArrayList<Object> params = new ArrayList<Object>();
                        StringBuilder update = new StringBuilder("UPDATE AD_CtxHelpMsg_Trl SET MsgText=? ");
                        update.append("WHERE AD_CtxHelpMsg_ID=? AND AD_Language=? AND AD_Client_ID=?");
                        params.add(this.translatedContent);
                        params.add(id);
                        params.add(Env.getAD_Language((Properties)Env.getCtx()));
                        params.add(0);
                        DB.executeUpdateEx((String)update.toString(), (Object[])params.toArray(), (String)trx.getTrxName());
                    } else {
                        StringBuilder insert = new StringBuilder("Insert Into AD_CtxHelpMsg_Trl (AD_Client_ID, AD_Org_ID, AD_CtxHelpMsg_ID, IsActive, IsTranslated, AD_Language, MsgText,");
                        insert.append("Created, CreatedBy, Updated, UpdatedBy, AD_CtxHelpMsg_Trl_UU)").append(" Values (?, ?, ?, 'Y', 'N', ?, ?, getDate(), ?, getDate(), ?, generate_uuid()) ");
                        ArrayList<Object> params = new ArrayList<Object>();
                        params.add(0);
                        params.add(0);
                        params.add(msg.getAD_CtxHelpMsg_ID());
                        params.add(Env.getAD_Language((Properties)Env.getCtx()));
                        params.add(this.translatedContent);
                        params.add(Env.getAD_User_ID((Properties)Env.getCtx()));
                        params.add(Env.getAD_User_ID((Properties)Env.getCtx()));
                        DB.executeUpdateEx((String)insert.toString(), (Object[])params.toArray(), (String)trx.getTrxName());
                    }
                }
            }
            suggestion.setAD_Language(Env.getAD_Language((Properties)Env.getCtx()));
            suggestion.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
            suggestion.set_ValueOfColumn("AD_UserClient_ID", (Object)Env.getAD_Client_ID((Properties)Env.getCtx()));
            suggestion.setIsApproved(false);
            suggestion.setProcessed(false);
            suggestion.setMsgText(this.helpTextbox.getValue());
            suggestion.setIsSaveAsTenantCustomization(false);
            suggestion.saveCrossTenantSafeEx();
        }
        this.detach();
    }

    private String removeHeaderTag(String htmlString) {
        htmlString = htmlString.replace("<html>", "").replace("</html>", "").replace("<body>", "").replace("</body>", "").replace("<head>", "").replace("</head>", "");
        return htmlString;
    }

    private String getContextHelpName(PO po) {
        if (po == null) {
            return "Home";
        }
        if (po instanceof MTab) {
            MTab tab = (MTab)po;
            return tab.getAD_Window().getName() + " / " + tab.getName();
        }
        if (po instanceof MProcess) {
            MProcess process = (MProcess)po;
            String name = process.getName();
            return "Report/Process " + name;
        }
        if (po instanceof MForm) {
            MForm form = (MForm)po;
            String name = form.getName();
            return "Form " + name;
        }
        if (po instanceof MWorkflow) {
            MWorkflow wf = (MWorkflow)po;
            String name = wf.getName();
            return "Workflow " + name;
        }
        if (po instanceof MInfoWindow) {
            MInfoWindow info = (MInfoWindow)po;
            String name = info.getName();
            return "Info " + name;
        }
        if (po instanceof MWFNode) {
            MWFNode node = (MWFNode)po;
            String name = "node";
            return node.getAD_Workflow().getName() + " / " + name;
        }
        if (po instanceof MTask) {
            MTask task = (MTask)po;
            String name = task.getName();
            return "Task " + name;
        }
        return po.get_ValueAsString("Name");
    }

    private void setContextHelpInfo(PO po, MCtxHelp ctxHelp) {
        if (po == null) {
            ctxHelp.setName("Home");
            ctxHelp.setCtxType("H");
        } else if (po instanceof MTab) {
            MTab tab = (MTab)po;
            String name = tab.getName();
            String fullName = tab.getAD_Window().getName() + " / " + name;
            if (fullName.length() <= 60) {
                ctxHelp.setName(fullName);
            } else {
                ctxHelp.setDescription(fullName);
                String lname = "Tab " + name;
                if (lname.length() <= 60) {
                    ctxHelp.setName(lname);
                }
            }
            ctxHelp.setCtxType("T");
        } else if (po instanceof MProcess) {
            MProcess process = (MProcess)po;
            String name = process.getName();
            String fullName = "Report/Process " + name;
            if (fullName.length() <= 60) {
                ctxHelp.setName(fullName);
            } else {
                ctxHelp.setDescription(fullName);
                ctxHelp.setName(name);
            }
            ctxHelp.setCtxType("P");
        } else if (po instanceof MForm) {
            MForm form = (MForm)po;
            String name = form.getName();
            String fullName = "Form " + name;
            if (fullName.length() <= 60) {
                ctxHelp.setName(fullName);
            } else {
                ctxHelp.setDescription(fullName);
                ctxHelp.setName(name);
            }
            ctxHelp.setCtxType("F");
        } else if (po instanceof MWorkflow) {
            MWorkflow wf = (MWorkflow)po;
            String name = wf.getName();
            String fullName = "Workflow " + name;
            if (fullName.length() <= 60) {
                ctxHelp.setName(fullName);
            } else {
                ctxHelp.setDescription(fullName);
                ctxHelp.setName(name);
            }
            ctxHelp.setCtxType("W");
        } else if (po instanceof MInfoWindow) {
            String fullName;
            MInfoWindow info = (MInfoWindow)po;
            String name = info.getName();
            MUserDefInfo userDef = MUserDefInfo.getBestMatch((Properties)Env.getCtx(), (int)info.getAD_InfoWindow_ID());
            if (userDef != null && !Util.isEmpty((String)userDef.getName())) {
                name = userDef.getName();
            }
            if ((fullName = "Info " + name).length() <= 60) {
                ctxHelp.setName(fullName);
            } else {
                ctxHelp.setDescription(fullName);
                ctxHelp.setName(name);
            }
            ctxHelp.setCtxType("I");
        } else if (po instanceof MWFNode) {
            MWFNode node = (MWFNode)po;
            String name = "node";
            String fullName = node.getAD_Workflow().getName() + " / " + name;
            if (fullName.length() <= 60) {
                ctxHelp.setName(fullName);
            } else {
                ctxHelp.setDescription(fullName);
                ctxHelp.setName(name);
            }
            ctxHelp.setCtxType("N");
        } else if (po instanceof MTask) {
            MTask task = (MTask)po;
            String name = task.getName();
            String fullName = "Task " + name;
            if (fullName.length() <= 60) {
                ctxHelp.setName(fullName);
            } else {
                ctxHelp.setDescription(fullName);
                ctxHelp.setName(name);
            }
            ctxHelp.setCtxType("K");
        }
    }
}

