/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.I_AD_Menu;
import org.compiere.model.MMenu;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MTreeFavorite;
import org.compiere.model.MTreeFavoriteNode;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.South;

public class LoginOpenSequenceDialog
extends Window {
    private static final long serialVersionUID = -6200912526954948898L;
    protected static final CLogger log = CLogger.getCLogger(LoginOpenSequenceDialog.class);
    private Button bAdd = ButtonFactory.createNamedButton("Next", false, true);
    private Button bRemove = ButtonFactory.createNamedButton("Previous", false, true);
    private Button bUp = ButtonFactory.createNamedButton("Parent", false, true);
    private Button bDown = ButtonFactory.createNamedButton("Detail", false, true);
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, false, true, false, false, false);
    private SimpleListModel noModel = new SimpleListModel();
    private SimpleListModel yesModel = new SimpleListModel();
    private Listbox noList = new Listbox();
    private Listbox yesList = new Listbox();
    private Label noLabel = new Label();
    private Label yesLabel = new Label();
    private ArrayList<Integer> autoOpenSeqs = new ArrayList();
    private int m_AD_User_ID;

    public LoginOpenSequenceDialog(int AD_User_ID) {
        this.m_AD_User_ID = AD_User_ID;
        this.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"LoginOpenSeqNo"));
        this.setBorder("normal");
        this.setPosition("center");
        this.setShadow(true);
        this.setSizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setSclass("popup-dialog fav-login-open-seq-dialog");
        this.setStyle("position: relative; margin: none; border: none; padding: none;");
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 650);
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 450);
        this.init();
    }

    private void init() {
        Hlayout hlayout = new Hlayout();
        hlayout.appendChild((Component)this.noList);
        hlayout.appendChild((Component)this.yesList);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)hlayout, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hlayout, "1");
        Center center = new Center();
        center.setSclass("dialog-content");
        center.appendChild((Component)hlayout);
        Panel southPanel = new Panel();
        southPanel.appendChild((Component)this.confirmPanel);
        South south = new South();
        south.setSclass("dialog-footer");
        south.appendChild((Component)southPanel);
        Borderlayout layout = new Borderlayout();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)layout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)layout, "1");
        layout.appendChild((Component)center);
        layout.appendChild((Component)south);
        this.appendChild((Component)layout);
        this.yesModel.setMultiple(true);
        this.noModel.setMultiple(true);
        this.noLabel.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Available"));
        this.yesLabel.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected"));
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.noList, "1");
        ZKUpdateUtil.setVflex(this.noList, true);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.yesList, "1");
        ZKUpdateUtil.setVflex(this.yesList, true);
        EventListener<Event> mouseListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if ("onDoubleClick".equals(event.getName())) {
                    LoginOpenSequenceDialog.this.migrateValueAcrossLists(event);
                }
            }
        };
        this.yesList.addDoubleClickListener(mouseListener);
        this.noList.addDoubleClickListener(mouseListener);
        Object actionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                LoginOpenSequenceDialog.this.migrateValueAcrossLists(event);
            }
        };
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bAdd);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bAdd);
        this.bAdd.addEventListener("onClick", (EventListener)actionListener);
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bRemove);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bRemove);
        this.bRemove.addEventListener("onClick", (EventListener)actionListener);
        DragListener crossListMouseListener = new DragListener();
        this.yesList.addOnDropListener(crossListMouseListener);
        this.noList.addOnDropListener(crossListMouseListener);
        if (!ClientInfo.isMobile()) {
            this.yesList.setItemDraggable(true);
            this.noList.setItemDraggable(true);
        }
        actionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                LoginOpenSequenceDialog.this.migrateValueWithinYesList(event);
            }
        };
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bUp);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bUp);
        this.bUp.addEventListener("onClick", (EventListener)actionListener);
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bDown);
        LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)this.bDown);
        this.bDown.addEventListener("onClick", (EventListener)actionListener);
        ListHead listHead = new ListHead();
        listHead.setParent((Component)this.yesList);
        ListHeader listHeader = new ListHeader();
        listHeader.appendChild((Component)this.yesLabel);
        Hlayout yesButtonLayout = new Hlayout();
        yesButtonLayout.appendChild((Component)this.bUp);
        yesButtonLayout.appendChild((Component)this.bDown);
        yesButtonLayout.setStyle("display: inline-block; float: right;");
        listHeader.appendChild((Component)yesButtonLayout);
        listHeader.setParent((Component)listHead);
        listHead = new ListHead();
        listHead.setParent((Component)this.noList);
        listHeader = new ListHeader();
        listHeader.appendChild((Component)this.noLabel);
        listHeader.setSort("auto");
        listHeader.setSortDirection("ascending");
        this.noList.setAttribute("org.zkoss.zul.listbox.autoSort", "true");
        Hlayout noButtonLayout = new Hlayout();
        noButtonLayout.appendChild((Component)this.bRemove);
        noButtonLayout.appendChild((Component)this.bAdd);
        noButtonLayout.setStyle("display: inline-block; float: right;");
        listHeader.appendChild((Component)noButtonLayout);
        listHeader.setParent((Component)listHead);
        EventListener<Event> onClickListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event.getTarget().equals((Object)LoginOpenSequenceDialog.this.confirmPanel.getButton("Ok"))) {
                    LoginOpenSequenceDialog.this.saveData();
                } else if (event.getTarget().equals((Object)LoginOpenSequenceDialog.this.confirmPanel.getButton("Cancel"))) {
                    LoginOpenSequenceDialog.this.detach();
                } else if (event.getTarget().equals((Object)LoginOpenSequenceDialog.this.confirmPanel.getButton("Reset"))) {
                    LoginOpenSequenceDialog.this.loadData();
                }
            }
        };
        this.confirmPanel.addActionListener(onClickListener);
    }

    public void loadData() {
        this.autoOpenSeqs.clear();
        this.yesModel.removeAllElements();
        this.noModel.removeAllElements();
        int favTreeID = MTreeFavorite.getFavoriteTreeID((int)this.m_AD_User_ID);
        MRole role = MRole.get((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx()));
        Query query = new Query(Env.getCtx(), "AD_Tree_Favorite_Node", "AD_Tree_Favorite_ID=? AND AD_Menu_ID>0 AND LoginOpenSeqNo>=0", null);
        query.setOrderBy("LoginOpenSeqNo");
        query.setOnlyActiveRecords(true);
        query.setParameters(new Object[]{favTreeID});
        Object object = query.getIDs();
        int n = ((int[])object).length;
        int n2 = 0;
        while (n2 < n) {
            int favNodeID = object[n2];
            this.autoOpenSeqs.add(favNodeID);
            ++n2;
        }
        query = new Query(Env.getCtx(), "AD_Tree_Favorite_Node", "AD_Tree_Favorite_ID=? AND AD_Menu_ID>0 ", null);
        query.setOrderBy("LoginOpenSeqNo");
        query.setOnlyActiveRecords(true);
        query.setParameters(new Object[]{favTreeID});
        List lsFavNode = null;
        try {
            PO.setCrossTenantSafe();
            lsFavNode = query.list();
        }
        finally {
            PO.clearCrossTenantSafe();
        }
        try {
            HashMap<Integer, ListElement> currSel = new HashMap<Integer, ListElement>();
            object = lsFavNode.iterator();
            while (object.hasNext()) {
                MTreeFavoriteNode favNode = (MTreeFavoriteNode)object.next();
                int key = favNode.getAD_Tree_Favorite_Node_ID();
                MMenu menu = (MMenu)MTable.get((Properties)Env.getCtx(), (int)116).getPO(favNode.getAD_Menu_ID(), null);
                Boolean access = MTreeFavorite.getAccessForMenuItem((MRole)role, (I_AD_Menu)menu);
                if (access == null || !access.booleanValue()) continue;
                ListElement pp = new ListElement(key, menu.get_Translation("Name"));
                if (this.autoOpenSeqs != null && this.autoOpenSeqs.size() > 0) {
                    if (this.autoOpenSeqs.contains(key)) {
                        currSel.put(key, pp);
                        continue;
                    }
                    this.noModel.addElement((Object)pp);
                    continue;
                }
                this.noModel.addElement((Object)pp);
            }
            if (this.autoOpenSeqs != null) {
                object = this.autoOpenSeqs.iterator();
                while (object.hasNext()) {
                    int key = (Integer)object.next();
                    if (currSel.get(key) == null) continue;
                    this.yesModel.addElement(currSel.get(key));
                }
            }
        }
        catch (DBException e) {
            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        this.bAdd.setEnabled(true);
        this.bRemove.setEnabled(true);
        this.bUp.setEnabled(true);
        this.bDown.setEnabled(true);
        this.yesList.setEnabled(true);
        this.noList.setEnabled(true);
        this.yesList.setItemRenderer(this.yesModel);
        this.yesList.setModel((ListModel)this.yesModel);
        this.noList.setItemRenderer(this.noModel);
        this.noList.setModel((ListModel)this.noModel);
    }

    protected void migrateValueAcrossLists(Event event) {
        Component source = event.getTarget();
        if (source instanceof ListItem) {
            source = ((ListItem)source).getListbox();
        }
        Listbox listFrom = source == this.bAdd || source == this.noList ? this.noList : this.yesList;
        Listbox listTo = source == this.bAdd || source == this.noList ? this.yesList : this.noList;
        int endIndex = this.yesList.getIndexOfItem(listTo.getSelectedItem());
        if (endIndex < 0) {
            endIndex = 0;
        }
        this.migrateLists(listFrom, listTo, endIndex);
    }

    protected void migrateLists(Listbox listFrom, Listbox listTo, int endIndex) {
        int index = 0;
        SimpleListModel lmFrom = (SimpleListModel)listFrom.getModel();
        SimpleListModel lmTo = (SimpleListModel)listTo.getModel();
        Set selectedItems = listFrom.getSelectedItems();
        ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
        for (Object obj : selectedItems) {
            ListItem listItem = (ListItem)((Object)obj);
            index = listFrom.getIndexOfItem(listItem);
            ListElement selObject = (ListElement)((Object)lmFrom.getElementAt(index));
            selObjects.add(selObject);
        }
        for (ListElement selObject : selObjects) {
            if (selObject == null || !selObject.isUpdateable()) continue;
            lmFrom.removeElement((Object)selObject);
            lmTo.add(endIndex, (Object)selObject);
            ++endIndex;
            index = lmTo.indexOf((Object)selObject);
            listTo.setSelectedIndex(index);
        }
    }

    protected void migrateValueWithinYesList(int endIndex, List<ListElement> selObjects) {
        int iniIndex = 0;
        Arrays.sort(selObjects.toArray());
        ListElement endObject = (ListElement)((Object)this.yesModel.getElementAt(endIndex));
        for (ListElement selected : selObjects) {
            iniIndex = this.yesModel.indexOf((Object)selected);
            ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(iniIndex));
            this.yesModel.removeElement((Object)selObject);
            endIndex = this.yesModel.indexOf((Object)endObject);
            this.yesModel.add(endIndex, (Object)selObject);
        }
    }

    protected void migrateValueWithinYesList(Event event) {
        Object[] selObjects = this.yesList.getSelectedItems().toArray();
        if (selObjects == null) {
            return;
        }
        int length = selObjects.length;
        if (length == 0) {
            return;
        }
        int[] indices = this.yesList.getSelectedIndices();
        Arrays.sort(indices);
        boolean change = false;
        Component source = event.getTarget();
        if (source == this.bUp) {
            i = 0;
            while (i < length) {
                int index = indices[i];
                if (index == 0) break;
                ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                ListElement newObject = (ListElement)((Object)this.yesModel.getElementAt(index - 1));
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index - 1);
                    indices[i] = index - 1;
                    change = true;
                    ++i;
                    continue;
                }
                break;
            }
        } else if (source == this.bDown) {
            i = length - 1;
            while (i >= 0) {
                int index = indices[i];
                if (index >= this.yesModel.getSize() - 1) break;
                ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                ListElement newObject = (ListElement)((Object)this.yesModel.getElementAt(index + 1));
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index + 1);
                    this.yesList.setSelectedIndex(index + 1);
                    indices[i] = index + 1;
                    change = true;
                    --i;
                    continue;
                }
                break;
            }
        }
        if (change) {
            this.yesList.setSelectedIndices(indices);
            if (this.yesList.getSelectedItem() != null) {
                AuFocus focus = new AuFocus((Component)this.yesList.getSelectedItem());
                Clients.response((AuResponse)focus);
            }
        }
    }

    public void saveData() {
        try {
            MTreeFavoriteNode favNode;
            ListElement pp;
            PO.setCrossTenantSafe();
            int i = 0;
            while (i < this.yesModel.getSize()) {
                pp = (ListElement)((Object)this.yesModel.getElementAt(i));
                if (pp.isUpdateable()) {
                    favNode = (MTreeFavoriteNode)MTable.get((int)200221).getPO(pp.getKey(), null);
                    favNode.setLoginOpenSeqNo(i);
                    favNode.saveEx();
                }
                ++i;
            }
            i = 0;
            while (i < this.noModel.getSize()) {
                pp = (ListElement)((Object)this.noModel.getElementAt(i));
                if (pp.isUpdateable()) {
                    favNode = (MTreeFavoriteNode)MTable.get((int)200221).getPO(pp.getKey(), null);
                    favNode.set_ValueNoCheck("LoginOpenSeqNo", null);
                    favNode.saveEx();
                }
                ++i;
            }
        }
        finally {
            PO.clearCrossTenantSafe();
        }
        this.detach();
    }

    private class DragListener
    implements EventListener<Event> {
        public void onEvent(Event event) throws Exception {
            if (event instanceof DropEvent) {
                int endIndex = 0;
                DropEvent me = (DropEvent)event;
                ListItem endItem = (ListItem)me.getTarget();
                ListItem startItem = (ListItem)me.getDragged();
                if (!startItem.isSelected()) {
                    startItem.setSelected(true);
                }
                if (startItem.getListbox() != endItem.getListbox()) {
                    Listbox listFrom = (Listbox)startItem.getListbox();
                    Listbox listTo = (Listbox)endItem.getListbox();
                    endIndex = LoginOpenSequenceDialog.this.yesList.getIndexOfItem(endItem);
                    LoginOpenSequenceDialog.this.migrateLists(listFrom, listTo, endIndex);
                } else if (startItem.getListbox() == endItem.getListbox() && startItem.getListbox() == LoginOpenSequenceDialog.this.yesList) {
                    ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
                    endIndex = LoginOpenSequenceDialog.this.yesList.getIndexOfItem(endItem);
                    for (Object obj : LoginOpenSequenceDialog.this.yesList.getSelectedItems()) {
                        ListItem listItem = (ListItem)((Object)obj);
                        int index = LoginOpenSequenceDialog.this.yesList.getIndexOfItem(listItem);
                        ListElement selObject = (ListElement)((Object)LoginOpenSequenceDialog.this.yesModel.getElementAt(index));
                        selObjects.add(selObject);
                    }
                    LoginOpenSequenceDialog.this.migrateValueWithinYesList(endIndex, selObjects);
                    LoginOpenSequenceDialog.this.yesList.clearSelection();
                }
            }
        }
    }

    private static class ListElement
    extends NamePair {
        private static final long serialVersionUID = -1717531470895073281L;
        private int m_key;
        private boolean m_updateable;

        public ListElement(int key, String name) {
            super(name);
            this.m_key = key;
            this.m_updateable = true;
        }

        public int getKey() {
            return this.m_key;
        }

        public boolean isUpdateable() {
            return this.m_updateable;
        }

        public String getID() {
            return this.m_key != -1 ? String.valueOf(this.m_key) : null;
        }

        public int hashCode() {
            return this.m_key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListElement) {
                ListElement li = (ListElement)((Object)obj);
                return li.getKey() == this.m_key && li.getName() != null && li.getName().equals(this.getName());
            }
            return false;
        }

        public String toString() {
            Object s = super.toString();
            if (s == null || ((String)s).trim().length() == 0) {
                s = "<" + this.getKey() + ">";
            }
            return s;
        }
    }
}

