/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.beans.PropertyChangeListener;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.Callback;
import org.adempiere.util.ICalloutUI;
import org.adempiere.webui.AdempiereIdGenerator;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADTreePanel;
import org.adempiere.webui.adwindow.ADWindowToolbar;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.adwindow.DetailPane;
import org.adempiere.webui.adwindow.GridTabRowRenderer;
import org.adempiere.webui.adwindow.GridView;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.adwindow.IFieldEditorContainer;
import org.adempiere.webui.adwindow.ToolbarProcessButton;
import org.adempiere.webui.apps.CalloutDialog;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Group;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.SimpleTreeModel;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Urlbox;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WButtonEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.editor.WImageEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.panel.HelpController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.GridTabDataBinder;
import org.adempiere.webui.util.TreeUtils;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.MColumn;
import org.compiere.model.MPreference;
import org.compiere.model.MRole;
import org.compiere.model.MStyle;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MToolBarButton;
import org.compiere.model.MToolBarButtonRestrict;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.SystemProperties;
import org.compiere.model.X_AD_ToolBarButton;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Button;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Div;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.West;
import org.zkoss.zul.impl.XulElement;

public class ADTabpanel
extends Div
implements Evaluatee,
EventListener<Event>,
DataStatusListener,
IADTabpanel,
IdSpace,
IFieldEditorContainer {
    private static final String SLIDE_LEFT_IN_CSS = "slide-left-in";
    private static final String SLIDE_LEFT_OUT_CSS = "slide-left-out";
    private static final String SLIDE_RIGHT_IN_CSS = "slide-right-in";
    private static final String SLIDE_RIGHT_OUT_CSS = "slide-right-out";
    private static final long serialVersionUID = -5335610241895151024L;
    private static final String ON_SAVE_OPEN_PREFERENCE_EVENT = "onSaveOpenPreference";
    public static final String ON_POST_INIT_EVENT = "onPostInit";
    public static final String ON_SWITCH_VIEW_EVENT = "onSwitchView";
    public static final String ON_DYNAMIC_DISPLAY_EVENT = "onDynamicDisplay";
    private static final String ON_DEFER_SET_SELECTED_NODE = "onDeferSetSelectedNode";
    private static final String ON_DEFER_SET_SELECTED_NODE_ATTR = "onDeferSetSelectedNode.Event.Posted";
    private static final CLogger logger = CLogger.getCLogger(ADTabpanel.class);
    private GridTab gridTab;
    private GridWindow gridWindow;
    private AbstractADWindowContent windowPanel;
    private int windowNo;
    private Grid form;
    private ArrayList<WEditor> editors = new ArrayList();
    private ArrayList<Component> editorComps = new ArrayList();
    private ArrayList<WButtonEditor> toolbarButtonEditors = new ArrayList();
    private ArrayList<ToolbarProcessButton> toolbarProcessButtons = new ArrayList();
    private boolean uiCreated = false;
    private GridView listPanel;
    private Map<String, List<Row>> fieldGroupContents;
    private Map<String, List<org.zkoss.zul.Row>> fieldGroupHeaders;
    private Map<String, List<Tab>> fieldGroupTabHeaders;
    private ArrayList<Row> rowList;
    protected List<Group> allCollapsibleGroups;
    private Borderlayout formContainer = null;
    private ADTreePanel treePanel = null;
    private GridTabDataBinder dataBinder;
    protected boolean activated = false;
    private Group currentGroup;
    private DetailPane detailPane;
    private boolean detailPaneMode;
    private int tabNo;
    private WEditor defaultFocusField = null;
    private int numberOfFormColumns;
    public static final String ON_TOGGLE_EVENT = "onToggle";
    private static final String DEFAULT_PANEL_WIDTH = "300px";
    private static CCache<Integer, Boolean> quickFormCache = new CCache(null, "QuickForm", 20, false);
    private Tabbox tabbox = new Tabbox();
    private List<Grid> tabGroupForms;
    private Rows currentTabGroupRows;

    public ADTabpanel() {
        this.init();
    }

    private void init() {
        this.initComponents();
        this.addEventListener(ON_DEFER_SET_SELECTED_NODE, this);
        this.addEventListener("onSavePayment", this);
        this.addEventListener("onActivate", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                ADTabpanel.this.removeAttribute("org.adempiere.webui.adwindow.IADTabpanel.onActivatePosted");
            }
        });
        this.addEventListener(ON_POST_INIT_EVENT, this);
        this.addEventListener(ON_SAVE_OPEN_PREFERENCE_EVENT, this);
        if (ClientInfo.isMobile()) {
            ClientInfo.onClientInfo(this, this::onClientInfo);
        }
    }

    private void initComponents() {
        LayoutUtils.addSclass("adtab-content", (HtmlBasedComponent)this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
        this.form = new Grid();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.form, "1");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.form, null);
        this.form.setVflex(false);
        this.form.setSclass("grid-layout adwindow-form");
        this.form.setWidgetAttribute("instanceName", "form");
        if (ClientInfo.isMobile()) {
            this.form.addEventListener("onSwipeRight", e -> {
                if (this.windowPanel != null && this.windowPanel.getBreadCrumb() != null && this.windowPanel.getBreadCrumb().isPreviousEnabled()) {
                    this.windowPanel.saveAndNavigate((Callback<Boolean>)((Callback)b -> {
                        if (b.booleanValue()) {
                            LayoutUtils.addSclass(SLIDE_RIGHT_OUT_CSS, (HtmlBasedComponent)this.form);
                            this.windowPanel.onPrevious();
                        }
                    }));
                }
            });
            this.form.addEventListener("onSwipeLeft", e -> {
                if (this.windowPanel != null && this.windowPanel.getBreadCrumb() != null && this.windowPanel.getBreadCrumb().isNextEnabled()) {
                    this.windowPanel.saveAndNavigate((Callback<Boolean>)((Callback)b -> {
                        if (b.booleanValue()) {
                            LayoutUtils.addSclass(SLIDE_LEFT_OUT_CSS, (HtmlBasedComponent)this.form);
                            this.windowPanel.onNext();
                        }
                    }));
                }
            });
        }
        this.listPanel = new GridView();
        if ("Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"P|ToggleOnDoubleClick"))) {
            this.listPanel.getListbox().addEventListener("onDoubleClick", this);
        }
    }

    private void setupFormSwipeListener() {
        String uuid = this.form.getUuid();
        StringBuilder script = new StringBuilder("(function(){let w=zk.Widget.$('").append(uuid).append("');");
        script.append("jq(w).on('touchstart', function(e) {let w=zk.Widget.$(this);w._touchstart=e;});");
        script.append("jq(w).on('touchmove', function(e) {let w=zk.Widget.$(this);w._touchmove=e;});");
        script.append("jq(w).on('touchend', function(e) {let w=zk.Widget.$(this);let ts = w._touchstart; let tl = w._touchmove;w._touchstart=null;w._touchmove=null;if (ts && tl) {if (ts.originalEvent) ts = ts.originalEvent;if (tl.originalEvent) tl = tl.originalEvent;if (ts.changedTouches && ts.changedTouches.length==1 && tl.changedTouches && tl.changedTouches.length==1) {let diff=(tl.timeStamp-ts.timeStamp)/1000;if (diff > 1) return;let diffx=tl.changedTouches[0].pageX-ts.changedTouches[0].pageX;let diffy=tl.changedTouches[0].pageY-ts.changedTouches[0].pageY;if (Math.abs(diffx) >= 100 && Math.abs(diffy) < 80) {if (diffx > 0) {let event = new zk.Event(w, 'onSwipeRight', null, {toServer: true});zAu.send(event);} else {let event = new zk.Event(w, 'onSwipeLeft', null, {toServer: true});zAu.send(event);}}}}});");
        script.append("})()");
        Clients.response((AuResponse)new AuScript(script.toString()));
    }

    @Override
    public void setDetailPane(DetailPane component) {
        Object height;
        this.detailPane = component;
        Borderlayout borderLayout = this.formContainer;
        South south = borderLayout.getSouth();
        if (south == null) {
            south = new South();
            LayoutUtils.addSlideSclass((LayoutRegion)south);
            borderLayout.appendChild((Component)south);
            south.addEventListener("onOpen", (EventListener)this);
            south.addEventListener("onSlide", (EventListener)this);
        }
        south.appendChild((Component)component);
        south.setVisible(true);
        south.setCollapsible(true);
        south.setSplittable(true);
        south.setOpen(this.isOpenDetailPane());
        south.setSclass("adwindow-gridview-detail");
        if (!south.isOpen()) {
            LayoutUtils.addSclass("slide", (HtmlBasedComponent)south);
        }
        if (!Util.isEmpty((String)(height = this.heigthDetailPane()))) {
            try {
                ClientInfo browserInfo = SessionManager.getAppDesktop().getClientInfo();
                int browserHeight = browserInfo.desktopHeight;
                int prefHeight = Integer.valueOf(((String)height).replace("px", ""));
                int topmarginpx = MSysConfig.getIntValue((String)"TOP_MARGIN_PIXELS_FOR_HEADER", (int)222);
                int maxHeight = browserHeight - topmarginpx;
                if (prefHeight <= maxHeight) {
                    height = Integer.toString(prefHeight) + "px";
                    ZKUpdateUtil.setHeight((HtmlBasedComponent)this.formContainer.getSouth(), (String)height);
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public DetailPane getDetailPane() {
        return this.detailPane;
    }

    @Override
    public void init(AbstractADWindowContent winPanel, GridTab gridTab) {
        this.gridWindow = gridTab.getGridWindow();
        this.windowNo = this.gridWindow.getWindowNo();
        this.gridTab = gridTab;
        gridTab.setCalloutUI((ICalloutUI)new CalloutDialog(Executions.getCurrent().getDesktop(), this.windowNo));
        this.windowPanel = winPanel;
        gridTab.addDataStatusListener((DataStatusListener)this);
        this.dataBinder = new GridTabDataBinder(gridTab);
        this.getChildren().clear();
        if (SystemProperties.isZkUnitTest()) {
            this.setId(AdempiereIdGenerator.escapeId(gridTab.getName()));
        }
        int AD_Tree_ID = 0;
        if (gridTab.isTreeTab()) {
            AD_Tree_ID = MTree.getDefaultAD_Tree_ID((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (String)gridTab.getKeyColumnName());
        }
        if (gridTab.isTreeTab() && AD_Tree_ID != 0) {
            Borderlayout layout = new Borderlayout();
            layout.setParent(this);
            layout.setSclass("adtab-form-borderlayout");
            if (ClientInfo.isMobile()) {
                LayoutUtils.addSclass("mobile", (HtmlBasedComponent)layout);
            }
            this.treePanel = new ADTreePanel(this.windowNo, gridTab.getTabNo());
            West west = new West();
            west.appendChild((Component)this.treePanel);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)west, this.widthTreePanel());
            west.setCollapsible(true);
            west.setSplittable(true);
            west.setAutoscroll(true);
            layout.appendChild((Component)west);
            LayoutUtils.addSlideSclass((LayoutRegion)west);
            if (this.isMobile()) {
                west.setOpen(false);
                LayoutUtils.addSclass("slide", (HtmlBasedComponent)west);
            }
            Center center = new Center();
            Vlayout div = new Vlayout();
            div.appendChild((Component)this.form);
            center.appendChild((Component)div);
            ZKUpdateUtil.setVflex((HtmlBasedComponent)div, "1");
            ZKUpdateUtil.setHflex((HtmlBasedComponent)div, "1");
            div.setSclass("adtab-form");
            div.setStyle("overflow-y: visible;");
            div.setSpacing("0px");
            layout.appendChild((Component)center);
            this.formContainer = layout;
            this.treePanel.getTree().addEventListener("onSelect", (EventListener)this);
        } else {
            Vlayout div = new Vlayout();
            div.setSclass("adtab-form");
            div.appendChild((Component)this.form);
            div.setStyle("overflow-y: visible;");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)div, "1");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)div, "100%");
            div.setSpacing("0px");
            Borderlayout layout = new Borderlayout();
            layout.setParent(this);
            layout.setSclass("adtab-form-borderlayout");
            if (ClientInfo.isMobile()) {
                LayoutUtils.addSclass("mobile", (HtmlBasedComponent)layout);
            }
            Center center = new Center();
            layout.appendChild((Component)center);
            center.appendChild((Component)div);
            this.formContainer = layout;
        }
        this.form.getParent().appendChild((Component)this.tabbox);
        this.setGroupTabboxVisibility();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tabbox, "100%");
        this.tabbox.setStyle("margin: 20px 0px 20px 0px; padding: 0px 20px 0px 20px; ");
        if (ClientInfo.isMobile()) {
            this.tabbox.setStyle("");
            this.tabbox.setMold("accordion");
        }
        this.form.getParent().appendChild((Component)this.listPanel);
        this.listPanel.setVisible(false);
        this.listPanel.setWindowNo(this.windowNo);
        this.listPanel.setADWindowPanel(winPanel);
    }

    @Override
    public void createUI() {
        this.createUI(false);
    }

    protected void createUI(boolean update) {
        if (update) {
            if (!this.uiCreated) {
                return;
            }
        } else {
            if (this.uiCreated) {
                return;
            }
            this.uiCreated = true;
        }
        this.fieldGroupContents = new HashMap<String, List<Row>>();
        this.fieldGroupHeaders = new HashMap<String, List<org.zkoss.zul.Row>>();
        this.allCollapsibleGroups = new ArrayList<Group>();
        this.tabGroupForms = new ArrayList<Grid>();
        this.fieldGroupTabHeaders = new HashMap<String, List<Tab>>();
        int numCols = this.gridTab.getNumColumns();
        if (numCols <= 0) {
            numCols = 6;
        }
        int diff = 0;
        if (this.isMobile()) {
            if (ClientInfo.maxWidth(499)) {
                if (numCols > 3) {
                    diff = numCols - 3;
                    numCols = 3;
                }
            } else if (ClientInfo.maxWidth(999) && numCols > 6) {
                diff = numCols - 6;
                numCols = 6;
            }
        }
        this.numberOfFormColumns = numCols;
        if (update) {
            this.form.getColumns().detach();
        }
        Columns columns = new Columns();
        this.form.appendChild((Component)columns);
        double equalWidth = 95.0 / (double)numCols;
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        decimalFormat.setRoundingMode(RoundingMode.DOWN);
        String columnWidth = decimalFormat.format(equalWidth);
        int h = 0;
        while (h < numCols + 1) {
            Column col = new Column();
            if (h == numCols) {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)col, "5%");
            } else {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)col, columnWidth + "%");
            }
            columns.appendChild((Component)col);
            ++h;
        }
        if (update) {
            this.form.getRows().detach();
            this.rowList = null;
            this.currentGroup = null;
        }
        Rows rows = this.form.newRows();
        GridField[] fields = this.gridTab.getFields();
        Row row = new Row();
        int actualxpos = 0;
        String currentFieldGroup = null;
        int i = 0;
        while (i < fields.length) {
            block83: {
                String fieldGroup;
                GridField field;
                block84: {
                    field = fields[i];
                    if (!field.isDisplayed()) break block83;
                    if (!field.isToolbarButton()) break block84;
                    WButtonEditor editor = null;
                    editor = update ? (WButtonEditor)this.findEditor(field) : (WButtonEditor)WebEditorFactory.getEditor(this.gridTab, field, false);
                    if (editor == null) break block84;
                    if (!update) {
                        if (this.windowPanel != null) {
                            editor.addActionListener(this.windowPanel);
                        }
                        editor.setGridTab(this.getGridTab());
                        editor.setADTabpanel(this);
                        field.addPropertyChangeListener((PropertyChangeListener)editor);
                        this.editors.add(editor);
                        editor.getComponent().setId(field.getColumnName());
                        this.toolbarButtonEditors.add(editor);
                    }
                    if (field.isToolbarOnlyButton()) break block83;
                }
                if (!(Util.isEmpty((String)(fieldGroup = field.getFieldGroup())) || fieldGroup.equals(currentFieldGroup) || "D".equals(field.getFieldGroupType()))) {
                    currentFieldGroup = fieldGroup;
                    if (numCols - actualxpos + 1 > 0) {
                        row.appendCellChild(this.createSpacer(), numCols - actualxpos + 1);
                    }
                    if (this.currentTabGroupRows != null) {
                        this.currentTabGroupRows.appendChild((Component)row);
                    } else {
                        row.setGroup(this.currentGroup);
                        rows.appendChild((Component)row);
                    }
                    if (this.rowList != null) {
                        this.rowList.add(row);
                    }
                    ArrayList<Object> headerRows = new ArrayList<Object>();
                    this.fieldGroupHeaders.put(fieldGroup, headerRows);
                    this.rowList = new ArrayList();
                    this.fieldGroupContents.put(fieldGroup, this.rowList);
                    if ("L".equals(field.getFieldGroupType())) {
                        row = new Row();
                        Label groupLabel = new Label(fieldGroup);
                        row.appendCellChild((Component)groupLabel, numCols);
                        rows.appendChild((Component)row);
                        headerRows.add((Object)row);
                        row = new Row();
                        Separator separator = new Separator();
                        separator.setBar(true);
                        row.appendCellChild((Component)separator, numCols);
                        rows.appendChild((Component)row);
                        headerRows.add((Object)row);
                        this.currentGroup = null;
                        this.currentTabGroupRows = null;
                    } else if ("T".equals(field.getFieldGroupType())) {
                        ArrayList<Tab> headerTabs = new ArrayList<Tab>();
                        this.fieldGroupTabHeaders.put(fieldGroup, headerTabs);
                        Tabs tabs = this.tabbox.getTabs();
                        if (tabs == null) {
                            tabs = new Tabs();
                            this.tabbox.appendChild((Component)tabs);
                            this.setGroupTabboxVisibility();
                        }
                        Tab tab = new Tab(fieldGroup);
                        tabs.appendChild((Component)tab);
                        headerTabs.add(tab);
                        Grid tabForm = new Grid();
                        this.tabGroupForms.add(tabForm);
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)tabForm, "1");
                        ZKUpdateUtil.setHeight((HtmlBasedComponent)tabForm, null);
                        tabForm.setVflex(false);
                        tabForm.setSclass("grid-layout adwindow-form");
                        Columns tabColumns = new Columns();
                        tabForm.appendChild((Component)tabColumns);
                        double tabEqualWidth = 95.5 / (double)numCols;
                        DecimalFormat tabDecimalFormat = new DecimalFormat("0.00");
                        decimalFormat.setRoundingMode(RoundingMode.DOWN);
                        String tabColumnWidth = tabDecimalFormat.format(tabEqualWidth);
                        int h2 = 0;
                        while (h2 < numCols + 1) {
                            Column col = new Column();
                            if (h2 == numCols) {
                                ZKUpdateUtil.setWidth((HtmlBasedComponent)col, "4.5%");
                            } else {
                                ZKUpdateUtil.setWidth((HtmlBasedComponent)col, tabColumnWidth + "%");
                            }
                            tabColumns.appendChild((Component)col);
                            ++h2;
                        }
                        tabForm.appendChild((Component)tabColumns);
                        Rows tabRows = tabForm.newRows();
                        Tabpanels tabpanels = this.tabbox.getTabpanels();
                        if (tabpanels == null) {
                            tabpanels = new Tabpanels();
                            ZKUpdateUtil.setWidth((HtmlBasedComponent)tabpanels, "100%");
                            this.tabbox.appendChild((Component)tabpanels);
                        }
                        Tabpanel tp = new Tabpanel();
                        tabpanels.appendChild((Component)tp);
                        tp.setStyle(" padding: 20px 0px 20px 0px; ");
                        tp.appendChild((Component)tabForm);
                        this.currentGroup = null;
                        this.currentTabGroupRows = tabRows;
                    } else {
                        Group rowg = new Group(fieldGroup);
                        Cell cell = (Cell)rowg.getFirstChild();
                        cell.setSclass("z-group-inner");
                        cell.setColspan(numCols + 1);
                        this.allCollapsibleGroups.add(rowg);
                        if ("T".equals(field.getFieldGroupType()) || field.getIsCollapsedByDefault()) {
                            rowg.setOpen(false);
                        }
                        this.currentTabGroupRows = null;
                        this.currentGroup = rowg;
                        rows.appendChild((Component)rowg);
                        headerRows.add((Object)rowg);
                    }
                    row = new Row();
                    actualxpos = 0;
                }
                int columnSpan = field.getColumnSpan();
                int xpos = field.getXPosition();
                if (xpos + columnSpan > numCols && diff > 0) {
                    if ((xpos -= diff) <= 0) {
                        xpos = 1;
                    }
                    if (xpos == 1 && (field.getDisplayType() == 20 || field.getDisplayType() == 28 || field.isFieldOnly())) {
                        xpos = 2;
                    }
                }
                if (xpos <= actualxpos) {
                    if (numCols - actualxpos + 1 > 0) {
                        row.appendCellChild(this.createSpacer(), numCols - actualxpos + 1);
                    }
                    if (this.currentTabGroupRows != null) {
                        this.currentTabGroupRows.appendChild((Component)row);
                    } else {
                        row.setGroup(this.currentGroup);
                        rows.appendChild((Component)row);
                    }
                    if (this.rowList != null) {
                        this.rowList.add(row);
                    }
                    row = new Row();
                    actualxpos = 0;
                }
                if (xpos - 1 - actualxpos > 0) {
                    row.appendCellChild(this.createSpacer(), xpos - 1 - actualxpos);
                }
                boolean paintLabel = field.getDisplayType() != 28 && field.getDisplayType() != 20 && !field.isFieldOnly();
                int remainCols = numCols - actualxpos;
                if (columnSpan > remainCols) {
                    int n = columnSpan = remainCols - 1 > 0 ? remainCols - 1 : 1;
                }
                actualxpos = field.isHeading() ? xpos : xpos + columnSpan - 1 + (paintLabel ? 1 : 0);
                if (!field.isHeading()) {
                    WEditor editor;
                    WEditor wEditor = editor = update ? this.findEditor(field) : WebEditorFactory.getEditor(this.gridTab, field, false);
                    if (editor != null) {
                        if (!update) {
                            String entityTypeInf = Env.IsShowTechnicalInfOnHelp((Properties)Env.getCtx()) ? "this.fieldEntityType());" : "'');";
                            editor.getComponent().setWidgetOverride("fieldHeader", HelpController.escapeJavascriptContent(field.getHeader()));
                            editor.getComponent().setWidgetOverride("fieldDescription", HelpController.escapeJavascriptContent(field.getDescription()));
                            editor.getComponent().setWidgetOverride("fieldHelp", HelpController.escapeJavascriptContent(field.getHelp()));
                            editor.getComponent().setWidgetOverride("fieldEntityType", HelpController.escapeJavascriptContent(field.getEntityType()));
                            editor.getComponent().setWidgetListener("onFocus", "zWatch.fire('onFieldTooltip', this, null, this.fieldHeader(), this.fieldDescription(), this.fieldHelp()," + entityTypeInf);
                            editor.setGridTab(this.getGridTab());
                            field.addPropertyChangeListener((PropertyChangeListener)editor);
                            this.editors.add(editor);
                            this.editorComps.add(editor.getComponent());
                        }
                        if (paintLabel) {
                            div = new Div();
                            div.setSclass("form-label");
                            Label label = editor.getLabel();
                            div.appendChild((Component)label);
                            if (label.getDecorator() != null) {
                                div.appendChild(label.getDecorator());
                            }
                            row.appendCellChild((Component)div, 1);
                        }
                        row.appendCellChild(editor.getComponent(), columnSpan);
                        row.getLastCell().setStyle("position: relative; overflow: visible;");
                        if (!update) {
                            if (editor instanceof WButtonEditor) {
                                if (this.windowPanel != null) {
                                    ((WButtonEditor)editor).addActionListener(this.windowPanel);
                                }
                            } else {
                                editor.addValueChangeListener(this.dataBinder);
                            }
                        }
                        if (this.defaultFocusField == null && field.isDefaultFocus()) {
                            this.defaultFocusField = editor;
                        }
                        if (!update) {
                            WEditorPopupMenu popupMenu;
                            editor.fillHorizontal();
                            Component fellow = editor.getComponent().getFellowIfAny(field.getColumnName());
                            if (fellow == null) {
                                editor.getComponent().setId(field.getColumnName());
                            }
                            if ((popupMenu = editor.getPopupMenu()) == null) {
                                popupMenu = new WEditorPopupMenu(false, false, false, false, false, false, null);
                            }
                            if (popupMenu != null) {
                                if (editor instanceof ContextMenuListener) {
                                    popupMenu.addMenuListener((ContextMenuListener)((Object)editor));
                                }
                                popupMenu.setId(field.getColumnName() + "-popup");
                                this.appendChild((Component)popupMenu);
                                if (!field.isFieldOnly()) {
                                    Label label = editor.getLabel();
                                    if (ClientInfo.isMobile()) {
                                        WEditorPopupMenu finalPopupMenu = popupMenu;
                                        label.addEventListener("onClick", evt -> finalPopupMenu.open((Component)label, "after_start"));
                                    } else {
                                        if (popupMenu.isZoomEnabled() && editor instanceof IZoomableEditor) {
                                            label.addEventListener("onClick", new ZoomListener((IZoomableEditor)((Object)editor)));
                                        }
                                        popupMenu.addContextElement((XulElement)label);
                                    }
                                }
                                popupMenu.addSuggestion(field);
                                if (!ClientInfo.isMobile() && editor.getComponent() instanceof XulElement) {
                                    popupMenu.addContextElement((XulElement)editor.getComponent());
                                }
                            }
                        }
                    }
                } else {
                    Label label = new Label(field.getHeader());
                    div = new Div();
                    div.setSclass("form-label-heading");
                    if (field.getAD_LabelStyle_ID() > 0) {
                        MStyle style = MStyle.get((Properties)Env.getCtx(), (int)field.getAD_LabelStyle_ID());
                        String cssStyle = style.buildStyle(ThemeManager.getTheme(), new Evaluatee(){

                            public String get_ValueAsString(String variableName) {
                                return field.get_ValueAsString(variableName);
                            }
                        });
                        if (cssStyle != null && cssStyle.startsWith("@sclass=")) {
                            String sclass = cssStyle.substring("@sclass=".length());
                            div.setSclass(sclass);
                        } else if (style != null && cssStyle.startsWith("@zclass=")) {
                            String zclass = cssStyle.substring("@zclass=".length());
                            div.setZclass(zclass);
                        } else {
                            div.setStyle(cssStyle);
                        }
                    }
                    row.appendCellChild(this.createSpacer());
                    div.appendChild((Component)label);
                    row.appendCellChild((Component)div);
                }
            }
            ++i;
        }
        if (numCols - actualxpos + 1 > 0) {
            row.appendCellChild(this.createSpacer(), numCols - actualxpos + 1);
        }
        if (this.currentTabGroupRows != null) {
            this.currentTabGroupRows.appendChild((Component)row);
        } else {
            row.setGroup(this.currentGroup);
            rows.appendChild((Component)row);
        }
        if (this.rowList != null) {
            this.rowList.add(row);
        }
        if (!update) {
            this.loadToolbarButtons();
        }
        if (!update && this.gridTab.isTreeTab() && this.treePanel != null) {
            int AD_Tree_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"AD_Tree_ID", (boolean)true);
            int AD_Tree_ID_Default = MTree.getDefaultAD_Tree_ID((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (String)this.gridTab.getKeyColumnName());
            if (AD_Tree_ID != 0) {
                this.treePanel.initTree(AD_Tree_ID, this.windowNo);
                Events.echoEvent((String)ON_DEFER_SET_SELECTED_NODE, (Component)this, null);
            } else if (AD_Tree_ID_Default != 0) {
                int linkColId = MTree.get((Properties)Env.getCtx(), (int)AD_Tree_ID_Default, null).getParent_Column_ID();
                String linkColName = null;
                int linkID = 0;
                if (linkColId > 0) {
                    linkColName = MColumn.getColumnName((Properties)Env.getCtx(), (int)linkColId);
                    linkID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.windowNo, (String)linkColName, (boolean)true);
                }
                this.treePanel.initTree(AD_Tree_ID_Default, this.windowNo, linkColName, linkID);
                Events.echoEvent((String)ON_DEFER_SET_SELECTED_NODE, (Component)this, null);
            }
        }
        if (!(update || this.gridTab.isSingleRow() || this.isGridView())) {
            this.switchRowPresentation();
        }
    }

    private WEditor findEditor(GridField field) {
        for (WEditor editor : this.editors) {
            if (editor.getGridField() != field) continue;
            return editor;
        }
        return null;
    }

    private void loadToolbarButtons() {
        int[] ids;
        MToolBarButton[] mToolbarButtons;
        MToolBarButton[] mToolBarButtonArray = mToolbarButtons = MToolBarButton.getProcessButtonOfTab((int)this.gridTab.getAD_Tab_ID(), null);
        int n = mToolbarButtons.length;
        int n2 = 0;
        while (n2 < n) {
            MToolBarButton mToolbarButton = mToolBarButtonArray[n2];
            Boolean access = MRole.getDefault().getProcessAccess(mToolbarButton.getAD_Process_ID());
            if (access != null && access.booleanValue()) {
                ToolbarProcessButton toolbarProcessButton = new ToolbarProcessButton(mToolbarButton, this, this.windowPanel, this.windowNo);
                this.toolbarProcessButtons.add(toolbarProcessButton);
            }
            ++n2;
        }
        if (this.toolbarProcessButtons.size() > 0 && (ids = MToolBarButtonRestrict.getProcessButtonOfTab((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx()), (int)this.gridTab.getAD_Tab_ID(), null)) != null && ids.length > 0) {
            int[] nArray = ids;
            int n3 = ids.length;
            n = 0;
            while (n < n3) {
                int id = nArray[n];
                X_AD_ToolBarButton tbt = new X_AD_ToolBarButton(Env.getCtx(), id, null);
                for (ToolbarProcessButton btn : this.toolbarProcessButtons) {
                    if (!tbt.getComponentName().equals(btn.getColumnName())) continue;
                    this.toolbarProcessButtons.remove(btn);
                    break;
                }
                ++n;
            }
        }
    }

    private Component createSpacer() {
        return new Space();
    }

    @Override
    public void dynamicDisplay(int col) {
        boolean noData;
        if (!this.gridTab.isOpen()) {
            return;
        }
        if (this.form.getSclass() != null && this.form.getSclass().contains(SLIDE_RIGHT_OUT_CSS)) {
            Executions.schedule((Desktop)this.getDesktop(), e -> {
                LayoutUtils.removeSclass(SLIDE_RIGHT_OUT_CSS, (HtmlBasedComponent)this.form);
                LayoutUtils.addSclass(SLIDE_RIGHT_IN_CSS, (HtmlBasedComponent)this.form);
                Executions.schedule((Desktop)this.getDesktop(), e1 -> this.onAfterSlide(e1), (Event)new Event("onAfterSlide", (Component)this.form));
            }, (Event)new Event("onAfterSlideRightOut", (Component)this.form));
        } else if (this.form.getSclass() != null && this.form.getSclass().contains(SLIDE_LEFT_OUT_CSS)) {
            Executions.schedule((Desktop)this.getDesktop(), e -> {
                LayoutUtils.removeSclass(SLIDE_LEFT_OUT_CSS, (HtmlBasedComponent)this.form);
                LayoutUtils.addSclass(SLIDE_LEFT_IN_CSS, (HtmlBasedComponent)this.form);
                Executions.schedule((Desktop)this.getDesktop(), e1 -> this.onAfterSlide(e1), (Event)new Event("onAfterSlide", (Component)this.form));
            }, (Event)new Event("onAfterSlideLeftOut", (Component)this.form));
        }
        ArrayList<Group> collapsedGroups = new ArrayList<Group>();
        for (Group group : this.allCollapsibleGroups) {
            if (group.isOpen()) continue;
            collapsedGroups.add(group);
        }
        if (col > 0) {
            GridField changedField = this.gridTab.getField(col);
            String columnName = changedField.getColumnName();
            ArrayList dependants = this.gridTab.getDependantFields(columnName);
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("(" + this.gridTab.toString() + ") " + columnName + " - Dependents=" + dependants.size());
            }
            if (dependants.size() <= 0 && changedField.getCallout().length() <= 0 && Core.findCallout((String)this.gridTab.getTableName(), (String)columnName).size() <= 0) {
                for (WEditor comp : this.editors) {
                    comp.updateStyle();
                }
                return;
            }
        }
        boolean bl = noData = this.gridTab.getRowCount() == 0;
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config(this.gridTab.toString() + " - Rows=" + this.gridTab.getRowCount());
        }
        for (WEditor comp : this.editors) {
            GridField mField = comp.getGridField();
            if (mField != null) {
                if (mField.isDisplayed(true)) {
                    if (!comp.isVisible()) {
                        comp.setVisible(true);
                    }
                    if (noData) {
                        comp.setReadWrite(false);
                    } else {
                        boolean rw = mField.isEditable(true);
                        if (rw && !comp.isReadWrite()) {
                            mField.refreshLookup();
                        }
                        comp.setReadWrite(rw);
                        comp.setMandatory(mField.isMandatory(true));
                        comp.dynamicDisplay();
                    }
                } else if (comp.isVisible()) {
                    comp.setVisible(false);
                }
            }
            comp.updateStyle();
        }
        List rows = this.form.getRows().getChildren();
        for (Component comp : rows) {
            if (!(comp instanceof Row)) continue;
            Row row = (Row)comp;
            boolean visible = false;
            boolean editorRow = false;
            for (Component component : row.getChildren()) {
                Component component2 = component.getFirstChild();
                if (!this.editorComps.contains(component2)) continue;
                editorRow = true;
                WEditor editor = this.editors.get(this.editorComps.indexOf(component2));
                if (editor != null && row.getGroup() != null && !row.getGroup().isOpen() && editor.isMandatoryStyle()) {
                    row.getGroup().setOpen(true);
                    if (collapsedGroups.contains((Object)row.getGroup())) {
                        collapsedGroups.remove((Object)row.getGroup());
                    }
                }
                if (!component2.isVisible()) continue;
                visible = true;
                break;
            }
            if (!editorRow || row.isVisible() == visible) continue;
            row.setAttribute("groupRowVisible", visible ? "true" : "false");
            row.setVisible(visible);
        }
        for (Grid tabForm : this.tabGroupForms) {
            List tabrows = tabForm.getRows().getChildren();
            for (Component comp : tabrows) {
                if (!(comp instanceof Row)) continue;
                Row row = (Row)comp;
                boolean visible = false;
                boolean editorRow = false;
                for (Component cellComponent : row.getChildren()) {
                    Component component = cellComponent.getFirstChild();
                    if (!this.editorComps.contains(component)) continue;
                    editorRow = true;
                    if (!component.isVisible()) continue;
                    visible = true;
                    break;
                }
                if (!editorRow || row.isVisible() == visible) continue;
                row.setVisible(visible);
            }
        }
        for (Map.Entry<String, List<org.zkoss.zul.Row>> entry : this.fieldGroupHeaders.entrySet()) {
            List<Row> contents = this.fieldGroupContents.get(entry.getKey());
            boolean visible = false;
            for (Row row : contents) {
                if (!row.isVisible()) continue;
                visible = true;
                break;
            }
            List<org.zkoss.zul.Row> headers = entry.getValue();
            for (org.zkoss.zul.Row row : headers) {
                if (row.isVisible() == visible) continue;
                row.setVisible(visible);
            }
        }
        Tab visibleTab = null;
        boolean isSelectedTabInvisible = false;
        for (Map.Entry<String, List<Tab>> entry : this.fieldGroupTabHeaders.entrySet()) {
            boolean bl2;
            List<Row> contents = this.fieldGroupContents.get(entry.getKey());
            boolean bl3 = false;
            for (Row row : contents) {
                if (!row.isVisible()) continue;
                bl2 = true;
                break;
            }
            List<Tab> tabs = entry.getValue();
            for (Tab tab : tabs) {
                if (tab.isVisible() != bl2) {
                    if (tab.isSelected() && !bl2) {
                        isSelectedTabInvisible = true;
                    }
                    tab.setVisible(bl2);
                }
                if (!tab.isVisible()) continue;
                visibleTab = tab;
            }
        }
        if (isSelectedTabInvisible && visibleTab != null) {
            this.tabbox.setSelectedTab(visibleTab);
        }
        for (Group group : collapsedGroups) {
            group.setOpen(false);
        }
        if (this.listPanel.isVisible()) {
            this.listPanel.dynamicDisplay(col);
        }
        for (ToolbarProcessButton btn : this.toolbarProcessButtons) {
            btn.dynamicDisplay();
            btn.readOnlyLogic();
            btn.pressedLogic();
        }
        Events.sendEvent((Component)this, (Event)new Event(ON_DYNAMIC_DISPLAY_EVENT, (Component)this));
        this.echoDeferSetSelectedNodeEvent();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config(this.gridTab.toString() + " - fini - " + (col <= 0 ? "complete" : "seletive"));
        }
    }

    private void onAfterSlide(Event e) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        LayoutUtils.removeSclass(SLIDE_LEFT_IN_CSS, (HtmlBasedComponent)this.form);
        LayoutUtils.removeSclass(SLIDE_RIGHT_IN_CSS, (HtmlBasedComponent)this.form);
    }

    private void echoDeferSetSelectedNodeEvent() {
        if (this.getAttribute(ON_DEFER_SET_SELECTED_NODE_ATTR) == null) {
            this.setAttribute(ON_DEFER_SET_SELECTED_NODE_ATTR, Boolean.TRUE);
            Events.echoEvent((String)ON_DEFER_SET_SELECTED_NODE, (Component)this, null);
        }
    }

    @Override
    public String getDisplayLogic() {
        return this.gridTab.getDisplayLogic();
    }

    @Override
    public String getTitle() {
        return this.gridTab.getName();
    }

    public String get_ValueAsString(String variableName) {
        return new DefaultEvaluatee(this.getGridTab(), this.windowNo, this.tabNo).get_ValueAsString(Env.getCtx(), variableName);
    }

    @Override
    public int getTabLevel() {
        return this.gridTab.getTabLevel();
    }

    @Override
    public String getTableName() {
        return this.gridTab.getTableName();
    }

    @Override
    public int getRecord_ID() {
        return this.gridTab.getRecord_ID();
    }

    @Override
    public boolean isCurrent() {
        return this.gridTab != null ? this.gridTab.isCurrent() : false;
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    @Override
    public void query() {
        boolean open = this.gridTab.isOpen();
        this.gridTab.query(false);
        if (this.listPanel.isVisible() && !open) {
            this.gridTab.getTableModel().fireTableDataChanged();
        }
    }

    @Override
    public void query(boolean onlyCurrentRows, int onlyCurrentDays, int maxRows) {
        boolean open = this.gridTab.isOpen();
        try {
            this.gridTab.query(onlyCurrentRows, onlyCurrentDays, maxRows);
            if (this.listPanel.isVisible() && !open) {
                this.gridTab.getTableModel().fireTableDataChanged();
            }
        }
        catch (Exception e) {
            if (DBException.isTimeout((Exception)e)) {
                throw e;
            }
            Dialog.error(this.windowNo, e.getMessage());
        }
    }

    @Override
    public void resetDetailForNewParentRecord() {
        boolean open = this.gridTab.isOpen();
        if (open) {
            this.gridTab.resetDetailForNewParentRecord();
        } else {
            this.gridTab.setCurrentRow(-1, true);
        }
    }

    @Override
    public GridTab getGridTab() {
        return this.gridTab;
    }

    @Override
    public ADTreePanel getTreePanel() {
        return this.treePanel;
    }

    public String getTreeDisplayedOn() {
        return this.gridTab.getTreeDisplayedOn();
    }

    @Override
    public void refresh() {
        this.gridTab.dataRefresh();
    }

    @Override
    public void activate(boolean activate) {
        if (activate) {
            if (this.getAttribute("org.adempiere.webui.adwindow.IADTabpanel.onActivatePosted") != null) {
                return;
            }
            this.setAttribute("org.adempiere.webui.adwindow.IADTabpanel.onActivatePosted", Boolean.TRUE);
        }
        this.activated = activate;
        if (this.listPanel.isVisible()) {
            if (activate) {
                this.listPanel.activate(this.gridTab);
            } else {
                this.listPanel.deactivate();
            }
        } else if (activate) {
            this.formContainer.setVisible(activate);
            if (!this.isMobile() && !this.isDetailPaneMode()) {
                this.focusToFirstEditor();
            }
        }
        if (this.gridTab.getRecord_ID() > 0 && this.gridTab.isTreeTab() && this.treePanel != null) {
            this.echoDeferSetSelectedNodeEvent();
        }
        Event event = new Event("onActivate", (Component)this, (Object)activate);
        Events.postEvent((Event)event);
    }

    @Override
    public void focusToFirstEditor() {
        this.focusToFirstEditor(false);
    }

    public void focusToFirstEditor(boolean checkCurrent) {
        WEditor toFocus = null;
        if (this.defaultFocusField != null && this.defaultFocusField.isVisible() && this.defaultFocusField.isReadWrite() && this.defaultFocusField.getComponent().getParent() != null && !(this.defaultFocusField instanceof WImageEditor)) {
            toFocus = this.defaultFocusField;
        } else {
            for (WEditor editor : this.editors) {
                if (!editor.isVisible() || !editor.isReadWrite() || editor.getComponent().getParent() == null || editor instanceof WImageEditor) continue;
                toFocus = editor;
                break;
            }
        }
        if (toFocus != null) {
            this.focusToEditor(toFocus, checkCurrent);
        }
    }

    public void onEvent(Event event) {
        if (event.getTarget() == this.listPanel.getListbox()) {
            Events.sendEvent((Component)this, (Event)new Event(ON_TOGGLE_EVENT, (Component)this));
        } else if (this.treePanel != null && event.getTarget() == this.treePanel.getTree()) {
            Treeitem item = this.treePanel.getTree().getSelectedItem();
            if (item != null && item.getValue() != null) {
                this.navigateTo((DefaultTreeNode<MTreeNode>)((DefaultTreeNode)item.getValue()));
            }
        } else if (ON_DEFER_SET_SELECTED_NODE.equals(event.getName())) {
            this.removeAttribute(ON_DEFER_SET_SELECTED_NODE_ATTR);
            this.setSelectedNode();
        } else if ("onSavePayment".equals(event.getName())) {
            this.windowPanel.onSavePayment();
        } else if (ON_POST_INIT_EVENT.equals(event.getName())) {
            if (this.isDetailVisible() && this.detailPane.getSelectedADTabpanel() != null) {
                this.detailPane.getSelectedADTabpanel().activate(true);
            }
        } else if (event.getTarget() instanceof South) {
            if (this.detailPane != null) {
                boolean openEvent = event instanceof OpenEvent;
                if (openEvent) {
                    OpenEvent oe = (OpenEvent)event;
                    this.onSouthEvent(oe.isOpen() ? SouthEvent.OPEN : SouthEvent.CLOSE);
                } else {
                    this.onSouthEvent(SouthEvent.SLIDE);
                }
            }
        } else if (event.getName().equals(ON_SAVE_OPEN_PREFERENCE_EVENT)) {
            Boolean value = (Boolean)event.getData();
            int windowId = this.getGridTab().getAD_Window_ID();
            int adTabId = this.getGridTab().getAD_Tab_ID();
            if (windowId > 0 && adTabId > 0) {
                Query query = new Query(Env.getCtx(), MTable.get((Properties)Env.getCtx(), (int)195), "AD_Window_ID=? AND Attribute=? AND AD_User_ID=? AND AD_Process_ID IS NULL AND PreferenceFor = 'W'", null);
                int userId = Env.getAD_User_ID((Properties)Env.getCtx());
                MPreference preference = (MPreference)query.setOnlyActiveRecords(true).setApplyAccessFilter(true).setClient_ID().setParameters(new Object[]{windowId, adTabId + "|DetailPane.IsOpen", userId}).first();
                if (preference == null || preference.getAD_Preference_ID() <= 0) {
                    preference = new MPreference(Env.getCtx(), 0, null);
                    preference.setAD_Window_ID(windowId);
                    preference.setAD_User_ID(userId);
                    preference.setAttribute(adTabId + "|DetailPane.IsOpen");
                }
                preference.setValue(value != false ? "Y" : "N");
                preference.saveEx();
                Env.getCtx().setProperty("P" + windowId + "|" + adTabId + "|DetailPane.IsOpen", value != false ? "Y" : "N");
            }
        }
    }

    public void setSelectedNode() {
        if (this.gridTab.getRecord_ID() >= 0 && this.gridTab.isTreeTab() && this.treePanel != null) {
            this.setSelectedNode(this.gridTab.getRecord_ID());
        }
    }

    private void onSouthEvent(SouthEvent event) {
        IADTabpanel tabPanel;
        if (event == SouthEvent.OPEN || event == SouthEvent.CLOSE) {
            boolean open = event == SouthEvent.OPEN;
            Events.echoEvent((String)ON_SAVE_OPEN_PREFERENCE_EVENT, (Component)this, (Object)open);
            if (!open) {
                return;
            }
        }
        if (this.detailPane.getParent() == null) {
            this.formContainer.appendSouth((Component)this.detailPane);
        }
        if ((tabPanel = this.detailPane.getSelectedADTabpanel()) != null) {
            if (!tabPanel.isActivated()) {
                tabPanel.activate(true);
            } else {
                tabPanel.getGridView().invalidateGridView();
            }
            if (!tabPanel.isGridView()) {
                if (this.detailPane.getSelectedPanel().isToggleToFormView()) {
                    this.detailPane.getSelectedPanel().afterToggle();
                } else {
                    tabPanel.switchRowPresentation();
                }
            }
        }
    }

    private boolean isOpenDetailPane() {
        String preference;
        if (this.isMobile()) {
            return false;
        }
        boolean open = true;
        int windowId = this.getGridTab().getAD_Window_ID();
        int adTabId = this.getGridTab().getAD_Tab_ID();
        if (windowId > 0 && adTabId > 0 && (preference = Env.getPreference((Properties)Env.getCtx(), (int)windowId, (String)(adTabId + "|DetailPane.IsOpen"), (boolean)false)) != null && preference.trim().length() > 0) {
            open = "Y".equals(preference);
        }
        return open;
    }

    private String heigthDetailPane() {
        String height = null;
        int windowId = this.getGridTab().getAD_Window_ID();
        int adTabId = this.getGridTab().getAD_Tab_ID();
        if (windowId > 0 && adTabId > 0) {
            height = Env.getPreference((Properties)Env.getCtx(), (int)windowId, (String)(adTabId + "|DetailPane.Height"), (boolean)false);
        }
        return height;
    }

    private String widthTreePanel() {
        String width = null;
        int windowId = this.getGridTab().getAD_Window_ID();
        int adTabId = this.getGridTab().getAD_Tab_ID();
        if (windowId > 0 && adTabId > 0) {
            width = Env.getPreference((Properties)Env.getCtx(), (int)windowId, (String)(adTabId + "|TreePanel.Width"), (boolean)false);
        }
        return Util.isEmpty(width) ? DEFAULT_PANEL_WIDTH : width;
    }

    private void navigateTo(DefaultTreeNode<MTreeNode> value) {
        MTreeNode treeNode = (MTreeNode)value.getData();
        int nodeID = treeNode.getNode_ID();
        int size = this.gridTab.getRowCount();
        int row = -1;
        int i = 0;
        while (i < size) {
            if (this.gridTab.getKeyID(i) == nodeID) {
                row = i;
                break;
            }
            ++i;
        }
        if (row == -1) {
            if (nodeID > 0 && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Tab does not have ID with Node_ID=" + nodeID);
            }
            if (this.gridTab.getCurrentRow() >= 0) {
                this.gridTab.setCurrentRow(this.gridTab.getCurrentRow(), true);
            }
            throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"RecordIsNotInCurrentSearch"));
        }
        this.windowPanel.onTreeNavigate(this.gridTab, row);
    }

    public void dataStatusChanged(DataStatusEvent e) {
        String msg;
        GridField mField;
        if (Executions.getCurrent() == null || e.isInitEdit()) {
            return;
        }
        int col = e.getChangedColumn();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("(" + String.valueOf(this.gridTab) + ") Col=" + col + ": " + e.toString());
        }
        if ((mField = this.gridTab.getField(col)) != null && (mField.getCallout().length() > 0 || Core.findCallout((String)this.gridTab.getTableName(), (String)mField.getColumnName()).size() > 0 || this.gridTab.hasDependants(mField.getColumnName())) && (msg = this.gridTab.processFieldChange(mField)).length() > 0) {
            Dialog.error(this.windowNo, msg);
        }
        if (!this.uiCreated) {
            this.createUI();
        }
        this.dynamicDisplay(col);
        if (this.treePanel != null) {
            if (this.getTreeDisplayedOn().equals("M")) {
                this.treePanel.getParent().setVisible(!this.isDetailPaneMode());
            } else if (this.getTreeDisplayedOn().equals("D")) {
                this.treePanel.getParent().setVisible(this.isDetailPaneMode());
            }
            if ("Deleted".equalsIgnoreCase(e.getAD_Message())) {
                if (e.Record_ID != null && e.Record_ID instanceof Integer && ((Integer)e.Record_ID).intValue() != this.gridTab.getRecord_ID()) {
                    this.deleteNode((Integer)e.Record_ID);
                } else {
                    this.setSelectedNode(this.gridTab.getRecord_ID());
                }
            } else if (!e.isInserting()) {
                DefaultTreeNode<Object> treeNode;
                boolean refresh = true;
                Treeitem item = this.treePanel.getTree().getSelectedItem();
                SimpleTreeModel model = (SimpleTreeModel)this.treePanel.getTree().getModel();
                if (item != null && item.getValue() != null && (treeNode = (DefaultTreeNode<Object>)((DefaultTreeNode)item.getValue()).getData()).getNode_ID() == this.gridTab.getRecord_ID()) {
                    this.setSelectedNode(this.gridTab.getRecord_ID());
                    refresh = false;
                }
                if ("Saved".equals(e.getAD_Message()) && model.find(null, this.gridTab.getRecord_ID()) != null && this.isTreeDrivenByValue()) {
                    model.removeNode(model.find(null, this.gridTab.getRecord_ID()));
                }
                if ("Saved".equals(e.getAD_Message()) && model.find(null, this.gridTab.getRecord_ID()) == null) {
                    this.addNewNode();
                    if (this.isTreeDrivenByValue()) {
                        this.treePanel.prepareForRefresh();
                    }
                }
                if ("Saved".equals(e.getAD_Message()) && model.find(null, this.gridTab.getRecord_ID()) != null && !this.isTreeDrivenByValue() && (treeNode = model.find(null, this.gridTab.getRecord_ID())) != null) {
                    MTreeNode data = (MTreeNode)treeNode.getData();
                    String label = (String)(this.isValueDisplayed() ? this.gridTab.getValue("Value").toString() + " - " : "") + this.gridTab.get_ValueAsString("Name");
                    if (!data.getName().equals(label)) {
                        data.setName(label);
                        treeNode.setData((Object)data);
                    }
                }
                if (refresh) {
                    int AD_Tree_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"AD_Tree_ID", (boolean)true);
                    if (AD_Tree_ID != 0) {
                        if (this.treePanel.initTree(AD_Tree_ID, this.windowNo)) {
                            this.echoDeferSetSelectedNodeEvent();
                        } else {
                            this.setSelectedNode(this.gridTab.getRecord_ID());
                        }
                    } else {
                        AD_Tree_ID = MTree.getDefaultAD_Tree_ID((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (String)this.gridTab.getKeyColumnName());
                        this.treePanel.prepareForRefresh();
                        int linkColId = MTree.get((Properties)Env.getCtx(), (int)AD_Tree_ID, null).getParent_Column_ID();
                        String linkColName = null;
                        int linkID = 0;
                        if (linkColId > 0) {
                            linkColName = MColumn.getColumnName((Properties)Env.getCtx(), (int)linkColId);
                            linkID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.windowNo, (String)linkColName, (boolean)true);
                        }
                        if (this.treePanel.initTree(AD_Tree_ID, this.windowNo, linkColName, linkID)) {
                            this.echoDeferSetSelectedNodeEvent();
                        } else {
                            this.setSelectedNode(this.gridTab.getRecord_ID());
                        }
                    }
                }
            } else if (e.isInserting() && this.gridTab.getRecord_ID() < 0 && this.gridTab.getTabLevel() > 0 && this.gridTab.getParentTab() != null && this.gridTab.getParentTab().getValue("AD_Tree_ID") != null) {
                int AD_Tree_ID = Integer.parseInt(this.gridTab.getParentTab().getValue("AD_Tree_ID").toString());
                this.treePanel.initTree(AD_Tree_ID, this.windowNo);
            }
        }
        if (this.listPanel.isVisible()) {
            this.listPanel.updateListIndex();
            this.listPanel.dynamicDisplay(col);
            if ("Refreshed".equals(e.getAD_Message()) || "Sorted".equals(e.getAD_Message())) {
                this.listPanel.invalidateGridView();
            }
        }
    }

    private void deleteNode(int recordId) {
        DefaultTreeNode treeNode;
        MTreeNode data;
        if (recordId <= 0) {
            return;
        }
        SimpleTreeModel model = (SimpleTreeModel)this.treePanel.getTree().getModel();
        if (this.treePanel.getTree().getSelectedItem() != null && (data = (MTreeNode)(treeNode = (DefaultTreeNode)this.treePanel.getTree().getSelectedItem().getValue()).getData()).getNode_ID() == recordId) {
            model.removeNode((DefaultTreeNode<Object>)treeNode);
            return;
        }
        treeNode = model.find(null, recordId);
        if (treeNode != null) {
            model.removeNode((DefaultTreeNode<Object>)treeNode);
        }
    }

    private void addNewNode() {
        if (this.gridTab.getRecord_ID() > 0) {
            Object name = (String)this.gridTab.getValue("Name");
            String description = (String)this.gridTab.getValue("Description");
            boolean summary = this.gridTab.getValueAsBoolean("IsSummary");
            String imageIndicator = (String)this.gridTab.getValue("Action");
            SimpleTreeModel model = (SimpleTreeModel)this.treePanel.getTree().getModel();
            DefaultTreeNode<Object> treeNode = model.getRoot();
            MTreeNode root = (MTreeNode)treeNode.getData();
            int parentID = root.getNode_ID();
            DefaultTreeNode<Object> parentNode = null;
            if (this.isTreeDrivenByValue()) {
                String value = this.gridTab.getValue("Value").toString();
                parentID = PO.retrieveIdOfParentValue((String)value, (String)this.getTableName(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()), null);
                parentNode = model.find(treeNode, parentID);
                if (this.isValueDisplayed()) {
                    name = value + " - " + (String)name;
                }
            }
            MTreeNode node = new MTreeNode(this.gridTab.getRecord_ID(), 0, (String)name, description, parentID, summary, imageIndicator, false, null);
            DefaultTreeNode newNode = new DefaultTreeNode((Object)node);
            if (this.isTreeDrivenByValue() && parentNode != null) {
                model.addNode(parentNode, (DefaultTreeNode<Object>)newNode, 0);
            } else {
                model.addNode((DefaultTreeNode<Object>)newNode);
            }
            int[] path = model.getPath((TreeNode)newNode);
            Treeitem ti = this.treePanel.getTree().renderItemByPath(path);
            this.treePanel.getTree().setSelectedItem(ti);
        }
    }

    private void setSelectedNode(int recordId) {
        DefaultTreeNode<Object> treeNode;
        if (recordId <= 0) {
            return;
        }
        if (TreeUtils.isOnInitRenderPosted(this.treePanel.getTree()) || this.treePanel.getTree().getTreechildren() == null || this.treePanel.getTree().getTreechildren().getItemCount() == 0) {
            this.treePanel.getTree().onInitRender();
        }
        SimpleTreeModel model = (SimpleTreeModel)this.treePanel.getTree().getModel();
        if (this.treePanel.getTree().getSelectedItem() != null) {
            Treeitem treeItem = this.treePanel.getTree().getSelectedItem();
            if (!treeItem.isLoaded()) {
                return;
            }
            DefaultTreeNode treeNode2 = (DefaultTreeNode)treeItem.getValue();
            MTreeNode data = (MTreeNode)treeNode2.getData();
            if (data.getNode_ID() == recordId) {
                String name;
                int[] path = model.getPath((TreeNode)treeNode2);
                Treeitem ti = this.treePanel.getTree().renderItemByPath(path);
                if (ti.getPage() == null) {
                    this.echoDeferSetSelectedNodeEvent();
                }
                boolean changed = false;
                if (this.isValueDisplayed()) {
                    String name2;
                    String value = (String)this.gridTab.getValue("Value");
                    String full = value + " - " + (name2 = (String)this.gridTab.getValue("Name"));
                    if (full != null && !full.equals(data.getName())) {
                        data.setName(full);
                        changed = true;
                    }
                } else if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Menu") && (name = (String)this.gridTab.getValue("Name")) != null && !name.equals(data.getName())) {
                    data.setName(name);
                    changed = true;
                }
                Object summaryobj = this.gridTab.getValue("IsSummary");
                boolean summary = false;
                if (summaryobj != null) {
                    summary = summaryobj instanceof Boolean ? ((Boolean)summaryobj).booleanValue() : "Y".equals(summaryobj.toString());
                }
                if (summary != data.isSummary()) {
                    data.setSummary(summary);
                    changed = true;
                }
                if (changed) {
                    treeNode2.setData((Object)data);
                }
                return;
            }
        }
        if ((treeNode = model.find(null, recordId)) != null) {
            int[] path = model.getPath((TreeNode)treeNode);
            Treeitem ti = this.treePanel.getTree().renderItemByPath(path);
            this.treePanel.getTree().selectItem(ti);
        } else {
            this.addNewNode();
        }
    }

    @Override
    public void switchRowPresentation() {
        if (this.form.isVisible()) {
            this.form.setVisible(false);
            ((HtmlBasedComponent)this.form.getParent()).setStyle("");
        } else {
            this.form.setVisible(true);
            ((HtmlBasedComponent)this.form.getParent()).setStyle("overflow-y: visible;");
        }
        this.setGroupTabboxVisibility();
        this.listPanel.setVisible(!this.form.isVisible());
        if (this.listPanel.isVisible()) {
            this.listPanel.refresh(this.gridTab);
            this.listPanel.scrollToCurrentRow();
            this.listPanel.invalidate();
        } else {
            this.listPanel.deactivate();
        }
        Events.sendEvent((Component)this, (Event)new Event(ON_SWITCH_VIEW_EVENT, (Component)this));
    }

    @Override
    public void afterSave(boolean onSaveEvent) {
    }

    public void focus() {
        if (this.form.isVisible() && !this.isMobile()) {
            this.focusToFirstEditor(true);
        } else {
            this.listPanel.focus();
        }
    }

    public void setFocusToField(String columnName) {
        if (this.formContainer.isVisible()) {
            for (WEditor editor : this.editors) {
                if (!columnName.equals(editor.getColumnName())) continue;
                Clients.response((AuResponse)new AuFocus(editor.getComponent()));
                break;
            }
        } else {
            this.listPanel.setFocusToField(columnName);
        }
    }

    @Override
    public boolean onEnterKey() {
        if (this.listPanel.isVisible()) {
            return this.listPanel.onEnterKey();
        }
        return false;
    }

    @Override
    public boolean isGridView() {
        return this.listPanel.isVisible();
    }

    @Override
    public GridView getGridView() {
        return this.listPanel;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public void setDetailPaneMode(boolean detailPaneMode) {
        if (this.detailPaneMode != detailPaneMode) {
            this.detailPaneMode = detailPaneMode;
            if (detailPaneMode) {
                this.detachDetailPane();
            } else {
                this.attachDetailPane();
            }
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this, "true");
            this.listPanel.setDetailPaneMode(detailPaneMode, this.gridTab);
        }
    }

    private void attachDetailPane() {
        if (this.formContainer.getSouth() != null) {
            this.formContainer.getSouth().setVisible(true);
            if (this.formContainer.getSouth().isOpen() && this.detailPane != null) {
                if (this.detailPane.getParent() != this.formContainer.getSouth()) {
                    this.formContainer.appendSouth((Component)this.detailPane);
                } else {
                    this.detailPane.setVisible(true);
                }
            }
        }
    }

    private void detachDetailPane() {
        if (this.formContainer.getSouth() != null) {
            this.formContainer.getSouth().setVisible(false);
            if (this.detailPane != null && this.detailPane.getParent() != null) {
                this.detailPane.setVisible(false);
            }
        }
    }

    @Override
    public List<Button> getToolbarButtons() {
        ArrayList<Button> buttonList = new ArrayList<Button>();
        for (WButtonEditor editor : this.toolbarButtonEditors) {
            if (editor.getComponent() == null || !editor.getComponent().isVisible()) continue;
            buttonList.add(editor.getComponent());
        }
        for (ToolbarProcessButton processButton : this.toolbarProcessButtons) {
            if (!processButton.getButton().isVisible()) continue;
            buttonList.add(processButton.getButton());
        }
        return buttonList;
    }

    @Override
    public boolean needSave(boolean rowChange, boolean onlyRealChange) {
        return this.getGridTab().needSave(rowChange, onlyRealChange);
    }

    @Override
    public boolean dataSave(boolean onSaveEvent) {
        return this.getGridTab().dataSave(onSaveEvent);
    }

    @Override
    public boolean isDetailPaneMode() {
        return this.detailPaneMode;
    }

    @Override
    public void setTabNo(int tabNo) {
        this.tabNo = tabNo;
    }

    @Override
    public int getTabNo() {
        return this.tabNo;
    }

    public void activateDetailIfVisible() {
        if (this.isDetailVisible()) {
            RowRenderer renderer;
            GridTabRowRenderer gtr;
            org.zkoss.zul.Row row;
            IADTabpanel tabPanel = this.detailPane.getSelectedADTabpanel();
            if (tabPanel != null && !tabPanel.isActivated()) {
                tabPanel.activate(true);
                if (!tabPanel.isGridView()) {
                    tabPanel.switchRowPresentation();
                }
            } else if (tabPanel != null && !tabPanel.getGridTab().isCurrent()) {
                tabPanel.activate(true);
            } else if (tabPanel != null && tabPanel.isGridView() && (row = (gtr = (GridTabRowRenderer)(renderer = tabPanel.getGridView().getListbox().getRowRenderer())).getCurrentRow()) != null) {
                gtr.setCurrentRow(row);
            }
        }
    }

    @Override
    public boolean isDetailVisible() {
        if (this.formContainer.getSouth() == null || !this.formContainer.getSouth().isVisible() || !this.formContainer.getSouth().isOpen()) {
            return false;
        }
        return this.detailPane != null;
    }

    public boolean hasDetailTabs() {
        if (this.formContainer.getSouth() == null || !this.formContainer.getSouth().isVisible()) {
            return false;
        }
        return this.detailPane != null && this.detailPane.getTabcount() > 0;
    }

    @Override
    public void focusToNextEditor(WEditor ref) {
        boolean found = false;
        for (WEditor editor : this.editors) {
            if (editor == ref) {
                found = true;
                continue;
            }
            if (!found || !editor.isVisible() || !editor.isReadWrite() || editor instanceof WButtonEditor) continue;
            this.focusToEditor(editor, false);
            break;
        }
    }

    protected void focusToEditor(WEditor toFocus, boolean checkCurrent) {
        Object c = toFocus.getComponent();
        if (c instanceof EditorBox) {
            c = ((EditorBox)((Object)c)).getTextbox();
        } else if (c instanceof NumberBox) {
            c = ((NumberBox)((Object)c)).getDecimalbox();
        } else if (c instanceof Urlbox) {
            c = ((Urlbox)((Object)c)).getTextbox();
        }
        if (!checkCurrent) {
            ((HtmlBasedComponent)c).focus();
        } else {
            StringBuilder script = new StringBuilder("(function(){let b=true;try{if (zk.currentFocus) {");
            script.append("let p=zk.Widget.$('#").append(this.formContainer.getCenter().getUuid()).append("');");
            script.append("if (zUtl.isAncestor(p, zk.currentFocus)) {");
            script.append("b=false;}}}catch(error){}");
            script.append("if(b){let w=zk.Widget.$('#").append(c.getUuid()).append("');w.focus(0);}");
            script.append("})()");
            Clients.response((AuResponse)new AuScript(script.toString()));
        }
    }

    public void setParent(Component parent) {
        super.setParent(parent);
        if (parent != null) {
            this.listPanel.onADTabPanelParentChanged();
            if (ClientInfo.isMobile()) {
                this.setupFormSwipeListener();
            }
        }
    }

    private boolean isTreeDrivenByValue() {
        SimpleTreeModel model = (SimpleTreeModel)this.treePanel.getTree().getModel();
        boolean retValue = false;
        retValue = model.isTreeDrivenByValue();
        return retValue;
    }

    private boolean isValueDisplayed() {
        SimpleTreeModel model = (SimpleTreeModel)this.treePanel.getTree().getModel();
        boolean retValue = false;
        retValue = model.isValueDisplayed();
        return retValue;
    }

    public void onPageDetached(Page page) {
        String width;
        String height;
        if (this.formContainer.getSouth() != null && this.formContainer.getSouth().isVisible() && this.formContainer.getSouth().isOpen() && !Util.isEmpty((String)(height = this.formContainer.getSouth().getHeight()))) {
            this.savePreference("DetailPane.Height", height);
        }
        if (this.treePanel != null && this.formContainer.getWest() != null && this.formContainer.getWest().isVisible() && this.formContainer.getWest().isOpen() && !Util.isEmpty((String)(width = this.formContainer.getWest().getWidth()))) {
            this.savePreference("TreePanel.Width", width);
        }
        for (WEditor editor : this.editors) {
            editor.getComponent().setWidgetListener("onFocus", null);
        }
        super.onPageDetached(page);
    }

    protected void savePreference(String attribute, String value) {
        int windowId = this.getGridTab().getAD_Window_ID();
        int adTabId = this.getGridTab().getAD_Tab_ID();
        if (windowId > 0 && adTabId > 0) {
            Query query = new Query(Env.getCtx(), MTable.get((Properties)Env.getCtx(), (int)195), "AD_Window_ID=? AND Attribute=? AND AD_User_ID=? AND AD_Process_ID IS NULL AND PreferenceFor = 'W'", null);
            int userId = Env.getAD_User_ID((Properties)Env.getCtx());
            MPreference preference = (MPreference)query.setOnlyActiveRecords(true).setApplyAccessFilter(true).setClient_ID().setParameters(new Object[]{windowId, adTabId + "|" + attribute, userId}).first();
            if (preference == null || preference.getAD_Preference_ID() <= 0) {
                preference = new MPreference(Env.getCtx(), 0, null);
                preference.setAD_Window_ID(windowId);
                preference.setAD_User_ID(userId);
                preference.setAttribute(adTabId + "|" + attribute);
            }
            preference.setValue(value);
            preference.saveEx();
            Env.getCtx().setProperty("P" + windowId + "|" + adTabId + "|" + attribute, value);
        }
    }

    protected void onClientInfo() {
        if (!this.uiCreated || this.gridTab == null) {
            return;
        }
        int numCols = this.gridTab.getNumColumns();
        if (numCols <= 0) {
            numCols = 6;
        }
        if (ClientInfo.maxWidth(499)) {
            if (numCols > 3) {
                numCols = 3;
            }
        } else if (ClientInfo.maxWidth(999) && numCols > 6) {
            numCols = 6;
        }
        if (numCols > 0 && numCols != this.numberOfFormColumns) {
            this.createUI(true);
            this.dynamicDisplay(0);
        }
    }

    protected boolean isMobile() {
        return ClientInfo.isMobile();
    }

    @Override
    public void editorTraverse(Callback<WEditor> editorTaverseCallback) {
        this.editorTraverse(editorTaverseCallback, this.editors);
    }

    @Override
    public boolean isEnableQuickFormButton() {
        boolean hasQuickForm = false;
        int tabID = this.getGridTab().getAD_Tab_ID();
        if (quickFormCache.containsKey((Object)tabID)) {
            hasQuickForm = (Boolean)quickFormCache.get((Object)tabID);
        } else if (this.getGridTab() != null) {
            GridField[] gridFieldArray = this.getGridTab().getFields();
            int n = gridFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                GridField field = gridFieldArray[n2];
                if (field.isQuickForm()) {
                    hasQuickForm = true;
                    break;
                }
                ++n2;
            }
            quickFormCache.put((Object)tabID, (Object)hasQuickForm);
        }
        return hasQuickForm;
    }

    private void setGroupTabboxVisibility() {
        boolean isGroupTabVisible = false;
        if (this.tabbox.getChildren() != null && this.tabbox.getChildren().size() > 0) {
            isGroupTabVisible = this.form.isVisible();
        }
        this.tabbox.setVisible(isGroupTabVisible);
    }

    @Override
    public boolean isEnableCustomizeButton() {
        return this.isGridView();
    }

    @Override
    public void updateToolbar(ADWindowToolbar toolbar) {
    }

    @Override
    public void updateDetailToolbar(Toolbar toolbar) {
    }

    public AbstractADWindowContent getADWindowContent() {
        return this.windowPanel;
    }

    private static enum SouthEvent {
        SLIDE,
        OPEN,
        CLOSE;

    }

    static class ZoomListener
    implements EventListener<Event> {
        private IZoomableEditor zoomableEditor;

        ZoomListener(IZoomableEditor editor) {
            this.zoomableEditor = editor;
        }

        public void onEvent(Event event) throws Exception {
            if ("onClick".equals(event.getName())) {
                this.zoomableEditor.actionZoom();
            }
        }
    }
}

