/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_MS
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", "Ribu, ", "Juta, ", "Bilion, ", "Trilion, ", "Quadrillion, ", "Quintillion, "};
    private static final String[] tensNames = new String[]{"", "Sepuluh ", "Dua Puluh ", "Tiga Puluh ", "Empat Puluh ", "Lima Puluh ", "Enam Puluh ", "Tujuh Puluh ", "Lapan Puluh ", "Sembilan Puluh "};
    private static final String[] numNames = new String[]{"", "Satu ", "Dua ", "Tiga ", "Empat ", "Lima ", "Enam ", "Tujuh ", "Lapan ", "Sembilan ", "Sepuluh ", "Sebelas", "Dua Belas ", "Tiga Belas ", "Empat Belas ", "Lima Belas ", "Enam Belas ", "Tujuh Belas ", "Lapan Belas ", "Sembilan Belas "};

    private String convertLessThanOneThousand(int number) {
        Object soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + (String)soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return numNames[number] + "Ratus " + (String)soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "Kosong";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "Negatif ";
        }
        Object soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                soFar = s + majorNames[place] + (String)soFar;
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + (String)soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("RINGGIT ");
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        int newpos = amount.lastIndexOf(46);
        long dollars = Long.parseLong(amount.substring(0, newpos));
        sb.append(this.convert(dollars));
        int i2 = 0;
        while (i2 < oldamt.length()) {
            if (pos == i2) {
                String cents = oldamt.substring(i2 + 1);
                long sen = Long.parseLong(cents);
                sb.append(" dan SEN");
                sb.append(' ').append(this.convert(sen));
                break;
            }
            ++i2;
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_MS aiw = new AmtInWords_MS();
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("12.34");
        aiw.print("123.45");
        aiw.print("1,234.56");
        aiw.print("12,345.78");
        aiw.print("123,457.89");
        aiw.print("1,234,578.90");
        aiw.print("100.00");
    }
}

