/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProductPO;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Process
public class ProjectGenPO
extends SvrProcess {
    private int m_C_Project_ID = 0;
    private int m_C_ProjectPhase_ID = 0;
    private int m_C_ProjectLine_ID = 0;
    private boolean m_ConsolidateDocument = true;
    private ArrayList<MOrder> m_pos = new ArrayList();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Project_ID")) {
                    this.m_C_Project_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_ProjectPhase_ID")) {
                    this.m_C_ProjectPhase_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_ProjectLine_ID")) {
                    this.m_C_ProjectLine_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("ConsolidateDocument")) {
                    this.m_ConsolidateDocument = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - C_Project_ID=" + this.m_C_Project_ID + " - C_ProjectLine_ID=" + this.m_C_ProjectLine_ID + " - Consolidate=" + this.m_ConsolidateDocument);
        }
        if (this.m_C_ProjectLine_ID != 0) {
            MProjectLine projectLine = new MProjectLine(this.getCtx(), this.m_C_ProjectLine_ID, this.get_TrxName());
            MProject project = new MProject(this.getCtx(), projectLine.getC_Project_ID(), this.get_TrxName());
            this.createPO(project, projectLine);
        } else if (this.m_C_ProjectPhase_ID != 0) {
            MProject project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
            MProjectLine[] mProjectLineArray = project.getPhaseLines(this.m_C_ProjectPhase_ID);
            int n = mProjectLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                MProjectLine line = mProjectLineArray[n2];
                if (line.isActive()) {
                    this.createPO(project, line);
                }
                ++n2;
            }
        } else {
            MProject project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
            MProjectLine[] mProjectLineArray = project.getLines();
            int n = mProjectLineArray.length;
            int n3 = 0;
            while (n3 < n) {
                MProjectLine line = mProjectLineArray[n3];
                if (line.isActive()) {
                    this.createPO(project, line);
                }
                ++n3;
            }
        }
        return "";
    }

    private void createPO(MProject project, MProjectLine projectLine) {
        if (projectLine.getM_Product_ID() == 0) {
            this.addLog(projectLine.getLine(), null, null, "Line has no Product");
            return;
        }
        if (projectLine.getC_OrderPO_ID() != 0) {
            this.addLog(projectLine.getLine(), null, null, "Line was ordered previously");
            return;
        }
        MProductPO[] pos = MProductPO.getOfProduct((Properties)this.getCtx(), (int)projectLine.getM_Product_ID(), (String)this.get_TrxName());
        if (pos == null || pos.length == 0) {
            this.addLog(projectLine.getLine(), null, null, "Product has no PO record");
            return;
        }
        MOrder order = null;
        int i = 0;
        while (i < this.m_pos.size()) {
            MOrder test = this.m_pos.get(i);
            if (test.getC_BPartner_ID() == pos[0].getC_BPartner_ID()) {
                order = test;
                break;
            }
            ++i;
        }
        if (order == null) {
            MBPartner bp = new MBPartner(this.getCtx(), pos[0].getC_BPartner_ID(), this.get_TrxName());
            order = new MOrder(project, false, null);
            int AD_Org_ID = projectLine.getAD_Org_ID();
            if (AD_Org_ID == 0) {
                this.log.warning("createPOfromProjectLine - AD_Org_ID=0");
                AD_Org_ID = Env.getAD_Org_ID((Properties)this.getCtx());
                if (AD_Org_ID != 0) {
                    projectLine.setAD_Org_ID(AD_Org_ID);
                }
            }
            order.setClientOrg(projectLine.getAD_Client_ID(), AD_Org_ID);
            order.setBPartner(bp);
            order.saveEx();
            if (this.m_ConsolidateDocument) {
                this.m_pos.add(order);
            }
        }
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setM_Product_ID(projectLine.getM_Product_ID(), true);
        orderLine.setQty(projectLine.getPlannedQty());
        orderLine.setDescription(projectLine.getDescription());
        orderLine.setPrice();
        if (orderLine.getPriceActual().signum() == 0) {
            BigDecimal poPrice = pos[0].getPricePO();
            int C_Currency_ID = pos[0].getC_Currency_ID();
            if (poPrice == null || poPrice.signum() == 0) {
                poPrice = pos[0].getPriceLastPO();
            }
            if (poPrice == null || poPrice.signum() == 0) {
                poPrice = pos[0].getPriceList();
            }
            if (poPrice != null && poPrice.signum() != 0) {
                if (order.getC_Currency_ID() != C_Currency_ID) {
                    poPrice = MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)poPrice, (int)C_Currency_ID, (int)order.getC_Currency_ID(), (Timestamp)order.getDateAcct(), (int)order.getC_ConversionType_ID(), (int)order.getAD_Client_ID(), (int)order.getAD_Org_ID());
                }
                orderLine.setPrice(poPrice);
            }
        }
        orderLine.setTax();
        orderLine.saveEx();
        projectLine.setC_OrderPO_ID(order.getC_Order_ID());
        projectLine.saveEx();
        this.addBufferLog(order.getC_Order_ID(), order.getDateOrdered(), new BigDecimal(orderLine.getLine()), Msg.getElement((String)Env.getAD_Language((Properties)Env.getCtx()), (String)"C_Order_ID", (boolean)false) + ":" + order.getDocumentNo(), order.get_Table_ID(), order.getC_Order_ID());
    }
}

