/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.xhtml;

import java.util.Enumeration;
import org.apache.ecs.Element;
import org.apache.ecs.HtmlColor;
import org.apache.ecs.KeyEvents;
import org.apache.ecs.MouseEvents;
import org.apache.ecs.MultiPartElement;
import org.apache.ecs.Printable;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.img;

public class td
extends MultiPartElement
implements Printable,
MouseEvents,
KeyEvents {
    private static final long serialVersionUID = 2600951455950300475L;

    public td() {
        this.setElementType("td");
        this.setCase(2);
        this.setAttributeQuote(true);
    }

    public td(String className, String hAlign, String vAlign, boolean nowrap) {
        this();
        if (className != null) {
            this.setClass(className);
        }
        if (hAlign != null) {
            this.setAlign(hAlign);
        }
        if (vAlign != null) {
            this.setVAlign(vAlign);
        }
        this.setNoWrap(nowrap);
    }

    public td(String className, String hAlign, String vAlign, boolean nowrap, Element value) {
        this(className, hAlign, vAlign, nowrap);
        if (value == null) {
            this.addElement("&nbsp;");
        } else {
            this.addElement(value);
        }
    }

    public td(Element value) {
        this.setElementType("td");
        this.setCase(2);
        this.setAttributeQuote(true);
        this.addElement(value);
    }

    public td(String value) {
        this.setElementType("td");
        this.setCase(2);
        this.setAttributeQuote(true);
        this.addElement(value);
    }

    public td setAbbr(String cdata) {
        this.addAttribute("abbr", cdata);
        return this;
    }

    public td setAxis(String cdata) {
        this.addAttribute("axis", cdata);
        return this;
    }

    public td setAxes(String id_refs) {
        this.addAttribute("axes", id_refs);
        return this;
    }

    public td setRowSpan(int rowspan) {
        this.addAttribute("rowspan", Integer.toString(rowspan));
        return this;
    }

    public td setRowSpan(String rowspan) {
        this.addAttribute("rowspan", rowspan);
        return this;
    }

    public td setColSpan(int colspan) {
        this.addAttribute("colspan", Integer.toString(colspan));
        return this;
    }

    public td setColSpan(String colspan) {
        this.addAttribute("colspan", colspan);
        return this;
    }

    public td setNoWrap(boolean wrap) {
        if (wrap) {
            this.addAttribute("nowrap", "nowrap");
        } else {
            this.removeAttribute("nowrap");
        }
        return this;
    }

    public td setWidth(int width) {
        this.addAttribute("width", Integer.toString(width));
        return this;
    }

    public td setWidth(String width) {
        this.addAttribute("width", width);
        return this;
    }

    public td setHeight(int height) {
        this.addAttribute("height", Integer.toString(height));
        return this;
    }

    public td setHeight(String height) {
        this.addAttribute("height", height);
        return this;
    }

    public td setAlign(String hAlign) {
        if (!(hAlign == null || hAlign.equals("left") || hAlign.equals("center") || hAlign.equals("right"))) {
            throw new IllegalArgumentException(hAlign + " - Illegal for Horizontal Align(left,center,right)");
        }
        this.addAttribute("align", hAlign);
        return this;
    }

    public td setVAlign(String vAlign) {
        if (!(vAlign == null || vAlign.equals("top") || vAlign.equals("middle") || vAlign.equals("absmiddle") || vAlign.equals("bottom") || vAlign.equals("absbottom") || vAlign.equals("baseline"))) {
            throw new IllegalArgumentException(vAlign + " - Illegal for Vertical Align(top,middle,bottom..)");
        }
        this.addAttribute("valign", vAlign);
        return this;
    }

    public td setChar(String character) {
        this.addAttribute("char", character);
        return this;
    }

    public td setCharOff(int char_off) {
        this.addAttribute("charoff", Integer.toString(char_off));
        return this;
    }

    public td setCharOff(String char_off) {
        this.addAttribute("charoff", char_off);
        return this;
    }

    public td setBgColor(String color) {
        this.addAttribute("bgcolor", HtmlColor.convertColor(color));
        return this;
    }

    @Override
    public Element setLang(String lang) {
        this.addAttribute("lang", lang);
        this.addAttribute("xml:lang", lang);
        return this;
    }

    public td addElement(String hashcode, Element element) {
        this.addElementToRegistry(hashcode, element);
        return this;
    }

    public td addElement(String hashcode, String element) {
        this.addElementToRegistry(hashcode, element);
        return this;
    }

    public td addElement(Element element) {
        this.addElementToRegistry(element);
        return this;
    }

    public td addElement(String element) {
        this.addElementToRegistry(element);
        return this;
    }

    public td removeElement(String hashcode) {
        this.removeElementFromRegistry(hashcode);
        return this;
    }

    @Override
    public void setOnClick(String script2) {
        this.addAttribute("onclick", script2);
    }

    @Override
    public void setOnDblClick(String script2) {
        this.addAttribute("ondblclick", script2);
    }

    @Override
    public void setOnMouseDown(String script2) {
        this.addAttribute("onmousedown", script2);
    }

    @Override
    public void setOnMouseUp(String script2) {
        this.addAttribute("onmouseup", script2);
    }

    @Override
    public void setOnMouseOver(String script2) {
        this.addAttribute("onmouseover", script2);
    }

    @Override
    public void setOnMouseMove(String script2) {
        this.addAttribute("onmousemove", script2);
    }

    @Override
    public void setOnMouseOut(String script2) {
        this.addAttribute("onmouseout", script2);
    }

    @Override
    public void setOnKeyPress(String script2) {
        this.addAttribute("onkeypress", script2);
    }

    @Override
    public void setOnKeyDown(String script2) {
        this.addAttribute("onkeydown", script2);
    }

    @Override
    public void setOnKeyUp(String script2) {
        this.addAttribute("onkeyup", script2);
    }

    @Override
    public boolean getNeedLineBreak() {
        Enumeration<Element> en = this.elements();
        int i2 = 0;
        int j = 0;
        while (en.hasMoreElements()) {
            ++j;
            Element obj = en.nextElement();
            if (!(obj instanceof img) && !(obj instanceof a)) continue;
            ++i2;
        }
        return i2 != j;
    }
}

