/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.JFrame;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.compiere.Adempiere;
import org.compiere.install.KeyStoreDialog;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;

public class KeyStoreMgt {
    private static final CLogger log = CLogger.getCLogger(KeyStoreMgt.class);
    private File m_file = null;
    private char[] m_password = null;
    private KeyStore m_keyStore = null;
    private String organizationUnit;
    private String location;
    private String state;
    private String country;
    private String commonName;
    private String organization;
    public static String KEYSTORE_DIRECTORY = "jettyhome/etc";
    public static String KEYSTORE_NAME = "keystore";

    public KeyStoreMgt(String fileName, char[] password) {
        log.info(fileName);
        this.m_file = new File(fileName);
        this.m_password = password;
    }

    public String verify(JFrame parent, String alias) {
        KeyStore ks = null;
        try {
            ks = this.getKeyStore();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "get KeyStore", (Throwable)e);
            return e.getMessage();
        }
        if (ks == null) {
            this.createCertificate(alias, parent);
            try {
                ks = this.getKeyStore();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "new KeyStore", (Throwable)e);
                return e.getMessage();
            }
        }
        if (ks == null) {
            return "No Key Store";
        }
        Certificate cert = null;
        try {
            cert = this.getCertificate(alias);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "certificate", (Throwable)e);
            return e.getMessage();
        }
        if (cert == null) {
            return "No Certificate found";
        }
        return null;
    }

    public KeyStore getKeyStore() throws Exception {
        try {
            this.m_keyStore = KeyStore.getInstance("JKS");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Instance", (Throwable)e);
        }
        if (this.m_file.exists()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.m_file.toString());
            }
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(this.m_file);
                    this.m_keyStore.load(is, this.m_password);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "load", (Throwable)e);
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Exception exception) {}
                        is = null;
                    }
                    return null;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception exception) {}
                    is = null;
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
                Object var1_2 = null;
            }
        } else {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Provider=" + String.valueOf(this.m_keyStore.getProvider()) + " - Type=" + this.m_keyStore.getType());
        }
        return this.m_keyStore;
    }

    public Certificate getCertificate(String alias) throws Exception {
        Date date;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Alias=" + alias);
        }
        if ((date = this.m_keyStore.getCreationDate(alias)) == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created=" + String.valueOf(date));
        }
        Key key = this.m_keyStore.getKey(alias, this.m_password);
        if (CLogMgt.isLevelFinest()) {
            log.info("Key=" + String.valueOf(key));
        } else if (log.isLoggable(Level.FINE)) {
            log.fine(key.getAlgorithm());
        }
        Certificate cert = this.m_keyStore.getCertificate(alias);
        if (CLogMgt.isLevelFinest()) {
            log.info("Certificate = " + String.valueOf(cert));
        } else if (log.isLoggable(Level.FINE)) {
            log.fine(cert.getType());
        }
        return cert;
    }

    private void createCertificate(String alias, JFrame parent) {
        String dname;
        log.info("");
        try {
            File dir = this.m_file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "directory", (Throwable)e);
        }
        if ((dname = KeyStoreMgt.getDname(this, parent)) == null) {
            return;
        }
        try {
            KeyStoreMgt.selfcert(alias, this.m_password, this.m_file.getAbsolutePath(), dname);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "certificate", (Throwable)e);
        }
    }

    public void setCommonName(String cn) {
        this.commonName = cn;
    }

    public void setOrganization(String o) {
        this.organization = o;
    }

    public void setOrganizationUnit(String o) {
        this.organizationUnit = o;
    }

    public void setLocation(String l) {
        this.location = l;
    }

    public void setState(String s) {
        this.state = s;
    }

    public void setCountry(String c) {
        this.country = c;
    }

    public static String getDname(KeyStoreMgt mgt, JFrame parent) {
        String c;
        String cn = mgt.commonName;
        if (cn == null) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                cn = address.getCanonicalHostName();
            }
            catch (Exception exception) {}
        }
        String ou = mgt.organization != null ? mgt.organization : System.getProperty("user.name");
        String o = mgt.organizationUnit != null ? mgt.organizationUnit : "iDempiereUser";
        String l = mgt.location != null ? mgt.location : "MyTown";
        String s = mgt.state != null ? mgt.state : "";
        String string = c = mgt.country != null ? mgt.country : System.getProperty("user.country");
        if (parent != null) {
            KeyStoreDialog skd = new KeyStoreDialog(parent, cn, ou, o, l, s, c);
            if (!skd.isOK()) {
                return null;
            }
            cn = skd.getCN();
            ou = skd.getOU();
            o = skd.getO();
            l = skd.getL();
            s = skd.getS();
            c = skd.getC();
        }
        if (cn == null || cn.length() == 0) {
            log.warning("No Common Name (CN)");
            return null;
        }
        if (ou == null || ou.length() == 0) {
            log.warning("No Organization Unit (OU)");
            return null;
        }
        if (o == null || o.length() == 0) {
            log.warning("No Organization (O)");
            return null;
        }
        if (c == null || c.length() == 0) {
            log.warning("No Country (C)");
            return null;
        }
        StringBuilder dname = new StringBuilder();
        dname.append("CN=").append(KeyStoreMgt.escapeCommas(cn));
        dname.append(", OU=").append(KeyStoreMgt.escapeCommas(ou));
        dname.append(", O=").append(KeyStoreMgt.escapeCommas(o));
        if (l != null && l.length() > 0) {
            dname.append(", L=").append(KeyStoreMgt.escapeCommas(l));
        }
        if (s != null && s.length() > 0) {
            dname.append(", ST=").append(KeyStoreMgt.escapeCommas(s));
        }
        dname.append(", C=").append(KeyStoreMgt.escapeCommas(c));
        return dname.toString();
    }

    public static String escapeCommas(String in) {
        if (in == null || in.indexOf(44) == -1) {
            return in;
        }
        StringBuilder out = new StringBuilder();
        char[] chars = in.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == ',') {
                out.append('\\').append(',');
            } else {
                out.append(chars[i]);
            }
            ++i;
        }
        return out.toString();
    }

    public static void selfcert(String alias, char[] password, String fileName, String dname) {
        try {
            File storeFile = new File(fileName);
            if (storeFile.exists()) {
                return;
            }
            CertificateKeyPair certKeyPair = KeyStoreMgt.createCertificate(dname);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(password);
            KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(certKeyPair.keyPair.getPrivate(), new Certificate[]{certKeyPair.cert});
            keyStore.setEntry(alias, entry, protParam);
            Throwable throwable = null;
            Object var10_12 = null;
            try (OutputStream fos = Files.newOutputStream(storeFile.toPath(), new OpenOption[0]);){
                keyStore.store(fos, password);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static CertificateKeyPair createCertificate(String dname) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048, new SecureRandom());
        KeyPair certKeyPair = keyGen.generateKeyPair();
        X500Name dnName = new X500Name(dname);
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        Instant validFrom = Instant.now();
        Instant validUntil = validFrom.plus(999L, ChronoUnit.DAYS);
        X500Name issuerName = dnName;
        PrivateKey issuerKey = certKeyPair.getPrivate();
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuerName, serialNumber, Date.from(validFrom), Date.from(validUntil), dnName, certKeyPair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSA").build(issuerKey);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certHolder);
        return new CertificateKeyPair(certKeyPair, cert);
    }

    public static String getKeystoreFileName(String baseDir) {
        Object fileName = baseDir;
        if (fileName == null) {
            fileName = "";
        } else if (!((String)fileName).endsWith(File.separator)) {
            fileName = (String)fileName + File.separator;
        }
        fileName = (String)fileName + KEYSTORE_DIRECTORY + File.separator + KEYSTORE_NAME;
        return fileName;
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment((boolean)true);
        System.out.println(new KeyStoreMgt("C:/Adempiere/keystore/myKeystore2", "myPassword".toCharArray()).verify(null, "idempiere"));
    }

    private static class CertificateKeyPair {
        private KeyPair keyPair;
        private X509Certificate cert;

        private CertificateKeyPair(KeyPair keyPair, X509Certificate cert) {
            this.keyPair = keyPair;
            this.cert = cert;
        }
    }
}

