/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

@Process
public class ImportReportLine
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_PA_ReportLineSet_ID = 0;
    private boolean m_deleteOldImported = false;
    private Timestamp m_DateValue = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("PA_ReportLineSet_ID")) {
                    this.m_PA_ReportLineSet_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DeleteOldImported")) {
                    this.m_deleteOldImported = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        int noUpdateSource;
        int noInsertSource;
        int noUpdateLine;
        int noInsertLine;
        StringBuilder clientCheck;
        int no;
        StringBuilder sql;
        block56: {
            ResultSet rs;
            CPreparedStatement pstmt;
            block52: {
                sql = null;
                no = 0;
                clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
                if (this.m_deleteOldImported) {
                    sql = new StringBuilder("DELETE FROM I_ReportLine ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
                    no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Delete Old Impored =" + no);
                    }
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("),").append(" AD_Org_ID = COALESCE (AD_Org_ID, 0),").append(" IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, getDate()),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, getDate()),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" I_ErrorMsg = ' ',").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Reset=" + no);
                }
                if (this.m_PA_ReportLineSet_ID != 0) {
                    sql = new StringBuilder("UPDATE I_ReportLine i ").append("SET ReportLineSetName=(SELECT Name FROM PA_ReportLineSet r").append(" WHERE PA_ReportLineSet_ID=").append(this.m_PA_ReportLineSet_ID).append(" AND i.AD_Client_ID=r.AD_Client_ID) ").append("WHERE ReportLineSetName IS NULL AND PA_ReportLineSet_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                    no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Set ReportLineSetName Default=" + no);
                    }
                }
                sql = new StringBuilder("UPDATE I_ReportLine i ").append("SET PA_ReportLineSet_ID=(SELECT PA_ReportLineSet_ID FROM PA_ReportLineSet r").append(" WHERE i.ReportLineSetName=r.Name AND i.AD_Client_ID=r.AD_Client_ID) ").append("WHERE PA_ReportLineSet_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set PA_ReportLineSet_ID=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid ReportLineSet, ' ").append("WHERE PA_ReportLineSet_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Invalid ReportLineSet=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Ignored=NoLineName, ' ").append("WHERE PA_ReportLine_ID IS NULL AND Name IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Invalid LineName=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine i ").append("SET C_ElementValue_ID=(SELECT C_ElementValue_ID FROM C_ElementValue e").append(" WHERE i.ElementValue=e.Value AND i.AD_Client_ID=e.AD_Client_ID) ").append("WHERE C_ElementValue_ID IS NULL AND ElementValue IS NOT NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set C_ElementValue_ID=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid ElementValue, ' ").append("WHERE C_ElementValue_ID IS NULL AND LineType<>'C'").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Invalid AccountType=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET SeqNo=I_ReportLine_ID ").append("WHERE SeqNo IS NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set SeqNo Default=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine i ").append("SET (Description, SeqNo, IsSummary, IsPrinted, LineType, CalculationType, AmountType, PAAmountType, PAPeriodType, PostingType)=").append(" (SELECT Description, SeqNo, IsSummary, IsPrinted, LineType, CalculationType, AmountType, PAAmountType, PAPeriodType, PostingType").append(" FROM I_ReportLine ii WHERE i.Name=ii.Name AND i.PA_ReportLineSet_ID=ii.PA_ReportLineSet_ID").append(" AND ii.I_ReportLine_ID=(SELECT MIN(I_ReportLine_ID) FROM I_ReportLine iii").append(" WHERE i.Name=iii.Name AND i.PA_ReportLineSet_ID=iii.PA_ReportLineSet_ID)) ").append("WHERE EXISTS (SELECT *").append(" FROM I_ReportLine ii WHERE i.Name=ii.Name AND i.PA_ReportLineSet_ID=ii.PA_ReportLineSet_ID").append(" AND ii.I_ReportLine_ID=(SELECT MIN(I_ReportLine_ID) FROM I_ReportLine iii").append(" WHERE i.Name=iii.Name AND i.PA_ReportLineSet_ID=iii.PA_ReportLineSet_ID))").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Sync from first Row of Line=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET IsSummary='N' ").append("WHERE IsSummary IS NULL OR IsSummary NOT IN ('Y','N')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set IsSummary Default=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET IsPrinted='Y' ").append("WHERE IsPrinted IS NULL OR IsPrinted NOT IN ('Y','N')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set IsPrinted Default=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET LineType='S' ").append("WHERE LineType IS NULL OR LineType NOT IN ('S','C')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set LineType Default=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid CalculationType, ' ").append("WHERE CalculationType IS NOT NULL AND CalculationType NOT IN ('A','P','R','S')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Invalid CalculationType=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET PAAmountType = substr(AmountType,1,1), PAPeriodType = substr(AmountType,1,2) ").append("WHERE AmountType IS NOT NULL AND (PAAmountType IS NULL OR PAPeriodType IS NULL) ").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Converted AmountType=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid PAAmountType, ' ").append("WHERE PAAmountType IS NOT NULL AND UPPER(AmountType) NOT IN ('B','C','D','Q','S','R')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Invalid AmountType=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid PAPeriodType, ' ").append("WHERE PAPeriodType IS NOT NULL AND UPPER(AmountType) NOT IN ('P','Y','T','N')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Invalid PeriodType=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid CalculationType, ' ").append("WHERE PostingType IS NOT NULL AND PostingType NOT IN ('A','B','E','S','R')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Invalid PostingType=" + no);
                }
                sql = new StringBuilder("UPDATE I_ReportLine i ").append("SET PA_ReportLine_ID=(SELECT MAX(PA_ReportLine_ID) FROM PA_ReportLine r").append(" WHERE i.Name=r.Name AND i.PA_ReportLineSet_ID=r.PA_ReportLineSet_ID) ").append("WHERE PA_ReportLine_ID IS NULL AND PA_ReportLineSet_ID IS NOT NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set PA_ReportLine_ID=" + no);
                }
                this.commitEx();
                noInsertLine = 0;
                noUpdateLine = 0;
                sql = new StringBuilder("SELECT DISTINCT PA_ReportLineSet_ID, Name ").append("FROM I_ReportLine ").append("WHERE I_IsImported='N' AND PA_ReportLine_ID IS NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
                CPreparedStatement pstmt_insertLine = null;
                pstmt = null;
                rs = null;
                try {
                    try {
                        StringBuilder dbpst = new StringBuilder("INSERT INTO PA_ReportLine ").append("(PA_ReportLine_ID,PA_ReportLineSet_ID,").append("AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,").append("Name,SeqNo,IsPrinted,IsSummary,LineType)").append("SELECT ?,PA_ReportLineSet_ID,").append("AD_Client_ID,AD_Org_ID,'Y',getDate(),CreatedBy,getDate(),UpdatedBy,").append("Name,SeqNo,IsPrinted,IsSummary,LineType ").append("FROM I_ReportLine ").append("WHERE I_ReportLine_ID=(SELECT MAX(I_ReportLine_ID) ").append("FROM I_ReportLine ").append("WHERE PA_ReportLineSet_ID=? AND Name=? ").append((CharSequence)clientCheck).append(")");
                        pstmt_insertLine = DB.prepareStatement((String)dbpst.toString(), (String)this.get_TrxName());
                        pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            int PA_ReportLineSet_ID = rs.getInt(1);
                            String Name = rs.getString(2);
                            try {
                                int PA_ReportLine_ID = DB.getNextID((int)this.m_AD_Client_ID, (String)"PA_ReportLine", (String)this.get_TrxName());
                                if (PA_ReportLine_ID <= 0) {
                                    throw new DBException("No NextID (" + PA_ReportLine_ID + ")");
                                }
                                pstmt_insertLine.setInt(1, PA_ReportLine_ID);
                                pstmt_insertLine.setInt(2, PA_ReportLineSet_ID);
                                pstmt_insertLine.setString(3, Name);
                                no = pstmt_insertLine.executeUpdate();
                                if (this.log.isLoggable(Level.FINEST)) {
                                    this.log.finest("Insert ReportLine = " + no + ", PA_ReportLine_ID=" + PA_ReportLine_ID);
                                }
                                ++noInsertLine;
                            }
                            catch (Exception ex) {
                                if (!this.log.isLoggable(Level.FINEST)) continue;
                                this.log.finest(ex.toString());
                            }
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, "Create ReportLine", (Throwable)e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        DB.close(pstmt_insertLine);
                        pstmt_insertLine = null;
                        break block52;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    DB.close(pstmt_insertLine);
                    pstmt_insertLine = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                DB.close((Statement)pstmt_insertLine);
                pstmt_insertLine = null;
            }
            sql = new StringBuilder("UPDATE I_ReportLine i ").append("SET PA_ReportLine_ID=(SELECT MAX(PA_ReportLine_ID) FROM PA_ReportLine r").append(" WHERE i.Name=r.Name AND i.PA_ReportLineSet_ID=r.PA_ReportLineSet_ID) ").append("WHERE PA_ReportLine_ID IS NULL AND PA_ReportLineSet_ID IS NOT NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set PA_ReportLine_ID=" + no);
            }
            sql = new StringBuilder("UPDATE PA_ReportLine r ").append("SET (Description,SeqNo,IsSummary,IsPrinted,LineType,CalculationType,AmountType,PAAmountType,PAPeriodType,PostingType,Updated,UpdatedBy)=").append(" (SELECT Description,SeqNo,IsSummary,IsPrinted,LineType,CalculationType,AmountType,PAAmountType,PAPeriodType,PostingType,getDate(),UpdatedBy").append(" FROM I_ReportLine i WHERE r.Name=i.Name AND r.PA_ReportLineSet_ID=i.PA_ReportLineSet_ID").append(" AND i.I_ReportLine_ID=(SELECT MIN(I_ReportLine_ID) FROM I_ReportLine iii").append(" WHERE i.Name=iii.Name AND i.PA_ReportLineSet_ID=iii.PA_ReportLineSet_ID)) ").append("WHERE EXISTS (SELECT *").append(" FROM I_ReportLine i WHERE r.Name=i.Name AND r.PA_ReportLineSet_ID=i.PA_ReportLineSet_ID").append(" AND i.I_ReportLine_ID=(SELECT MIN(I_ReportLine_ID) FROM I_ReportLine iii").append(" WHERE i.Name=iii.Name AND i.PA_ReportLineSet_ID=iii.PA_ReportLineSet_ID AND i.I_IsImported='N'))").append((CharSequence)clientCheck);
            noUpdateLine = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Update PA_ReportLine=" + noUpdateLine);
            }
            noInsertSource = 0;
            noUpdateSource = 0;
            sql = new StringBuilder("SELECT I_ReportLine_ID, PA_ReportSource_ID ").append("FROM I_ReportLine ").append("WHERE PA_ReportLine_ID IS NOT NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
            CPreparedStatement pstmt_insertSource = null;
            CPreparedStatement pstmt_deleteSource = null;
            CPreparedStatement pstmt_setImported = null;
            try {
                try {
                    StringBuilder dbpst = new StringBuilder("INSERT INTO PA_ReportSource ").append("(PA_ReportSource_ID,").append("AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,").append("PA_ReportLine_ID,ElementType,C_ElementValue_ID) ").append("SELECT ?,").append("AD_Client_ID,AD_Org_ID,'Y',getDate(),CreatedBy,getDate(),UpdatedBy,").append("PA_ReportLine_ID,'AC',C_ElementValue_ID ").append("FROM I_ReportLine ").append("WHERE I_ReportLine_ID=?").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
                    pstmt_insertSource = DB.prepareStatement((String)dbpst.toString(), (String)this.get_TrxName());
                    dbpst = new StringBuilder("DELETE FROM PA_ReportSource ").append("WHERE C_ElementValue_ID IS NULL").append(" AND PA_ReportSource_ID=?").append((CharSequence)clientCheck);
                    pstmt_deleteSource = DB.prepareStatement((String)dbpst.toString(), (String)this.get_TrxName());
                    pstmt_setImported = DB.prepareStatement((String)"UPDATE I_ReportLine SET I_IsImported='Y', PA_ReportSource_ID=?,  Updated=getDate(), Processed='Y' WHERE I_ReportLine_ID=?", (String)this.get_TrxName());
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int PA_ReportSource_ID;
                        int I_ReportLine_ID;
                        block53: {
                            I_ReportLine_ID = rs.getInt(1);
                            PA_ReportSource_ID = rs.getInt(2);
                            if (PA_ReportSource_ID == 0) {
                                try {
                                    PA_ReportSource_ID = DB.getNextID((int)this.m_AD_Client_ID, (String)"PA_ReportSource", (String)this.get_TrxName());
                                    if (PA_ReportSource_ID <= 0) {
                                        throw new DBException("No NextID (" + PA_ReportSource_ID + ")");
                                    }
                                    pstmt_insertSource.setInt(1, PA_ReportSource_ID);
                                    pstmt_insertSource.setInt(2, I_ReportLine_ID);
                                    no = pstmt_insertSource.executeUpdate();
                                    if (this.log.isLoggable(Level.FINEST)) {
                                        this.log.finest("Insert ReportSource = " + no + ", I_ReportLine_ID=" + I_ReportLine_ID + ", PA_ReportSource_ID=" + PA_ReportSource_ID);
                                    }
                                    ++noInsertSource;
                                    break block53;
                                }
                                catch (Exception ex) {
                                    if (this.log.isLoggable(Level.FINEST)) {
                                        this.log.finest("Insert ReportSource - " + ex.toString());
                                    }
                                    sql = new StringBuilder("UPDATE I_ReportLine i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)("Insert ElementSource: " + ex.toString()))).append("WHERE I_ReportLine_ID=").append(I_ReportLine_ID);
                                    DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                                    continue;
                                }
                            }
                            StringBuilder sqlt = new StringBuilder("UPDATE PA_ReportSource ").append("SET (ElementType,C_ElementValue_ID,Updated,UpdatedBy)=").append(" (SELECT CAST('AC' AS CHAR(2)),C_ElementValue_ID,getDate(),UpdatedBy").append(" FROM I_ReportLine").append(" WHERE I_ReportLine_ID=").append(I_ReportLine_ID).append(") ").append("WHERE PA_ReportSource_ID=").append(PA_ReportSource_ID).append(" ").append((CharSequence)clientCheck);
                            CPreparedStatement pstmt_updateSource = null;
                            try {
                                try {
                                    pstmt_updateSource = DB.prepareStatement((String)sqlt.toString(), (String)this.get_TrxName());
                                    no = pstmt_updateSource.executeUpdate();
                                    if (this.log.isLoggable(Level.FINEST)) {
                                        this.log.finest("Update ReportSource = " + no + ", I_ReportLine_ID=" + I_ReportLine_ID + ", PA_ReportSource_ID=" + PA_ReportSource_ID);
                                    }
                                    ++noUpdateSource;
                                }
                                catch (SQLException ex) {
                                    if (this.log.isLoggable(Level.FINEST)) {
                                        this.log.finest("Update ReportSource - " + ex.toString());
                                    }
                                    sql = new StringBuilder("UPDATE I_ReportLine i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)("Update ElementSource: " + ex.toString()))).append("WHERE I_ReportLine_ID=").append(I_ReportLine_ID);
                                    DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                                    DB.close((Statement)pstmt_updateSource);
                                    pstmt_updateSource = null;
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                DB.close(pstmt_updateSource);
                                pstmt_updateSource = null;
                                throw throwable;
                            }
                            DB.close((Statement)pstmt_updateSource);
                            pstmt_updateSource = null;
                        }
                        pstmt_setImported.setInt(1, PA_ReportSource_ID);
                        pstmt_setImported.setInt(2, I_ReportLine_ID);
                        no = pstmt_setImported.executeUpdate();
                        if (no != 1) {
                            this.log.log(Level.SEVERE, "Set Imported=" + no);
                        }
                        pstmt_deleteSource.setInt(1, PA_ReportSource_ID);
                        no = pstmt_deleteSource.executeUpdate();
                        if (this.log.isLoggable(Level.FINEST)) {
                            this.log.finest("Delete ReportSource with Null Account= " + no + ", I_ReportLine_ID=" + I_ReportLine_ID + ", PA_ReportSource_ID=" + PA_ReportSource_ID);
                        }
                        this.commitEx();
                    }
                }
                catch (SQLException sQLException) {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    DB.close(pstmt_insertSource);
                    pstmt_insertSource = null;
                    DB.close(pstmt_setImported);
                    pstmt_setImported = null;
                    DB.close(pstmt_deleteSource);
                    pstmt_deleteSource = null;
                    break block56;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                DB.close(pstmt_insertSource);
                pstmt_insertSource = null;
                DB.close(pstmt_setImported);
                pstmt_setImported = null;
                DB.close(pstmt_deleteSource);
                pstmt_deleteSource = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            DB.close((Statement)pstmt_insertSource);
            pstmt_insertSource = null;
            DB.close((Statement)pstmt_setImported);
            pstmt_setImported = null;
            DB.close((Statement)pstmt_deleteSource);
            pstmt_deleteSource = null;
        }
        sql = new StringBuilder("UPDATE I_ReportLine ").append("SET I_IsImported='N', Updated=getDate() ").append("WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@PA_ReportLine_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdateLine), "@PA_ReportLine_ID@: @Updated@");
        this.addLog(0, null, new BigDecimal(noInsertSource), "@PA_ReportSource_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdateSource), "@PA_ReportSource_ID@: @Updated@");
        return "";
    }
}

