/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MDiscountSchemaLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MProductPrice;
import org.compiere.model.MSequence;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;

@Process
public class M_PriceList_Create
extends SvrProcess {
    private int p_PriceList_Version_ID = 0;
    private boolean p_DeleteOld = false;
    private int m_AD_PInstance_ID = 0;
    private MPriceListVersion m_plv = null;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals("DeleteOld")) {
                    this.p_DeleteOld = para.getParameterAsBoolean();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
                }
            }
            ++n2;
        }
        this.p_PriceList_Version_ID = this.getRecord_ID();
        this.m_AD_PInstance_ID = this.getAD_PInstance_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("M_PriceList_Version_ID=" + this.p_PriceList_Version_ID + ", DeleteOld=" + this.p_DeleteOld);
        this.m_plv = new MPriceListVersion(this.getCtx(), this.p_PriceList_Version_ID, this.get_TrxName());
        if (this.m_plv.get_ID() == 0 || this.m_plv.get_ID() != this.p_PriceList_Version_ID) {
            throw new AdempiereUserError("@NotFound@  @M_PriceList_Version_ID@=" + this.p_PriceList_Version_ID);
        }
        String error = this.checkPrerequisites();
        if (error != null && error.length() > 0) {
            throw new AdempiereUserError(error);
        }
        return this.create();
    }

    private String checkPrerequisites() {
        Object[] clientParam = new Object[]{this.m_plv.getAD_Client_ID()};
        DB.executeUpdateEx((String)"UPDATE M_Product_PO SET PriceList = 0 WHERE PriceList IS NULL AND AD_Client_ID=?", (Object[])clientParam, (String)this.get_TrxName());
        DB.executeUpdateEx((String)"UPDATE M_Product_PO SET PriceLastPO = 0 WHERE PriceLastPO IS NULL AND AD_Client_ID=?", (Object[])clientParam, (String)this.get_TrxName());
        DB.executeUpdateEx((String)"UPDATE M_Product_PO SET PricePO = PriceLastPO WHERE (PricePO IS NULL OR PricePO = 0) AND PriceLastPO <> 0 AND AD_Client_ID=?", (Object[])clientParam, (String)this.get_TrxName());
        DB.executeUpdateEx((String)"UPDATE\tM_Product_PO SET PricePO = 0 WHERE PricePO IS NULL AND AD_Client_ID=?", (Object[])clientParam, (String)this.get_TrxName());
        DB.executeUpdateEx((String)"UPDATE M_Product_PO p SET IsCurrentVendor = 'Y' WHERE IsCurrentVendor = 'N' AND NOT EXISTS (SELECT pp.M_Product_ID FROM M_Product_PO pp WHERE pp.M_Product_ID=p.M_Product_ID GROUP BY pp.M_Product_ID HAVING COUNT(*) > 1) AND AD_Client_ID=?", (Object[])clientParam, (String)this.get_TrxName());
        String whereClause = "IsCurrentVendor='Y' AND IsActive='Y' AND EXISTS (SELECT M_Product_ID FROM M_Product_PO x WHERE x.M_Product_ID=M_Product_PO.M_Product_ID AND IsCurrentVendor='Y' AND IsActive='Y' GROUP BY M_Product_ID HAVING COUNT(*) > 1)";
        String orderByClause = "M_Product_ID, Created";
        List pos = new Query(this.getCtx(), "M_Product_PO", whereClause, this.get_TrxName()).setClient_ID().setOrderBy(orderByClause).list();
        int success = 0;
        int errors = 0;
        int M_Product_ID = 0;
        for (MProductPO po : pos) {
            if (M_Product_ID != po.getM_Product_ID()) {
                M_Product_ID = po.getM_Product_ID();
                continue;
            }
            po.setIsCurrentVendor(false);
            if (po.save()) {
                ++success;
                continue;
            }
            ++errors;
            this.log.warning("Not updated " + String.valueOf(po));
        }
        this.log.info("Current Vendor - Changes=" + success + ", Errors=" + errors);
        return null;
    }

    private String create() throws Exception {
        MDiscountSchemaLine[] dsl;
        StringBuffer info = new StringBuffer();
        if (this.p_DeleteOld) {
            int no = DB.executeUpdateEx((String)"DELETE FROM M_ProductPrice WHERE M_PriceList_Version_ID=?", (Object[])new Object[]{this.p_PriceList_Version_ID}, (String)this.get_TrxName());
            this.log.info("Deleted=" + no);
            info.append("@Deleted@=").append(no).append(" - ");
        }
        int M_Pricelist_Version_Base_ID = this.m_plv.getM_Pricelist_Version_Base_ID();
        MPriceList pl = this.m_plv.getPriceList();
        int curPrecision = pl.getStandardPrecision();
        MDiscountSchema ds = new MDiscountSchema(this.getCtx(), this.m_plv.getM_DiscountSchema_ID(), this.get_TrxName());
        MDiscountSchemaLine[] mDiscountSchemaLineArray = dsl = ds.getLines(false);
        int n = dsl.length;
        int n2 = 0;
        while (n2 < n) {
            MDiscountSchemaLine dsLine = mDiscountSchemaLineArray[n2];
            if (dsLine.isActive()) {
                MProductPrice[] pp;
                Object sql;
                String message = "#" + dsLine.getSeqNo();
                String dd = dsLine.getDescription();
                if (dd != null && dd.length() > 0) {
                    message = message + " " + dd;
                }
                int noDeleted = DB.executeUpdateEx((String)"DELETE FROM T_Selection WHERE AD_PInstance_ID=?", (Object[])new Object[]{this.m_AD_PInstance_ID}, (String)this.get_TrxName());
                StringBuilder sqlb = new StringBuilder("INSERT INTO T_Selection (AD_PInstance_ID, T_Selection_ID) ");
                int M_DiscountSchemaLine_ID = dsLine.getM_DiscountSchemaLine_ID();
                int p2 = M_Pricelist_Version_Base_ID;
                if (p2 == 0) {
                    p2 = dsLine.getAD_Client_ID();
                    sqlb.append("SELECT DISTINCT ?, po.M_Product_ID FROM M_Product_PO po  INNER JOIN M_Product p ON (p.M_Product_ID=po.M_Product_ID) INNER JOIN M_DiscountSchemaLine dl ON (dl.M_DiscountSchemaLine_ID=?) WHERE p.AD_Client_ID IN (?, 0) AND p.IsActive='Y' AND po.IsActive='Y' AND (dl.Group1 IS NULL OR p.Group1=dl.Group1) AND (dl.Group2 IS NULL OR p.Group2=dl.Group2) AND (dl.C_BPartner_ID IS NULL OR po.C_BPartner_ID=dl.C_BPartner_ID) AND (dl.VendorCategory IS NULL OR po.VendorCategory=dl.VendorCategory) AND (dl.IsIgnoreIsCurrentVendor='Y' OR po.IsCurrentVendor='Y') AND (dl.M_Product_ID IS NULL OR p.M_Product_ID=dl.M_Product_ID)");
                    if (dsLine.getM_Product_Category_ID() > 0) {
                        sqlb.append(" AND p.M_Product_Category_ID IN (").append(this.getSubCategoryWhereClause(dsLine.getM_Product_Category_ID())).append(")");
                    }
                } else {
                    sqlb.append("SELECT DISTINCT ?, p.M_Product_ID FROM M_ProductPrice pp INNER JOIN M_Product p ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN M_DiscountSchemaLine dl ON (dl.M_DiscountSchemaLine_ID=?) WHERE pp.M_PriceList_Version_ID=? AND p.IsActive='Y' AND pp.IsActive='Y' AND (dl.Group1 IS NULL OR p.Group1=dl.Group1) AND (dl.Group2 IS NULL OR p.Group2=dl.Group2) AND ((dl.C_BPartner_ID IS NULL AND dl.VendorCategory IS NULL) OR EXISTS (SELECT * FROM M_Product_PO po WHERE po.M_Product_ID=p.M_Product_ID   AND (dl.C_BPartner_ID IS NULL OR po.C_BPartner_ID=dl.C_BPartner_ID)   AND (dl.VendorCategory IS NULL OR po.VendorCategory=dl.VendorCategory))) AND (dl.M_Product_ID IS NULL OR p.M_Product_ID=dl.M_Product_ID)");
                    if (dsLine.getM_Product_Category_ID() > 0) {
                        sqlb.append(" AND p.M_Product_Category_ID IN (").append(this.getSubCategoryWhereClause(dsLine.getM_Product_Category_ID())).append(")");
                    }
                }
                int noSelected = DB.executeUpdateEx((String)sqlb.toString(), (Object[])new Object[]{this.m_AD_PInstance_ID, M_DiscountSchemaLine_ID, p2}, (String)this.get_TrxName());
                message = message + ": @Selected@=" + noSelected;
                if (M_Pricelist_Version_Base_ID == 0 || M_Pricelist_Version_Base_ID != this.p_PriceList_Version_ID) {
                    sql = "DELETE FROM M_ProductPrice pp WHERE pp.M_PriceList_Version_ID=? AND EXISTS (SELECT * FROM T_Selection s WHERE AD_PInstance_ID=? AND pp.M_Product_ID=s.T_Selection_ID)";
                    noDeleted = DB.executeUpdateEx((String)sql, (Object[])new Object[]{this.p_PriceList_Version_ID, this.m_AD_PInstance_ID}, (String)this.get_TrxName());
                    message = message + ", @Deleted@=" + noDeleted;
                }
                int noInserted = 0;
                sql = "INSERT INTO M_ProductPrice (M_PriceList_Version_ID, M_Product_ID, AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, PriceList, PriceStd, PriceLimit, M_ProductPrice_ID, M_ProductPrice_UU) ";
                int seqproductpriceid = MSequence.get((Properties)this.getCtx(), (String)"M_ProductPrice").get_ID();
                sql = M_Pricelist_Version_Base_ID == this.p_PriceList_Version_ID ? null : (M_Pricelist_Version_Base_ID == 0 ? (String)sql + "SELECT plv.M_PriceList_Version_ID, po.M_Product_ID, plv.AD_Client_ID, plv.AD_Org_ID, 'Y', SysDate, plv.UpdatedBy, SysDate, plv.UpdatedBy, COALESCE(currencyConvert(po.PriceList, po.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), 0), COALESCE(currencyConvert(po.PriceList,\tpo.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), 0), COALESCE(currencyConvert(po.PricePO, po.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), 0),  nextidfunc(?,'N'), generate_uuid() FROM M_Product_PO po INNER JOIN M_PriceList_Version plv ON (plv.M_PriceList_Version_ID=?) INNER JOIN M_PriceList pl ON (pl.M_PriceList_ID=plv.M_PriceList_ID) INNER JOIN M_DiscountSchemaLine dl ON (dl.M_DiscountSchemaLine_ID=?) WHERE EXISTS (SELECT * FROM T_Selection s WHERE s.AD_PInstance_ID=? AND po.M_Product_ID=s.T_Selection_ID) AND ((dl.C_BPartner_ID IS NULL AND po.IsCurrentVendor='Y')      OR (po.C_BPartner_ID=dl.C_BPartner_ID AND (dl.IsIgnoreIsCurrentVendor='Y' OR po.IsCurrentVendor='Y'))) AND po.IsActive='Y'" : (String)sql + "SELECT plv.M_PriceList_Version_ID, pp.M_Product_ID, plv.AD_Client_ID, plv.AD_Org_ID, 'Y', SysDate, plv.UpdatedBy, SysDate, plv.UpdatedBy, COALESCE(currencyConvert(pp.PriceList, bpl.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), 0), COALESCE(currencyConvert(pp.PriceStd, bpl.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), 0), COALESCE(currencyConvert(pp.PriceLimit, bpl.C_Currency_ID, pl.C_Currency_ID, dl.ConversionDate, dl.C_ConversionType_ID, plv.AD_Client_ID, plv.AD_Org_ID), 0),  nextidfunc(?,'N'), generate_uuid() FROM M_ProductPrice pp INNER JOIN M_PriceList_Version plv ON (plv.M_PriceList_Version_ID=?) INNER JOIN M_PriceList pl ON (pl.M_PriceList_ID=plv.M_PriceList_ID) INNER JOIN M_PriceList_Version bplv ON (pp.M_PriceList_Version_ID=bplv.M_PriceList_Version_ID) INNER JOIN M_PriceList bpl ON (bplv.M_PriceList_ID=bpl.M_PriceList_ID) INNER JOIN M_DiscountSchemaLine dl ON (dl.M_DiscountSchemaLine_ID=?) WHERE pp.M_PriceList_Version_ID=? AND EXISTS (SELECT * FROM T_Selection s WHERE s.AD_PInstance_ID=? AND pp.M_Product_ID=s.T_Selection_ID) AND pp.IsActive='Y'");
                if (sql != null) {
                    Object[] params = M_Pricelist_Version_Base_ID == 0 ? new Object[]{seqproductpriceid, this.p_PriceList_Version_ID, M_DiscountSchemaLine_ID, this.m_AD_PInstance_ID} : new Object[]{seqproductpriceid, this.p_PriceList_Version_ID, M_DiscountSchemaLine_ID, M_Pricelist_Version_Base_ID, this.m_AD_PInstance_ID};
                    noInserted = DB.executeUpdateEx((String)sql, (Object[])params, (String)this.get_TrxName());
                    message = message + " @Inserted@=" + noInserted;
                }
                MProductPrice[] mProductPriceArray = pp = this.m_plv.getProductPrice(" AND EXISTS (SELECT * FROM T_Selection s WHERE s.AD_PInstance_ID = " + this.m_AD_PInstance_ID + " AND s.T_Selection_ID=M_ProductPrice.M_Product_ID)");
                int n3 = pp.length;
                int n4 = 0;
                while (n4 < n3) {
                    MProductPrice price = mProductPriceArray[n4];
                    BigDecimal priceList = price.getPriceList();
                    BigDecimal priceStd = price.getPriceStd();
                    BigDecimal priceLimit = price.getPriceLimit();
                    price.setPriceList(this.calculate(dsLine.getList_Base(), priceList, priceStd, priceLimit, dsLine.getList_Fixed(), dsLine.getList_AddAmt(), dsLine.getList_Discount(), dsLine.getList_Rounding(), curPrecision, price.getM_Product_ID()));
                    price.setPriceStd(this.calculate(dsLine.getStd_Base(), priceList, priceStd, priceLimit, dsLine.getStd_Fixed(), dsLine.getStd_AddAmt(), dsLine.getStd_Discount(), dsLine.getStd_Rounding(), curPrecision, price.getM_Product_ID()));
                    price.setPriceLimit(this.calculate(dsLine.getLimit_Base(), priceList, priceStd, priceLimit, dsLine.getLimit_Fixed(), dsLine.getLimit_AddAmt(), dsLine.getLimit_Discount(), dsLine.getLimit_Rounding(), curPrecision, price.getM_Product_ID()));
                    price.saveEx();
                    ++n4;
                }
                this.addLog(message);
            }
            ++n2;
        }
        DB.executeUpdateEx((String)"DELETE FROM T_Selection WHERE AD_PInstance_ID=?", (Object[])new Object[]{this.m_AD_PInstance_ID}, (String)this.get_TrxName());
        MProductPrice[] pp = this.m_plv.getProductPrice(true);
        info.append(" - @Records@=").append(pp.length);
        return info.toString();
    }

    private BigDecimal calculate(String base, BigDecimal list, BigDecimal std, BigDecimal limit, BigDecimal fix, BigDecimal add, BigDecimal discount, String round, int curPrecision, int M_Product_ID) {
        BigDecimal calc = null;
        double dd = 0.0;
        if ("L".equals(base)) {
            dd = list.doubleValue();
        } else if ("S".equals(base)) {
            dd = std.doubleValue();
        } else if ("X".equals(base)) {
            dd = limit.doubleValue();
        } else if ("F".equals(base)) {
            calc = fix;
        } else if ("P".equals(base)) {
            MProduct product;
            MAcctSchema as = MClientInfo.get((Properties)this.getCtx(), (int)this.m_plv.getAD_Client_ID()).getMAcctSchema1();
            ProductCost m_productCost = new ProductCost(this.getCtx(), M_Product_ID, 0, this.get_TrxName());
            m_productCost.setQty(BigDecimal.ONE);
            BigDecimal costs = m_productCost.getProductCosts(as, this.m_plv.getAD_Org_ID(), null, 0, false);
            if ((costs == null || costs.signum() == 0) && (product = new MProduct(this.getCtx(), M_Product_ID, this.get_TrxName())).isStocked()) {
                this.log.log(Level.WARNING, "No Costs for " + product.getName());
            }
            calc = costs;
        } else {
            throw new IllegalArgumentException("Unknown Base=" + base);
        }
        if (calc == null) {
            if (add.signum() != 0) {
                dd += add.doubleValue();
            }
            if (discount.signum() != 0) {
                dd *= 1.0 - discount.doubleValue() / 100.0;
            }
            calc = new BigDecimal(dd);
        }
        if ("C".equals(round)) {
            calc = calc.setScale(curPrecision, RoundingMode.HALF_UP);
        } else if ("D".equals(round)) {
            calc = calc.setScale(1, RoundingMode.HALF_UP);
        } else if ("h".equals(round)) {
            calc = calc.setScale(-2, RoundingMode.HALF_UP);
        } else if ("5".equals(round)) {
            mm = new BigDecimal(20);
            calc = calc.multiply(mm);
            calc = calc.setScale(0, RoundingMode.HALF_UP);
            calc = calc.divide(mm, 2, RoundingMode.HALF_UP);
        } else if (!"N".equals(round)) {
            if ("Q".equals(round)) {
                mm = new BigDecimal(4);
                calc = calc.multiply(mm);
                calc = calc.setScale(0, RoundingMode.HALF_UP);
                calc = calc.divide(mm, 2, RoundingMode.HALF_UP);
            } else if ("T".equals(round)) {
                calc = calc.setScale(-1, RoundingMode.HALF_UP);
            } else if ("t".equals(round)) {
                calc = calc.setScale(-3, RoundingMode.HALF_UP);
            } else if ("0".equals(round)) {
                calc = calc.setScale(0, RoundingMode.HALF_UP);
            }
        }
        return calc;
    }

    private String getSubCategoryWhereClause(int productCategoryId) throws SQLException, AdempiereSystemError {
        int subTreeRootParentId = 0;
        StringBuilder retString = new StringBuilder();
        String sql = " SELECT M_Product_Category_ID, M_Product_Category_Parent_ID FROM M_Product_Category";
        Vector<SimpleTreeNode> categories = new Vector<SimpleTreeNode>(100);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DB.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (rs.getInt(1) == productCategoryId) {
                    subTreeRootParentId = rs.getInt(2);
                }
                categories.add(new SimpleTreeNode(rs.getInt(1), rs.getInt(2)));
            }
            retString.append(this.getSubCategoriesString(productCategoryId, categories, subTreeRootParentId));
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)stmt);
            rs = null;
            stmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)stmt);
        rs = null;
        stmt = null;
        return retString.toString();
    }

    private String getSubCategoriesString(int productCategoryId, Vector<SimpleTreeNode> categories, int loopIndicatorId) throws AdempiereSystemError {
        StringBuilder ret = new StringBuilder();
        for (SimpleTreeNode node : categories) {
            if (node.getParentId() != productCategoryId) continue;
            if (node.getNodeId() == loopIndicatorId) {
                throw new AdempiereSystemError("The product category tree contains a loop on categoryId: " + loopIndicatorId);
            }
            ret.append(this.getSubCategoriesString(node.getNodeId(), categories, loopIndicatorId));
            ret.append(",");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(ret.toString());
        }
        return ret.toString() + productCategoryId;
    }

    private static class SimpleTreeNode {
        private int nodeId;
        private int parentId;

        public SimpleTreeNode(int nodeId, int parentId) {
            this.nodeId = nodeId;
            this.parentId = parentId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }
}

