/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.layout.Page;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Util;

public class PrintDataEvaluatee
implements Evaluatee {
    private PrintData m_data;
    private Page m_page;

    public PrintDataEvaluatee(Page page, PrintData data) {
        this.m_data = data;
        this.m_page = page;
    }

    @Override
    public String get_ValueAsString(String variableName) {
        if ("*Page".equals(variableName)) {
            return this.m_page != null ? String.valueOf(this.m_page.getPageNo()) : "1";
        }
        if ("*PageCount".equals(variableName)) {
            return this.m_page != null ? String.valueOf(this.m_page.getPageCount()) : "1";
        }
        String foreignColumn = "";
        int f = variableName.indexOf(46);
        if (f > 0) {
            foreignColumn = variableName.substring(f + 1, variableName.length());
            variableName = variableName.substring(0, f);
        }
        String value = null;
        if (variableName.startsWith("#") || variableName.startsWith("$")) {
            value = Env.getContext(Env.getCtx(), variableName);
        } else {
            Object obj = this.m_data.getNode(variableName);
            if (obj == null || !(obj instanceof PrintDataElement)) {
                return "";
            }
            PrintDataElement data = (PrintDataElement)obj;
            if (data.isNull()) {
                return "";
            }
            value = data.getValue() instanceof Boolean ? ((Boolean)data.getValue() != false ? "Y" : "N") : data.getValueAsString();
        }
        if (!Util.isEmpty(value) && !Util.isEmpty(foreignColumn) && variableName.endsWith("_ID")) {
            String refValue = "";
            int id = 0;
            try {
                id = Integer.parseInt(value);
            }
            catch (Exception exception) {}
            if (id > 0) {
                String tableName = null;
                tableName = !Util.isEmpty(this.m_data.getTableName()) ? this.m_data.getTableName() : variableName.substring(0, variableName.length() - 3);
                MColumn column = MColumn.get(this.m_data.getCtx(), tableName, variableName);
                if (column != null) {
                    String foreignTable = column.getReferenceTableName();
                    refValue = DB.getSQLValueString(null, "SELECT " + foreignColumn + " FROM " + foreignTable + " WHERE " + foreignTable + "_ID = ?", id);
                } else {
                    if (variableName.startsWith("#") || variableName.startsWith("$")) {
                        variableName = variableName.substring(1);
                    } else if (variableName.indexOf("|") > 0) {
                        variableName = variableName.substring(variableName.lastIndexOf("|") + 1);
                    }
                    String foreignTable = null;
                    foreignTable = foreignColumn.indexOf(".") > 0 ? foreignColumn.substring(0, foreignColumn.indexOf(".")) : variableName.substring(0, variableName.length() - 3);
                    MTable t = MTable.get(Env.getCtx(), foreignTable);
                    if (t != null) {
                        refValue = DB.getSQLValueString(null, "SELECT " + foreignColumn + " FROM " + foreignTable + " WHERE " + foreignTable + "_ID = ?", id);
                    }
                }
            }
            return refValue;
        }
        return value;
    }

    public static boolean hasPageLogic(String displayLogic) {
        if (Util.isEmpty(displayLogic, true)) {
            return false;
        }
        return displayLogic.contains("@*Page");
    }
}

