/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.p;
import org.compiere.model.MChatEntry;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_CM_Chat;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Util;

public class MChat
extends X_CM_Chat {
    private static final long serialVersionUID = -1188256932717048308L;
    private MChatEntry[] m_entries = null;
    private SimpleDateFormat m_format = null;

    public static MChat[] getOfTable(Properties ctx, int AD_Table_ID) {
        List<MChat> list = new Query(ctx, "CM_Chat", "AD_Table_ID=?", null).setClient_ID().setParameters(AD_Table_ID).setOrderBy("Record_ID").list();
        MChat[] retValue = new MChat[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MChat(Properties ctx, String CM_Chat_UU, String trxName) {
        super(ctx, CM_Chat_UU, trxName);
        if (Util.isEmpty(CM_Chat_UU)) {
            this.setInitialDefaults();
        }
    }

    public MChat(Properties ctx, int CM_Chat_ID, String trxName) {
        super(ctx, CM_Chat_ID, trxName);
        if (CM_Chat_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setConfidentialType("A");
        this.setModerationType("N");
    }

    public MChat(Properties ctx, int AD_Table_ID, int Record_ID, String Description, String trxName) {
        this(ctx, 0, trxName);
        this.setAD_Table_ID(AD_Table_ID);
        this.setRecord_ID(Record_ID);
        this.setDescription(Description);
    }

    public MChat(Properties ctx, int AD_Table_ID, int Record_ID, String Record_UU, String Description, String trxName) {
        this(ctx, 0, trxName);
        this.setAD_Table_ID(AD_Table_ID);
        this.setRecord_ID(Record_ID);
        this.setRecord_UU(Record_UU);
        this.setDescription(Description);
    }

    public MChat(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MChatEntry[] getEntries(boolean reload) {
        if (this.m_entries != null && !reload) {
            return this.m_entries;
        }
        List<MChatEntry> list = new Query(this.getCtx(), "CM_ChatEntry", "CM_Chat_ID=?", null).setParameters(this.getCM_Chat_ID()).setOrderBy("Created").list();
        this.m_entries = new MChatEntry[list.size()];
        list.toArray(this.m_entries);
        return this.m_entries;
    }

    @Override
    public void setDescription(String Description) {
        if (Description != null && Description.length() > 0) {
            super.setDescription(Description);
        } else {
            StringBuilder msgsd = new StringBuilder().append(this.getAD_Table_ID()).append("#").append(this.getRecord_ID());
            super.setDescription(msgsd.toString());
        }
    }

    public p getHistory(String ConfidentialType) {
        p history = new p();
        this.getEntries(false);
        boolean first = true;
        int i = 0;
        while (i < this.m_entries.length) {
            MChatEntry entry = this.m_entries[i];
            if (entry.isActive() && entry.isConfidentialType(ConfidentialType)) {
                if (first) {
                    first = false;
                } else {
                    history.addElement((Element)new hr());
                }
                b b2 = new b();
                MUser user = MUser.get(this.getCtx(), entry.getCreatedBy());
                b2.addElement(user.getName());
                b2.addElement(" \t");
                Timestamp created = entry.getCreated();
                if (this.m_format == null) {
                    this.m_format = DisplayType.getDateFormat(16);
                }
                b2.addElement(this.m_format.format(created));
                history.addElement((Element)b2);
                p p2 = new p();
                String data = entry.getCharacterData();
                data = Util.maskHTML(data, true);
                p2.addElement(data);
                history.addElement((Element)p2);
            }
            ++i;
        }
        return history;
    }

    public static int getID(int Table_ID, int Record_ID) {
        String sql = "SELECT CM_Chat_ID FROM CM_Chat WHERE AD_Table_ID=? AND Record_ID=?";
        int chatID = DB.getSQLValueEx(null, sql, Table_ID, Record_ID);
        return chatID;
    }

    public static int getID(int Table_ID, int Record_ID, String Record_UU) {
        if (Util.isEmpty(Record_UU)) {
            return MChat.getID(Table_ID, Record_ID);
        }
        String sql = "SELECT CM_Chat_ID FROM CM_Chat WHERE AD_Table_ID=? AND Record_UU=?";
        int chatID = DB.getSQLValueEx(null, sql, Table_ID, Record_UU);
        return chatID;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MTable table2;
        PO po;
        if (this.getRecord_ID() > 0 && this.getAD_Table_ID() > 0 && Util.isEmpty(this.getRecord_UU()) && (po = (table2 = MTable.get(this.getAD_Table_ID())).getPO(this.getRecord_ID(), this.get_TrxName())) != null) {
            this.setRecord_UU(po.get_UUID());
        }
        return true;
    }
}

