/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Properties;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MUserDefInfoColumn;
import org.compiere.model.MValRule;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;

public class InfoColumnVO
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 304775780197602066L;
    private Properties ctx;
    private boolean isMandatory;
    private boolean isQueryCriteria;
    private boolean isQueryAfterChange;
    private boolean isReadOnly;
    private boolean isDisplayed;
    private boolean isIdentifier;
    private boolean isKey;
    private boolean isAutocomplete;
    private boolean isRange;
    private int AD_Reference_ID;
    private int AD_Reference_Value_ID;
    private int SeqNoSelection;
    private int AD_InfoColumn_ID;
    private int AD_Val_Rule_ID;
    private int AD_FieldStyle_ID;
    private int AD_InfoWindow_ID;
    private int SeqNo;
    private String ColumnName;
    private String DisplayLogic;
    private String Name;
    private String NameTrl;
    private String Placeholder;
    private String Placeholder2;
    private String PlaceHolderTrl;
    private String SelectClause;
    private String InputFieldValidation;
    private String QueryOperator;
    private String QueryFunction;
    private String Description;
    private String DescriptionTrl;
    private String DefaultValue;
    private String DefaultValue2;
    private String HelpTrl;
    private String Help;
    private String ValidationCode;
    private String EntityType;
    private MInfoColumn infoColumn;

    public InfoColumnVO(Properties ctx, MInfoColumn infoColumn) {
        this.ctx = ctx;
        this.infoColumn = infoColumn;
        this.AD_InfoColumn_ID = infoColumn.getAD_InfoColumn_ID();
        this.AD_InfoWindow_ID = infoColumn.getAD_InfoWindow_ID();
        this.ColumnName = infoColumn.getColumnName();
        this.isMandatory = infoColumn.isMandatory();
        this.isQueryCriteria = infoColumn.isQueryCriteria();
        this.isQueryAfterChange = infoColumn.isQueryAfterChange();
        this.NameTrl = infoColumn.get_Translation("Name");
        this.Name = infoColumn.getName();
        this.AD_Reference_ID = infoColumn.getAD_Reference_ID();
        this.AD_Reference_Value_ID = infoColumn.getAD_Reference_Value_ID();
        this.PlaceHolderTrl = infoColumn.get_Translation("Placeholder");
        this.Placeholder = infoColumn.getPlaceholder();
        this.Placeholder2 = infoColumn.getPlaceholder2();
        this.isReadOnly = infoColumn.isReadOnly();
        this.SelectClause = infoColumn.getSelectClause();
        this.DisplayLogic = infoColumn.getDisplayLogic();
        this.isDisplayed = infoColumn.isDisplayed();
        this.InputFieldValidation = infoColumn.getInputFieldValidation();
        this.isIdentifier = infoColumn.isIdentifier();
        this.QueryOperator = infoColumn.getQueryOperator();
        this.SeqNoSelection = infoColumn.getSeqNoSelection();
        this.QueryFunction = infoColumn.getQueryFunction();
        this.Description = infoColumn.getDescription();
        this.DescriptionTrl = infoColumn.get_Translation("Description");
        this.isKey = infoColumn.isKey();
        this.DefaultValue = infoColumn.getDefaultValue();
        this.DefaultValue2 = infoColumn.getDefaultValue2();
        this.HelpTrl = infoColumn.get_Translation("Help");
        this.Help = infoColumn.getHelp();
        this.AD_FieldStyle_ID = infoColumn.getAD_FieldStyle_ID();
        this.isAutocomplete = infoColumn.isAutocomplete();
        this.SeqNo = infoColumn.getSeqNo();
        this.AD_Val_Rule_ID = infoColumn.getAD_Val_Rule_ID();
        this.EntityType = infoColumn.getEntityType();
        if (infoColumn.getAD_Val_Rule_ID() > 0) {
            this.ValidationCode = MValRule.get(ctx, infoColumn.getAD_Val_Rule_ID()).getCode();
        }
        this.isRange = this.QueryOperator != null && this.QueryOperator.equals("=") && (DisplayType.isDate(this.AD_Reference_ID) || DisplayType.isNumeric(this.AD_Reference_ID)) ? infoColumn.isRange() : false;
        this.afterCreate();
    }

    public InfoColumnVO afterCreate() {
        InfoColumnVO vo = this;
        MUserDefInfoColumn userDef = null;
        userDef = MUserDefInfoColumn.get(vo.ctx, vo.AD_InfoColumn_ID, vo.AD_InfoWindow_ID);
        if (userDef != null) {
            vo.EntityType = vo.EntityType + "**U**";
            if (userDef.getName() != null) {
                vo.Name = userDef.getName();
            }
            if (userDef.get_Translation("Name") != null) {
                vo.NameTrl = userDef.get_Translation("Name");
            }
            if (userDef.getDescription() != null) {
                vo.Description = userDef.getDescription();
            }
            if (userDef.get_Translation("Description") != null) {
                vo.DescriptionTrl = userDef.get_Translation("Description");
            }
            if (userDef.getHelp() != null) {
                vo.Help = userDef.getHelp();
            }
            if (userDef.get_Translation("Help") != null) {
                vo.HelpTrl = userDef.get_Translation("Help");
            }
            if (userDef.getDisplayLogic() != null) {
                vo.DisplayLogic = userDef.getDisplayLogic();
            }
            if (userDef.getDefaultValue() != null) {
                vo.DefaultValue = userDef.getDefaultValue();
            }
            if (userDef.getIsDisplayed() != null) {
                vo.isDisplayed = "Y".equals(userDef.getIsDisplayed());
            }
            if (userDef.getIsReadOnly() != null) {
                vo.isReadOnly = "Y".equals(userDef.getIsReadOnly());
            }
            if (userDef.getAD_Reference_ID() > 0) {
                vo.AD_Reference_ID = userDef.getAD_Reference_ID();
            }
            if (userDef.getAD_Reference_Value_ID() > 0) {
                vo.AD_Reference_Value_ID = userDef.getAD_Reference_Value_ID();
            }
            if (userDef.getIsMandatory() != null) {
                vo.isMandatory = "Y".equals(userDef.getIsMandatory());
            }
            if (userDef.getSeqNo() > 0) {
                vo.SeqNo = userDef.getSeqNo();
            }
            if (userDef.getSeqNoSelection() > 0) {
                vo.SeqNoSelection = userDef.getSeqNoSelection();
            }
            if (userDef.getAD_Val_Rule_ID() > 0) {
                vo.ValidationCode = MValRule.get(vo.ctx, userDef.getAD_Val_Rule_ID()).getCode();
                vo.AD_Val_Rule_ID = userDef.getAD_Val_Rule_ID();
            }
            if (userDef.getAD_FieldStyle_ID() > 0) {
                vo.AD_FieldStyle_ID = userDef.getAD_FieldStyle_ID();
            }
            if (userDef.getPlaceholder() != null) {
                vo.Placeholder = userDef.getPlaceholder();
            }
            if (userDef.get_Translation("Placeholder") != null) {
                vo.PlaceHolderTrl = userDef.get_Translation("Placeholder");
            }
            if (userDef.getInputFieldValidation() != null) {
                vo.InputFieldValidation = userDef.getInputFieldValidation();
            }
            if (userDef.getIsQueryCriteria() != null) {
                vo.isQueryCriteria = "Y".equals(userDef.getIsQueryCriteria());
            }
            if (userDef.getIsQueryAfterChange() != null) {
                vo.isQueryAfterChange = "Y".equals(userDef.getIsQueryAfterChange());
            }
            if (userDef.getQueryFunction() != null) {
                vo.QueryFunction = userDef.getQueryFunction();
            }
            if (userDef.getQueryOperator() != null) {
                vo.QueryOperator = userDef.getQueryOperator();
            }
            if (userDef.getIsAutocomplete() != null) {
                vo.isAutocomplete = "Y".equals(userDef.getIsAutocomplete());
            }
        }
        return vo;
    }

    public static InfoColumnVO[] create(Properties ctx, MInfoColumn[] p_infoColumns) {
        ArrayList<InfoColumnVO> infoColumns = new ArrayList<InfoColumnVO>();
        MInfoColumn[] mInfoColumnArray = p_infoColumns;
        int n = p_infoColumns.length;
        int n2 = 0;
        while (n2 < n) {
            MInfoColumn p_infoColumn = mInfoColumnArray[n2];
            InfoColumnVO infoColumn = new InfoColumnVO(ctx, p_infoColumn);
            infoColumns.add(infoColumn);
            ++n2;
        }
        infoColumns.sort(new Comparator<InfoColumnVO>(){

            @Override
            public int compare(InfoColumnVO o1, InfoColumnVO o2) {
                Integer o1SeqNo = o1.getSeqNo();
                Integer o2SeqNo = o2.getSeqNo();
                return o1SeqNo.compareTo(o2SeqNo);
            }
        });
        return infoColumns.toArray(new InfoColumnVO[infoColumns.size()]);
    }

    public boolean isDisplayed(final Properties ctx, final int windowNo) {
        if (!this.isDisplayed()) {
            return false;
        }
        if (this.getDisplayLogic() == null || this.getDisplayLogic().trim().length() == 0) {
            return true;
        }
        Evaluatee evaluatee = new Evaluatee(){

            @Override
            public String get_ValueAsString(String variableName) {
                return Env.getContext(ctx, windowNo, variableName, true);
            }
        };
        boolean retValue = Evaluator.evaluateLogic(evaluatee, this.getDisplayLogic());
        return retValue;
    }

    public String getColumnName() {
        return this.ColumnName;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public boolean isQueryCriteria() {
        return this.isQueryCriteria;
    }

    public boolean isQueryAfterChange() {
        return this.isQueryAfterChange;
    }

    public String getNameTrl() {
        return this.NameTrl;
    }

    public String getName() {
        return this.Name;
    }

    public int getAD_Reference_ID() {
        return this.AD_Reference_ID;
    }

    public int getAD_Reference_Value_ID() {
        return this.AD_Reference_Value_ID;
    }

    public String getPlaceHolderTrl() {
        return this.PlaceHolderTrl;
    }

    public String getPlaceholder() {
        return this.Placeholder;
    }

    public String getPlaceholder2() {
        return this.Placeholder2;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getSelectClause() {
        return this.SelectClause;
    }

    public String getDisplayLogic() {
        return this.DisplayLogic;
    }

    public boolean isDisplayed() {
        return this.isDisplayed;
    }

    public String getInputFieldValidation() {
        return this.InputFieldValidation;
    }

    public boolean isIdentifier() {
        return this.isIdentifier;
    }

    public String getQueryOperator() {
        return this.QueryOperator;
    }

    public int getSeqNoSelection() {
        return this.SeqNoSelection;
    }

    public String getQueryFunction() {
        return this.QueryFunction;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public String getDescription() {
        return this.Description;
    }

    public String getDescriptionTrl() {
        return this.DescriptionTrl;
    }

    public MInfoColumn getAD_InfoColumn() {
        return this.infoColumn;
    }

    public int getAD_Val_Rule_ID() {
        return this.AD_Val_Rule_ID;
    }

    public String getDefaultValue() {
        return this.DefaultValue;
    }

    public String getDefaultValue2() {
        return this.DefaultValue2;
    }

    public String getHelpTrl() {
        return this.HelpTrl;
    }

    public String getHelp() {
        return this.Help;
    }

    public int getAD_FieldStyle_ID() {
        return this.AD_FieldStyle_ID;
    }

    public boolean isAutocomplete() {
        return this.isAutocomplete;
    }

    public int getAD_InfoColumn_ID() {
        return this.AD_InfoColumn_ID;
    }

    public String getValidationCode() {
        return this.ValidationCode;
    }

    public int getSeqNo() {
        return this.SeqNo;
    }

    public String getEntityType() {
        return this.EntityType;
    }

    public void setEntityType(String entityType) {
        this.EntityType = entityType;
    }

    public boolean isRange() {
        return this.isRange;
    }
}

