/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.sso;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.adempiere.base.Service;
import org.adempiere.base.sso.ISSOPrincipalFactory;
import org.adempiere.base.sso.ISSOPrincipalService;
import org.compiere.model.I_SSO_PrincipalConfig;
import org.compiere.model.MSSOPrincipalConfig;
import org.compiere.util.CCache;

public class SSOUtils {
    private static final CCache<Integer, ISSOPrincipalService> s_SSOPrincipalServicecache = new CCache(SSOUtils.class.getSimpleName(), 40, 0);
    public static final String ERROR_VALIDATION_URL = "/error.zul";
    public static final String SSO_MODE_OSGI = "SSO_MODE_OSGI";
    public static final String SSO_MODE_WEBUI = "SSO_MODE_WEBUI";
    public static final String SSO_MODE_MONITOR = "SSO_MODE_MONITOR";
    public static final String ISCHANGEROLE_REQUEST = "ISCHANGEROLE_REQUEST";
    public static final String EVENT_ON_AFTER_SSOLOGIN = "onAfterSSOLogin";
    private static ArrayList<String> ignoreResourceURL = null;

    static {
        ignoreResourceURL = new ArrayList();
        ignoreResourceURL.add("zkau");
        ignoreResourceURL.add("images");
        ignoreResourceURL.add("css");
        ignoreResourceURL.add("res");
    }

    public static ISSOPrincipalService getSSOPrincipalService() {
        ISSOPrincipalService principal = null;
        MSSOPrincipalConfig config = MSSOPrincipalConfig.getDefaultSSOPrincipalConfig();
        if (config == null) {
            return null;
        }
        if (s_SSOPrincipalServicecache.containsKey(config.getSSO_PrincipalConfig_ID())) {
            return s_SSOPrincipalServicecache.get(config.getSSO_PrincipalConfig_ID());
        }
        List<ISSOPrincipalFactory> factories = Service.locator().list(ISSOPrincipalFactory.class).getServices();
        for (ISSOPrincipalFactory factory : factories) {
            principal = factory.getSSOPrincipalService(config);
            if (principal == null) continue;
            s_SSOPrincipalServicecache.put(config.getSSO_PrincipalConfig_ID(), principal);
            break;
        }
        return principal;
    }

    public static String getRedirectedURL(String redirectMode, I_SSO_PrincipalConfig config) {
        if (SSO_MODE_OSGI.equalsIgnoreCase(redirectMode)) {
            return config.getSSO_OSGIRedirectURIs();
        }
        if (SSO_MODE_MONITOR.equalsIgnoreCase(redirectMode)) {
            return config.getSSO_IDempMonitorRedirectURIs();
        }
        return config.getSSO_ApplicationRedirectURIs();
    }

    public static String getCreateErrorResponce(String error) {
        return new StringBuffer("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>").append("<html xmlns='http://www.w3.org/1999/xhtml'>").append("<head>").append("<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />").append("<title>iDempiere Server Error</title>").append("<link href='/standard.css' rel='stylesheet'/>").append("</head>").append("<body>").append("<h1>iDempiere Server Error </h1>").append("<p>The iDempiere Server encountered a unrecoverable error.</p>").append("<p>").append(error).append("</p>").append("<h2>Please notify the administrator.</h2>").append("</body>").append("</html>").toString();
    }

    public static boolean isResourceRequest(HttpServletRequest request, boolean isWebUI) {
        String[] urlpath = request.getServletPath().toLowerCase().split("/");
        if (isWebUI) {
            return urlpath != null && urlpath.length > 1 && ignoreResourceURL.contains(urlpath[1]);
        }
        return urlpath != null && urlpath.length > 3 && ignoreResourceURL.contains(urlpath[3]);
    }
}

