/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.util.logging.Level;
import org.adempiere.base.IProcessFactory;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.compiere.process.ProcessCall;
import org.compiere.util.CLogger;

public class DefaultProcessFactory
implements IProcessFactory {
    private static final CLogger log = CLogger.getCLogger(DefaultProcessFactory.class);

    @Override
    public ProcessCall newProcessInstance(String className) {
        ProcessCall process = null;
        process = EquinoxExtensionLocator.instance().locate(ProcessCall.class, "org.adempiere.base.Process", className, null).getExtension();
        if (process == null) {
            ClassLoader classLoader;
            Class<?> processClass;
            block10: {
                processClass = null;
                classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    try {
                        processClass = classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException ex) {
                        if (!log.isLoggable(Level.FINE)) break block10;
                        log.log(Level.FINE, className, ex);
                    }
                }
            }
            if (processClass == null) {
                classLoader = this.getClass().getClassLoader();
                try {
                    processClass = classLoader.loadClass(className);
                }
                catch (ClassNotFoundException ex) {
                    log.log(Level.WARNING, className, ex);
                    return null;
                }
            }
            if (processClass == null) {
                return null;
            }
            try {
                process = (ProcessCall)processClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Instance for " + className, ex);
                return null;
            }
        }
        return process;
    }
}

