/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MSysConfig;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;
import org.zkforge.ckez.CKeditor;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Vlayout;

public class WTextEditorDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -1857623453350849161L;
    private boolean editable;
    private int maxSize;
    private String text;
    private boolean cancelled;
    private Tabbox tabbox;
    private Textbox textBox;
    private CKeditor editor;
    private Label status;
    private Tab htmlTab;
    private boolean isShowHTMLTab = true;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));

    public WTextEditorDialog(String title, String text, boolean editable, int maxSize, boolean IsHtml) {
        this(title, text, editable, maxSize, IsHtml, true);
    }

    public WTextEditorDialog(String title, String text, boolean editable, int maxSize, boolean IsHtml, boolean IsShowHTMLTab) {
        this.setTitle(title);
        this.editable = editable;
        this.maxSize = maxSize;
        this.text = text;
        this.isShowHTMLTab = IsShowHTMLTab;
        this.init();
        if (IsHtml && IsShowHTMLTab) {
            this.tabbox.setSelectedTab(this.htmlTab);
        }
    }

    public WTextEditorDialog(String title, String text, boolean editable, int maxSize) {
        this(title, text, editable, maxSize, false);
    }

    private void init() {
        this.setBorder("normal");
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 450);
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 800);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setStyle("position: absolute;");
        this.setSizable(false);
        this.setSclass("popup-dialog text-editor-dialog");
        Vlayout vbox = new Vlayout();
        this.appendChild((Component)vbox);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)vbox, "true");
        vbox.setSclass("dialog-content");
        this.tabbox = new Tabbox();
        vbox.appendChild((Component)this.tabbox);
        Tabs tabs = new Tabs();
        this.tabbox.appendChild((Component)tabs);
        Tabpanels tabPanels = new Tabpanels();
        this.tabbox.appendChild((Component)tabPanels);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabbox, "1");
        Tab tab = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"Text"));
        tabs.appendChild((Component)tab);
        Tabpanel tabPanel = new Tabpanel();
        tabPanels.appendChild((Component)tabPanel);
        this.textBox = new Textbox(this.text);
        this.textBox.setCols(80);
        this.textBox.setMultiline(true);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.textBox, "100%");
        this.textBox.setEnabled(this.editable);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.textBox, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.textBox, "1");
        tabPanel.appendChild((Component)this.textBox);
        if (this.isShowHTMLTab) {
            this.htmlTab = new Tab("HTML");
            tabs.appendChild((Component)this.htmlTab);
            tabPanel = new Tabpanel();
            tabPanels.appendChild((Component)tabPanel);
            if (this.editable) {
                this.createEditor(tabPanel);
            } else {
                Div div = new Div();
                ZKUpdateUtil.setHeight((HtmlBasedComponent)div, "100%");
                ZKUpdateUtil.setWidth((HtmlBasedComponent)div, "100%");
                div.setStyle("overflow: auto; border: 1px solid");
                tabPanel.appendChild((Component)div);
                Html html = new Html();
                div.appendChild((Component)html);
                html.setContent(this.text);
            }
        }
        vbox.appendChild((Component)new Separator());
        Div footer = new Div();
        footer.setSclass("dialog-footer");
        ConfirmPanel confirmPanel = new ConfirmPanel(true);
        footer.appendChild((Component)confirmPanel);
        confirmPanel.addButton(confirmPanel.createButton("Reset"));
        confirmPanel.addActionListener(this);
        this.appendChild((Component)footer);
        if (this.maxSize > 0) {
            this.status = new Label();
            footer.appendChild((Component)this.status);
            this.updateStatus(this.text.length());
            this.status.setStyle("margin-top:10px;");
            this.textBox.addEventListener("onChange", this);
            if (this.isShowHTMLTab && this.editor != null) {
                this.editor.addEventListener("onChange", (EventListener)this);
            }
        }
        this.tabbox.addEventListener("onSelect", this);
        this.setClosable(true);
        this.setSizable(true);
        this.setMaximizable(true);
        this.addEventListener("onCancel", e -> this.onCancel());
        this.addEventListener("onSize", e -> this.onSize());
        this.addEventListener("onMaximize", e -> this.onSize());
    }

    private void createEditor(org.zkoss.zul.Tabpanel tabPanel) {
        this.editor = new CKeditor();
        if (ClientInfo.isMobile()) {
            this.editor.setCustomConfigurationsPath("/js/ckeditor/config-min.js");
        } else {
            this.editor.setCustomConfigurationsPath("/js/ckeditor/config.js");
        }
        this.editor.setToolbar("MyToolbar");
        HashMap<String, String> lang = new HashMap<String, String>();
        lang.put("language", Language.getLoginLanguage().getAD_Language());
        this.editor.setConfig(lang);
        tabPanel.appendChild((Component)this.editor);
        this.editor.setVflex("1");
        this.editor.setWidth("100%");
        this.editor.setValue(this.text);
    }

    public void onEditorCallback(Event event) {
        this.text = WTextEditorDialog.sanitize((String)event.getData());
        this.detach();
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (event.getTarget().getId().equals("Ok")) {
            if (this.editable) {
                if (this.maxSize > 0) {
                    int currentSize = 0;
                    currentSize = this.tabbox.getSelectedIndex() == 0 ? this.textBox.getText().length() : this.editor.getValue().length();
                    if (currentSize > this.maxSize) {
                        Dialog.error(0, "Error", Msg.getMsg((Properties)Env.getCtx(), (String)"TextEditorDialogCurrentSizeExceedMaxSize", (Object[])new Object[]{currentSize, this.maxSize}));
                        return;
                    }
                }
                if (this.tabbox.getSelectedIndex() == 0) {
                    this.text = this.textBox.getText();
                    this.detach();
                } else {
                    String script = "(function(){let w=zk('#" + this.editor.getUuid() + "').$();let d=w.getEditor().getData();let t=zk('#" + this.getUuid() + "').$();let e=new zk.Event(t,'onEditorCallback',d,{toServer:true});zAu.send(e);})()";
                    Clients.response((AuResponse)new AuScript(script));
                }
            }
        } else if (event.getTarget().getId().equals("Reset")) {
            Dialog.ask(0, "TextEditorDialogResetConfirmation", new org.adempiere.util.Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        WTextEditorDialog.this.textBox.setText(WTextEditorDialog.this.text);
                        if (WTextEditorDialog.this.editor != null) {
                            WTextEditorDialog.this.editor.setValue(WTextEditorDialog.this.text);
                        }
                    }
                }
            });
        } else if (event.getName().equals("onSelect")) {
            if (this.editable) {
                if (this.tabbox.getSelectedIndex() == 0) {
                    this.textBox.setText(this.editor.getValue());
                    this.updateStatus(this.textBox.getText().length());
                } else {
                    this.editor.setValue(this.textBox.getText());
                    this.updateStatus(this.editor.getValue().length());
                }
            }
        } else if (event.getName().equals("onChange")) {
            if (event.getTarget() == this.textBox) {
                this.updateStatus(this.textBox.getText().length());
            } else if (event.getTarget() == this.editor) {
                this.updateStatus(this.editor.getValue().length());
            }
        }
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.cancelled = true;
        this.detach();
    }

    private void onSize() {
        if (this.editor != null) {
            this.editor.invalidate();
        }
    }

    private void updateStatus(int newLength) {
        if (this.status != null && this.maxSize > 0) {
            StringBuilder msg = new StringBuilder();
            msg.append(newLength);
            if (newLength == this.maxSize) {
                msg.append(" = ");
            } else if (newLength < this.maxSize) {
                msg.append(" < ");
            } else {
                msg.append(" > ");
            }
            msg.append(this.maxSize);
            this.status.setValue(msg.toString());
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getText() {
        return this.text;
    }

    public static String sanitize(String untrustedHTML) {
        PolicyFactory policy = Sanitizers.BLOCKS.and(Sanitizers.FORMATTING).and(Sanitizers.IMAGES).and(Sanitizers.LINKS).and(Sanitizers.STYLES).and(Sanitizers.TABLES);
        String ret = policy.sanitize(untrustedHTML);
        ret = ret.replaceAll("&#35;", "#");
        ret = ret.replaceAll("&#64;", "@");
        return ret;
    }
}

