/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.apps.ProcessParameterPanel;
import org.adempiere.webui.apps.form.WProcessParameter;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.VerticalBox;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.GridTab;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcessDrillRule;
import org.compiere.model.MScheduler;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Html;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.Window;

@Form
public class WProcessParameterForm
extends ADForm {
    private static final long serialVersionUID = -2533099650671242190L;
    private WProcessParameter pp;
    private VerticalBox dialogBody;
    private Html message;
    private Panel centerPanel;
    private ProcessInfo processInfo;
    private String m_Name;
    private StringBuffer m_messageText = new StringBuffer();
    private String tableName = "";
    private ProcessParameterPanel parameterPanel;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private static final CLogger log = CLogger.getCLogger(WProcessParameterForm.class);

    public WProcessParameterForm(WProcessParameter wpp) {
        this.pp = wpp;
        this.initComponents();
    }

    @Override
    public Window.Mode getWindowMode() {
        return Window.Mode.HIGHLIGHTED;
    }

    public boolean setVisible(boolean visible) {
        boolean ok = super.setVisible(visible);
        if (visible && this.getProcessInfo() != null && this.parameterPanel == null) {
            this.initForm();
        }
        return ok;
    }

    @Override
    public void onEvent(Event event) throws Exception {
        Component component = event.getTarget();
        if (component instanceof Button) {
            Button element = (Button)component;
            if ("Ok".equalsIgnoreCase(element.getId())) {
                this.onOK();
            } else if ("Cancel".equalsIgnoreCase(element.getId())) {
                this.onCancel();
            }
        } else {
            super.onEvent(event);
        }
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.dispose();
    }

    private void onOK() {
        MPInstancePara[] paras = this.parameterPanel.getParameters();
        GridTab gridTab = super.getGridTab();
        if (gridTab != null) {
            this.tableName = gridTab.getTableName();
        }
        this.pp.saveParameters(paras, this.tableName);
        this.dispose();
    }

    @Override
    protected void initForm() {
        if (this.getProcessInfo() != null) {
            int AD_Process_ID = 0;
            GridTab gridTab = super.getGridTab();
            if (gridTab != null) {
                this.tableName = gridTab.getTableName();
            }
            if (this.tableName.equalsIgnoreCase("AD_Scheduler")) {
                MScheduler scheduler = new MScheduler(Env.getCtx(), this.getProcessInfo().getRecord_ID(), null);
                AD_Process_ID = scheduler.getAD_Process_ID();
            } else if (this.tableName.equalsIgnoreCase("AD_Process_DrillRule")) {
                MProcessDrillRule drillRule = new MProcessDrillRule(Env.getCtx(), this.getProcessInfo().getRecord_ID(), null);
                AD_Process_ID = drillRule.getAD_Process_ID();
            }
            if (AD_Process_ID > 0) {
                this.processInfo = new ProcessInfo("", AD_Process_ID);
                this.init();
            }
        }
        this.setSizable(true);
        this.setClosable(true);
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 500);
        } else {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this, null);
        }
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this, "min");
    }

    private void initComponents() {
        this.setBorder("normal");
        this.dialogBody = new VerticalBox();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.dialogBody, "1");
        Vlayout dialogContent = new Vlayout();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)dialogContent, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)dialogContent, "1");
        dialogContent.setSclass("dialog-content");
        this.dialogBody.appendChild((Component)dialogContent);
        Div div = new Div();
        div.setId("message");
        this.message = new Html();
        div.appendChild((Component)this.message);
        div.setStyle("max-height: 150pt; overflow: auto;");
        dialogContent.appendChild((Component)div);
        this.centerPanel = new Panel();
        dialogContent.appendChild((Component)this.centerPanel);
        Hbox hbox = new Hbox();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)hbox, "100%");
        hbox.setSclass("dialog-footer");
        Button btn = ButtonFactory.createNamedButton("Ok");
        btn.setId("Ok");
        btn.addEventListener("onClick", this);
        hbox.appendChild((Component)btn);
        btn = ButtonFactory.createNamedButton("Cancel");
        btn.setId("Cancel");
        btn.addEventListener("onClick", this);
        hbox.appendChild((Component)btn);
        hbox.setPack("end");
        this.dialogBody.appendChild((Component)hbox);
        this.appendChild((Component)this.dialogBody);
        this.setSclass("popup-dialog process-parameter-form-dialog");
    }

    private boolean init() {
        boolean trl = !Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Process");
        String sql = "SELECT Name, Description, Help, IsReport, ShowHelp FROM AD_Process WHERE AD_Process_ID=?";
        if (trl) {
            sql = "SELECT t.Name, t.Description, t.Help, p.IsReport, p.ShowHelp FROM AD_Process p, AD_Process_Trl t WHERE p.AD_Process_ID=t.AD_Process_ID AND p.AD_Process_ID=? AND t.AD_Language=?";
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, this.processInfo.getAD_Process_ID());
                if (trl) {
                    pstmt.setString(2, Env.getAD_Language((Properties)Env.getCtx()));
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    this.m_Name = rs.getString(1);
                    this.m_messageText.append("<b>");
                    String s = rs.getString(2);
                    if (!rs.wasNull()) {
                        this.m_messageText.append(s);
                    }
                    this.m_messageText.append("</b>");
                    s = rs.getString(3);
                    if (!rs.wasNull()) {
                        this.m_messageText.append("<p>").append(s).append("</p>");
                    }
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql, (Throwable)e);
                DB.close(rs, (Statement)pstmt);
                return false;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        if (this.m_Name == null) {
            return false;
        }
        this.setTitle(this.m_Name);
        this.message.setContent(this.m_messageText.toString());
        this.processInfo.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        this.processInfo.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
        this.processInfo.setTitle(this.m_Name);
        this.parameterPanel = new ProcessParameterPanel(this.m_WindowNo, this.processInfo);
        this.centerPanel.getChildren().clear();
        if (!this.parameterPanel.init()) {
            return false;
        }
        this.centerPanel.appendChild((Component)this.parameterPanel);
        return true;
    }

    public void setWidth(String width) {
        super.setWidth(width);
    }
}

