/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.webservices.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Model;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;
import org.idempiere.webservices.model.MWebServiceMethod;
import org.idempiere.webservices.model.X_WS_WebService;
import org.idempiere.webservices.model.X_WS_WebServiceMethod;

@Model(table="WS_WebService")
public class MWebService
extends X_WS_WebService
implements ImmutablePOSupport {
    private static final long serialVersionUID = 297628235579089311L;
    private MWebServiceMethod[] m_methods = null;
    private static ImmutableIntPOCache<Integer, MWebService> s_cache = new ImmutableIntPOCache("WS_WebService", 20);
    private static final CLogger s_log = CLogger.getCLogger(MWebService.class);

    public static MWebService get(int WS_WebService_ID) {
        return MWebService.get(Env.getCtx(), WS_WebService_ID);
    }

    public static MWebService get(Properties ctx, int WS_WebService_ID) {
        Integer key = WS_WebService_ID;
        MWebService retValue = (MWebService)s_cache.get(ctx, (Object)key, e -> new MWebService(ctx, (MWebService)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWebService(ctx, WS_WebService_ID, null);
        if (retValue.get_ID() == WS_WebService_ID) {
            s_cache.put((Object)key, (PO)retValue, e -> new MWebService(Env.getCtx(), (MWebService)e));
            return retValue;
        }
        return null;
    }

    public static MWebService get(Properties ctx, String webServiceValue) {
        MWebService retValue;
        block10: {
            MWebService[] it;
            if (webServiceValue == null) {
                return null;
            }
            MWebService[] mWebServiceArray = it = s_cache.values().toArray(new MWebService[0]);
            int n = it.length;
            int n2 = 0;
            while (n2 < n) {
                retValue = mWebServiceArray[n2];
                if (webServiceValue.equals(retValue.getValue())) {
                    return retValue;
                }
                ++n2;
            }
            retValue = null;
            String sql = "SELECT * FROM WS_WebService WHERE Value=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setString(1, webServiceValue);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MWebService(ctx, rs, null);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            Integer key = retValue.getWS_WebService_ID();
            s_cache.put((Object)key, (PO)retValue);
        }
        return retValue;
    }

    public MWebServiceMethod[] getMethods(boolean requery) {
        ArrayList<MWebServiceMethod> list;
        block8: {
            if (this.m_methods != null && !requery) {
                return this.m_methods;
            }
            String sql = "SELECT * FROM WS_WebServiceMethod WHERE WS_WebService_ID=? AND IsActive='Y' ORDER BY Value";
            list = new ArrayList<MWebServiceMethod>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getWS_WebService_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MWebServiceMethod(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e2) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e2);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() > 0 && this.is_Immutable()) {
            list.stream().forEach(e -> {
                MWebServiceMethod mWebServiceMethod = e.markImmutable();
            });
        }
        this.m_methods = new MWebServiceMethod[list.size()];
        list.toArray(this.m_methods);
        return this.m_methods;
    }

    public X_WS_WebServiceMethod getMethod(String methodValue) {
        if (methodValue == null || methodValue.length() == 0) {
            return null;
        }
        this.getMethods(false);
        int i2 = 0;
        while (i2 < this.m_methods.length) {
            if (methodValue.equals(this.m_methods[i2].getValue())) {
                return this.m_methods[i2];
            }
            ++i2;
        }
        return null;
    }

    public MWebService(Properties ctx, String WS_WebService_UU, String trxName) {
        super(ctx, WS_WebService_UU, trxName);
    }

    public MWebService(Properties ctx, int WS_WebService_ID, String trxName) {
        super(ctx, WS_WebService_ID, trxName);
    }

    public MWebService(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWebService(MWebService copy) {
        this(Env.getCtx(), copy);
    }

    public MWebService(Properties ctx, MWebService copy) {
        this(ctx, copy, null);
    }

    public MWebService(Properties ctx, MWebService copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_methods = copy.m_methods != null ? (MWebServiceMethod[])Arrays.stream(copy.m_methods).map(e -> new MWebServiceMethod(ctx, (MWebServiceMethod)e, trxName)).toArray(MWebServiceMethod[]::new) : null;
    }

    public MWebService markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_methods != null && this.m_methods.length > 0) {
            Arrays.stream(this.m_methods).forEach(e -> {
                MWebServiceMethod mWebServiceMethod = e.markImmutable();
            });
        }
        return this;
    }
}

