/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.StubEvent;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.EventListenerMap;
import org.zkoss.zk.ui.sys.StubComponent;

public class StubsComponent
extends StubComponent {
    protected String[] _uuids;
    protected String[][] _idmap;
    protected Object[][] _evtmap;

    public void onChildrenMerged(Component replaced, boolean bListener) {
        if (this._uuids != null) {
            throw new IllegalStateException("called twice");
        }
        LinkedList<String> uuids = new LinkedList<String>();
        LinkedList<String[]> idmap = new LinkedList<String[]>();
        LinkedList<Object[]> evtmap = bListener ? new LinkedList<Object[]>() : null;
        Page page = this.getPage();
        this.mapChildren(page != null ? (DesktopCtrl)((Object)page.getDesktop()) : null, uuids, idmap, evtmap, replaced);
        this._uuids = uuids.toArray(new String[uuids.size()]);
        this._idmap = !idmap.isEmpty() ? (String[][])idmap.toArray((T[])new String[idmap.size()][]) : null;
        this._evtmap = evtmap != null && !evtmap.isEmpty() ? (Object[][])evtmap.toArray((T[])new Object[evtmap.size()][]) : null;
    }

    protected void mapChildren(DesktopCtrl desktopCtrl, List<String> uuids, List<String[]> idmap, List<Object[]> evtmap, Component comp) {
        for (Component p = comp.getFirstChild(); p != null; p = p.getNextSibling()) {
            EventListenerMap em;
            String id;
            if (p instanceof StubsComponent) {
                Object[][] kidevts;
                String[][] kidids;
                String[] kiduuids = ((StubsComponent)p)._uuids;
                if (kiduuids != null) {
                    for (String uuid : kiduuids) {
                        uuids.add(uuid);
                        if (desktopCtrl == null) continue;
                        desktopCtrl.mapComponent(uuid, this);
                    }
                }
                if ((kidids = ((StubsComponent)p)._idmap) != null) {
                    for (String[] idinf : kidids) {
                        idmap.add(idinf);
                    }
                }
                if (evtmap != null && (kidevts = ((StubsComponent)p)._evtmap) != null) {
                    for (Object[] evtinf : kidevts) {
                        evtmap.add(evtinf);
                    }
                }
            }
            String uuid = p.getUuid();
            uuids.add(uuid);
            if (desktopCtrl != null) {
                desktopCtrl.mapComponent(uuid, this);
            }
            if ((id = p.getId()) != null && id.length() > 0) {
                idmap.add(new String[]{uuid, id});
            }
            if (evtmap != null && (em = ((ComponentCtrl)((Object)p)).getEventListenerMap()) != null) {
                evtmap.add(new Object[]{uuid, em});
            }
            this.mapChildren(desktopCtrl, uuids, idmap, evtmap, p);
        }
    }

    @Override
    public String getId(String uuid) {
        if (this._idmap != null) {
            for (String[] idinf : this._idmap) {
                if (!uuid.equals(idinf[0])) continue;
                return idinf[1];
            }
        }
        return super.getId(uuid);
    }

    @Override
    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)newpage.getDesktop());
            for (String uuid : this._uuids) {
                desktopCtrl.mapComponent(uuid, this);
            }
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)page.getDesktop());
        for (String uuid : this._uuids) {
            desktopCtrl.mapComponent(uuid, null);
        }
    }

    @Override
    public void service(Event event, Scope scope) throws Exception {
        String uuid;
        StubEvent stubevt = event instanceof StubEvent ? (StubEvent)event : null;
        String string = uuid = stubevt != null ? stubevt.getUuid() : null;
        if (uuid == null || uuid.equals(this.getUuid())) {
            super.service(event, scope);
        } else if (this._evtmap != null) {
            for (Object[] evtinf : this._evtmap) {
                if (!uuid.equals(evtinf[0])) continue;
                ((EventListenerMap)evtinf[1]).service(event, scope, this, stubevt.getCommand());
                break;
            }
            this.postToNonStubAncestor(stubevt);
        }
    }

    @Override
    public String getWidgetClass() {
        return "#stubs";
    }

    @Override
    protected boolean isChildable() {
        return false;
    }

    @Override
    public String toString() {
        int j;
        StringBuffer sb = new StringBuffer(super.toString());
        if (this._uuids != null) {
            sb.append('(');
            for (j = 0; j < this._uuids.length; ++j) {
                if (j != 0) {
                    sb.append(", ");
                }
                sb.append(this._uuids[j]);
            }
            sb.append(')');
        }
        if (this._idmap != null) {
            sb.append('(');
            for (j = 0; j < this._idmap.length; ++j) {
                if (j != 0) {
                    sb.append(", ");
                }
                sb.append(this._idmap[j][0]).append('=').append(this._idmap[j][1]);
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

