/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

public class Reflections {
    public static <A extends Annotation> void forFields(Class<?> clazz, Class<A> annotationClass, FieldRunner<A> runner) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                A anno = f.getAnnotation(annotationClass);
                if (anno == null) continue;
                f.setAccessible(true);
                runner.onField(c, f, anno);
            }
        }
    }

    public static <A extends Annotation> void forMethods(Class<?> clazz, Class<A> annotationClass, MethodRunner<A> runner) {
        for (Method m : clazz.getMethods()) {
            A anno = m.getAnnotation(annotationClass);
            if (anno == null) continue;
            m.setAccessible(true);
            runner.onMethod(clazz, m, anno);
        }
    }

    public static boolean isAppendableToCollection(Type type, Object object) {
        Class<?> aClass;
        if (!Collection.class.isAssignableFrom(Reflections.getClass(type))) {
            return false;
        }
        if (type instanceof ParameterizedType && (aClass = Reflections.getClass(((ParameterizedType)type).getActualTypeArguments()[0])) != null) {
            return aClass.isAssignableFrom(object.getClass());
        }
        return type instanceof Class;
    }

    public static boolean isPassableToMethod(Method method, Object ... arguments) {
        Type[] types = method.getGenericParameterTypes();
        if (types.length != arguments.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            Class<?> aClass = Reflections.getClass(types[i]);
            if (aClass == null || aClass.isAssignableFrom(arguments[i].getClass())) continue;
            return false;
        }
        return true;
    }

    public static void setFieldValue(Object bean, Field field, Object value) {
        try {
            field.set(bean, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("IllegalStateException @ setFieldValue");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("IllegalAccessException @ setFieldValue");
        }
    }

    public static Object getFieldValue(Object bean, Field field) {
        try {
            return field.get(bean);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("IllegalStateException @ getFieldValue");
        }
    }

    public static void addToCollectionField(Object owner, Field field, Object item) {
        if (!Reflections.isAppendableToCollection(field.getGenericType(), item)) {
            throw new IllegalArgumentException(item + " is not appendable to " + field);
        }
        try {
            field.setAccessible(true);
            Collection c = (Collection)field.get(owner);
            if (c == null) {
                throw new IllegalArgumentException(field + " has not been initiated.");
            }
            c.add(item);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void invokeMethod(Method method, Object bean, Object ... arguments) {
        if (!Reflections.isPassableToMethod(method, arguments)) {
            throw new IllegalArgumentException("Arguments does not match method signature: " + method);
        }
        method.setAccessible(true);
        try {
            method.invoke(bean, arguments);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getClass(Type type) {
        Class<?> c;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Reflections.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType && (c = Reflections.getClass(((GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(c, 0).getClass();
        }
        return null;
    }

    public static interface MethodRunner<A extends Annotation> {
        public void onMethod(Class<?> var1, Method var2, A var3);
    }

    public static interface FieldRunner<A extends Annotation> {
        public void onField(Class<?> var1, Field var2, A var3);
    }
}

