/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.Serializable;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.resource.ContentLoader;
import org.zkoss.util.resource.Loader;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.zk.scripting.Interpreters;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.EvaluatorRef;
import org.zkoss.zk.xel.ExValue;

public class ZScript
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ZScript.class);
    private EvaluatorRef _evalr;
    private String _zslang;
    private final String _cnt;
    private final Object _url;
    private final Locator _locator;

    public static final ZScript parseContent(String content) {
        return ZScript.parseContent(content, 0);
    }

    public static final ZScript parseContent(String content, int lineno) {
        int len;
        String prefix = null;
        String zslang = null;
        int n = len = content != null ? content.length() : 0;
        if (len > 0) {
            if (lineno > 1) {
                StringBuffer sb = new StringBuffer(lineno);
                while (--lineno > 0) {
                    sb.append('\n');
                }
                prefix = sb.toString();
            }
            for (int j = 0; j < len; ++j) {
                char cc = content.charAt(j);
                if (cc == ':') {
                    if (j <= 0) break;
                    zslang = content.substring(0, j);
                    if (Interpreters.exists(zslang)) {
                        content = content.substring(j + 1);
                        break;
                    }
                    log.warn("Ignored: unknown scripting language, " + zslang);
                    break;
                }
                if (!Interpreters.isLegalName(cc)) break;
            }
        }
        return new ZScript(zslang, (String)(prefix != null && content.length() > 0 ? prefix + content : content));
    }

    public ZScript(String zslang, String content) {
        this._zslang = zslang;
        this._cnt = content != null ? content : "";
        this._url = null;
        this._locator = null;
    }

    public ZScript(String zslang, URL url) {
        if (url == null) {
            throw new IllegalArgumentException("null");
        }
        this._zslang = zslang;
        this._url = url;
        this._cnt = null;
        this._locator = null;
    }

    public ZScript(EvaluatorRef evalr, String zslang, String url, Locator locator) {
        if (url == null || locator == null) {
            throw new IllegalArgumentException("null");
        }
        this._evalr = evalr;
        this._zslang = zslang;
        this._url = new ExValue(url, String.class);
        this._cnt = null;
        this._locator = locator;
        if (evalr == null && ((ExValue)this._url).isExpression()) {
            throw new IllegalArgumentException("evalr required since EL is used: " + url);
        }
    }

    public String getLanguage() {
        return this._zslang;
    }

    public void setLanguage(String zslang) {
        this._zslang = zslang;
    }

    public String getRawContent() {
        return this._cnt;
    }

    public String getContent(Page page, Component comp) {
        String o;
        URL url;
        if (this._cnt != null) {
            return this._cnt;
        }
        if (this._url instanceof ExValue) {
            String s = (String)(comp != null ? ((ExValue)this._url).getValue((Evaluator)this._evalr, comp) : ((ExValue)this._url).getValue((Evaluator)this._evalr, page));
            if (s == null || s.isEmpty()) {
                throw new UiException("The zscript URL, " + this._url + ", is evaluated to \"" + s + "\"");
            }
            url = this._locator.getResource(s);
            if (url == null) {
                throw new UiException("File not found: " + s + " (evaluated from " + this._url + ")");
            }
        } else {
            url = (URL)this._url;
        }
        if ((o = (String)ZScript.getCache().get((Object)url)) == null) {
            throw new UiException("File not found: " + this._url);
        }
        return o;
    }

    void setEvaluatorRef(EvaluatorRef evalr) {
        this._evalr = evalr;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40).append("[zscript: ");
        if (this._url != null) {
            sb.append(this._url);
        } else {
            int len = this._cnt.length();
            if (len > 20) {
                sb.append(this._cnt, 0, 16).append("...");
            } else {
                sb.append(this._cnt);
            }
        }
        return sb.append(']').toString();
    }

    private static ResourceCache<Object, String> getCache() {
        return CacheHolder.INSTANCE;
    }

    private static class CacheHolder {
        private static final ResourceCache<Object, String> INSTANCE = CacheHolder.initializeCache();

        private CacheHolder() {
        }

        private static ResourceCache<Object, String> initializeCache() {
            ResourceCache cache = new ResourceCache((Loader)new ContentLoader());
            cache.setMaxSize(512);
            cache.setLifetime(3600000);
            return cache;
        }
    }
}

