/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.text.DateFormatInfo;
import org.zkoss.text.DateFormats;
import org.zkoss.util.TimeZones;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.sys.SessionsCtrl;

public class I18Ns {
    private static final Logger log = LoggerFactory.getLogger(I18Ns.class);
    private static final String ATTR_SETUP = "org.zkoss.zk.ui.http.charset.setup";
    private static final String PX_PREFERRED_TIME_ZONE = "px_preferred_time_zone";

    public static final Object setup(Session sess, ServletRequest request, ServletResponse response, String charset) {
        return I18Ns.setup((Object)sess, request, response, charset);
    }

    public static final Object setup(HttpSession sess, ServletRequest request, ServletResponse response, String charset) {
        return I18Ns.setup((Object)sess, request, response, charset);
    }

    private static final Object setup(Object sess, ServletRequest request, ServletResponse response, String charset) {
        Object[] old;
        if (request.getAttribute(ATTR_SETUP) != null) {
            old = null;
        } else {
            HttpSession hsess;
            if (sess instanceof Session) {
                Session se = (Session)sess;
                se.getWebApp().getConfiguration().invokeRequestInterceptors(se, request, response);
                hsess = (HttpSession)se.getNativeSession();
            } else {
                hsess = (HttpSession)sess;
            }
            Object ol = Charsets.setup((HttpSession)hsess, (ServletRequest)request, (ServletResponse)response, (String)charset);
            TimeZone tz = I18Ns.getTimeZone(hsess);
            TimeZone otz = TimeZones.setThreadLocal((TimeZone)tz);
            DateFormatInfo dfinfo = I18Ns.getDateFormatInfo(hsess);
            DateFormatInfo odi = DateFormats.setLocalFormatInfo((DateFormatInfo)dfinfo);
            request.setAttribute(ATTR_SETUP, (Object)Boolean.TRUE);
            old = new Object[]{ol, otz, odi};
        }
        if (sess instanceof Session) {
            SessionsCtrl.setCurrent((Session)sess);
        }
        return old;
    }

    private static TimeZone getTimeZone(HttpSession hsess) {
        TimeZone tz = I18Ns.checkTimeZone(hsess.getAttribute("org.zkoss.web.preferred.timeZone"));
        if (tz != null) {
            return tz;
        }
        tz = I18Ns.checkTimeZone(hsess.getAttribute(PX_PREFERRED_TIME_ZONE));
        if (tz != null) {
            return tz;
        }
        tz = I18Ns.checkTimeZone(hsess.getServletContext().getAttribute("org.zkoss.web.preferred.timeZone"));
        if (tz != null) {
            return tz;
        }
        tz = I18Ns.checkTimeZone(hsess.getServletContext().getAttribute(PX_PREFERRED_TIME_ZONE));
        if (tz != null) {
            return tz;
        }
        String s = Library.getProperty((String)"org.zkoss.web.preferred.timeZone");
        return s != null ? TimeZone.getTimeZone(s) : null;
    }

    private static DateFormatInfo getDateFormatInfo(HttpSession hsess) {
        DateFormatInfo fi = I18Ns.checkDateFormatInfo(hsess.getAttribute("org.zkoss.web.preferred.dateFormatInfo"));
        if (fi != null) {
            return fi;
        }
        fi = I18Ns.checkDateFormatInfo(hsess.getServletContext().getAttribute("org.zkoss.web.preferred.dateFormatInfo"));
        if (fi != null) {
            return fi;
        }
        String s = Library.getProperty((String)"org.zkoss.web.preferred.dateFormatInfo");
        if (s != null) {
            try {
                return I18Ns.checkDateFormatInfo(Classes.newInstanceByThread((String)s));
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + s, ex);
            }
        }
        return null;
    }

    private static TimeZone checkTimeZone(Object tz) {
        if (tz != null && !(tz instanceof TimeZone)) {
            log.warn("org.zkoss.web.preferred.timeZone ignored. TimeZone required, not " + tz.getClass());
            return null;
        }
        return (TimeZone)tz;
    }

    private static DateFormatInfo checkDateFormatInfo(Object o) {
        if (o == null || o instanceof DateFormatInfo) {
            return (DateFormatInfo)o;
        }
        try {
            if (o instanceof String) {
                o = Classes.forNameByThread((String)((String)o));
            }
            if (o instanceof Class) {
                return (DateFormatInfo)((Class)o).newInstance();
            }
        }
        catch (Throwable ex) {
            log.warn("org.zkoss.web.preferred.dateFormatInfo ignored. Failed to instantiate " + o, ex);
            return null;
        }
        log.warn("org.zkoss.web.preferred.dateFormatInfo ignored. DateFormatInfo required, not " + o.getClass());
        return null;
    }

    public static final void cleanup(ServletRequest request, Object old) {
        if (old != null) {
            request.removeAttribute(ATTR_SETUP);
            SessionsCtrl.setCurrent((Session)null);
            Object[] op = (Object[])old;
            TimeZones.setThreadLocal((TimeZone)((TimeZone)op[1]));
            DateFormats.setLocalFormatInfo((DateFormatInfo)((DateFormatInfo)op[2]));
            Charsets.cleanup((ServletRequest)request, (Object)op[0]);
        }
    }

    public static final void setPreferredTimeZone(HttpSession hsess, TimeZone timezone) {
        if (timezone != null) {
            hsess.setAttribute("org.zkoss.web.preferred.timeZone", (Object)timezone);
        } else {
            hsess.removeAttribute("org.zkoss.web.preferred.timeZone");
            hsess.removeAttribute(PX_PREFERRED_TIME_ZONE);
        }
    }

    public static final void setPreferredTimeZone(ServletContext ctx, TimeZone timezone) {
        if (timezone != null) {
            ctx.setAttribute("org.zkoss.web.preferred.timeZone", (Object)timezone);
        } else {
            ctx.removeAttribute("org.zkoss.web.preferred.timeZone");
            ctx.removeAttribute(PX_PREFERRED_TIME_ZONE);
        }
    }
}

