/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.util.List;
import org.zkoss.lang.Generics;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlShadowElement;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.Template;

public class Templates {
    public static Template lookup(Component comp, String name) {
        return Templates.lookup(comp, comp, name);
    }

    public static Template lookup(Component comp, Component base, String name) {
        return Templates.lookup(comp, base, name, null);
    }

    public static Template lookup(Component comp, Component base, String name, Component compBase) {
        return Templates.lookup(comp, base, name, compBase, false);
    }

    public static Template lookup(Component comp, Component base, String name, Component compBase, boolean excludeBase) {
        Template template;
        if (comp == null) {
            return null;
        }
        Template template2 = template = excludeBase && comp == base ? null : comp.getTemplate(name);
        if (template == null && !"".equals(name)) {
            Component parent;
            ComponentCtrl cCtrl;
            List list;
            if (comp instanceof ShadowElement) {
                Component shadowHost = ((ShadowElement)((Object)comp)).getShadowHost();
                return Templates.lookup(shadowHost != null ? shadowHost : comp.getParent(), base, name, null, excludeBase);
            }
            if (comp instanceof ComponentCtrl && !(list = (cCtrl = (ComponentCtrl)((Object)comp)).getShadowRoots()).isEmpty()) {
                for (ShadowElement sh : list) {
                    if (sh == base || !(sh instanceof HtmlShadowElement) || excludeBase && base.getClass().isInstance(sh)) continue;
                    HtmlShadowElement shadow = (HtmlShadowElement)sh;
                    Template tmp = shadow.getTemplate(name);
                    if (tmp != null) {
                        if (template == null) {
                            template = tmp;
                        }
                        if (compBase == null) continue;
                        switch (HtmlShadowElement.inRange(shadow, compBase)) {
                            case FIRST: 
                            case IN_RANGE: 
                            case LAST: {
                                template = tmp;
                            }
                        }
                        continue;
                    }
                    if (template != null) continue;
                    switch (HtmlShadowElement.inRange(shadow, compBase)) {
                        case FIRST: 
                        case IN_RANGE: 
                        case LAST: {
                            template = Templates.findShadowChildTemplate(shadow, compBase, name);
                        }
                    }
                }
                if (template != null) {
                    return template;
                }
            }
            if ((parent = comp.getParent()) != null) {
                return Templates.lookup(parent, base, name, comp, excludeBase);
            }
            template = comp.getPage().getTemplate(name);
        }
        return template;
    }

    private static Template findShadowChildTemplate(HtmlShadowElement shadow, Component compBase, String name) {
        List children = Generics.cast(shadow.getChildren());
        if (!children.isEmpty()) {
            for (ShadowElement child : children) {
                if (!(child instanceof HtmlShadowElement)) continue;
                HtmlShadowElement current = (HtmlShadowElement)child;
                switch (HtmlShadowElement.inRange(current, compBase)) {
                    case FIRST: 
                    case IN_RANGE: 
                    case LAST: {
                        Template t = Templates.findShadowChildTemplate(current, compBase, name);
                        if (t != null) {
                            return t;
                        }
                        t = current.getTemplate(name);
                        if (t == null) break;
                        return t;
                    }
                }
            }
        }
        return null;
    }
}

