/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.zkoss.html.HTMLs;
import org.zkoss.idom.Namespace;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.DynamicTag;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.ext.render.DirectContent;
import org.zkoss.zk.ui.ext.render.PrologAllowed;
import org.zkoss.zk.ui.impl.NativeHelpers;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.sys.StringPropertyAccess;

public class HtmlNativeComponent
extends AbstractComponent
implements DynamicTag,
Native {
    private static final Native.Helper _helper = new HtmlHelper();
    private static final String ATTR_RENDER_CONTEXT = "org.zkoss.zk.native.renderContext";
    private String _tag;
    private String _prolog = "";
    private String _epilog = "";
    private String _prefix;
    private String _postfix;
    private Map<String, Object> _props;
    private List<Namespace> _dns;
    private static final String ATTR_TOP_NATIVE = "zkHtmlTopNative";
    private static HashMap<String, PropertyAccess> _properties = new HashMap(5);

    public HtmlNativeComponent() {
    }

    public HtmlNativeComponent(String tag) {
        this.setTag(tag);
    }

    public HtmlNativeComponent(String tag, String prolog, String epilog) {
        this(tag);
        this._prolog = prolog != null ? prolog : "";
        this._epilog = epilog != null ? epilog : "";
    }

    @Override
    public String getWidgetClass() {
        return "zk.Native";
    }

    public String getTag() {
        return this._tag;
    }

    @Override
    public List<Namespace> getDeclaredNamespaces() {
        if (this._dns != null) {
            return this._dns;
        }
        return Collections.emptyList();
    }

    @Override
    public void addDeclaredNamespace(Namespace ns) {
        if (ns == null) {
            throw new IllegalArgumentException();
        }
        if (this._dns == null) {
            this._dns = new LinkedList<Namespace>();
        }
        this._dns.add(ns);
    }

    @Override
    public String getPrologContent() {
        return this._prolog;
    }

    @Override
    public void setPrologContent(String prolog) {
        this._prolog = prolog != null ? prolog : "";
    }

    @Override
    public String getEpilogContent() {
        return this._epilog;
    }

    @Override
    public void setEpilogContent(String epilog) {
        this._epilog = epilog != null ? epilog : "";
    }

    @Override
    public Native.Helper getHelper() {
        return _helper;
    }

    @Override
    public boolean setVisible(boolean visible) {
        throw new UnsupportedOperationException("Use client-dependent attribute, such as display:none");
    }

    @Override
    public void redraw(Writer out) throws IOException {
        String tn;
        boolean root;
        Execution exec = Executions.getCurrent();
        boolean bl = root = this.getParent() == null && (this.getPage().isComplete() || exec != null && "complete".equals(ExecutionsCtrl.getPageRedrawControl(exec)));
        if (exec == null || exec.isAsyncUpdate(null) || !root && !HtmlPageRenders.isDirectContent(exec)) {
            super.redraw(out);
            return;
        }
        Writer oldout = null;
        if (exec != null && !HtmlPageRenders.isZkTagsGenerated(exec) && exec.getAttribute(ATTR_TOP_NATIVE) == null && (root || "html".equals(tn = this._tag != null ? this._tag.toLowerCase(Locale.ENGLISH) : "") || "body".equals(tn) || "head".equals(tn))) {
            exec.setAttribute(ATTR_TOP_NATIVE, Boolean.TRUE);
            oldout = out;
            out = new StringWriter();
        }
        out.write(this.getPrologHalf());
        Component child = this.getFirstChild();
        if (child == null) {
            if (root) {
                HtmlPageRenders.outStandalone(exec, null, out);
            }
        } else {
            Component next;
            if (root) {
                HtmlPageRenders.setDirectContent(exec, true);
            }
            do {
                next = child.getNextSibling();
                if (child instanceof Native || ((ComponentCtrl)((Object)child)).getExtraCtrl() instanceof DirectContent) {
                    ((ComponentCtrl)((Object)child)).redraw(out);
                    continue;
                }
                HtmlPageRenders.setDirectContent(exec, false);
                HtmlPageRenders.outStandalone(exec, child, out);
                HtmlPageRenders.setDirectContent(exec, true);
            } while ((child = next) != null);
        }
        out.write(this.getEpilogHalf());
        if (oldout != null) {
            exec.removeAttribute(ATTR_TOP_NATIVE);
            StringBuffer sb = ((StringWriter)out).getBuffer();
            if (!HtmlPageRenders.isZkTagsGenerated(exec)) {
                String zktags;
                String msg;
                int jhead = -1;
                int junav = -1;
                int head = -1;
                int heade = -1;
                int html = -1;
                int j = 0;
                int len = sb.length();
                while ((j = sb.indexOf("<", j)) >= 0) {
                    if (jhead < 0 && HtmlNativeComponent.startsWith(sb, "zkhead", ++j)) {
                        int l = Strings.indexOf((StringBuffer)sb, (char)'>', (int)j) + 1;
                        jhead = --j;
                        sb.delete(jhead, l);
                        len = sb.length();
                        continue;
                    }
                    if (head < 0 && HtmlNativeComponent.startsWith(sb, "head", j)) {
                        head = Strings.indexOf((StringBuffer)sb, (char)'>', (int)j) + 1;
                        continue;
                    }
                    if (html < 0 && HtmlNativeComponent.startsWith(sb, "html", j)) {
                        html = Strings.indexOf((StringBuffer)sb, (char)'>', (int)j) + 1;
                        continue;
                    }
                    if (junav < 0 && HtmlNativeComponent.startsWith(sb, "body", j)) {
                        junav = Strings.indexOf((StringBuffer)sb, (char)'>', (int)j) + 1;
                        break;
                    }
                    if (sb.charAt(j) != '/' || !HtmlNativeComponent.startsWith(sb, "head", ++j)) continue;
                    heade = j - 2;
                }
                boolean disableUnavailable = false;
                if (jhead < 0 && (jhead = head) < 0 && (jhead = heade) < 0 && (jhead = junav) < 0 && (jhead = html) < 0) {
                    String tn2;
                    if (this._tag != null && ("div".equals(tn2 = this._tag.toLowerCase(Locale.ENGLISH)) || "span".equals(tn2))) {
                        int len2 = sb.length();
                        block6: for (int j2 = 0; j2 < len2; ++j2) {
                            switch (sb.charAt(j2)) {
                                case '>': {
                                    disableUnavailable = true;
                                    jhead = j2 + 1;
                                }
                                case '\"': 
                                case '=': {
                                    break block6;
                                }
                                default: {
                                    continue block6;
                                }
                            }
                        }
                    }
                    if (jhead < 0) {
                        jhead = 0;
                    }
                }
                if ((msg = HtmlPageRenders.outUnavailable(exec)) != null && !disableUnavailable) {
                    if (junav < 0 && html >= 0) {
                        junav = sb.lastIndexOf("</html");
                    }
                    if (junav >= 0) {
                        sb.insert(junav < jhead ? jhead : junav, msg);
                    } else {
                        sb.append(msg);
                    }
                }
                if ((zktags = HtmlPageRenders.outHeaderZkTags(exec, this.getPage())) != null) {
                    sb.insert(jhead, zktags);
                }
            }
            oldout.write(sb.toString());
        }
    }

    private static boolean startsWith(StringBuffer sb, String tag, int start) {
        char cc;
        int end = start + tag.length();
        return !(sb.length() <= end || !tag.equalsIgnoreCase(sb.substring(start, end)) || (cc = sb.charAt(end)) >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z');
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "prolog", this.getPrologHalf());
        this.render(renderer, "epilog", this.getEpilogHalf());
    }

    private String getPrologHalf() {
        StringBuffer sb = new StringBuffer(128);
        Native.Helper helper = this.getHelper();
        if (this._prefix != null) {
            sb.append(this._prefix);
        }
        helper.getFirstHalf(sb, this._tag, this._props, this._dns);
        sb.append(this._prolog);
        return sb.toString();
    }

    private String getEpilogHalf() {
        StringBuffer sb = new StringBuffer(128);
        Native.Helper helper = this.getHelper();
        sb.append(this._epilog);
        helper.getSecondHalf(sb, this._tag);
        if (this._postfix != null) {
            sb.append(this._postfix);
        }
        return sb.toString();
    }

    @Override
    public void setTag(String tag) throws WrongValueException {
        this._tag = tag != null && tag.length() > 0 ? tag : null;
    }

    @Override
    public boolean hasTag(String tag) {
        return true;
    }

    @Override
    public boolean hasDynamicProperty(String name) {
        return ComponentsCtrl.isReservedAttribute(name);
    }

    @Override
    public Object getDynamicProperty(String name) {
        return this._props != null ? this._props.get(name) : null;
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return this._props;
    }

    @Override
    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        if (name == null) {
            throw new WrongValueException("name required");
        }
        if (value == null) {
            if (this._props != null) {
                this._props.remove(name);
            }
        } else {
            if (this._props == null) {
                this._props = new LinkedHashMap<String, Object>();
            }
            if ("sclass".equals(name)) {
                this._props.put("class", value);
            } else {
                this._props.put(name, value);
            }
        }
    }

    @Override
    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    @Override
    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        _properties.put("id", new StringPropertyAccess(){

            @Override
            public void setValue(Component cmp, String value) {
                ((HtmlNativeComponent)cmp).setId(value);
            }

            @Override
            public String getValue(Component cmp) {
                return ((HtmlNativeComponent)cmp).getId();
            }
        });
        _properties.put("tag", new StringPropertyAccess(){

            @Override
            public void setValue(Component cmp, String value) {
                ((HtmlNativeComponent)cmp).setTag(value);
            }

            @Override
            public String getValue(Component cmp) {
                return ((HtmlNativeComponent)cmp).getTag();
            }
        });
        _properties.put("epilogContent", new StringPropertyAccess(){

            @Override
            public void setValue(Component cmp, String value) {
                ((HtmlNativeComponent)cmp).setEpilogContent(value);
            }

            @Override
            public String getValue(Component cmp) {
                return ((HtmlNativeComponent)cmp).getEpilogContent();
            }
        });
        _properties.put("prologContent", new StringPropertyAccess(){

            @Override
            public void setValue(Component cmp, String value) {
                ((HtmlNativeComponent)cmp).setPrologContent(value);
            }

            @Override
            public String getValue(Component cmp) {
                return ((HtmlNativeComponent)cmp).getPrologContent();
            }
        });
    }

    protected class ExtraCtrl
    implements DirectContent,
    PrologAllowed {
        protected ExtraCtrl() {
        }

        @Override
        public void setPrologContent(String prolog) {
            HtmlNativeComponent.this._prefix = prolog;
        }
    }

    public static class HtmlHelper
    implements Native.Helper {
        @Override
        public Component newNative(String text) {
            HtmlNativeComponent nc = new HtmlNativeComponent();
            if (text != null) {
                nc.setPrologContent(text);
            }
            return nc;
        }

        @Override
        public void getFirstHalf(StringBuffer sb, String tag, Map<String, Object> props, Collection<Namespace> namespaces) {
            if (tag != null) {
                sb.append('<').append(tag);
            }
            NativeHelpers.getAttributes(sb, props, namespaces);
            if (tag != null) {
                String tn = tag.toLowerCase(Locale.ENGLISH);
                if ("zkhead".equals(tn) || HTMLs.isOrphanTag((String)tn)) {
                    sb.append('/');
                }
                sb.append('>');
            }
        }

        @Override
        public void getSecondHalf(StringBuffer sb, String tag) {
            if (tag != null) {
                String tn = tag.toLowerCase(Locale.ENGLISH);
                if ("zkhead".equals(tn) || HTMLs.isOrphanTag((String)tn)) {
                    return;
                }
                sb.append("</").append(tag).append('>');
            }
        }

        @Override
        public void appendText(StringBuffer sb, String text) {
            sb.append(text);
        }
    }
}

