/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.device;

import java.io.IOException;
import java.util.Locale;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.DeviceConfig;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.sys.ServerPush;

public abstract class GenericDevice
implements Device {
    private String _type;
    private String _uamsg;
    private Class _spushcls;
    private String _embed;

    @Override
    public boolean isSupported(int func) {
        return false;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public Boolean isCompatible(String userAgent) {
        return null;
    }

    @Override
    public String getUnavailableMessage() {
        return this._uamsg;
    }

    @Override
    public String setUnavailableMessage(String msg) {
        String old = this._uamsg;
        this._uamsg = msg != null && msg.length() > 0 ? msg : null;
        return old;
    }

    @Override
    public Class setServerPushClass(Class cls) {
        if (cls != null && !ServerPush.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("ServerPush not implemented: " + cls);
        }
        Class old = this._spushcls;
        this._spushcls = cls;
        return old;
    }

    @Override
    public Class getServerPushClass() {
        return this._spushcls;
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public void addEmbedded(String content) {
        if (content != null && content.length() > 0) {
            this._embed = this._embed != null ? this._embed + "\n" + content : content;
        }
    }

    @Override
    public String getEmbedded() {
        return this._embed;
    }

    @Override
    public Object[] matches(String userAgent) {
        return null;
    }

    @Override
    public void reloadMessages(Locale locale) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String packageToPath(String pkg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toAbsolutePath(String path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void init(String type, DeviceConfig config) {
        this._type = type;
        this._uamsg = config.getUnavailableMessage();
        this._spushcls = config.getServerPushClass();
        this._embed = config.getEmbedded();
    }

    @Override
    public void sessionWillPassivate(Desktop desktop) {
    }

    @Override
    public void sessionDidActivate(Desktop desktop) {
    }
}

