/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Generics;
import org.zkoss.mesg.Messages;
import org.zkoss.util.resource.Labels;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ClassWebResource;
import org.zkoss.xml.XMLs;
import org.zkoss.zk.au.AuDecoder;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.AuWriters;
import org.zkoss.zk.au.RequestOutOfSequenceException;
import org.zkoss.zk.au.http.AuDynaMediar;
import org.zkoss.zk.au.http.AuExtension;
import org.zkoss.zk.au.http.AuMultipartUploader;
import org.zkoss.zk.au.http.DHtmlResourceServlet;
import org.zkoss.zk.au.out.AuConfirmClose;
import org.zkoss.zk.au.out.AuObsolete;
import org.zkoss.zk.au.out.AuSendRedirect;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.ActivationTimeoutException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.SessionResolverImpl;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.URIInfo;

public class DHtmlUpdateServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DHtmlUpdateServlet.class);
    private static final String ATTR_UPDATE_SERVLET = "org.zkoss.zk.au.http.updateServlet";
    private static final String ATTR_AU_PROCESSORS = "org.zkoss.zk.au.http.auProcessors";
    private final AtomicLong _lastModified = new AtomicLong();
    private final Map<String, AuExtension> _aues = new ConcurrentHashMap<String, AuExtension>(8);
    private boolean _compress = true;
    private static final AuDecoder _audec = new AuDecoder(){

        @Override
        public String getDesktopId(Object request) {
            return ((HttpServletRequest)request).getParameter("dtid");
        }

        @Override
        public String getFirstCommand(Object request) {
            return ((HttpServletRequest)request).getParameter("cmd_0");
        }

        @Override
        public List<AuRequest> decode(Object request, Desktop desktop) {
            String cmdId;
            LinkedList<AuRequest> aureqs = new LinkedList<AuRequest>();
            HttpServletRequest hreq = (HttpServletRequest)request;
            int j = 0;
            while ((cmdId = hreq.getParameter("cmd_" + j)) != null) {
                String uuid = hreq.getParameter("uuid_" + j);
                String data = hreq.getParameter("data_" + j);
                Map decdata = (Map)JSONValue.parse((String)data);
                aureqs.add(uuid == null || uuid.isEmpty() ? new AuRequest(desktop, cmdId, decdata) : new AuRequest(desktop, uuid, cmdId, decdata));
                ++j;
            }
            return aureqs;
        }

        @Override
        public boolean isIgnorable(Object request, WebApp wapp) {
            HttpServletRequest hreq = (HttpServletRequest)request;
            int j = 0;
            while (hreq.getParameter("cmd_" + j) != null) {
                String opt = hreq.getParameter("opt_" + j);
                if (opt == null || !opt.contains("i")) {
                    return false;
                }
                ++j;
            }
            return true;
        }
    };

    public static DHtmlUpdateServlet getUpdateServlet(WebApp wapp) {
        return (DHtmlUpdateServlet)((Object)wapp.getServletContext().getAttribute(ATTR_UPDATE_SERVLET));
    }

    public void init() throws ServletException {
        WebApp wapp;
        Map aues;
        ServletConfig config = this.getServletConfig();
        ServletContext ctx = this.getServletContext();
        ctx.setAttribute(ATTR_UPDATE_SERVLET, (Object)this);
        WebManager webman = WebManager.getWebManager(ctx);
        String param = config.getInitParameter("compress");
        boolean bl = this._compress = param == null || param.isEmpty() || "true".equals(param);
        if (!this._compress) {
            webman.getClassWebResource().setCompress(null);
        }
        if ((aues = (Map)(wapp = webman.getWebApp()).getAttribute(ATTR_AU_PROCESSORS)) != null) {
            for (Map.Entry me : aues.entrySet()) {
                this.addAuExtension((String)me.getKey(), (AuExtension)me.getValue());
            }
            wapp.removeAttribute(ATTR_AU_PROCESSORS);
        }
        int j = 0;
        while ((param = config.getInitParameter("extension" + j)) != null || (param = config.getInitParameter("processor" + j)) != null) {
            int k = param.indexOf(61);
            if (k < 0) {
                log.warn("Ignore init-param: illegal format, " + param);
            } else {
                String prefix = param.substring(0, k).trim();
                String clsnm = param.substring(k + 1).trim();
                try {
                    this.addAuExtension(prefix, (AuExtension)Classes.newInstanceByThread((String)clsnm));
                }
                catch (ClassNotFoundException ex) {
                    log.warn("Ignore init-param: class not found, {}", (Object)clsnm);
                }
                catch (ClassCastException ex) {
                    log.warn("Ignore: " + clsnm + " not implement " + AuExtension.class);
                }
                catch (Throwable ex) {
                    log.warn("Ignore init-param: failed to add an AU extension, " + param, ex);
                }
            }
            ++j;
        }
        if (this.getAuExtension("/view") == null) {
            this.addAuExtension("/view", new AuDynaMediar());
        }
    }

    public void destroy() {
        for (AuExtension aue : this._aues.values()) {
            try {
                aue.destroy();
            }
            catch (Throwable ex) {
                log.warn("Unable to stop " + aue, ex);
            }
        }
    }

    public boolean isCompress() {
        return this._compress;
    }

    public void setCompress(boolean compress) {
        this._compress = compress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final AuExtension getAuExtension(WebApp wapp, String prefix) {
        DHtmlUpdateServlet upsv = DHtmlUpdateServlet.getUpdateServlet(wapp);
        if (upsv != null) return upsv.getAuExtension(prefix);
        Class<DHtmlUpdateServlet> clazz = DHtmlUpdateServlet.class;
        synchronized (DHtmlUpdateServlet.class) {
            upsv = DHtmlUpdateServlet.getUpdateServlet(wapp);
            if (upsv != null) return upsv.getAuExtension(prefix);
            Map aues = (Map)wapp.getAttribute(ATTR_AU_PROCESSORS);
            if (aues == null) return null;
            AuExtension auExtension = (AuExtension)aues.get(prefix);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return auExtension;
        }
    }

    public AuExtension getAuExtension(String prefix) {
        return this._aues.get(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final AuExtension addAuExtension(WebApp wapp, String prefix, AuExtension extension) throws ServletException {
        DHtmlUpdateServlet upsv = DHtmlUpdateServlet.getUpdateServlet(wapp);
        if (upsv != null) return upsv.addAuExtension(prefix, extension);
        Class<DHtmlUpdateServlet> clazz = DHtmlUpdateServlet.class;
        synchronized (DHtmlUpdateServlet.class) {
            upsv = DHtmlUpdateServlet.getUpdateServlet(wapp);
            if (upsv != null) return upsv.addAuExtension(prefix, extension);
            DHtmlUpdateServlet.checkAuExtension(prefix, extension);
            HashMap<String, AuExtension> aues = Generics.cast((Map)((Map)wapp.getAttribute(ATTR_AU_PROCESSORS)));
            if (aues != null) return aues.put(prefix, extension);
            aues = new HashMap<String, AuExtension>(4);
            wapp.setAttribute(ATTR_AU_PROCESSORS, aues);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return aues.put(prefix, extension);
        }
    }

    public AuExtension addAuExtension(String prefix, AuExtension extension) throws ServletException {
        DHtmlUpdateServlet.checkAuExtension(prefix, extension);
        if (this._aues.get(prefix) == extension) {
            return extension;
        }
        extension.init(this);
        AuExtension old = this._aues.put(prefix, extension);
        if (old != null) {
            try {
                old.destroy();
            }
            catch (Throwable ex) {
                log.warn("Unable to stop " + old, ex);
            }
        }
        return old;
    }

    private static void checkAuExtension(String prefix, AuExtension extension) {
        if (prefix == null || !prefix.startsWith("/") || prefix.length() < 2 || "/_".equals(prefix) || extension == null) {
            throw new UiException("Ilegal prefix: " + prefix);
        }
        if ("/web".equalsIgnoreCase(prefix)) {
            throw new IllegalArgumentException("/web is reserved");
        }
    }

    private AuExtension getAuExtensionByPath(String path) {
        for (Map.Entry<String, AuExtension> me : this._aues.entrySet()) {
            if (!path.startsWith(me.getKey())) continue;
            return me.getValue();
        }
        return null;
    }

    protected long getLastModified(HttpServletRequest request) {
        String ext;
        String pi = Https.getThisPathInfo((ServletRequest)request);
        if (pi != null && pi.startsWith("/web") && pi.indexOf(42) < 0 && !Servlets.isIncluded((ServletRequest)request) && ((ext = Servlets.getExtension((String)pi, (boolean)false)) == null || this.getClassWebResource().getExtendlet(ext) == null)) {
            if (this._lastModified.get() == 0L) {
                this._lastModified.set(new Date().getTime());
            }
            return this._lastModified.get();
        }
        return -1L;
    }

    private ClassWebResource getClassWebResource() {
        return WebManager.getWebManager(this.getServletContext()).getClassWebResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pi = Https.getThisPathInfo((ServletRequest)request);
        ServletContext ctx = this.getServletContext();
        if (DHtmlResourceServlet.doGet0(request, response, ctx, this.getClassWebResource())) {
            return;
        }
        Session sess = WebManager.getSession(ctx, request, false);
        if (pi != null && pi.length() != 0 && !pi.startsWith("/_/") && !"/_".equals(pi)) {
            AuExtension aue = this.getAuExtensionByPath(pi);
            if (aue == null) {
                response.sendError(404);
                log.debug("Unknown path info: {}", (Object)pi);
                return;
            }
            Object oldsess = null;
            if (sess == null) {
                oldsess = SessionsCtrl.getRawCurrent();
                SessionsCtrl.setCurrent(new SessionResolverImpl(ctx, request));
            } else {
                SessionsCtrl.setCurrent(sess);
            }
            Object old = aue.charsetSetup(sess, request, response);
            try {
                aue.service(request, response, pi);
            }
            finally {
                if (sess != null) {
                    I18Ns.cleanup((ServletRequest)request, old);
                } else {
                    Charsets.cleanup((ServletRequest)request, (Object)old);
                    SessionsCtrl.setRawCurrent(oldsess);
                }
            }
            return;
        }
        if (!"POST".equals(request.getMethod())) {
            response.sendError(404);
            log.debug("Request method is not POST: {}", (Object)Servlets.getDetail((ServletRequest)request));
            return;
        }
        if (sess == null) {
            Object old = Charsets.setup(null, (ServletRequest)request, (ServletResponse)response, (String)"UTF-8");
            try {
                WebApp wapp = WebManager.getWebAppIfAny(ctx);
                this.denoteSessionTimeout(wapp, request, response, this._compress);
                return;
            }
            finally {
                Charsets.cleanup((ServletRequest)request, (Object)old);
            }
        }
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Expires", "-1");
        Object old = I18Ns.setup(sess, (ServletRequest)request, (ServletResponse)response, "UTF-8");
        try {
            this.process(sess, request, response, this._compress);
        }
        finally {
            I18Ns.cleanup((ServletRequest)request, old);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void denoteSessionTimeout(WebApp wapp, HttpServletRequest request, HttpServletResponse response, boolean compress) throws ServletException, IOException {
        response.setIntHeader("ZK-Error", 410);
        String dtid = DHtmlUpdateServlet.getAuDecoder(wapp).getDesktopId(request);
        if (dtid != null) {
            this.sessionTimeout(request, response, wapp, dtid, compress);
        }
    }

    public void process(Session sess, HttpServletRequest request, HttpServletResponse response, boolean compress) throws ServletException, IOException {
        List<AuRequest> aureqs;
        String dtid;
        String errClient = request.getHeader("ZK-Error-Report");
        if (errClient != null && log.isDebugEnabled()) {
            log.debug("Error found at client: " + errClient + "\n" + Servlets.getDetail((ServletRequest)request));
        }
        WebApp wapp = sess.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        AuDecoder audec = DHtmlUpdateServlet.getAuDecoder(wapp);
        boolean multipartContent = AuMultipartUploader.isMultipartContent(request);
        if (multipartContent) {
            audec = AuMultipartUploader.parseRequest(request, audec);
        }
        if ((dtid = audec.getDesktopId(request)) == null) {
            if (log.isDebugEnabled()) {
                String msg = "Incomplete request\n" + Servlets.getDetail((ServletRequest)request);
                log.debug(msg);
            }
            response.sendError(467, "Incomplete request");
            return;
        }
        Desktop desktop = this.getDesktop(sess, dtid);
        if (desktop == null) {
            String cmdId = audec.getFirstCommand(request);
            if (!"rmDesktop".equals(cmdId)) {
                desktop = this.recoverDesktop(sess, request, response, wappc, dtid);
            }
            if (desktop == null) {
                response.setIntHeader("ZK-Error", 410);
                this.sessionTimeout(request, response, wapp, dtid, compress);
                return;
            }
        }
        WebManager.setDesktop(request, desktop);
        String sid = request.getHeader("ZK-SID");
        if (sid != null) {
            try {
                Integer.parseInt(sid);
            }
            catch (NumberFormatException e) {
                log.warn("", (Throwable)e);
                DHtmlUpdateServlet.responseError(request, response, "Illegal request");
                return;
            }
            response.setHeader("ZK-SID", sid);
        }
        Configuration config = wapp.getConfiguration();
        boolean keepAlive = false;
        try {
            boolean timerKeepAlive = config.isTimerKeepAlive();
            aureqs = audec.decode(request, desktop);
            for (AuRequest aureq : aureqs) {
                String cmdId = aureq.getCommand();
                keepAlive = (timerKeepAlive || !"onTimer".equals(cmdId)) && !"dummy".equals(cmdId);
                if (!keepAlive) continue;
                break;
            }
        }
        catch (Throwable ex) {
            log.warn("", ex);
            DHtmlUpdateServlet.responseError(request, response, "Invalid Request (see: Server logs for details)");
            return;
        }
        if (aureqs.isEmpty()) {
            String errmsg = "Illegal request: cmd required";
            log.debug("Illegal request: cmd required");
            DHtmlUpdateServlet.responseError(request, response, "Illegal request: cmd required");
            return;
        }
        ((SessionCtrl)((Object)sess)).notifyClientRequest(keepAlive);
        ExecutionImpl exec = new ExecutionImpl(this.getServletContext(), request, response, desktop, null);
        if (sid != null) {
            ((ExecutionCtrl)exec).setRequestId(sid);
        }
        AuWriter out = AuWriters.newInstance();
        out.setCompress(compress);
        out.open(request, response);
        try {
            wappc.getUiEngine().execUpdate(exec, aureqs, out);
        }
        catch (ActivationTimeoutException ex) {
            log.warn(ex.getMessage());
            response.setHeader("ZK-SID", sid);
            response.setIntHeader("ZK-Error", 5502);
        }
        catch (RequestOutOfSequenceException ex) {
            log.warn(ex.getMessage());
            response.setHeader("ZK-SID", sid);
            response.setIntHeader("ZK-Error", 5501);
        }
        out.close(request, response);
    }

    protected Desktop getDesktop(Session sess, String dtid) {
        return ((WebAppCtrl)((Object)sess.getWebApp())).getDesktopCache(sess).getDesktopIfAny(dtid);
    }

    private void sessionTimeout(HttpServletRequest request, HttpServletResponse response, WebApp wapp, String dtid, boolean compress) throws ServletException, IOException {
        String sid = request.getHeader("ZK-SID");
        if (sid != null) {
            try {
                Integer.parseInt(sid);
            }
            catch (NumberFormatException e) {
                log.warn("", (Throwable)e);
                DHtmlUpdateServlet.responseError(request, response, "Illegal request");
                return;
            }
            response.setHeader("ZK-SID", sid);
        }
        AuWriter out = AuWriters.newInstance();
        out.setCompress(compress);
        out.open(request, response);
        if (!DHtmlUpdateServlet.getAuDecoder(wapp).isIgnorable(request, wapp)) {
            AuResponse resp;
            String deviceType = DHtmlUpdateServlet.getDeviceType(request);
            URIInfo ui = wapp != null ? wapp.getConfiguration().getTimeoutURI(deviceType) : null;
            String uri = ui != null ? ui.uri : null;
            out.write(new AuConfirmClose(null));
            if (uri != null) {
                if (!uri.isEmpty()) {
                    uri = Encodes.encodeURL((ServletContext)this.getServletContext(), (ServletRequest)request, (ServletResponse)response, (String)uri);
                }
                resp = new AuSendRedirect(uri, null);
            } else {
                String key;
                String msg = wapp != null ? wapp.getConfiguration().getTimeoutMessage(deviceType) : null;
                dtid = XMLs.encodeText((String)dtid);
                if (msg != null && msg.startsWith("label:") && (msg = Labels.getLabel((String)(key = msg.substring(6)), (Object[])new Object[]{dtid})) == null) {
                    log.warn("Label not found, {}", (Object)key);
                }
                if (msg == null) {
                    msg = Messages.get((int)MZk.UPDATE_OBSOLETE_PAGE, (Object)dtid);
                }
                resp = new AuObsolete(dtid, msg);
            }
            out.write(resp);
        }
        out.close(request, response);
    }

    private static String getDeviceType(HttpServletRequest request) {
        String agt = request.getHeader("user-agent");
        if (agt != null && !agt.isEmpty()) {
            try {
                return Devices.getDeviceByClient(agt).getType();
            }
            catch (Throwable ex) {
                log.warn("Unknown device for {}", (Object)agt);
            }
        }
        return "ajax";
    }

    protected Desktop recoverDesktop(Session sess, HttpServletRequest request, HttpServletResponse response, WebAppCtrl wappc, String dtid) {
        block5: {
            FailoverManager failover = wappc.getFailoverManager();
            if (failover != null) {
                Desktop desktop = null;
                ServletContext ctx = this.getServletContext();
                try {
                    if (failover.isRecoverable(sess, dtid)) {
                        desktop = WebManager.getWebManager(ctx).getDesktop(sess, (ServletRequest)request, (ServletResponse)response, null, true);
                        if (desktop == null) {
                            throw new IllegalStateException("sendRediect or forward not allowed in recovering");
                        }
                        wappc.getUiEngine().execRecover(new ExecutionImpl(ctx, request, response, desktop, null), failover);
                        return desktop;
                    }
                }
                catch (Throwable ex) {
                    log.error("Unable to recover " + dtid, ex);
                    if (desktop == null) break block5;
                    ((DesktopCtrl)((Object)desktop)).recoverDidFail(ex);
                }
            }
        }
        return null;
    }

    private static void responseError(HttpServletRequest request, HttpServletResponse response, String errmsg) throws IOException {
        response.sendError(400, errmsg);
    }

    private static final AuDecoder getAuDecoder(WebApp wapp) {
        AuDecoder audec = wapp != null ? ((WebAppCtrl)((Object)wapp)).getAuDecoder() : null;
        return audec != null ? audec : _audec;
    }
}

