/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel;

import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELException;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.ExpressionFactory;
import org.zkoss.zel.MethodInfo;
import org.zkoss.zel.MethodNotFoundException;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zel.PropertyNotWritableException;
import org.zkoss.zel.Util;
import org.zkoss.zel.impl.util.ClassUtil;
import org.zkoss.zel.impl.util.ConcurrentCache;
import org.zkoss.zel.impl.util.ReflectionUtil;

public class BeanELResolver
extends ELResolver {
    private static final int CACHE_SIZE = System.getSecurityManager() == null ? Integer.parseInt(System.getProperty("org.zkoss.zel.BeanELResolver.CACHE_SIZE", "1000")) : AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.valueOf(System.getProperty(BeanELResolver.CACHE_SIZE_PROP, "1000"));
        }
    });
    private static final String CACHE_SIZE_PROP = "org.zkoss.zel.BeanELResolver.CACHE_SIZE";
    private final boolean readOnly;
    private static final ConcurrentCache<String, BeanProperties> cache = new ConcurrentCache(CACHE_SIZE);
    private static final ConcurrentCache<Class<?>, Map<CachedMethodInfo, Method>> METHODS_CACHE = new ConcurrentCache(CACHE_SIZE);

    public BeanELResolver() {
        this.readOnly = false;
    }

    public BeanELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(base, property);
        return this.property(context, base, property).getPropertyType();
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(base, property);
        Method m = this.property(context, base, property).read(context);
        try {
            Object result = m.invoke(base, (Object[])null);
            context.putContext(MethodInfo.class, base);
            context.putContext(Method.class, m);
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Util.handleThrowable(cause);
            throw new ELException(Util.message(context, "propertyReadError", base.getClass().getName(), property.toString()), cause);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        context.setPropertyResolved(base, property);
        if (this.readOnly) {
            throw new PropertyNotWritableException(Util.message(context, "resolverNotWriteable", base.getClass().getName()));
        }
        Method m = this.property(context, base, property).write(context);
        try {
            m.invoke(base, value);
            context.putContext(MethodInfo.class, base);
            context.putContext(Method.class, m);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Util.handleThrowable(cause);
            throw new ELException(Util.message(context, "propertyWriteError", base.getClass().getName(), property.toString()), cause);
        }
        catch (IllegalArgumentException e) {
            if (!this.checkType(m, value)) {
                Class<?> baseClass = base.getClass();
                for (Method method : ReflectionUtil.getSetter(baseClass, property.toString())) {
                    Class<?>[] clazzes = method.getParameterTypes();
                    if (!ClassUtil.isInstance(value, clazzes[0])) continue;
                    m = method;
                    break;
                }
            }
            try {
                m.invoke(base, value);
                context.putContext(MethodInfo.class, base);
                context.putContext(Method.class, m);
            }
            catch (InvocationTargetException ee) {
                Throwable cause = ee.getCause();
                Util.handleThrowable(cause);
                throw new ELException(Util.message(context, "propertyWriteError", base.getClass().getName(), property.toString()), cause);
            }
            catch (IllegalArgumentException ee) {
                throw new ELException(Util.message(context, "propertyWriteError", base.getClass().getName(), property.toString()), ee);
            }
            catch (Exception ee) {
                throw new ELException(ee);
            }
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    private boolean checkType(Method m, Object value) {
        Class<?>[] clazzes = m.getParameterTypes();
        if (clazzes.length != 1) {
            return false;
        }
        return clazzes[0].isInstance(value);
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || method == null) {
            return null;
        }
        ExpressionFactory factory = ExpressionFactory.newInstance();
        Method matchingMethod = BeanELResolver.getMethod(base.getClass(), (String)factory.coerceToType(method, String.class), paramTypes, params);
        Class<?>[] parameterTypes = matchingMethod.getParameterTypes();
        Object[] parameters = null;
        if (parameterTypes.length > 0) {
            parameters = new Object[parameterTypes.length];
            int paramCount = params.length;
            if (matchingMethod.isVarArgs()) {
                int varArgIndex = parameterTypes.length - 1;
                for (int i = 0; i < varArgIndex; ++i) {
                    parameters[i] = factory.coerceToType(params[i], parameterTypes[i]);
                }
                Class<?> varArgClass = parameterTypes[varArgIndex].getComponentType();
                Object varargs = Array.newInstance(varArgClass, paramCount - varArgIndex);
                for (int i = varArgIndex; i < paramCount; ++i) {
                    Array.set(varargs, i - varArgIndex, factory.coerceToType(params[i], varArgClass));
                }
                parameters[varArgIndex] = varargs;
            } else {
                parameters = new Object[parameterTypes.length];
                try {
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        parameters[i] = factory.coerceToType(params[i], parameterTypes[i]);
                    }
                }
                catch (ELException ele) {
                    if (paramTypes == null && ele.getCause() instanceof IllegalArgumentException) {
                        paramTypes = new Class[parameters.length];
                        for (int i = 0; i < parameterTypes.length; ++i) {
                            paramTypes[i] = params[i].getClass();
                        }
                        return this.invoke(context, base, method, paramTypes, params);
                    }
                    throw ele;
                }
            }
        }
        Object result = null;
        try {
            result = matchingMethod.invoke(base, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new ELException(e);
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ThreadDeath) {
                throw (ThreadDeath)cause;
            }
            if (cause instanceof VirtualMachineError) {
                throw (VirtualMachineError)cause;
            }
            throw new ELException(cause);
        }
        context.setPropertyResolved(true);
        return result;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(base, property);
        return this.readOnly || this.property(context, base, property).isReadOnly();
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        try {
            PropertyDescriptor[] pds = Util.getPropertyDescriptors(base.getClass());
            for (int i = 0; i < pds.length; ++i) {
                PropertyDescriptor pd = pds[i];
                pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
                if (pd instanceof IndexedPropertyDescriptor) {
                    pd.setValue("type", ((IndexedPropertyDescriptor)pd).getIndexedPropertyType());
                    continue;
                }
                pd.setValue("type", pd.getPropertyType());
            }
            return Arrays.asList((FeatureDescriptor[])pds).iterator();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return Object.class;
        }
        return null;
    }

    private final BeanProperty property(ELContext ctx, Object base, Object property) {
        Class<?> type = base.getClass();
        String prop = property.toString();
        BeanProperties props = cache.get(type.getName());
        if (props == null || type != props.getType()) {
            props = new BeanProperties(type);
            cache.put(type.getName(), props);
        }
        return props.get(ctx, prop);
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes, Object[] params) {
        Method method;
        Map<CachedMethodInfo, Method> clzMap = METHODS_CACHE.get(clazz);
        if (clzMap != null && (method = clzMap.get(new CachedMethodInfo(methodName, paramTypes))) != null) {
            return method;
        }
        return BeanELResolver.getMethod0(clazz, methodName, paramTypes, params);
    }

    /*
     * Unable to fully structure code
     */
    private static Method getMethod0(Class<?> clazz, String methodName, Class<?>[] paramTypes, Object[] params) {
        matchingMethod = null;
        if (paramTypes != null) {
            try {
                matchingMethod = Util.getMethod(clazz, clazz.getMethod(methodName, paramTypes));
            }
            catch (NoSuchMethodException e) {
                paramCount = 0;
                if (params != null) {
                    paramCount = params.length;
                }
                for (Method m : methods = clazz.getMethods()) {
                    if (!methodName.equals(m.getName())) continue;
                    if (m.getParameterTypes().length == paramCount) {
                        matchingMethod = Util.getMethod(clazz, m);
                        break;
                    }
                    if (!m.isVarArgs() || paramCount <= m.getParameterTypes().length - 2) continue;
                    matchingMethod = Util.getMethod(clazz, m);
                }
                if (matchingMethod != null) ** GOTO lbl33
                throw new MethodNotFoundException("Unable to find method [" + methodName + "] with [" + paramCount + "] parameters");
            }
        } else {
            paramCount = 0;
            if (params != null) {
                paramCount = params.length;
            }
            for (Method m : methods = clazz.getMethods()) {
                if (!methodName.equals(m.getName())) continue;
                if (m.getParameterTypes().length == paramCount) {
                    matchingMethod = Util.getMethod(clazz, m);
                    break;
                }
                if (!m.isVarArgs() || paramCount <= m.getParameterTypes().length - 2) continue;
                matchingMethod = Util.getMethod(clazz, m);
            }
            if (matchingMethod == null) {
                throw new MethodNotFoundException("Unable to find method [" + methodName + "] with [" + paramCount + "] parameters");
            }
        }
lbl33:
        // 4 sources

        if (matchingMethod != null) {
            BeanELResolver.METHODS_CACHE.computeIfAbsent(clazz, (Function<Class, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getMethod0$0(java.lang.Class ), (Ljava/lang/Class;)Ljava/util/Map;)()).put(new CachedMethodInfo(methodName, paramTypes), matchingMethod);
        }
        return matchingMethod;
    }

    private static /* synthetic */ Map lambda$getMethod0$0(Class k) {
        return new ConcurrentHashMap();
    }

    private static final class CachedMethodInfo {
        private final String _methodName;
        private final Class<?>[] _paramTypes;

        public CachedMethodInfo(String methodName, Class<?>[] paramTypes) {
            this._methodName = methodName;
            this._paramTypes = paramTypes;
        }

        public String getMethodName() {
            return this._methodName;
        }

        public Class<?>[] getParamTypes() {
            return this._paramTypes;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this._methodName.hashCode();
            result = 31 * result + (this._paramTypes != null ? this._paramTypes.length : 0);
            return result;
        }

        public boolean equals(Object obj) {
            int len2;
            if (!(obj instanceof CachedMethodInfo)) {
                return false;
            }
            if (!((CachedMethodInfo)obj).getMethodName().equals(this._methodName)) {
                return false;
            }
            Class<?>[] targetParamTypes = ((CachedMethodInfo)obj).getParamTypes();
            int len = this._paramTypes != null ? this._paramTypes.length : 0;
            int n = len2 = targetParamTypes != null ? targetParamTypes.length : 0;
            if (len != len2) {
                return false;
            }
            for (int j = 0; j < len; ++j) {
                if (Objects.equals(this._paramTypes[j], targetParamTypes[j])) continue;
                return false;
            }
            return true;
        }
    }

    static final class BeanProperty {
        private final Class<?> type;
        private final Class<?> owner;
        private final PropertyDescriptor descriptor;
        private Method read;
        private Method write;

        public BeanProperty(Class<?> owner, PropertyDescriptor descriptor) {
            this.owner = owner;
            this.descriptor = descriptor;
            this.type = descriptor instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType() : descriptor.getPropertyType();
        }

        public Class getPropertyType() {
            return this.type;
        }

        public boolean isReadOnly() {
            return this.write == null && null == (this.write = Util.getMethod(this.owner, this.descriptor.getWriteMethod()));
        }

        public Method getWriteMethod() {
            return this.write(null);
        }

        public Method getReadMethod() {
            return this.read(null);
        }

        private Method write(ELContext ctx) {
            if (this.write == null) {
                this.write = Util.getMethod(this.owner, this.descriptor.getWriteMethod());
                if (this.write == null) {
                    Method m2;
                    String name = this.descriptor.getName();
                    String mname = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
                    Class<?> parameterTypes = this.descriptor instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)this.descriptor).getIndexedPropertyType() : this.descriptor.getPropertyType();
                    try {
                        m2 = this.owner.getMethod(mname, parameterTypes);
                        this.write = Util.getMethod(this.owner, m2);
                    }
                    catch (SecurityException m2) {
                    }
                    catch (NoSuchMethodException m2) {
                        // empty catch block
                    }
                    if (this.write == null) {
                        try {
                            m2 = ClassUtil.getCloseMethod(this.owner, mname, new Class[]{parameterTypes});
                            this.write = Util.getMethod(this.owner, m2);
                        }
                        catch (SecurityException securityException) {
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                }
                if (this.write == null) {
                    throw new PropertyNotWritableException(Util.message(ctx, "propertyNotWritable", this.owner.getName(), this.descriptor.getName()));
                }
            }
            return this.write;
        }

        private Method read(ELContext ctx) {
            if (this.read == null) {
                this.read = Util.getMethod(this.owner, this.descriptor.getReadMethod());
                if (this.read == null) {
                    throw new PropertyNotFoundException(Util.message(ctx, "propertyNotReadable", this.owner.getName(), this.descriptor.getName()));
                }
            }
            return this.read;
        }
    }

    static final class BeanProperties {
        private final Map<String, BeanProperty> properties;
        private final Class<?> type;

        public BeanProperties(Class<?> type) throws ELException {
            this.type = type;
            this.properties = new HashMap<String, BeanProperty>();
            try {
                PropertyDescriptor[] pds = Util.getPropertyDescriptors(this.type);
                for (int i = 0; i < pds.length; ++i) {
                    PropertyDescriptor pd = this.recoverIndexedPropertyDescriptor(this.type, pds[i]);
                    this.properties.put(pd.getName(), new BeanProperty(type, pd));
                }
            }
            catch (IntrospectionException ie) {
                throw new ELException(ie);
            }
        }

        private PropertyDescriptor recoverIndexedPropertyDescriptor(Class baseClz, PropertyDescriptor pd) {
            IndexedPropertyDescriptor ipd;
            if (pd instanceof IndexedPropertyDescriptor && (ipd = (IndexedPropertyDescriptor)pd).getIndexedReadMethod() != null) {
                try {
                    String name = ipd.getName();
                    Method rm = ipd.getIndexedReadMethod();
                    String readMethodName = rm != null ? rm.getName() : null;
                    Method wm = ipd.getIndexedWriteMethod();
                    String writeMethodName = wm != null ? wm.getName() : null;
                    pd = new PropertyDescriptor(name, baseClz, readMethodName, writeMethodName);
                }
                catch (IntrospectionException introspectionException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return pd;
        }

        private BeanProperty get(ELContext ctx, String name) {
            BeanProperty property = this.properties.get(name);
            if (property == null) {
                throw new PropertyNotFoundException(Util.message(ctx, "propertyNotFound", this.type.getName(), name));
            }
            return property;
        }

        public BeanProperty getBeanProperty(String name) {
            return this.get(null, name);
        }

        private Class<?> getType() {
            return this.type;
        }
    }
}

