/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Files;
import org.zkoss.lang.Library;
import org.zkoss.util.URLs;
import org.zkoss.util.resource.Loader;
import org.zkoss.web.util.resource.ExtendletContext;

public abstract class ExtendletLoader<V>
implements Loader<String, V> {
    private static final Logger log = LoggerFactory.getLogger(ExtendletLoader.class);
    private int _checkPeriod = ExtendletLoader.getInitCheckPeriod();

    protected ExtendletLoader() {
    }

    protected String getRealPath(String path) {
        return path;
    }

    public boolean shallCheck(String src, long expiredMillis) {
        return expiredMillis > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(String src) {
        if (this.getCheckPeriod() < 0) {
            return 1L;
        }
        URLConnection conn = null;
        try {
            URL url = this.getExtendletContext().getResource(src);
            if (url != null) {
                conn = (url = URLs.sanitizeURL((URL)url)).openConnection();
                long v = conn.getLastModified();
                long l = v != -1L ? v : 0L;
                return l;
            }
        }
        catch (Throwable e) {
        }
        finally {
            if (conn != null) {
                try {
                    conn.getInputStream().close();
                }
                catch (Throwable e) {
                    log.warn("The connection cannot be closed", e);
                }
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V load(String src) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Parse " + src);
        }
        String path = this.getRealPath(src);
        InputStream is = null;
        if (this.getCheckPeriod() >= 0) {
            try {
                URL real = this.getExtendletContext().getResource(path);
                if (real != null) {
                    real = URLs.sanitizeURL((URL)real);
                    is = real.openStream();
                }
            }
            catch (Throwable ex) {
                log.warn("Unable to read from URL: " + path, ex);
            }
        }
        if (is == null && (is = this.getExtendletContext().getResourceAsStream(path)) == null) {
            return null;
        }
        try {
            V ex = this.parse(is, path, src);
            return ex;
        }
        catch (Throwable ex) {
            log.error("Failed to parse " + src, ex);
            V v = null;
            return v;
        }
        finally {
            Files.close((InputStream)is);
        }
    }

    protected abstract V parse(InputStream var1, String var2, String var3) throws Exception;

    protected abstract ExtendletContext getExtendletContext();

    public int getCheckPeriod() {
        return this._checkPeriod;
    }

    private static int getInitCheckPeriod() {
        int v = Library.getIntProperty((String)"org.zkoss.util.resource.extendlet.checkPeriod", (int)-1);
        return v > 0 ? v * 1000 : v;
    }
}

