/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.fn;

public class Color {
    private int red;
    private int green;
    private int blue;
    private int alpha;

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this.checkColorRange(r, g, b, a);
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
    }

    private void checkColorRange(int r, int g, int b, int a) {
        Object wrongColors = "";
        boolean gotError = false;
        if (r < 0 || r > 255) {
            gotError = true;
            wrongColors = (String)wrongColors + "\"red\"";
        }
        if (g < 0 || g > 255) {
            gotError = true;
            wrongColors = (String)wrongColors + " \"green\"";
        }
        if (b < 0 || b > 255) {
            gotError = true;
            wrongColors = (String)wrongColors + " \"blue\"";
        }
        if (a < 0 || a > 255) {
            gotError = true;
            wrongColors = (String)wrongColors + " \"alpha\"";
        }
        if (gotError) {
            throw new IllegalArgumentException((String)wrongColors + " color value outside of expected range 0-255");
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getRGB() {
        return (this.alpha << 24) + (this.red << 16) + (this.green << 8) + this.blue;
    }
}

