/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.AbstractSimpleDateTimeConstraint;
import org.zkoss.zul.Datebox;

public class SimpleLocalDateConstraint
extends AbstractSimpleDateTimeConstraint<LocalDate> {
    public SimpleLocalDateConstraint(int flags) {
        super(flags);
    }

    public SimpleLocalDateConstraint(int flags, String errmsg) {
        super(flags, errmsg);
    }

    public SimpleLocalDateConstraint(Pattern regex, String errmsg) {
        super(regex, errmsg);
    }

    public SimpleLocalDateConstraint(int flags, Pattern regex, String errmsg) {
        super(flags, regex, errmsg);
    }

    public SimpleLocalDateConstraint(int flags, LocalDate begin, LocalDate end, String errmsg) {
        super(flags, errmsg);
        this._beg = begin;
        this._end = end;
        this.fixConstraint();
    }

    public SimpleLocalDateConstraint(String constraint) {
        super(constraint);
    }

    @Override
    protected void fixConstraint() {
        if ((this._flags & 1) != 0 && this._end == null) {
            this._end = LocalDate.now();
        }
        if ((this._flags & 2) != 0 && this._beg == null) {
            this._beg = LocalDate.now();
        }
    }

    @Override
    public void validate(Component comp, Object value) throws WrongValueException {
        super.validate(comp, value);
        if (value instanceof Date) {
            Instant instant = ((Date)value).toInstant();
            this.validate0(comp, LocalDateTime.ofInstant(instant, SimpleLocalDateConstraint.getZoneId(this._tzone)).toLocalDate());
        }
    }

    @Override
    protected LocalDate parseFrom(String val) throws UiException {
        try {
            return LocalDate.from(SimpleLocalDateConstraint.getDateFormat(this._tzone).parse(val.trim()));
        }
        catch (DateTimeException ex) {
            throw new UiException("Not a date: " + val + ". Format: yyyyMMdd", (Throwable)ex);
        }
    }

    private static DateTimeFormatter getDateFormat(TimeZone tzone) {
        return DateTimeFormatter.ofPattern("yyyyMMdd", Locales.getCurrent()).withZone(SimpleLocalDateConstraint.getZoneId(tzone));
    }

    private static ZoneId getZoneId(TimeZone tzone) {
        return Optional.ofNullable(tzone).orElse(TimeZones.getCurrent()).toZoneId();
    }

    @Override
    protected String valueToString(Component comp, LocalDate value) {
        if (value == null) {
            return "";
        }
        if (comp instanceof Datebox) {
            return ((Datebox)comp).coerceToString(Date.from(value.atStartOfDay(SimpleLocalDateConstraint.getZoneId(this._tzone)).toInstant()));
        }
        return SimpleLocalDateConstraint.getDateFormat(this._tzone).format(value);
    }
}

