/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javassist.util.proxy.MethodFilter;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Form;
import org.zkoss.bind.FormStatus;
import org.zkoss.bind.annotation.Transient;
import org.zkoss.bind.proxy.BeanProxyHandler;
import org.zkoss.bind.proxy.FormFieldCleaner;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.bind.proxy.ProxyNodeImpl;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Callback;

public class FormProxyHandler<T>
extends BeanProxyHandler<T> {
    private static final long serialVersionUID = 20150109113926L;
    protected static MethodFilter FORM_METHOD_FILTER = new MethodFilter(){

        public boolean isHandled(Method m) {
            if (m.isAnnotationPresent(Transient.class)) {
                return false;
            }
            String name = m.getName();
            if ("hashCode".equals(name) || "equals".equals(name)) {
                return true;
            }
            if (ProxyHelper.isAttribute(m)) {
                if (name.startsWith("set")) {
                    return BeanProxyHandler.isSetMethodHandled(m);
                }
                if (name.startsWith("get") || name.startsWith("is")) {
                    return true;
                }
            }
            try {
                FormProxyObject.class.getMethod(name, m.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException e) {
                try {
                    Form.class.getMethod(name, m.getParameterTypes());
                    return true;
                }
                catch (NoSuchMethodException ex) {
                    return false;
                }
            }
        }
    };
    private static final Map<String, Object> _defaultValues = new HashMap<String, Object>(10);
    private FormBinding _binding;
    FormStatusImpl _status = new FormStatusImpl();

    public FormProxyHandler(T origin) {
        super(origin);
        this._node = new ProxyNodeImpl("", null);
    }

    @Override
    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Exception {
        try {
            String mname = method.getName();
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.equals(FormFieldCleaner.class)) {
                return _defaultValues.get(mname);
            }
            if ("setFormOwner".equals(mname)) {
                this.addCallbacks();
                if (this._binding != null) {
                    BinderCtrl binder = (BinderCtrl)((Object)this._binding.getBinder());
                    binder.removeSaveFormFieldNames((Form)self);
                    this._origin = ProxyHelper.getOriginObject(args[0]);
                    this._binding = (FormBinding)args[1];
                } else {
                    this._origin = ProxyHelper.getOriginObject(args[0]);
                    this._binding = (FormBinding)args[1];
                }
                return null;
            }
            if ("cacheSavePropertyBinding".equals(mname)) {
                ProxyHelper.cacheSavePropertyBinding(this._node, (String)args[0], (SavePropertyBinding)args[1]);
                return null;
            }
            if ("getFormStatus".equals(mname)) {
                this._status.setOwner((FormProxyObject)self);
                return this._status;
            }
            if ("collectCachedSavePropertyBinding".equals(mname)) {
                HashSet<Pair<String, SavePropertyBinding>> sBindings = new HashSet<Pair<String, SavePropertyBinding>>(this._node.getCachedSavePropertyBinding());
                this._node.getCachedSavePropertyBinding().clear();
                return sBindings;
            }
            return super.invoke(self, method, proceed, args);
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
    }

    private void addCallbacks() {
        this._node.setOnDataChangeCallback((Callback)new Callback<Object[]>(){

            public void call(Object[] data) {
                Execution execution = Executions.getCurrent();
                HashSet<Pair> zkProxyNotified = execution != null ? (HashSet<Pair>)execution.getAttribute("$$zkFormProxyNotified$$") : null;
                String property = (String)data[1];
                Pair zkFormProxyNotifiedVal = new Pair(data[0], (Object)property);
                if (zkProxyNotified == null || !zkProxyNotified.contains(zkFormProxyNotifiedVal)) {
                    FormProxyHandler.this._binding.getBinder().notifyChange(data[0], property);
                    if (execution != null) {
                        if (zkProxyNotified == null) {
                            zkProxyNotified = new HashSet<Pair>();
                        }
                        zkProxyNotified.add(new Pair(data[0], (Object)property));
                        execution.setAttribute("$$zkFormProxyNotified$$", zkProxyNotified);
                    }
                }
            }
        });
        this._node.setOnDirtyChangeCallback(new Callback(){

            public void call(Object data) {
                FormProxyHandler.this._binding.getBinder().notifyChange(FormProxyHandler.this._binding.getFormBean().getFormStatus(), ".");
            }
        });
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.addCallbacks();
    }

    static {
        _defaultValues.put("getResetEmptyStringValue", "");
        _defaultValues.put("getResetNullValue", null);
        _defaultValues.put("getResetByteValue", (byte)0);
        _defaultValues.put("getResetShortValue", (short)0);
        _defaultValues.put("getResetIntValue", 0);
        _defaultValues.put("getResetLongValue", 0L);
        _defaultValues.put("getResetFloatValue", Float.valueOf(0.0f));
        _defaultValues.put("getResetDoubleValue", 0.0);
        _defaultValues.put("getResetBooleanValue", false);
        _defaultValues.put("getResetCharValue", Character.valueOf('\u0000'));
    }

    private class FormStatusImpl
    implements FormStatus,
    Serializable {
        private static final long serialVersionUID = 1L;
        private FormProxyObject self;

        public void setOwner(FormProxyObject self) {
            this.self = self;
        }

        @Override
        public boolean isDirty() {
            return this.self.isFormDirty();
        }

        @Override
        public void reset() {
            this.self.resetFromOrigin();
        }

        @Override
        public void submit(BindContext ctx) {
            this.self.submitToOrigin(ctx);
        }

        @Override
        public Object getOrigin() {
            return this.self;
        }
    }
}

