/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.LabelImageElement;
import org.zkoss.zul.impl.Utils;

public class A
extends LabelImageElement
implements Disable {
    private AuxInfo _auxinf;

    public A() {
    }

    public A(String label) {
        super(label);
    }

    public A(String label, String image) {
        super(label, image);
    }

    public boolean isDisabled() {
        return this._auxinf != null && this._auxinf.disabled;
    }

    public void setDisabled(boolean disabled) {
        if ((this._auxinf != null && this._auxinf.disabled) != disabled) {
            this.initAuxInfoForA().disabled = disabled;
            this.smartUpdate("disabled", this.isDisabled());
        }
    }

    public String getAutodisable() {
        return this._auxinf != null ? this._auxinf.autodisable : null;
    }

    public void setAutodisable(String autodisable) {
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.autodisable : null), (Object)autodisable)) {
            this.initAuxInfoForA().autodisable = autodisable;
            this.smartUpdate("autodisable", this.getAutodisable());
        }
    }

    public String getDir() {
        return this._auxinf != null ? this._auxinf.dir : "normal";
    }

    public void setDir(String dir) throws WrongValueException {
        if (!"normal".equals(dir) && !"reverse".equals(dir)) {
            throw new WrongValueException(dir);
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.dir : "normal"), (Object)dir)) {
            this.initAuxInfoForA().dir = dir;
            this.smartUpdate("dir", this.getDir());
        }
    }

    public String getHref() {
        return this._auxinf != null ? this._auxinf.href : null;
    }

    public void setHref(String href) {
        if (href != null && href.length() == 0) {
            href = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.href : null), (Object)href)) {
            this.initAuxInfoForA().href = href;
            this.smartUpdate("href", new EncodedHref());
        }
    }

    public String getTarget() {
        return this._auxinf != null ? this._auxinf.target : null;
    }

    public void setTarget(String target) {
        if (target != null && target.length() == 0) {
            target = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.target : null), (Object)target)) {
            this.initAuxInfoForA().target = target;
            this.smartUpdate("target", this.getTarget());
        }
    }

    private String getEncodedHref() {
        Desktop dt = this.getDesktop();
        return this._auxinf != null && this._auxinf.href != null && dt != null ? dt.getExecution().encodeURL(this._auxinf.href) : null;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        String s = this.getDir();
        if (!"normal".equals(s)) {
            this.render(renderer, "dir", s);
        }
        this.render(renderer, "disabled", this.isDisabled());
        this.render(renderer, "autodisable", this.getAutodisable());
        String href = this.getEncodedHref();
        this.render(renderer, "href", href);
        this.render(renderer, "target", this.getTarget());
        Utils.renderCrawlableA(href, this.getLabel());
    }

    @Override
    protected void renderCrawlable(String label) throws IOException {
    }

    private AuxInfo initAuxInfoForA() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-a";
    }

    static {
        A.addClientEvent(A.class, (String)"onFocus", (int)8192);
        A.addClientEvent(A.class, (String)"onBlur", (int)8192);
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private String dir = "normal";
        private String href;
        private String target;
        private String autodisable;
        protected String upload;
        private boolean disabled;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }

    private class EncodedHref
    implements DeferredValue {
        private EncodedHref() {
        }

        public Object getValue() {
            return A.this.getEncodedHref();
        }
    }
}

