/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.security.jaspi;

import java.security.Principal;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.servlet.ServletContext;
import org.eclipse.jetty.ee8.security.Authenticator;
import org.eclipse.jetty.ee8.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.ee8.security.jaspi.JaspiAuthenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaspiAuthenticatorFactory
extends DefaultAuthenticatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JaspiAuthenticatorFactory.class);
    public static final String MESSAGE_LAYER = "HttpServlet";
    private Subject _serviceSubject;
    private String _serverName;

    public Subject getServiceSubject() {
        return this._serviceSubject;
    }

    public void setServiceSubject(Subject serviceSubject) {
        this._serviceSubject = serviceSubject;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public Authenticator getAuthenticator(Server server, ServletContext context, Authenticator.AuthConfiguration configuration, IdentityService identityService, LoginService loginService) {
        AuthConfigFactory factory = AuthConfigFactory.getFactory();
        if (factory == null) {
            return null;
        }
        String serverName = this.findServerName(context, server);
        Subject serviceSubject = this.findServiceSubject(server);
        String contextPath = StringUtil.isEmpty((String)context.getContextPath()) ? "/" : context.getContextPath();
        String appContext = serverName + " " + contextPath;
        if (factory.getConfigProvider(MESSAGE_LAYER, appContext, null) == null) {
            return null;
        }
        return new JaspiAuthenticator(serviceSubject, appContext, true);
    }

    protected Subject findServiceSubject(Server server) {
        if (this._serviceSubject != null) {
            return this._serviceSubject;
        }
        List subjects = (List)server.getBeans(Subject.class);
        if (subjects.size() > 0) {
            return (Subject)subjects.get(0);
        }
        return null;
    }

    protected String findServerName(ServletContext context, Server server) {
        Set<Principal> principals;
        if (this._serverName != null) {
            return this._serverName;
        }
        String virtualServerName = context.getVirtualServerName();
        if (virtualServerName != null) {
            return virtualServerName;
        }
        Subject subject = this.findServiceSubject(server);
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            return principals.iterator().next().getName();
        }
        return "server";
    }
}

