/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.SystemException;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.resource.XMLResourcesLocator;

public class ClassLocator
implements XMLResourcesLocator {
    private static final Logger log = LoggerFactory.getLogger(ClassLocator.class);
    private static final String[] ZK_MODULES = new String[]{"zkbind", "zkplus", "zk", "zul"};

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> en;
        name = ClassLocator.resolveName(name);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null && (en = cl.getResources(name)).hasMoreElements()) {
            return en;
        }
        cl = ClassLocator.class.getClassLoader();
        if (cl != null && (en = cl.getResources(name)).hasMoreElements()) {
            return en;
        }
        return ClassLoader.getSystemResources(name);
    }

    @Override
    public List<XMLResourcesLocator.Resource> getDependentXMLResources(String name, String elName, String elDepends) throws IOException {
        LinkedHashMap<String, XMLResource> rcmap = new LinkedHashMap<String, XMLResource>();
        Enumeration<URL> en = this.getResources(name);
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            XMLResource xr = new XMLResource(url, elName, elDepends);
            XMLResource old = rcmap.put(xr.name, xr);
            if (old == null) continue;
            log.warn("Replicate resource: " + xr.name + "\nOverwrite " + old.url + "\nwith " + xr.url);
        }
        LinkedList<XMLResourcesLocator.Resource> rcs = new LinkedList<XMLResourcesLocator.Resource>();
        LinkedHashSet<String> resolving = new LinkedHashSet<String>();
        while (!rcmap.isEmpty()) {
            Iterator it = rcmap.values().iterator();
            XMLResource xr = (XMLResource)it.next();
            it.remove();
            ClassLocator.resolveDependency(xr, rcs, rcmap, resolving, elName);
            assert (resolving.isEmpty());
        }
        return rcs;
    }

    private static void resolveDependency(XMLResource xr, List<XMLResourcesLocator.Resource> rcs, Map<String, XMLResource> rcmap, Set<String> resolving, String elName) {
        if (!resolving.add(xr.name)) {
            throw new IllegalStateException("Recusrive reference among " + resolving);
        }
        ClassLocator.checkCompDenpendency(xr, rcmap, elName);
        for (String nm : xr.depends) {
            XMLResource dep = rcmap.remove(nm);
            if (dep == null) continue;
            ClassLocator.resolveDependency(dep, rcs, rcmap, resolving, elName);
        }
        rcs.add(new XMLResourcesLocator.Resource(xr.url, xr.document));
        resolving.remove(xr.name);
        if (log.isDebugEnabled()) {
            log.debug("Adding resolved resource: " + xr.name);
        }
    }

    private static void checkCompDenpendency(XMLResource xr, Map<String, XMLResource> rcmap, String elName) {
        if (xr.depends.size() > 0) {
            return;
        }
        for (String zkModule : ZK_MODULES) {
            if (!zkModule.equals(xr.name)) continue;
            return;
        }
        Element xrRoot = xr.document.getRootElement();
        Element strictElement = xrRoot.getElement("strict");
        boolean strict = strictElement == null ? false : Boolean.parseBoolean(strictElement.getText(true));
        List<Element> elementList = xrRoot.getElements("component");
        HashMap<String, Boolean> visited = new HashMap<String, Boolean>(elementList.size());
        for (Element el : elementList) {
            List<Element> ambigComps;
            visited.put(el.getElement("component-name").getText(), Boolean.TRUE);
            Element anExtends = el.getElement("extends");
            if (anExtends == null || visited.containsKey(anExtends.getText()) || (ambigComps = ClassLocator.findAmbiguousComps(rcmap, el)).isEmpty()) continue;
            StringBuilder addonNameBuilder = new StringBuilder();
            for (Element ambigComp : ambigComps) {
                Element ambigRoot = ambigComp.getDocument().getRootElement();
                addonNameBuilder.append("'").append(ambigRoot.getElement(elName).getFirstChild().getNodeValue()).append("', ");
            }
            String message = "In {}, you are extending component {} which is defined in {}please define <depends> element";
            String[] messageArgs = new String[]{xr.url.toString(), el.getElementValue("extends", true), addonNameBuilder.toString()};
            ClassLocator.warningMessage(message, messageArgs, strict);
        }
    }

    private static List<Element> findAmbiguousComps(Map<String, XMLResource> rcmap, Element el) {
        ArrayList<Element> ambigComps = new ArrayList<Element>();
        block0: for (Map.Entry<String, XMLResource> entry : rcmap.entrySet()) {
            Element root = entry.getValue().document.getRootElement();
            if (root == null) continue;
            for (Element comp : root.getElements("component")) {
                String extendedElName = el.getElementValue("extends", true);
                String compName = comp.getElementValue("component-name", true);
                if (compName == null || !compName.equals(extendedElName)) continue;
                ambigComps.add(comp);
                continue block0;
            }
        }
        return ambigComps;
    }

    private static void warningMessage(String message, String[] args, boolean strict) {
        if (strict) {
            String f = message.replace("{}", "%s");
            String result = String.format(f, args);
            throw new SystemException(result);
        }
        log.warn(message, (Object[])args);
    }

    @Override
    public String getDirectory() {
        return null;
    }

    @Override
    public URL getResource(String name) {
        URL url;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL uRL = url = cl != null ? cl.getResource(ClassLocator.resolveName(name)) : null;
        if (url != null) {
            return url;
        }
        url = ClassLocator.class.getResource(name);
        return url != null ? url : ClassLocator.class.getClassLoader().getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl != null ? cl.getResourceAsStream(ClassLocator.resolveName(name)) : null;
        return is != null ? is : ClassLocator.class.getResourceAsStream(name);
    }

    private static String resolveName(String name) {
        return name != null && name.startsWith("/") ? name.substring(1) : name;
    }

    public int hashCode() {
        return 1123;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ClassLocator;
    }

    private static class XMLResource {
        private final String name;
        private final URL url;
        private final Document document;
        private final List<String> depends;

        private XMLResource(URL url, String elName, String elDepends) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug("Loading " + url);
            }
            try {
                this.document = new SAXBuilder(false, false, true).build(url);
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                IOException ioex = new IOException("Unable to load " + url);
                ioex.initCause(ex);
                throw ioex;
            }
            this.url = url;
            Element root = this.document.getRootElement();
            this.name = IDOMs.getRequiredElementValue(root, elName);
            String deps = root.getElementValue(elDepends, true);
            if (deps == null || deps.length() == 0) {
                this.depends = Collections.emptyList();
            } else {
                this.depends = new LinkedList<String>();
                CollectionsX.parse(this.depends, deps, ',');
                if (log.isTraceEnabled()) {
                    log.trace(this.name + " depends on " + this.depends);
                }
            }
        }

        public String toString() {
            return "[" + this.name + ": " + this.url + " depends on " + this.depends + "]";
        }
    }
}

