/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.common.QuicErrorCode;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.quiche.QuicheConnectionId;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.strategy.AdaptiveExecutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QuicConnection
extends AbstractConnection {
    private static final Logger LOG = LoggerFactory.getLogger(QuicConnection.class);
    private final List<QuicSession.Listener> listeners = new CopyOnWriteArrayList<QuicSession.Listener>();
    private final ConcurrentMap<QuicheConnectionId, QuicSession> sessions = new ConcurrentHashMap<QuicheConnectionId, QuicSession>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Scheduler scheduler;
    private final ByteBufferPool bufferPool;
    private final AdaptiveExecutionStrategy strategy;
    private final Flusher flusher = new Flusher();
    private final Callback fillableCallback = new FillableCallback();
    private int outputBufferSize = 2048;
    private boolean useInputDirectByteBuffers = true;
    private boolean useOutputDirectByteBuffers = true;

    protected QuicConnection(Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, EndPoint endPoint) {
        super(endPoint, executor);
        this.scheduler = scheduler;
        this.bufferPool = bufferPool;
        this.strategy = new AdaptiveExecutionStrategy((ExecutionStrategy.Producer)new QuicProducer(), this.getExecutor());
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public void setOutputBufferSize(int outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public Collection<QuicSession> getQuicSessions() {
        return List.copyOf(this.sessions.values());
    }

    public void addEventListener(EventListener listener) {
        super.addEventListener(listener);
        if (listener instanceof QuicSession.Listener) {
            this.listeners.add((QuicSession.Listener)listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        super.removeEventListener(listener);
        if (listener instanceof QuicSession.Listener) {
            this.listeners.remove((QuicSession.Listener)listener);
        }
    }

    public void onOpen() {
        super.onOpen();
        LifeCycle.start((Object)this.strategy);
    }

    public void onClose(Throwable cause) {
        LifeCycle.stop((Object)this.strategy);
        super.onClose(cause);
    }

    public void onFillable() {
        this.strategy.produce();
    }

    public void fillInterested() {
        this.getEndPoint().fillInterested(this.fillableCallback);
    }

    public abstract boolean onIdleExpired(TimeoutException var1);

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("closing connection {}", (Object)this);
            }
            for (QuicSession session : this.sessions.values()) {
                try {
                    session.inwardClose(QuicErrorCode.NO_ERROR.code(), "close");
                }
                catch (Throwable x) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("could not close {}", (Object)session, (Object)x);
                }
            }
        }
    }

    public void outwardClose(QuicSession session, Throwable failure) {
        QuicheConnectionId connectionId;
        if (LOG.isDebugEnabled()) {
            LOG.debug("outward close {} on {}", (Object)session, (Object)this);
        }
        if ((connectionId = session.getConnectionId()) != null) {
            this.sessions.remove(connectionId);
            LifeCycle.stop((Object)((Object)session));
        }
    }

    protected abstract QuicSession createSession(SocketAddress var1, ByteBuffer var2) throws IOException;

    public abstract InetSocketAddress getLocalInetSocketAddress();

    public void write(Callback callback, SocketAddress remoteAddress, ByteBuffer ... buffers) {
        this.flusher.offer(callback, remoteAddress, buffers);
    }

    private Runnable receiveAndProcess() {
        boolean interested = this.isFillInterested();
        if (LOG.isDebugEnabled()) {
            LOG.debug("receiveAndProcess() fillInterested={}", (Object)interested);
        }
        if (interested) {
            return null;
        }
        RetainableByteBuffer buffer = this.bufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
        ByteBuffer cipherBuffer = buffer.getByteBuffer();
        try {
            Runnable task;
            while (true) {
                QuicSession session;
                QuicheConnectionId quicheConnectionId;
                int fill;
                BufferUtil.clear((ByteBuffer)cipherBuffer);
                SocketAddress remoteAddress = this.getEndPoint().receive(cipherBuffer);
                int n = fill = remoteAddress == EndPoint.EOF ? -1 : cipherBuffer.remaining();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("filled cipher buffer with {} byte(s)", (Object)fill);
                }
                if (fill < 0) {
                    buffer.release();
                    this.getEndPoint().shutdownOutput();
                    return null;
                }
                if (fill == 0) {
                    buffer.release();
                    this.fillInterested();
                    return null;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("peer IP address: {}, ciphertext packet size: {}", (Object)remoteAddress, (Object)cipherBuffer.remaining());
                }
                if ((quicheConnectionId = QuicheConnectionId.fromPacket((ByteBuffer)cipherBuffer)) == null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("packet contains undecipherable connection ID, dropping it");
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("packet contains connection ID {}", (Object)quicheConnectionId);
                }
                if ((session = (QuicSession)((Object)this.sessions.get(quicheConnectionId))) == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("packet is for unknown session, trying to create a new one");
                    }
                    if ((session = this.createSession(remoteAddress, cipherBuffer)) != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("session created");
                        }
                        session.setConnectionId(quicheConnectionId);
                        session.setIdleTimeout(this.getEndPoint().getIdleTimeout());
                        this.sessions.put(quicheConnectionId, session);
                        this.listeners.forEach(arg_0 -> ((QuicSession)session).addEventListener(arg_0));
                        LifeCycle.start((Object)((Object)session));
                        task = session.pollTask();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("processing creation task {} on {}", (Object)task, (Object)session);
                        }
                        if (task == null) continue;
                        buffer.release();
                        return task;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("session not created");
                    continue;
                }
                task = this.process(session, remoteAddress, cipherBuffer);
                if (task != null) break;
            }
            buffer.release();
            return task;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("receiveAndProcess() failure", x);
            }
            buffer.release();
            this.onFailure(x);
            return null;
        }
    }

    protected Runnable process(QuicSession session, SocketAddress remoteAddress, ByteBuffer cipherBuffer) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("packet is for existing session {}, processing {} bytes", (Object)session, (Object)cipherBuffer.remaining());
            }
            Runnable task = session.process(remoteAddress, cipherBuffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("produced session task {} on {}", (Object)task, (Object)this);
            }
            return task;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("process failure for {}", (Object)session, (Object)x);
            }
            session.onFailure(x);
            return null;
        }
    }

    protected void onFailure(Throwable failure) {
        this.sessions.values().forEach(session -> this.outwardClose((QuicSession)((Object)session), failure));
    }

    private class Flusher
    extends IteratingCallback {
        private final Queue<Entry> queue = new ConcurrentLinkedQueue<Entry>();
        private Entry entry;

        private Flusher() {
        }

        public void offer(Callback callback, SocketAddress address, ByteBuffer[] buffers) {
            this.queue.offer(new Entry(callback, address, buffers));
            this.iterate();
        }

        protected IteratingCallback.Action process() {
            this.entry = this.queue.poll();
            if (this.entry == null) {
                return IteratingCallback.Action.IDLE;
            }
            QuicConnection.this.getEndPoint().write((Callback)this, this.entry.address, this.entry.buffers);
            return IteratingCallback.Action.SCHEDULED;
        }

        protected void onSuccess() {
            this.entry.callback.succeeded();
        }

        public Invocable.InvocationType getInvocationType() {
            return this.entry.callback.getInvocationType();
        }

        protected void onCompleteFailure(Throwable cause) {
            this.entry.callback.failed(cause);
            QuicConnection.this.close();
        }

        private static class Entry {
            private final Callback callback;
            private final SocketAddress address;
            private final ByteBuffer[] buffers;

            private Entry(Callback callback, SocketAddress address, ByteBuffer[] buffers) {
                this.callback = callback;
                this.address = address;
                this.buffers = buffers;
            }
        }
    }

    private class FillableCallback
    implements Callback {
        private FillableCallback() {
        }

        public void succeeded() {
            QuicConnection.this.onFillable();
        }

        public void failed(Throwable x) {
            QuicConnection.this.onFillInterestedFailed(x);
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.EITHER;
        }
    }

    private class QuicProducer
    implements ExecutionStrategy.Producer {
        private QuicProducer() {
        }

        public Runnable produce() {
            return QuicConnection.this.receiveAndProcess();
        }
    }
}

