/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ddf;

import org.zkoss.poi.ddf.EscherProperties;
import org.zkoss.poi.ddf.EscherProperty;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndian;

public class EscherSimpleProperty
extends EscherProperty {
    protected int propertyValue;

    public EscherSimpleProperty(short id, int propertyValue) {
        super(id);
        this.propertyValue = propertyValue;
    }

    public EscherSimpleProperty(short propertyNumber, boolean isComplex, boolean isBlipId, int propertyValue) {
        super(propertyNumber, isComplex, isBlipId);
        this.propertyValue = propertyValue;
    }

    @Override
    public int serializeSimplePart(byte[] data, int offset) {
        LittleEndian.putShort(data, offset, this.getId());
        LittleEndian.putInt(data, offset + 2, this.propertyValue);
        return 6;
    }

    @Override
    public int serializeComplexPart(byte[] data, int pos) {
        return 0;
    }

    public int getPropertyValue() {
        return this.propertyValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EscherSimpleProperty)) {
            return false;
        }
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)o;
        if (this.propertyValue != escherSimpleProperty.propertyValue) {
            return false;
        }
        return this.getId() == escherSimpleProperty.getId();
    }

    public int hashCode() {
        return this.propertyValue;
    }

    public String toString() {
        return "propNum: " + this.getPropertyNumber() + ", RAW: 0x" + HexDump.toHex(this.getId()) + ", propName: " + EscherProperties.getPropertyName(this.getPropertyNumber()) + ", complex: " + this.isComplex() + ", blipId: " + this.isBlipId() + ", value: " + this.propertyValue + " (0x" + HexDump.toHex(this.propertyValue) + ")";
    }

    @Override
    public String toXml(String tab) {
        StringBuilder builder = new StringBuilder();
        builder.append(tab).append("<").append(this.getClass().getSimpleName()).append(" id=\"0x").append(HexDump.toHex(this.getId())).append("\" name=\"").append(this.getName()).append("\" blipId=\"").append(this.isBlipId()).append("\" complex=\"").append(this.isComplex()).append("\" value=\"").append("0x").append(HexDump.toHex(this.propertyValue)).append("\"/>\n");
        return builder.toString();
    }
}

