/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HeaderPositionHelper
implements Serializable {
    private static final long serialVersionUID = 5465053151036240304L;
    int _defaultSize;
    private List<HeaderPositionInfo> _infos;

    public HeaderPositionHelper(int defaultSize, List<HeaderPositionInfo> infos) {
        this._defaultSize = defaultSize;
        this._infos = infos;
    }

    public int getDefaultSize() {
        return this._defaultSize;
    }

    public List<HeaderPositionInfo> getInfos() {
        return new ArrayList<HeaderPositionInfo>(this._infos);
    }

    public boolean isHidden(int cellIndex) {
        int j = Collections.binarySearch(this._infos, cellIndex, new HeaderPositionInfoComparator());
        return j < 0 ? false : this._infos.get((int)j).hidden;
    }

    public int getPrevNonHidden(int cellIndex) {
        if (--cellIndex < 0) {
            return -1;
        }
        int j = Collections.binarySearch(this._infos, cellIndex, new HeaderPositionInfoComparator());
        if (j < 0 || !this._infos.get((int)j).hidden) {
            return cellIndex;
        }
        --cellIndex;
        while (--j >= 0) {
            HeaderPositionInfo info = this._infos.get(j);
            if (info.index < cellIndex) {
                return cellIndex;
            }
            if (info.index != cellIndex) continue;
            if (!info.hidden) {
                return cellIndex;
            }
            --cellIndex;
        }
        return cellIndex;
    }

    public int getNextNonHidden(int cellIndex) {
        int j;
        if ((j = Collections.binarySearch(this._infos, ++cellIndex, new HeaderPositionInfoComparator())) < 0 || !this._infos.get((int)j).hidden) {
            return cellIndex;
        }
        ++cellIndex;
        int len = this._infos.size();
        while (++j < len) {
            HeaderPositionInfo info = this._infos.get(j);
            if (info.index > cellIndex) {
                return cellIndex;
            }
            if (info.index != cellIndex) continue;
            if (!info.hidden) {
                return cellIndex;
            }
            ++cellIndex;
        }
        return cellIndex;
    }

    public int getSize(int cellIndex) {
        int j = Collections.binarySearch(this._infos, cellIndex, new HeaderPositionInfoComparator());
        return j < 0 ? this._defaultSize : this._infos.get((int)j).size;
    }

    private int getListIndex(int cellIndex) {
        int j = Collections.binarySearch(this._infos, cellIndex, new HeaderPositionInfoComparator());
        return j < 0 ? -j - 1 : j;
    }

    public void shiftMeta(int cellIndex, int offset) {
        int index = this.getListIndex(cellIndex);
        for (int j = this._infos.size() - 1; j >= index; --j) {
            HeaderPositionInfo info = this._infos.get(j);
            info.index += offset;
        }
    }

    public void unshiftMeta(int cellIndex, int offset) {
        int j;
        int bindex = this.getListIndex(cellIndex);
        int eindex = this.getListIndex(cellIndex + offset);
        for (j = eindex - 1; j >= bindex; --j) {
            this._infos.remove(j);
        }
        for (j = this._infos.size() - 1; j >= bindex; --j) {
            HeaderPositionInfo info = this._infos.get(j);
            info.index -= offset;
        }
    }

    public HeaderPositionInfo getInfo(int cellIndex) {
        int j = Collections.binarySearch(this._infos, cellIndex, new HeaderPositionInfoComparator());
        return j < 0 ? null : this._infos.get(j);
    }

    public void setInfoValues(int cellIndex, int size, int id, boolean hidden, boolean isCustom) {
        int index;
        int j = Collections.binarySearch(this._infos, cellIndex, new HeaderPositionInfoComparator());
        int n = index = j < 0 ? -j - 1 : j;
        if (j < 0) {
            this._infos.add(index, new HeaderPositionInfo(cellIndex, size, id, hidden, isCustom));
        } else {
            HeaderPositionInfo info = this._infos.get(index);
            info.size = size;
            info.id = id;
            info.hidden = hidden;
        }
    }

    public void removeInfo(int cellIndex) {
        int index;
        int j = Collections.binarySearch(this._infos, cellIndex, new HeaderPositionInfoComparator());
        int n = index = j < 0 ? -j - 1 : j;
        if (j >= 0) {
            this._infos.remove(index);
        }
    }

    public int getCellIndex(int px) {
        if (px < 0) {
            return 0;
        }
        int begPx = 0;
        int begIndex = 0;
        for (HeaderPositionInfo info : this._infos) {
            int cellIndex = info.index;
            int endPx = begPx + (cellIndex - begIndex) * this._defaultSize;
            if (endPx > px) {
                int step = px - begPx;
                return begIndex + step / this._defaultSize;
            }
            begPx = endPx + (info.hidden ? 0 : info.size);
            if (begPx > px) {
                return info.index;
            }
            begIndex = info.index + 1;
        }
        int step = px - begPx;
        return begIndex + step / this._defaultSize;
    }

    public int getStartPixel(int cellIndex) {
        if (cellIndex < 0) {
            return 0;
        }
        int px = 0;
        int begIndex = 0;
        for (HeaderPositionInfo info : this._infos) {
            int infoIndex = info.index;
            if (cellIndex > infoIndex) {
                px += (infoIndex - begIndex) * this._defaultSize;
                px += info.hidden ? 0 : info.size;
                begIndex = infoIndex + 1;
                continue;
            }
            if (cellIndex != infoIndex) break;
            return px += (infoIndex - begIndex) * this._defaultSize;
        }
        return px += (cellIndex - begIndex) * this._defaultSize;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (HeaderPositionInfo info : this._infos) {
            sb.append("[");
            sb.append(info.index).append(", ");
            sb.append(info.size).append(", ");
            sb.append(info.id).append(", ");
            sb.append(info.hidden).append(", ");
            sb.append("],");
        }
        sb.append("]");
        return sb.toString();
    }

    private static class HeaderPositionInfoComparator
    implements Comparator,
    Serializable {
        private HeaderPositionInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i1 = o1 instanceof HeaderPositionInfo ? ((HeaderPositionInfo)o1).index : (Integer)o1;
            int i2 = o2 instanceof HeaderPositionInfo ? ((HeaderPositionInfo)o2).index : (Integer)o2;
            return i1 - i2;
        }
    }

    public static class HeaderPositionInfo {
        public int index;
        public int size;
        public int id;
        public boolean hidden;
        private boolean custom = true;

        public HeaderPositionInfo(int index, int size, int id, boolean hidden, boolean isCustom) {
            this.index = index;
            this.size = size;
            this.id = id;
            this.hidden = hidden;
            this.custom = isCustom;
        }

        public boolean isCustom() {
            return this.custom;
        }

        public void setCustom(boolean custom) {
            this.custom = custom;
        }
    }
}

