/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SColor;
import io.keikai.model.impl.AbstractColorAdv;
import java.util.Arrays;

public class ColorImpl
extends AbstractColorAdv {
    private static final long serialVersionUID = 1L;
    private byte[] _rgb;
    private byte _alpha = (byte)-1;
    public static final AbstractColorAdv WHITE = new ColorImpl("#FFFFFF");
    public static final AbstractColorAdv BLACK = new ColorImpl("#000000");
    public static final AbstractColorAdv RED = new ColorImpl("#FF0000");
    public static final AbstractColorAdv GREEN = new ColorImpl("#00FF00");
    public static final AbstractColorAdv BLUE = new ColorImpl("#0000FF");
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ColorImpl(byte[] rgb) {
        if (rgb == null) {
            throw new IllegalArgumentException("null rgb array");
        }
        if (rgb.length == 4) {
            this._alpha = rgb[0];
            this._rgb = new byte[3];
            this._rgb[0] = rgb[1];
            this._rgb[1] = rgb[2];
            this._rgb[2] = rgb[3];
        } else {
            if (rgb.length != 3) {
                throw new IllegalArgumentException("wrong rgb length");
            }
            this._rgb = rgb;
        }
    }

    public ColorImpl(byte r, byte g, byte b) {
        this._rgb = new byte[]{r, g, b};
    }

    public ColorImpl(String htmlColor) {
        int offset = htmlColor.charAt(0) == '#' ? 1 : 0;
        short red = Short.parseShort(htmlColor.substring(offset + 0, offset + 2), 16);
        short green = Short.parseShort(htmlColor.substring(offset + 2, offset + 4), 16);
        short blue = Short.parseShort(htmlColor.substring(offset + 4, offset + 6), 16);
        byte r = (byte)(red & 0xFF);
        byte g = (byte)(green & 0xFF);
        byte b = (byte)(blue & 0xFF);
        this._rgb = new byte[]{r, g, b};
    }

    @Override
    public String getHtmlColor() {
        StringBuilder sb = new StringBuilder("#");
        for (byte c : this._rgb) {
            int n = c & 0xFF;
            sb.append(HEX[n / 16]);
            sb.append(HEX[n % 16]);
        }
        return sb.toString();
    }

    @Override
    public byte[] getRGB() {
        byte[] c = new byte[this._rgb.length];
        System.arraycopy(this._rgb, 0, c, 0, this._rgb.length);
        return c;
    }

    public int hashCode() {
        int prime = 31;
        int result = this._alpha;
        result = 31 * result + Arrays.hashCode(this._rgb);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorImpl other = (ColorImpl)obj;
        if (!Arrays.equals(this._rgb, other._rgb)) {
            return false;
        }
        return this._alpha == other._alpha;
    }

    public String toString() {
        return this.getHtmlColor();
    }

    @Override
    public byte[] getARGB() {
        byte[] c = new byte[this._rgb.length + 1];
        c[0] = this._alpha;
        System.arraycopy(this._rgb, 0, c, 1, this._rgb.length);
        return c;
    }

    @Override
    SColor cloneColor(SBook book) {
        return book == null ? this : book.createColor(this.getHtmlColor());
    }
}

