/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBar3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarDir;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.charts.AbstractCategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.CategoryData;
import org.zkoss.poi.ss.usermodel.charts.CategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartDirection;
import org.zkoss.poi.ss.usermodel.charts.ChartGrouping;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartAxDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartNumDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartTextSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartUtil;

public class XSSFBar3DChartData
implements CategoryData {
    private ChartGrouping _chartGrouping;
    private ChartDirection _chartDirection;
    private CTBar3DChart ctBar3DChart;
    private List<CategoryDataSerie> series = new ArrayList<CategoryDataSerie>();

    public XSSFBar3DChartData() {
        this.setBarDirection(ChartDirection.HORIZONTAL);
    }

    public XSSFBar3DChartData(XSSFChart chart) {
        this();
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTBar3DChart[] plotCharts = plotArea.getBar3DChartArray();
        if (plotCharts != null && plotCharts.length > 0) {
            this.ctBar3DChart = plotCharts[0];
        }
        if (this.ctBar3DChart != null) {
            CTBarSer[] bsers = this.ctBar3DChart.getSerArray();
            for (int j = 0; j < bsers.length; ++j) {
                CTBarSer ser = bsers[j];
                CTSerTx serTx = ser.getTx();
                XSSFChartTextSource title = serTx == null ? null : new XSSFChartTextSource(serTx);
                XSSFChartAxDataSource cats = new XSSFChartAxDataSource(ser.getCat());
                XSSFChartNumDataSource vals = new XSSFChartNumDataSource(ser.getVal());
                this.addSerie(title, cats, vals);
            }
        }
    }

    public ChartGrouping getGrouping() {
        if (this.ctBar3DChart != null) {
            this._chartGrouping = XSSFChartUtil.toChartGroupingForBar(this.ctBar3DChart.getGrouping());
        }
        return this._chartGrouping;
    }

    public void setGrouping(ChartGrouping grouping) {
        this._chartGrouping = grouping;
        if (this.ctBar3DChart != null) {
            CTBarGrouping ctgr = this.ctBar3DChart.getGrouping();
            if (ctgr == null) {
                ctgr = this.ctBar3DChart.addNewGrouping();
            }
            ctgr.setVal(XSSFChartUtil.fromChartGroupingForBar(grouping));
        }
    }

    public ChartDirection getBarDirection() {
        if (this.ctBar3DChart != null) {
            this._chartDirection = XSSFChartUtil.toBarDirection(this.ctBar3DChart.getBarDir());
        }
        return this._chartDirection;
    }

    public void setBarDirection(ChartDirection barDir) {
        this._chartDirection = barDir;
        if (this.ctBar3DChart != null) {
            CTBarDir dir = this.ctBar3DChart.getBarDir();
            if (dir == null) {
                dir = this.ctBar3DChart.addNewBarDir();
            }
            dir.setVal(XSSFChartUtil.fromBarDirection(barDir));
        }
    }

    @Override
    public CategoryDataSerie addSerie(ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
        if (!vals.isNumeric()) {
            throw new IllegalArgumentException("Pie data source must be numeric.");
        }
        int numOfSeries = this.series.size();
        Serie newSerie = new Serie(numOfSeries, numOfSeries, title, cats, vals);
        this.series.add(newSerie);
        return newSerie;
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        if (this.ctBar3DChart == null) {
            XSSFChart xssfChart = (XSSFChart)chart;
            CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
            this.ctBar3DChart = plotArea.addNewBar3DChart();
            this.ctBar3DChart.addNewVaryColors().setVal(true);
            this.setBarDirection(this._chartDirection);
            this.setGrouping(this._chartGrouping);
            for (CategoryDataSerie s : this.series) {
                ((Serie)s).addToChart(this.ctBar3DChart);
            }
        }
        for (ChartAxis a : axis) {
            this.ctBar3DChart.addNewAxId().setVal(a.getId());
        }
    }

    @Override
    public List<? extends CategoryDataSerie> getSeries() {
        return this.series;
    }

    static class Serie
    extends AbstractCategoryDataSerie {
        protected Serie(int id, int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
            super(id, order, title, cats, vals);
        }

        protected void addToChart(CTBar3DChart ctBar3DChart) {
            CTBarSer barSer = ctBar3DChart.addNewSer();
            barSer.addNewIdx().setVal((long)this.id);
            barSer.addNewOrder().setVal((long)this.order);
            if (this.title != null) {
                CTSerTx tx = barSer.addNewTx();
                XSSFChartUtil.buildSerTx(tx, this.title);
            }
            if (this.categories != null && this.categories.getPointCount() > 0) {
                CTAxDataSource cats = barSer.addNewCat();
                XSSFChartUtil.buildAxDataSource(cats, this.categories);
            }
            CTNumDataSource vals = barSer.addNewVal();
            XSSFChartUtil.buildNumDataSource(vals, this.values);
        }
    }
}

