/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.util;

import java.lang.reflect.Method;

public final class JVM {
    private static final int MAJOR_VERSION = JVM.getMajorVersion0();
    private static final boolean IS_32_BIT = JVM.is32bit0();

    private JVM() {
    }

    public static int getMajorVersion() {
        return MAJOR_VERSION;
    }

    private static int getMajorVersion0() {
        try {
            Method versionMethod = Runtime.class.getDeclaredMethod("version", new Class[0]);
            if (versionMethod != null) {
                Class<?> versionClazz = Class.forName("java.lang.Runtime$Version");
                Method majorMethod = versionClazz.getDeclaredMethod("major", new Class[0]);
                Object versionObject = versionMethod.invoke((Object)Runtime.getRuntime(), new Object[0]);
                return (Integer)majorMethod.invoke(versionObject, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JVM.parseVersionString(System.getProperty("java.version"));
    }

    static int parseVersionString(String javaVersion) {
        int dotIndex;
        String majorVersion = javaVersion.startsWith("1.") ? javaVersion.substring(2, 3) : ((dotIndex = javaVersion.indexOf(".")) == -1 ? javaVersion : javaVersion.substring(0, dotIndex));
        return Integer.parseInt(majorVersion);
    }

    private static boolean is32bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        String architecture = System.getProperty("sun.arch.data.model", "?");
        return architecture != null && architecture.equals("32");
    }

    public static boolean is32bit() {
        return IS_32_BIT;
    }

    public static boolean is64bit() {
        return !IS_32_BIT;
    }
}

