/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.SlidingWindowPolicy;
import com.hazelcast.jet.core.TimestampKind;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.function.KeyedWindowResultFunction;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.datamodel.WindowResult;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.ConstantFunctionEx;
import com.hazelcast.jet.pipeline.SessionWindowDefinition;
import com.hazelcast.jet.pipeline.SlidingWindowDefinition;
import com.hazelcast.jet.pipeline.WindowDefinition;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class WindowAggregateTransform<A, R>
extends AbstractTransform {
    private static final long serialVersionUID = 1L;
    private static final int MAX_WATERMARK_STRIDE = 100;
    private static final int MIN_WMS_PER_SESSION = 100;
    private static final KeyedWindowResultFunction JET_EVENT_WINDOW_RESULT_FN = (start, end, ignoredKey, result, isEarly) -> JetEvent.jetEvent(end - 1L, new WindowResult<Object>(start, end, result, isEarly));
    @Nonnull
    private final AggregateOperation<A, ? extends R> aggrOp;
    @Nonnull
    private final WindowDefinition wDef;

    public WindowAggregateTransform(@Nonnull List<Transform> upstream, @Nonnull WindowDefinition wDef, @Nonnull AggregateOperation<A, ? extends R> aggrOp) {
        super(WindowAggregateTransform.createName(wDef), upstream);
        this.aggrOp = aggrOp;
        this.wDef = wDef;
    }

    static String createName(WindowDefinition wDef) {
        if (wDef instanceof SlidingWindowDefinition) {
            return "sliding-window";
        }
        if (wDef instanceof SessionWindowDefinition) {
            return "session-window";
        }
        throw new IllegalArgumentException(wDef.getClass().getName());
    }

    static long preferredWatermarkStride(WindowDefinition wDef) {
        if (wDef instanceof SlidingWindowDefinition) {
            return ((SlidingWindowDefinition)wDef).slideBy();
        }
        if (wDef instanceof SessionWindowDefinition) {
            long timeout = ((SessionWindowDefinition)wDef).sessionTimeout();
            return Math.min(100L, Math.max(1L, timeout / 100L));
        }
        throw new IllegalArgumentException(wDef.getClass().getName());
    }

    @Override
    public long preferredWatermarkStride() {
        return WindowAggregateTransform.preferredWatermarkStride(this.wDef);
    }

    @Override
    public void addToDag(Planner p, PipelineImpl.Context context) {
        if (this.wDef instanceof SessionWindowDefinition) {
            this.addSessionWindow(p, (SessionWindowDefinition)this.wDef);
        } else if (this.aggrOp.combineFn() == null || this.wDef.earlyResultsPeriod() > 0L) {
            this.addSlidingWindowSingleStage(p, (SlidingWindowDefinition)this.wDef);
        } else {
            this.addSlidingWindowTwoStage(p, (SlidingWindowDefinition)this.wDef, context);
        }
    }

    private void addSlidingWindowSingleStage(Planner p, SlidingWindowDefinition wDef) {
        this.determinedLocalParallelism(1);
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), this.determinedLocalParallelism(), Processors.aggregateToSlidingWindowP(Collections.nCopies(this.aggrOp.arity(), new ConstantFunctionEx(this.name().hashCode())), Collections.nCopies(this.aggrOp.arity(), JetEvent::timestamp), TimestampKind.EVENT, SlidingWindowPolicy.slidingWinPolicy(wDef.windowSize(), wDef.slideBy()), wDef.earlyResultsPeriod(), this.aggrOp, WindowAggregateTransform.jetEventOfWindowResultFn()));
        p.addEdges((Transform)this, pv.v, edge -> edge.distributed().allToOne(this.name().hashCode()));
    }

    private void addSlidingWindowTwoStage(Planner p, SlidingWindowDefinition wDef, PipelineImpl.Context context) {
        this.determineLocalParallelism(-1, context, p.isPreserveOrder());
        SlidingWindowPolicy winPolicy = SlidingWindowPolicy.slidingWinPolicy(wDef.windowSize(), wDef.slideBy());
        Vertex v1 = p.dag.newVertex(this.name() + "-prepare", Processors.accumulateByFrameP(Collections.nCopies(this.aggrOp.arity(), new ConstantFunctionEx(this.name().hashCode())), Collections.nCopies(this.aggrOp.arity(), JetEvent::timestamp), TimestampKind.EVENT, winPolicy, this.aggrOp));
        v1.localParallelism(this.determinedLocalParallelism());
        if (p.isPreserveOrder()) {
            p.addEdges((Transform)this, v1, Edge::isolated);
        } else {
            p.addEdges(this, v1);
        }
        this.determinedLocalParallelism(1);
        Planner.PlannerVertex pv2 = p.addVertex((Transform)this, this.name(), this.determinedLocalParallelism(), Processors.combineToSlidingWindowP(winPolicy, this.aggrOp, WindowAggregateTransform.jetEventOfWindowResultFn()));
        p.dag.edge(Edge.between(v1, pv2.v).distributed().allToOne(this.name().hashCode()));
    }

    private void addSessionWindow(Planner p, SessionWindowDefinition wDef) {
        this.determinedLocalParallelism(1);
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), this.determinedLocalParallelism(), Processors.aggregateToSessionWindowP(wDef.sessionTimeout(), wDef.earlyResultsPeriod(), Collections.nCopies(this.aggrOp.arity(), JetEvent::timestamp), Collections.nCopies(this.aggrOp.arity(), new ConstantFunctionEx(this.name().hashCode())), this.aggrOp, WindowAggregateTransform.jetEventOfWindowResultFn()));
        p.addEdges((Transform)this, pv.v, edge -> edge.distributed().allToOne(this.name().hashCode()));
    }

    private static <K, R> KeyedWindowResultFunction<K, R, JetEvent<R>> jetEventOfWindowResultFn() {
        return JET_EVENT_WINDOW_RESULT_FN;
    }
}

