/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.exolab.castor.mapping.GeneralizedFieldHandler;
import org.exolab.castor.mapping.MappingException;

public class ValueOfFieldHandler
extends GeneralizedFieldHandler {
    private static final Class[] ARGS = new Class[]{String.class};
    private static final String METHOD_NAME = "valueOf";
    private final Class _type;
    private final Method _valueOf;

    public ValueOfFieldHandler(Class type) throws MappingException {
        if (type == null) {
            throw new IllegalArgumentException("The argument 'type' must not be null.");
        }
        this._type = type;
        Method method = null;
        try {
            method = type.getMethod(METHOD_NAME, ARGS);
        }
        catch (NoSuchMethodException nsme) {
            throw new MappingException(nsme);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            String err = "No static method 'valueOf' found in class: " + type.getName();
            throw new MappingException(err);
        }
        this._valueOf = method;
    }

    @Override
    public Object convertUponGet(Object value) {
        return value;
    }

    @Override
    public Object convertUponSet(Object value) {
        Object[] args = new Object[1];
        if (value != null) {
            args[0] = value.toString();
        }
        Object result = null;
        try {
            result = this._valueOf.invoke(null, args);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException(iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException(ite.getMessage());
        }
        return result;
    }

    @Override
    public Class getFieldType() {
        return this._type;
    }

    @Override
    public Object newInstance(Object parent) throws IllegalStateException {
        return null;
    }
}

